<?php

if ( ! function_exists( 'coppola_core_add_section_title_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function coppola_core_add_section_title_shortcode( $shortcodes ) {
		$shortcodes[] = 'CoppolaCore_Section_Title_Shortcode';

		return $shortcodes;
	}

	add_filter( 'coppola_core_filter_register_shortcodes', 'coppola_core_add_section_title_shortcode' );
}

if ( class_exists( 'CoppolaCore_Shortcode' ) ) {
	class CoppolaCore_Section_Title_Shortcode extends CoppolaCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( COPPOLA_CORE_SHORTCODES_URL_PATH . '/section-title' );
			$this->set_base( 'coppola_core_section_title' );
			$this->set_name( esc_html__( 'Section Title', 'coppola-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds section title element', 'coppola-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'subtitle',
					'title'      => esc_html__( 'Subtitle', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'subtitle_color',
					'title'      => esc_html__( 'Subtitle Color', 'coppola-core' ),
					'group'      => esc_html__( 'Text Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'title',
					'title'         => esc_html__( 'Title', 'coppola-core' ),
					'default_value' => esc_html__( 'Title Text', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'line_break_positions',
					'title'       => esc_html__( 'Positions of Line Break', 'coppola-core' ),
					'description' => esc_html__( 'Enter the positions of the words after which you would like to create a line break. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a line break, you would enter "1,3,4")', 'coppola-core' ),
					'group'       => esc_html__( 'Title Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'word_custom_color_positions',
					'title'       => esc_html__( 'Word Custom Color Positions', 'coppola-core' ),
					'description' => esc_html__( 'Enter the positions of the words which need to be displayed with a different color. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a different color, you would enter "1,3,4")', 'coppola-core' ),
					'group'       => esc_html__( 'Title Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'color',
					'name'        => 'word_custom_color',
					'title'       => esc_html__( 'Word Custom Color', 'coppola-core' ),
					'description' => esc_html__( 'Select a custom color for the words', 'coppola-core' ),
					'group'       => esc_html__( 'Title Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'word_svg_position',
					'title'       => esc_html__( 'SVG Word Overlay Position', 'coppola-core' ),
					'description' => esc_html__( 'Insert the position of the word where the SVG word overlay will be displayed - the graphic is set in the theme\'s General options', 'coppola-core' ),
					'group'       => esc_html__( 'Title Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'disable_title_break_words',
					'title'         => esc_html__( 'Disable Title Line Break', 'coppola-core' ),
					'description'   => esc_html__( 'Enabling this option will disable title line breaks for screen size 1024 and lower', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'group'         => esc_html__( 'Title Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Title Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'coppola-core' ),
					'group'      => esc_html__( 'Title Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title_margin_top',
					'title'      => esc_html__( 'Title Margin Top', 'coppola-core' ),
					'group'      => esc_html__( 'Title Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'link',
					'title'      => esc_html__( 'Title Custom Link', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'target',
					'title'         => esc_html__( 'Custom Link Target', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'link_target', false ),
					'default_value' => '_self',
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'button_link',
					'title'       => esc_html__( 'Button Link', 'coppola-core' ),
					'description' => esc_html__( 'Link for the button. Leave empty and no button will be shown', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'button_target',
					'title'         => esc_html__( 'Button Link Target', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'link_target', false ),
					'default_value' => '_blank',
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'button_text',
					'title'       => esc_html__( 'Button Text', 'coppola-core' ),
					'description' => esc_html__( 'Text to be displayed in the button.', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'button_layout',
					'title'         => esc_html__( 'Button Layout', 'coppola-core' ),
					'options'       => array(
						'filled'   => esc_html__( 'Filled', 'coppola-core' ),
						'outlined' => esc_html__( 'Outlined', 'coppola-core' ),
						'textual'  => esc_html__( 'Textual', 'coppola-core' ),
					),
					'default_value' => 'outlined',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'button_size',
					'title'      => esc_html__( 'Button Size', 'coppola-core' ),
					'options'    => array(
						''      => esc_html__( 'Normal', 'coppola-core' ),
						'small' => esc_html__( 'Small', 'coppola-core' ),
						'large' => esc_html__( 'Large', 'coppola-core' ),
						'full'  => esc_html__( 'Full Width', 'coppola-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'skin',
					'title'         => esc_html__( 'Button Skin', 'coppola-core' ),
					'options'       => array(
						'dark'  => esc_html__( 'Dark', 'coppola-core' ),
						'light' => esc_html__( 'Light', 'coppola-core' ),
					),
					'default_value' => 'dark',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_color',
					'title'      => esc_html__( 'Button Text Color', 'coppola-core' ),
					'group'      => esc_html__( 'Button Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'name'       => 'button_hover_color',
					'field_type' => 'color',
					'title'      => esc_html__( 'Button Text Hover Color', 'coppola-core' ),
					'group'      => esc_html__( 'Button Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_background_color',
					'title'      => esc_html__( 'Button Background Hover Color', 'coppola-core' ),
					'group'      => esc_html__( 'Button Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_border_color',
					'title'      => esc_html__( 'Button Border Color', 'coppola-core' ),
					'group'      => esc_html__( 'Button Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'button_hover_border_color',
					'title'      => esc_html__( 'Button Border Hover Color', 'coppola-core' ),
					'group'      => esc_html__( 'Button Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'button_margin',
					'title'      => esc_html__( 'Button Top Margin', 'coppola-core' ),
					'group'      => esc_html__( 'Button Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'textarea',
					'name'          => 'text',
					'title'         => esc_html__( 'Text', 'coppola-core' ),
					'default_value' => '',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'coppola-core' ),
					'group'      => esc_html__( 'Text Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'text_margin_top',
					'title'      => esc_html__( 'Text Margin Top', 'coppola-core' ),
					'group'      => esc_html__( 'Text Style', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'content_alignment',
					'title'      => esc_html__( 'Content Alignment', 'coppola-core' ),
					'options'    => array(
						''       => esc_html__( 'Default', 'coppola-core' ),
						'left'   => esc_html__( 'Left', 'coppola-core' ),
						'center' => esc_html__( 'Center', 'coppola-core' ),
						'right'  => esc_html__( 'Right', 'coppola-core' ),
					),
				)
			);
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes']       = $this->get_holder_classes( $atts );
			$atts['title']                = $this->get_modified_title( $atts );
			$atts['title_styles']         = $this->get_title_styles( $atts );
			$atts['text_styles']          = $this->get_text_styles( $atts );
			$atts['subtitle_styles']      = $this->get_subtitle_styles( $atts );
			$atts['data_attrs']           = $this->get_button_data_attrs( $atts );
			$atts['button_styles']        = $this->get_button_styles( $atts );
			$atts['button_inline_styles'] = $this->get_button_inline_styles( $atts );

			return coppola_core_get_template_part( 'shortcodes/section-title', 'templates/section-title', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-section-title';
			$holder_classes[] = ! empty( $atts['content_alignment'] ) ? 'qodef-alignment--' . $atts['content_alignment'] : 'qodef-alignment--left';
			$holder_classes[] = 'yes' === $atts['disable_title_break_words'] ? 'qodef-title-break--disabled' : '';

			return implode( ' ', $holder_classes );
		}

		private function get_modified_title( $atts ) {
			$title = $atts['title'];
			$svg   = coppola_core_set_svg_overlay();

			if ( ! empty( $title ) ) {
				$split_title = explode( ' ', $title );
				if ( ! empty( $atts['line_break_positions'] ) ) {
					$line_break_positions = explode( ',', str_replace( ' ', '', $atts['line_break_positions'] ) );

					foreach ( $line_break_positions as $position ) {
						$position = intval( $position );
						if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
							$split_title[ $position - 1 ] = $split_title[ $position - 1 ] . '<br/>';
						}
					}
				}

				if ( ! empty( $atts['word_custom_color_positions'] ) && isset( $atts['word_custom_color'] ) ) {
					$split_title = coppola_core_set_word_custom_color( $split_title, $atts['word_custom_color_positions'], $atts['word_custom_color'] );
				}

				if ( ! empty( $atts['word_svg_position'] ) && ! empty( $svg ) ) {
					$word_svg_position = intval( $atts['word_svg_position'] );
					if ( isset( $split_title[ $word_svg_position - 1 ] ) && ! empty( $split_title[ $word_svg_position - 1 ] ) ) {
						$split_title[ $word_svg_position - 1 ] = '<span class="qodef-e-svg">' . $split_title[ $word_svg_position - 1 ] . coppola_core_section_title_wp_kses( $svg ) . '</span>';
					}
				}
				$title = implode( ' ', $split_title );
			}

			return $title;
		}

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			if ( ! empty( $atts['title_margin_top'] ) ) {
				$styles[] = 'margin-top: ' . $atts['title_margin_top'];
			}

			return $styles;
		}

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['text_margin_top'] ) {
				if ( qode_framework_string_ends_with_space_units( $atts['text_margin_top'] ) ) {
					$styles[] = 'margin-top: ' . $atts['text_margin_top'];
				} else {
					$styles[] = 'margin-top: ' . intval( $atts['text_margin_top'] ) . 'px';
				}
			}

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			return $styles;
		}

		private function get_subtitle_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['subtitle_color'] ) ) {
				$styles[] = 'color: ' . $atts['subtitle_color'];
			}

			return $styles;
		}

		private function get_button_data_attrs( $atts ) {
			$data = array();

			if ( ! empty( $atts['button_hover_color'] ) ) {
				$data['data-hover-color'] = $atts['button_hover_color'];
			}

			if ( ! empty( $atts['button_hover_background_color'] ) ) {
				$data['data-hover-background-color'] = $atts['button_hover_background_color'];
			}

			if ( ! empty( $atts['button_hover_border_color'] ) ) {
				$data['data-hover-border-color'] = $atts['button_hover_border_color'];
			}

			return $data;
		}

		private function get_button_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['button_color'] ) ) {
				$styles['button-color'] = $atts['button_color'];
			}

			if ( ! empty( $atts['button_border_color'] ) ) {
				$styles['button-border-color'] = $atts['button_border_color'];
			}

			return $styles;
		}

		private function get_button_inline_styles( $atts ) {
			$styles = array();

			if ( '' !== $atts['button_margin'] ) {
				$styles[] = 'margin-top: ' . $atts['button_margin'];
			}

			return $styles;
		}
	}
}
