<?php
$image_src = wp_get_attachment_image_src( $image, 'full' );
?>
<div <?php qode_framework_class_attribute( $holder_classes ); ?>>
	<?php if ( isset( $retina_scaling ) && 'yes' === $retina_scaling ) { ?>
		<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><img class="qodef-ic-logo" itemprop="image" src="<?php echo esc_url( $image_src[0] ); ?>" width="<?php echo round( $image_src[1] / 2 ); ?>" height="<?php echo round( $image_src[2] / 2 ); ?>" alt="<?php echo esc_attr( $image_src[3] ); ?>" /></a>
		<?php
	} else {
		$images_proportion   = isset( $images_proportion ) && ! empty( $images_proportion ) ? esc_attr( $images_proportion ) : 'full';
		$custom_image_width  = isset( $custom_image_width ) && '' !== $custom_image_width ? intval( $custom_image_width ) : 0;
		$custom_image_height = isset( $custom_image_height ) && '' !== $custom_image_height ? intval( $custom_image_height ) : 0;
		echo coppola_core_get_list_shortcode_item_image( $images_proportion, $image, $custom_image_width, $custom_image_height );
	}
	?>
	<?php
	if ( ! empty( $top_left_video ) ) {
		?>
	<div class="qodef-ic-holder qodef-ic-top-left">
		<?php if ( ! empty( $top_left_link ) ) { ?>
			<a href="<?php echo esc_url( $top_left_link ); ?>" target="_blank" >
		<?php } ?>
			<h5 class="qodef-ic-title">
				<span class="qodef-ic-title-holder">
					<?php echo esc_attr( $top_left_title ); ?>
					<?php echo coppola_core_set_svg_overlay(); ?>
				</span>
			</h5>
		<?php if ( ! empty( $top_left_link ) ) { ?>
			</a>
		<?php } ?>
		<div class="qodef-ic-video">
			<video autoplay="autoplay" loop="loop" muted="muted" playsinline="">
				<source src="<?php echo esc_url( $top_left_video ); ?>">
			</video>
			<?php if ( ! empty( $top_left_text ) ) { ?>
				<span class="qodef-ic-text"><?php echo esc_attr( $top_left_text ); ?></span>
			<?php } ?>
		</div>
	</div>
	<?php } ?>
	<?php
	if ( ! empty( $top_right_video ) ) {
		?>
		<div class="qodef-ic-holder qodef-ic-top-right">
			<?php if ( ! empty( $top_right_link ) ) { ?>
			<a href="<?php echo esc_url( $top_right_link ); ?>" target="_blank" >
				<?php } ?>
				<h5 class="qodef-ic-title">
					<span class="qodef-ic-title-holder">
						<?php echo esc_attr( $top_right_title ); ?>
						<?php echo coppola_core_set_svg_overlay(); ?>
					</span>
				</h5>
				<?php if ( ! empty( $bottom_right_link ) ) { ?>
			</a>
			<?php } ?>
			<div class="qodef-ic-video">
				<video autoplay="autoplay" loop="loop" muted="muted" playsinline="">
					<source src="<?php echo esc_url( $top_right_video ); ?>">
				</video>
				<?php if ( ! empty( $top_right_text ) ) { ?>
					<span class="qodef-ic-text"><?php echo esc_attr( $top_right_text ); ?></span>
				<?php } ?>
			</div>
		</div>
	<?php } ?>
	<?php
	if ( ! empty( $bottom_right_video ) ) {
		?>
		<div class="qodef-ic-holder qodef-ic-bottom-right">
			<?php if ( ! empty( $bottom_right_link ) ) { ?>
			<a href="<?php echo esc_url( $bottom_right_link ); ?>" target="_blank" >
				<?php } ?>
				<h5 class="qodef-ic-title">
					<span class="qodef-ic-title-holder">
						<?php echo esc_attr( $bottom_right_title ); ?>
						<?php echo coppola_core_set_svg_overlay(); ?>
					</span>
				</h5>
				<?php if ( ! empty( $bottom_right_link ) ) { ?>
			</a>
			<?php } ?>
			<div class="qodef-ic-video">
				<video autoplay="autoplay" loop="loop" muted="muted" playsinline="">
					<source src="<?php echo esc_url( $bottom_right_video ); ?>">
				</video>
				<?php if ( ! empty( $bottom_right_text ) ) { ?>
					<span class="qodef-ic-text"><?php echo esc_attr( $bottom_right_text ); ?></span>
				<?php } ?>
			</div>
		</div>
	<?php } ?>
	<?php
	if ( ! empty( $bottom_left_video ) ) {
		?>
		<div class="qodef-ic-holder qodef-ic-bottom-left">
			<?php if ( ! empty( $bottom_left_link ) ) { ?>
			<a href="<?php echo esc_url( $bottom_left_link ); ?>" target="_blank" >
				<?php } ?>
				<h5 class="qodef-ic-title">
					<span class="qodef-ic-title-holder">
						<?php echo esc_attr( $bottom_left_title ); ?>
						<?php echo coppola_core_set_svg_overlay(); ?>
					</span>
				</h5>
				<?php if ( ! empty( $bottom_left_link ) ) { ?>
			</a>
			<?php } ?>
			<div class="qodef-ic-video">
				<video autoplay="autoplay" loop="loop" muted="muted" playsinline="">
					<source src="<?php echo esc_url( $bottom_left_video ); ?>">
				</video>
				<?php if ( ! empty( $bottom_left_text ) ) { ?>
					<span class="qodef-ic-text"><?php echo esc_attr( $bottom_left_text ); ?></span>
				<?php } ?>
			</div>
		</div>
	<?php } ?>
</div>
