<?php

if ( ! function_exists( 'coppola_core_add_interactive_corners_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function coppola_core_add_interactive_corners_shortcode( $shortcodes ) {
		$shortcodes[] = 'CoppolaCore_Interactive_Corners_Shortcode';

		return $shortcodes;
	}

	add_filter( 'coppola_core_filter_register_shortcodes', 'coppola_core_add_interactive_corners_shortcode' );
}

if ( class_exists( 'CoppolaCore_Shortcode' ) ) {
	class CoppolaCore_Interactive_Corners_Shortcode extends CoppolaCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'coppola_core_filter_interactive_corners_layouts', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( COPPOLA_CORE_SHORTCODES_URL_PATH . '/interactive-corners' );
			$this->set_base( 'coppola_core_interactive_corners' );
			$this->set_name( esc_html__( 'Interactive Corners', 'coppola-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds interactive corners holder', 'coppola-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'image',
					'title'      => esc_html__( 'Image', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'retina_scaling',
					'title'         => esc_html__( 'Enable Retina Scaling', 'coppola-core' ),
					'description'   => esc_html__( 'Image uploaded should be two times the height.', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'yes_no' ),
					'default_value' => '',
				)
			);
			$options_map = coppola_core_get_variations_options_map( $this->get_layouts() );

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'coppola-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'top_left_title',
					'title'      => esc_html__( 'Top Left Title', 'coppola-core' ),
					'group'      => esc_html__( 'Top Left Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'top_left_video',
					'title'      => esc_html__( 'Top Left Video URL', 'coppola-core' ),
					'group'      => esc_html__( 'Top Left Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'top_left_text',
					'title'      => esc_html__( 'Top Left Text', 'coppola-core' ),
					'group'      => esc_html__( 'Top Left Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'top_left_link',
					'title'      => esc_html__( 'Top Left Link', 'coppola-core' ),
					'group'      => esc_html__( 'Top Left Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'top_right_title',
					'title'      => esc_html__( 'Top Right Title', 'coppola-core' ),
					'group'      => esc_html__( 'Top Right Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'top_right_video',
					'title'      => esc_html__( 'Top Right Video URL', 'coppola-core' ),
					'group'      => esc_html__( 'Top Right Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'top_right_text',
					'title'      => esc_html__( 'Top Right Text', 'coppola-core' ),
					'group'      => esc_html__( 'Top Right Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'top_right_link',
					'title'      => esc_html__( 'Top Right Link', 'coppola-core' ),
					'group'      => esc_html__( 'Top Right Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'bottom_right_title',
					'title'      => esc_html__( 'Bottom Right Title', 'coppola-core' ),
					'group'      => esc_html__( 'Bottom Right Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'bottom_right_video',
					'title'      => esc_html__( 'Bottom Right Video URL', 'coppola-core' ),
					'group'      => esc_html__( 'Bottom Right Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'bottom_right_text',
					'title'      => esc_html__( 'Bottom Right Text', 'coppola-core' ),
					'group'      => esc_html__( 'Bottom Right Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'bottom_right_link',
					'title'      => esc_html__( 'Bottom Right Link', 'coppola-core' ),
					'group'      => esc_html__( 'Bottom Right Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'bottom_left_title',
					'title'      => esc_html__( 'Bottom Left Title', 'coppola-core' ),
					'group'      => esc_html__( 'Bottom Left Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'bottom_left_video',
					'title'      => esc_html__( 'Bottom Left Video URL', 'coppola-core' ),
					'group'      => esc_html__( 'Bottom Left Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'bottom_left_text',
					'title'      => esc_html__( 'Bottom Left Text', 'coppola-core' ),
					'group'      => esc_html__( 'Bottom Left Item', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'bottom_left_link',
					'title'      => esc_html__( 'Bottom Left Link', 'coppola-core' ),
					'group'      => esc_html__( 'Bottom Left Item', 'coppola-core' ),
				)
			);
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['this_shortcode'] = $this;

			return coppola_core_get_template_part( 'shortcodes/interactive-corners', 'variations/' . $atts['layout'] . '/templates/' . $atts['layout'], '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-interactive-corners';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';
			$holder_classes[] = ( 'yes' === $atts['retina_scaling'] ) ? 'qodef--retina' : '';

			return implode( ' ', $holder_classes );
		}

		public function get_title_styles( $item ) {
			$styles = array();

			if ( ! empty( $item['item_title_color'] ) ) {
				$styles[] = 'color: ' . $item['item_title_color'];
			}

			return $styles;
		}
	}
}
