(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_interactive_corners = {};

	$( document ).ready(
		function () {
			qodefInteractiveCornersList.init();
		}
	);

	var qodefInteractiveCornersList = {
		init: function () {
			this.holder = $( '.qodef-interactive-corners' );
			var $header = $( '#qodef-page-mobile-header' );

			var $headerHeight = $header.outerHeight() + 'px';

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						if ( qodef.windowWidth < 1025 ) {
							$( this ).css(
								'height',
								'calc(100vh - ' + $headerHeight + ')'
							);
						}
						qodefInteractiveCornersList.initActiveItem( $( this ) );
					}
				);
			}
		},
		initActiveItem: function ( $currentItem ) {
			var $title   = $currentItem.find( '.qodef-ic-title' ),
				$parents = $title.parents();

			$title.first().closest( 'div' ).addClass( 'qodef-ic-active-item' );

			$title.on(
				'mouseenter touchstart',
				function () {
					$parents.removeClass( 'qodef-ic-active-item' );
					$( this ).closest( 'div' ).addClass( 'qodef-ic-active-item' );

					var $current = $( this ).closest( 'div' );

					TweenMax.to(
						$current.find( '#gooBlur' ),
						0.5,
						{
							attr: {
								stdDeviation: '20'
							},
							onComplete: function () {
								TweenMax.to(
									$current.find( '#gooBlur' ),
									0.5,
									{
										attr: {
											stdDeviation: '0'
										}
									}
								);
							}
						}
					);

					TweenMax.to(
						$current.find( '.text1' ),
						1,
						{
							autoAlpha: 0,
							ease: 'Power2.easeInOut',
						}
					);

					TweenMax.to(
						$current.find( '.text2' ),
						1,
						{
							autoAlpha: 1,
							ease: 'Power2.easeInOut',
						}
					);
				}
			);

			if ( qodef.windowWidth < 1025 ) {
				$title.on(
					'click',
					function ( e ) {
						if ( ! $( this ).is( '.clicked' ) ) {
							e.preventDefault();
							$title.removeClass( 'clicked' );
							$( this ).addClass( 'clicked' );

							$parents.removeClass( 'qodef-ic-active-item' );
							$( this ).closest( 'div' ).addClass( 'qodef-ic-active-item' );
						}
					}
				);
			}
		}
	};
})( jQuery );
