<?php

if ( ! function_exists( 'coppola_core_add_icon_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function coppola_core_add_icon_widget( $widgets ) {
		$widgets[] = 'CoppolaCore_Icon_Widget';

		return $widgets;
	}

	add_filter( 'coppola_core_filter_register_widgets', 'coppola_core_add_icon_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class CoppolaCore_Icon_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'coppola_core_icon',
				)
			);

			if ( $widget_mapped ) {
				$this->set_base( 'coppola_core_icon' );
				$this->set_name( esc_html__( 'Coppola Icon', 'coppola-core' ) );
				$this->set_description( esc_html__( 'Add a icon element into widget areas', 'coppola-core' ) );
			}
		}

		public function render( $atts ) {
			echo CoppolaCore_Icon_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
