(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_icon_list_item = {};
	
	$( document ).ready(
		function () {
			qodefIconListItem.init();
		}
	);
	
	var qodefIconListItem = {
		init: function () {
			this.iconListItem = $( '.qodef-icon-list-item a' );
			if ( this.iconListItem.length ) {
				this.iconListItem.each(
					function () {
						qodefIconListItem.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			qodefIconListItem.iconHoverColor( $currentItem );
		},
		iconHoverColor: function ( $icon ) {
			if ( typeof $icon.data( 'hover-color' ) !== 'undefined' ) {
				var hoverColor    = $icon.data( 'hover-color' );
				var originalColor = $icon.css( 'color' );

				$icon.on(
					'mouseenter touchstart',
					function () {
						qodefIconListItem.changeColor( $icon, 'color', hoverColor );
					}
				);
				$icon.on(
					'mouseleave touchend',
					function () {
						qodefIconListItem.changeColor( $icon, 'color', originalColor );
					}
				);
			}
		},
		changeColor: function ( $icon, cssProperty, color ) {
			$icon.css( cssProperty, color );
		}
	};

	qodefCore.shortcodes.coppola_core_icon_list_item.qodefIconListItem = qodefIconListItem;

})( jQuery );
