<?php

if ( ! function_exists( 'coppola_core_add_horizontal_showcase_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function coppola_core_add_horizontal_showcase_shortcode( $shortcodes ) {
		$shortcodes[] = 'CoppolaCore_Horizontal_Showcase_Shortcode';

		return $shortcodes;
	}

	add_filter( 'coppola_core_filter_register_shortcodes', 'coppola_core_add_horizontal_showcase_shortcode' );
}

if ( class_exists( 'CoppolaCore_Shortcode' ) ) {
	class CoppolaCore_Horizontal_Showcase_Shortcode extends CoppolaCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( COPPOLA_CORE_SHORTCODES_URL_PATH . '/horizontal-showcase' );
			$this->set_base( 'coppola_core_horizontal_showcase' );
			$this->set_name( esc_html__( 'Horizontal Showcase', 'coppola-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds horizontal showcase element', 'coppola-core' ) );
			$this->set_scripts(
				array(
					'smooth-scrollbar' => array(
						'registered' => false,
						'url'        => COPPOLA_CORE_SHORTCODES_URL_PATH . '/horizontal-showcase/assets/js/plugins/smooth-scrollbar.js',
						'dependency' => array( 'jquery' ),
					),
					'overscroll'       => array(
						'registered' => false,
						'url'        => COPPOLA_CORE_SHORTCODES_URL_PATH . '/horizontal-showcase/assets/js/plugins/overscroll.js',
						'dependency' => array( 'jquery' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'coppola-core' ),
				)
			);
			if ( qode_framework_is_installed( 'elementor' ) ) {
				$elementor_sections = coppola_core_generate_elementor_templates_control( $this );

				if ( ! empty( $elementor_sections ) ) {
					$this->set_option( $elementor_sections );
				}
			}
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_parallax',
					'title'         => esc_html__( 'Enable Parallax', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
					'group'         => esc_html__( 'Animations', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Child elements', 'coppola-core' ),
					'items'      => array(
						array(
							'field_type' => 'image',
							'name'       => 'item_image',
							'title'      => esc_html__( 'Image', 'coppola-core' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_title',
							'title'      => esc_html__( 'Title', 'coppola-core' ),
						),
						array(
							'field_type' => 'select',
							'name'       => 'item_title_tag',
							'title'      => esc_html__( 'Title Tag', 'coppola-core' ),
							'options'    => coppola_core_get_select_type_options_pool( 'title_tag' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'word_custom_color_positions_title',
							'title'      => esc_html__( 'Word Custom Color Positions Title', 'coppola-core' ),
						),
						array(
							'field_type'  => 'color',
							'name'        => 'word_custom_color_title',
							'title'       => esc_html__( 'Word Custom Color Title', 'coppola-core' ),
							'description' => esc_html__( 'Enter the positions of the words which need to be displayed with a different color. Separate the positions with commas (e.g. if you would like the first, third, and fourth word to have a different color, you would enter "1,3,4")', 'coppola-core' ),
						),
						array(
							'field_type'  => 'text',
							'name'        => 'word_svg_position',
							'title'       => esc_html__( 'SVG Word Overlay Position', 'coppola-core' ),
							'description' => esc_html__( 'Insert the position of the word where the SVG word overlay will be displayed - the graphic is set in the theme\'s General options', 'coppola-core' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_tagline',
							'title'      => esc_html__( 'Tagline', 'coppola-core' ),
						),
						array(
							'field_type' => 'textarea',
							'name'       => 'item_text',
							'title'      => esc_html__( 'Text', 'coppola-core' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'word_custom_color_positions_text',
							'title'      => esc_html__( 'Word Custom Color Positions Text', 'coppola-core' ),
						),
						array(
							'field_type' => 'color',
							'name'       => 'word_custom_color_text',
							'title'      => esc_html__( 'Word Custom Color Text', 'coppola-core' ),
						),
						array(
							'field_type' => 'select',
							'name'       => 'item_text_tag',
							'title'      => esc_html__( 'Text Tag', 'coppola-core' ),
							'options'    => coppola_core_get_select_type_options_pool( 'title_tag' ),
						),
						array(
							'field_type' => 'text',
							'name'       => 'item_author',
							'title'      => esc_html__( 'Author', 'coppola-core' ),
						),
						array(
							'field_type'    => 'select',
							'name'          => 'layout',
							'title'         => esc_html__( 'Button Type', 'coppola-core' ),
							'options'       => $this->get_button_layouts(),
							'default_value' => 'textual',
						),
						array(
							'field_type' => 'text',
							'name'       => 'text',
							'title'      => esc_html__( 'Button Text', 'coppola-core' ),
						),
						array(
							'field_type'    => 'text',
							'name'          => 'link',
							'title'         => esc_html__( 'Link', 'coppola-core' ),
							'default_value' => '',
						),
					),
				)
			);
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'coppola_core_horizontal_showcase', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['content']        = Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $atts['predefined_section'] );
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['item_classes']   = $this->get_item_classes( $atts );
			$atts['this_shortcode'] = $this;

			return coppola_core_get_template_part( 'shortcodes/horizontal-showcase', 'templates/horizontal-showcase', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-horizontal-showcase';
			$holder_classes[] = 'qodef--focus-in-viewport';
			$holder_classes[] = 'yes' === $atts['enable_parallax'] ? 'qodef--parallax' : '';

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			return implode( ' ', $item_classes );
		}

		private function get_button_layouts() {
			$options = array();

			$button_layouts = apply_filters( 'coppola_core_filter_button_layouts', array() );

			foreach ( $button_layouts as $key => $value ) {
				$options[ $key ] = $value;
			}

			return $options;
		}

		public function get_modified_title( $atts ) {
			$title = $atts['item_title'];
			$svg   = coppola_core_set_svg_overlay();

			if ( ! empty( $title ) ) {
				$split_title = explode( ' ', $title );

				if ( ! empty( $atts['word_custom_color_positions_title'] ) && isset( $atts['word_custom_color_title'] ) ) {
					$split_title = coppola_core_set_word_custom_color( $split_title, $atts['word_custom_color_positions_title'], $atts['word_custom_color_title'] );
				}

				if ( ! empty( $atts['word_svg_position'] ) && ! empty( $svg ) ) {
					$word_svg_position = intval( $atts['word_svg_position'] );
					if ( isset( $split_title[ $word_svg_position - 1 ] ) && ! empty( $split_title[ $word_svg_position - 1 ] ) ) {
						$split_title[ $word_svg_position - 1 ] = '<span class="qodef-e-svg">' . $split_title[ $word_svg_position - 1 ] . coppola_core_section_title_wp_kses( $svg ) . '</span>';
					}
				}
				$title = implode( ' ', $split_title );
			}

			return $title;
		}

		public function get_modified_text( $atts ) {
			$title = $atts['item_text'];

			if ( ! empty( $title ) ) {
				$split_title = explode( ' ', $title );

				if ( ! empty( $atts['word_custom_color_positions_text'] ) && isset( $atts['word_custom_color_text'] ) ) {
					$split_title = coppola_core_set_word_custom_color( $split_title, $atts['word_custom_color_positions_text'], $atts['word_custom_color_text'] );
				}

				$title = implode( ' ', $split_title );
			}

			return $title;
		}
	}
}
