(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_horizontal_showcase = {};

	$( window ).on(
		'load',
		function () {
			qodefHorizontalShowcase.init();
		}
	);

	$( document ).ready(
		function () {
			qodefHorizontalShowcaseAppear.init();
		}
	);

	$( window ).on(
		'resize',
		function () {
			qodefHorizontalShowcase.init();
		}
	);

	$( window ).on(
		'orientationchange',
		function () {
			qodefHorizontalShowcase.init();
		}
	);

	var qodefHorizontalShowcase = {
		init: function () {
			var $holder = $( '.qodef-horizontal-showcase' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						qodefHorizontalShowcase.initItem( $( this ) );

						if ( $( this ).hasClass( 'qodef--parallax' ) ) {
							qodefHorizontalShowcase.initParallax( $( this ) );
						}
					}
				);
			}
		},
		initItem: function ( $thisHolder ) {
			if ( qodef.windowWidth > 1024 ) {
				qodefHorizontalShowcase.animateSlider( $thisHolder );
			}
		},
		animateSlider: function ( $thisHolder ) {
			/* logic for scrolling slider - start */

			var $Scrollbar = window.Scrollbar;

			//custom horizontalscroll plugin
			class HorizontalScrollPlugin extends Scrollbar.ScrollbarPlugin {
				transformDelta( delta, fromEvent ) {
					if ( ! /wheel/.test( fromEvent.type ) ) {
						return delta;
					}

					const { x, y } = delta;

					return {
						y: 0,
						x: Math.abs( x ) > Math.abs( y ) ? x : y
					};
				}
			}

			function _defineProperty( obj, key, value ) {
				if ( key in obj ) {
					Object.defineProperty(
						obj,
						key,
						{ value: value, enumerable: true, configurable: true, writable: true }
					);
				} else {
					obj[key] = value;
				}
				return obj;
			}

			_defineProperty(
				HorizontalScrollPlugin,
				'pluginName',
				'horizontalScroll'
			);

			//initialize scrolling
			$Scrollbar.use( HorizontalScrollPlugin );
			$Scrollbar.use( window.OverscrollPlugin );

			var thresholdScroll      = 0, //used for trashold
				triggerScroll        = false;
			var $horizontalScrollbar = $Scrollbar.init(
				document.querySelector( '.qodef-horizontal-showcase .qodef-m-items' ),
				{
					damping: 0.05,
					continuousScrolling: true,
					plugins: {
						overscroll: {
							onScroll: function ( thisScroll ) {
								if ( $thisHolder.hasClass( 'qodef--focus-in-viewport' ) ) { //if 'Enable Focus When in Viewport' option is enabled
									//when thresholdScroll reaches desired amount, than we trigger scrolling of page so slider would not be in viewport
									// depending on direction we scroll up or down
									thresholdScroll += Math.abs( thisScroll.x ); //aboslute value is taken sice x could be negative, depending on scroll direction
									if ( thresholdScroll > 2000 && ! triggerScroll ) {
										triggerScroll = true;
										qodefCore.qodefScroll.disable();
										var direction = thisScroll.x > 0 ? 'down' : 'up';
										scrollSliderOut( direction );
									}
								} else { //than just enable countinius scrolling
									$horizontalScrollbar.options.continuousScrolling = true;
								}
							},
							damping: 0.1,
							maxOverscroll: 150
						}
					}
				}
			);

			var scrollSliderOut = function ( direction ) {
				//calculate where to scroll page, depending on scroll direction
				var scrollTopAmount = direction == 'down' ? $thisHolder.offset().top + $thisHolder.outerHeight( true ) : $thisHolder.offset().top - qodef.windowHeight;

				$( 'html, body' ).stop().animate(
					{
						scrollTop: scrollTopAmount
					},
					1200,
					function () {
						$horizontalScrollbar.options.continuousScrolling = true;
						thresholdScroll                                  = 0;
						triggerScroll                                    = false;
						qodefCore.qodefScroll.enable();
					}
				);
			};

			//if 'Enable Focus When in Viewport' option is enabled, than watch scroll to focus slider when in viewport
			if ( $thisHolder.hasClass( 'qodef--focus-in-viewport' ) ) {

				var thisHolderTopOffset    = $thisHolder.offset().top,
					thisHolderBottomOffset = $thisHolder.offset().top + $thisHolder.outerHeight( true );

				//we have to listen wheel, since slider could be positioned on middle of page in some situations, and than our qodefIsInViewport will not work
				window.addEventListener(
					'wheel',
					function ( e ) {

						var previousPosition = $( window ).scrollTop(),
							currentPosition  = previousPosition + e.deltaY;

						//check direction of scroll and scroll page to slider slider top offset position
						if ( (e.deltaY > 0 && currentPosition < thisHolderTopOffset) || (e.deltaY < 0 && thisHolderBottomOffset < currentPosition + qodefAddonsCore.windowHeight) ) {
							qodefCore.qodefIsInViewport.check(
								$thisHolder,
								function () {
									qodefCore.qodefScroll.disable();
									$( 'html, body' ).stop().animate(
										{
											scrollTop: thisHolderTopOffset
										},
										1200,
										function () {
											triggerScroll = false;
											qodefCore.qodefScroll.enable();
										},
									);
								},
								true
							);
						}
					},
					{ passive: false }
				);
			}

			/* logic for scrolling slider - end */

			/* logic for show items on load/scroll - start */

			var $items        = $thisHolder.find( '.qodef-e' ),
				$first        = $thisHolder.find( '.qodef-intro-slide' ),
				$firstContent = $first.find( '.qodef-m-first-slide' );

			if ( $first.length && $firstContent.length ) {
				$first.css(
					'width',
					qodef.windowWidth * .88 + 'px'
				);
			}

			$items.each(
				function ( i ) {
					var $element = $( this );
					if ( i % 5 === 0 ) {
						$element.css(
							'width',
							qodef.windowWidth * .88 + 'px'
						);
						$element.find( '.qodef-e-media-image img' ).css(
							'max-width',
							qodef.windowWidth * .88 + 150 + 'px'
						);
					} else if ( i % 5 === 4 ) {
						$element.css(
							'width',
							qodef.windowWidth * .37 + 'px'
						);
						$element.find( '.qodef-e-media-image img' ).css(
							'max-width',
							qodef.windowWidth * .37 + 150 + 'px'
						);
					} else {
						$element.css(
							'width',
							qodef.windowWidth * .37 + 'px'
						);
					}
				}
			);

			//set data offset to items, so we could know when to show them
			$items.each(
				function ( i ) {
					var $thisOffsetLeft = $( this ).offset().left;
					$( this ).attr(
						'data-offset-left',
						$thisOffsetLeft
					);
					$( this ).data(
						'offset-left',
						$thisOffsetLeft
					);
				}
			);

			//if some items are in viewport on load, than show them
			$items.each(
				function ( i ) {
					var thisItem = $( this );
					if ( $thisHolder.width() > $( this ).data( 'offset-left' ) ) {
						setTimeout(
							function () {
								thisItem.addClass( 'qodef--appear' );
							},
							(i + 1) * 200
						);
					}
				}
			);

			//check items on scroll and show them when they are in viewport
			$horizontalScrollbar.addListener(
				function () {
					var scrollbarOffset = this.offset.x;
					$items.each(
						function () {
							if ( ! $( this ).hasClass( 'qodef--appear' ) ) {
								if ( $thisHolder.width() + scrollbarOffset > $( this ).data( 'offset-left' ) ) {
									$( this ).addClass( 'qodef--appear qodef--appear-delay' );
								}
							}
						}
					);
				}
			);

			/* logic for show items on load/scroll - end */
		},
		initParallax: function ( $thisHolder ) {
			var $parallaxImage = $thisHolder.find( '.qodef-m-item:nth-of-type(5n + 2) img, .qodef-m-item:nth-of-type(5n+6) img' );

			$parallaxImage.each( function () {
				var $thisItem     = $( this ),
					thisItemWidth = $thisItem.outerWidth(),
					progressVal   = 0,
					modifier      = 'translateX',
					modifierUnit  = 'px',
					startValue    = 150,
					endValue      = 0;

				// Set init value
				$thisItem.waitForImages( function () {
					$thisItem.css(
						'transform',
						modifier + '(' + startValue + modifierUnit + ')'
					);
				} );

				if ( qodefCore.windowWidth > 1024 ) {
					$( $thisHolder ).on(
						'wheel',
						function () {
							var thisItemLeft  = $thisItem.offset().left,
								thisItemRight = thisItemLeft + thisItemWidth;

							if ( qodef.scroll + window.innerWidth > thisItemLeft ) {
								progressVal = Math.abs( qodef.scroll + window.innerWidth - thisItemRight ) / window.innerWidth;
								if ( progressVal < 1 ) {
									$thisItem.css(
										'transform',
										modifier + '(' + (endValue + (1 - progressVal) * Math.abs( 1 - startValue )) + modifierUnit + ')'
									);
								}
							}
						}
					);
				}
			} );
		}
	};

	var qodefHorizontalShowcaseAppear = {
		init: function () {
			var $holder = $( '.qodef-horizontal-showcase' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						qodefHorizontalShowcaseAppear.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $holder ) {

			qodefCore.qodefIsInViewport.check(
				$holder.find( '.qodef-intro-slide' ),
				function () {
					$holder.addClass( 'qodef--appeared' );
				},
			);
		},
	};

	qodefCore.shortcodes.coppola_core_horizontal_showcase.qodefHorizontalShowcaseAppear = qodefHorizontalShowcaseAppear;
	qodefCore.shortcodes.coppola_core_horizontal_showcase.qodefHorizontalShowcase       = qodefHorizontalShowcase;

})( jQuery );
