<?php

if ( ! function_exists( 'coppola_core_get_list_shortcode_item_image' ) ) {
	/**
	 * Function that generates thumbnail img tag for list shortcodes
	 *
	 * @param string $image_dimension
	 * @param int $attachment_id
	 * @param int $custom_image_width
	 * @param int $custom_image_height
	 *
	 * @return string generated img tag
	 *
	 * @see qode_framework_generate_thumbnail()
	 */
	function coppola_core_get_list_shortcode_item_image( $image_dimension, $attachment_id = 0, $custom_image_width = 0, $custom_image_height = 0 ) {
		$item_id = get_the_ID();

		if ( 'custom' !== $image_dimension ) {
			if ( ! empty( $attachment_id ) ) {
				$html = wp_get_attachment_image( $attachment_id, $image_dimension );
			} else {
				$html = get_the_post_thumbnail( $item_id, $image_dimension );
			}
		} else {
			if ( ! empty( $custom_image_width ) && ! empty( $custom_image_height ) ) {
				if ( ! empty( $attachment_id ) ) {
					$html = qode_framework_generate_thumbnail( intval( $attachment_id ), $custom_image_width, $custom_image_height );
				} else {
					$html = qode_framework_generate_thumbnail( intval( get_post_thumbnail_id( $item_id ) ), $custom_image_width, $custom_image_height );
				}
			} else {
				$html = get_the_post_thumbnail( $item_id, $image_dimension );
			}
		}

		return apply_filters( 'coppola_core_filter_list_shortcode_item_image', $html, $attachment_id );
	}
}

if ( ! function_exists( 'coppola_core_get_list_shortcode_item_image_url' ) ) {
	/**
	 * Function that return thumbnail img url for list shortcodes
	 *
	 * @param string $image_dimension
	 * @param int $attachment_id
	 *
	 * @return string
	 */
	function coppola_core_get_list_shortcode_item_image_url( $image_dimension, $attachment_id = 0 ) {

		if ( ! empty( $attachment_id ) ) {
			$image = wp_get_attachment_image_src( intval( $attachment_id ), $image_dimension );
			$url   = $image[0];
		} else {
			$url = get_the_post_thumbnail_url( get_the_ID(), $image_dimension );
		}

		return $url;
	}
}

if ( ! function_exists( 'coppola_core_set_word_custom_color' ) ) {
	/**
	 * Function that adds custom color to selected words in the string
	 *
	 * @param array $split_title
	 * @param string $positions
	 * @param string $color
	 *
	 * @return array
	 */
	function coppola_core_set_word_custom_color( $split_title, $positions, $color ) {
		$word_custom_color_positions = explode( ',', str_replace( ' ', '', $positions ) );

		foreach ( $word_custom_color_positions as $position ) {
			$position = intval( $position );
			if ( isset( $split_title[ $position - 1 ] ) && ! empty( $split_title[ $position - 1 ] ) ) {
				$split_title[ $position - 1 ] = '<span class="qodef-e-custom-color" style="color: ' . esc_attr( $color ) . '">' . $split_title[ $position - 1 ] . '</span>';
			}
		}

		return $split_title;
	}
}

if ( ! function_exists( 'coppola_core_set_svg_overlay' ) ) {
	/**
	 * Function that adds an SVG image to a selected word in the string
	 *
	 *
	 * @return string
	 */
	function coppola_core_set_svg_overlay() {
		if ( ( 'predefined' === coppola_core_get_post_value_through_levels( 'qodef_svg_word_overlay_source', get_the_ID() ) ) ) {
			$svg = coppola_core_get_svg_icon( 'underline' );
		} else {
			$svg = coppola_core_get_post_value_through_levels( 'qodef_svg_word_overlay', get_the_ID() );
		}

		return $svg;
	}
}

if ( ! function_exists( 'coppola_core_section_title_wp_kses' ) ) {
	/**
	 * Function that does escaping of section title html.
	 * It uses wp_kses function with predefined attributes array.
	 *
	 * @param string $content - string to escape
	 *
	 * @return string escaped output
	 * @see wp_kses()
	 *
	 */
	function coppola_core_section_title_wp_kses( $content ) {
		$atts = array(
			'svg'      => array(
				'xmlns'             => true,
				'version'           => true,
				'id'                => true,
				'class'             => true,
				'x'                 => true,
				'y'                 => true,
				'aria-hidden'       => true,
				'aria-labelledby'   => true,
				'role'              => true,
				'width'             => true,
				'height'            => true,
				'viewbox'           => true,
				'enable-background' => true,
				'focusable'         => true,
				'data-prefix'       => true,
				'data-icon'         => true,
				'style'             => true,
			),
			'style'    => array(),
			'g'        => array(
				'stroke'       => true,
				'class'        => true,
				'stroke-width' => true,
				'fill'         => true,
				'fill-opacity' => true,
				'transform'    => true,
			),
			'rect'     => array(
				'x'         => true,
				'y'         => true,
				'width'     => true,
				'height'    => true,
				'transform' => true,
			),
			'title'    => array(
				'title' => true,
			),
			'path'     => array(
				'd'            => true,
				'stroke'       => true,
				'stroke-width' => true,
				'fill'         => true,
				'fill-opacity' => true,
				'transform'    => true,
				'class'        => true,
			),
			'polygon'  => array(
				'points' => true,
			),
			'line'     => array(
				'x1'        => true,
				'x2'        => true,
				'y1'        => true,
				'y2'        => true,
				'transform' => true,
			),
			'polyline' => array(
				'points'    => true,
				'transform' => true,
			),
			'circle'   => array(
				'cx'           => true,
				'cy'           => true,
				'r'            => true,
				'stroke'       => true,
				'stroke-width' => true,
				'fill'         => true,
				'fill-opacity' => true,
				'transform'    => true,
			),
			'div'      => array(
				'id'    => true,
				'class' => true,
				'style' => true,
			),
			'ul'       => array(
				'class' => true,
			),
			'li'       => array(
				'class' => true,
			),
			'br'       => true,
			'h1'       => array(
				'class' => true,
				'style' => true,
			),
			'h2'       => array(
				'class' => true,
				'style' => true,
			),
			'h3'       => array(
				'class' => true,
				'style' => true,
			),
			'h4'       => array(
				'class' => true,
				'style' => true,
			),
			'h5'       => array(
				'class' => true,
				'style' => true,
			),
			'h6'       => array(
				'class' => true,
				'style' => true,
			),
			'p'        => array(
				'id'    => true,
				'class' => true,
				'style' => true,
			),
			'a'        => array(
				'itemprop' => true,
				'id'       => true,
				'class'    => true,
				'href'     => true,
				'target'   => true,
				'style'    => true,
				'rel'      => true,
				'data-rel' => true,
			),
			'span'     => array(
				'id'    => true,
				'class' => true,
				'style' => true,
			),
			'i'        => array(
				'class' => true,
			),
			'img'      => array(
				'itemprop' => true,
				'id'       => true,
				'class'    => true,
				'width'    => true,
				'height'   => true,
				'src'      => true,
				'srcset'   => true,
				'sizes'    => true,
				'alt'      => true,
				'title'    => true,
			),
		);

		return wp_kses( $content, $atts );
	}
}

//function that returns all Elementor saved templates
if ( ! function_exists( 'coppola_core_return_elementor_templates' ) ) {

	function coppola_core_return_elementor_templates() {
		return Elementor\Plugin::instance()->templates_manager->get_source( 'local' )->get_items();
	}
}

//function that adds Template Elementor Control
if ( ! function_exists( 'coppola_core_generate_elementor_templates_control' ) ) {

	function coppola_core_generate_elementor_templates_control( $object, $control_name = 'template_id' ) {
		$templates = coppola_core_return_elementor_templates();

		if ( ! empty( $templates ) ) {
			$options = array(
				'0' => '— ' . esc_html__( 'Select', 'coppola-core' ) . ' —',
			);

			$types = array();

			foreach ( $templates as $template ) {
				$options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
				$types[ $template['template_id'] ]   = $template['type'];
			}

			return array(
				'field_type'    => 'select',
				'name'          => 'predefined_section',
				'title'         => esc_html__( 'Choose Template', 'coppola-core' ),
				'options'       => $options,
				'default_value' => '0',
			);
		}
	}
}
