(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_frame_slider = {};

	$( document ).ready(
		function () {
			qodefFrameSlider.init();
		}
	);

	var qodefFrameSlider = {
		init: function () {
			this.holder = $( '.qodef-frame-slider-holder' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefFrameSlider.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $holder ) {
			var $pad             = $holder.find('.qodef-frame-slider-pad'),
				$swiperHolderPad = $pad.find( '.qodef-m-swiper' ),
				$sliderHolderPad = $pad.find( '.qodef-m-items' ),
				$mob             = $holder.find('.qodef-frame-slider-mob'),
				$swiperHolderMob = $mob.find( '.qodef-m-swiper' ),
				$sliderHolderMob = $mob.find( '.qodef-m-items' );

			var $swiperPad = new Swiper(
				$swiperHolderPad,
				{
					effect: 'fade',
					slidesPerView: 1,
					centeredSlides: true,
					spaceBetween: 0,
					autoplay: true,
					loop: true,
					speed: 800,
					on: {
						init: function () {
							setTimeout(
								function () {
									$sliderHolderPad.addClass( 'qodef-swiper--initialized' );
								},
								1500
							);
						}
					},
				}
			);
			
			var $swiperMob = new Swiper(
				$swiperHolderMob,
				{
					effect: 'fade',
					slidesPerView: 1,
					centeredSlides: true,
					spaceBetween: 0,
					autoplay: {
						delay: 3300,
					},
					loop: true,
					speed: 600,
					on: {
						init: function () {
							setTimeout(
								function () {
									$sliderHolderMob.addClass( 'qodef-swiper--initialized' );
								},
								1500
							);
						}
					},
				}
			);
		}
	};

	qodefCore.shortcodes.coppola_core_frame_slider.qodefFrameSlider = qodefFrameSlider;

})( jQuery );
