<?php

if ( ! function_exists( 'coppola_core_add_events_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function coppola_core_add_events_shortcode( $shortcodes ) {
		$shortcodes[] = 'CoppolaCore_Events_Shortcode';

		return $shortcodes;
	}

	add_filter( 'coppola_core_filter_register_shortcodes', 'coppola_core_add_events_shortcode' );
}

if ( class_exists( 'CoppolaCore_Shortcode' ) ) {
	class CoppolaCore_Events_Shortcode extends CoppolaCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( COPPOLA_CORE_SHORTCODES_URL_PATH . '/events' );
			$this->set_base( 'coppola_events_gallery' );
			$this->set_name( esc_html__( 'Events', 'coppola-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds events holder', 'coppola-core' ) );
			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Events Items', 'coppola-core' ),
					'items'      => array(
						array(
							'field_type'    => 'text',
							'name'          => 'date',
							'title'         => esc_html__( 'Date', 'coppola-core' ),
							'default_value' => '',
						),
						array(
							'field_type'    => 'text',
							'name'          => 'title',
							'title'         => esc_html__( 'Title', 'coppola-core' ),
							'default_value' => '',
						),
						array(
							'field_type'    => 'text',
							'name'          => 'time',
							'title'         => esc_html__( 'Time', 'coppola-core' ),
							'default_value' => '',
						),
						array(
							'field_type'    => 'text',
							'name'          => 'view_more',
							'title'         => esc_html__( 'View More Link', 'coppola-core' ),
							'default_value' => '',
						),
						array(
							'field_type'    => 'text',
							'name'          => 'get_ticket',
							'title'         => esc_html__( 'Ticket Link', 'coppola-core' ),
							'default_value' => '',
						),
					),
				)
			);
			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts                   = $this->get_atts();
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['this_object']    = $this;
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );

			return coppola_core_get_template_part( 'shortcodes/events', 'templates/events', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-events';

			return implode( ' ', $holder_classes );
		}

		public function getItemAdditional( $items_atts ) {
			$additional = array();

			$additional['classes']       = 'qodef-m-events-image';
			$additional['circle_styles'] = '';
			$additional['image_styles']  = '';

			$additional['classes'] .= isset( $items_atts['image_background_color'] ) ? 'qodef-has-background' : '';

			if ( ! empty( $items_atts['circle_background_color'] ) ) {
				$additional['circle_styles'] = 'background-color: ' . $items_atts['circle_background_color'];
			}

			if ( ! empty( $items_atts['image_background_color'] ) ) {
				$additional['image_styles'] = 'background-color: ' . $items_atts['image_background_color'];
			}

			return $additional;
		}
	}
}
