(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefAuthorListPagination.init();
		}
	);

	$( window ).scroll(
		function () {
			qodefAuthorListPagination.scroll();
		}
	);

	$( document ).on(
		'coppola_core_trigger_author_load_more',
		function ( e, $holder, nextPage ) {
			qodefAuthorListPagination.triggerLoadMore( $holder, nextPage );
		}
	);

	/*
	 **	Init pagination functionality
	 */
	var qodefAuthorListPagination = {
		init: function ( settings ) {
			this.holder = $( '.qodef-author-pagination--on' );

			// Allow overriding the default config
			$.extend( this.holder, settings );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						var $holder = $( this );

						qodefAuthorListPagination.initPaginationType( $holder );
					}
				);
			}
		},
		scroll: function ( settings ) {
			this.holder = $( '.qodef-author-pagination--on' );

			// Allow overriding the default config
			$.extend( this.holder, settings );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						var $holder = $( this );

						if ( $holder.hasClass( 'qodef-pagination-type--infinite-scroll' ) ) {
							qodefAuthorListPagination.initInfiniteScroll( $holder );
						}
					}
				);
			}
		},
		initPaginationType: function ( $holder ) {
			if ( $holder.hasClass( 'qodef-pagination-type--standard' ) ) {
				qodefAuthorListPagination.initStandard( $holder );
			} else if ( $holder.hasClass( 'qodef-pagination-type--load-more' ) ) {
				qodefAuthorListPagination.initLoadMore( $holder );
			} else if ( $holder.hasClass( 'qodef-pagination-type--infinite-scroll' ) ) {
				qodefAuthorListPagination.initInfiniteScroll( $holder );
			}
		},
		initStandard: function ( $holder ) {
			var $paginationItems = $holder.find( '.qodef-m-pagination-items' );

			if ( $paginationItems.length ) {
				var options = $holder.data( 'options' );

				$paginationItems.children().each( function () {
					var $thisItem = $( this ),
						$itemLink = $thisItem.children( 'a' );

					qodefAuthorListPagination.changeStandardState( $holder, options.max_num_pages, 1 );

					$itemLink.on(
						'click',
						function ( e ) {
							e.preventDefault();

							if ( ! $thisItem.hasClass( 'qodef--active' ) ) {
								qodefAuthorListPagination.getNewPosts( $holder, $itemLink.data( 'paged' ) );
							}
						}
					);
				} );
			}
		},
		changeStandardState: function ( $holder, max_num_pages, nextPage ) {
			if ( $holder.hasClass( 'qodef-pagination-type--standard' ) ) {
				var $paginationNav = $holder.find( '.qodef-m-pagination-items' ),
					$numericItem   = $paginationNav.children( '.qodef--number' ),
					$prevItem      = $paginationNav.children( '.qodef--prev' ),
					$nextItem      = $paginationNav.children( '.qodef--next' );

				$numericItem.removeClass( 'qodef--active' ).eq( nextPage - 1 ).addClass( 'qodef--active' );

				$prevItem.children().data( 'paged', nextPage - 1 );

				if ( nextPage > 1 ) {
					$prevItem.show();
				} else {
					$prevItem.hide();
				}

				$nextItem.children().data( 'paged', nextPage + 1 );

				if ( nextPage === max_num_pages ) {
					$nextItem.hide();
				} else {
					$nextItem.show();
				}
			}
		},
		initLoadMore: function ( $holder ) {
			var $loadMoreButton = $holder.find( '.qodef-load-more-button' );

			$loadMoreButton.on(
				'click',
				function ( e ) {
					e.preventDefault();

					qodefAuthorListPagination.getNewPosts( $holder );
				}
			);
		},
		triggerLoadMore: function ( $holder, nextPage ) {
			qodefAuthorListPagination.getNewPosts( $holder, nextPage );
		},
		hideLoadMoreButton: function ( $holder, options ) {
			if ( $holder.hasClass( 'qodef-pagination-type--load-more' ) && options.next_page > options.max_num_pages ) {
				$holder.find( '.qodef-load-more-button' ).hide();
			}
		},
		initInfiniteScroll: function ( $holder ) {
			var holderEndPosition = $holder.outerHeight() + $holder.offset().top,
				scrollPosition    = qodefCore.scroll + qodefCore.windowHeight,
				options           = $holder.data( 'options' );

			if ( ! $holder.hasClass( 'qodef--loading' ) && scrollPosition > holderEndPosition && options.max_num_pages >= options.next_page ) {
				qodefAuthorListPagination.getNewPosts( $holder );
			}
		},
		getNewPosts: function ( $holder, nextPage ) {
			$holder.addClass( 'qodef--loading' );

			var $itemsHolder = $holder.children( '.qodef-grid-inner' );
			var options      = $holder.data( 'options' );

			qodefAuthorListPagination.setNextPageValue( options, nextPage, false );

			$.ajax(
				{
					type: 'GET',
					url: qodefGlobal.vars.restUrl + qodefGlobal.vars.authorPaginationRestRoute,
					data: {
						options: options,
					},
					beforeSend: function ( request ) {
						request.setRequestHeader( 'X-WP-Nonce', qodefGlobal.vars.restNonce );
					},
					success: function ( response ) {

						if ( response.status === 'success' ) {
							qodefAuthorListPagination.setNextPageValue( options, nextPage, true );
							qodefAuthorListPagination.changeStandardState( $holder, options.max_num_pages, nextPage );

							qodef.qodefWaitForImages.check(
								$itemsHolder,
								function () {
									qodefAuthorListPagination.addPosts( $itemsHolder, response.data, nextPage );

									qodefCore.body.trigger(
										'coppola_core_trigger_get_new_authors',
										[$holder]
									);
								}
							);

							qodefAuthorListPagination.hideLoadMoreButton( $holder, options );
						} else {
							console.log( response.message );
						}
					},
					complete: function () {
						$holder.removeClass( 'qodef--loading' );
					}
				}
			);
		},
		setNextPageValue: function ( options, nextPage, ajaxTrigger ) {
			if ( typeof nextPage !== 'undefined' && nextPage !== '' && ! ajaxTrigger ) {
				options.next_page = nextPage;
			} else if ( ajaxTrigger ) {
				options.next_page = parseInt( options.next_page, 10 ) + 1;
			}
		},
		addPosts: function ( $itemsHolder, newItems, nextPage ) {
			if ( typeof nextPage !== 'undefined' && nextPage !== '' ) {
				$itemsHolder.html( newItems );
			} else {
				$itemsHolder.append( newItems );
			}
		}
	};

})( jQuery );
