<?php
$text               = get_post_meta( get_the_ID(), 'qodef_testimonials_text', true );
$text_color         = get_post_meta( get_the_ID(), 'qodef_testimonials_text_color', true );
$svg_positions_text = get_post_meta( get_the_ID(), 'qodef_testimonials_line_position', true );
$text_styles[]      = ! empty( $text_color ) ? 'color: ' . $text_color : '';
$text_tag           = isset( $text_tag ) && ! empty( $text_tag ) ? $text_tag : 'h4';
$params             = array(
	'text'               => $text,
	'svg_positions_text' => $svg_positions_text,
);
$text_modified      = $this_shortcode->get_modified_text( $params );

if ( ! empty( $text ) ) { ?>
	<<?php echo esc_attr( $text_tag ); ?> itemprop="description" class="qodef-e-text" <?php qode_framework_inline_style( $text_styles ); ?>>
	<?php echo coppola_core_section_title_wp_kses( $text_modified ); ?>
	</<?php echo esc_attr( $text_tag ); ?>>
<?php } ?>
