<?php

if ( ! function_exists( 'coppola_core_add_testimonials_list_shortcode' ) ) {
	/**
	 * Function that is adding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function coppola_core_add_testimonials_list_shortcode( $shortcodes ) {
		$shortcodes[] = 'CoppolaCore_Testimonials_List_Shortcode';

		return $shortcodes;
	}

	add_filter( 'coppola_core_filter_register_shortcodes', 'coppola_core_add_testimonials_list_shortcode' );
}

if ( class_exists( 'CoppolaCore_List_Shortcode' ) ) {
	class CoppolaCore_Testimonials_List_Shortcode extends CoppolaCore_List_Shortcode {

		public function __construct() {
			$this->set_post_type( 'testimonials' );
			$this->set_post_type_additional_taxonomies( array( 'testimonials-category' ) );
			$this->set_layouts( apply_filters( 'coppola_core_filter_testimonials_list_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'coppola_core_filter_testimonials_list_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( COPPOLA_CORE_CPT_URL_PATH . '/testimonials/shortcodes/testimonials-list' );
			$this->set_base( 'coppola_core_testimonials_list' );
			$this->set_name( esc_html__( 'Testimonials List', 'coppola-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of testimonials', 'coppola-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'coppola-core' ),
				)
			);
			$this->map_list_options(
				array(
					'exclude_behavior' => array( 'masonry', 'justified-gallery' ),
					'exclude_option'   => array( 'images_proportion' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'skin',
					'title'      => esc_html__( 'Skin', 'coppola-core' ),
					'options'    => array(
						''      => esc_html__( 'Default', 'coppola-core' ),
						'light' => esc_html__( 'Light', 'coppola-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'static_title',
					'title'      => esc_html__( 'Static Title', 'coppola-core' ),
					'group'      => esc_html__( 'Layout', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'static_title_tag',
					'title'         => esc_html__( 'Static Title Tag', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h2',
					'group'         => esc_html__( 'Layout', 'coppola-core' ),
				)
			);
			$this->map_query_options( array( 'post_type' => $this->get_post_type() ) );
			$this->map_layout_options( array( 'layouts' => $this->get_layouts() ) );
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'text_tag',
					'title'         => esc_html__( 'Text Tag', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'title_tag', false ),
					'default_value' => 'h4',
					'group'         => esc_html__( 'Layout', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'font_size',
					'title'      => esc_html__( 'Font Size', 'coppola-core' ),
					'group'      => esc_html__( 'Style', 'coppola-core' ),
				)
			);
			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['post_type'] = $this->get_post_type();

			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );

			$atts['unique'] = rand( 0, 1000 );

			$atts['holder_classes']  = $this->get_holder_classes( $atts );
			$atts['wrapper_classes'] = $this->get_wrapper_classes( $atts );
			$atts['item_classes']    = $this->get_item_classes( $atts );
			$atts['text_styles']     = $this->get_text_styles( $atts );
			$atts['slider_attr']     = $this->get_slider_data( $atts, array( 'unique' => $atts['unique'] ) );
			$atts['query_result']    = new \WP_Query( coppola_core_get_query_params( $atts ) );

			$atts['this_shortcode'] = $this;

			return coppola_core_get_template_part( 'post-types/testimonials/shortcodes/testimonials-list', 'templates/content', $atts['behavior'], $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-testimonials-list';
			$holder_classes[] = isset( $atts['skin'] ) && ! empty( $atts['skin'] ) ? 'qodef-skin--' . $atts['skin'] : '';

			$list_classes   = $this->get_list_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $list_classes );

			return implode( ' ', $holder_classes );
		}

		private function get_wrapper_classes( $atts ) {

			$holder_classes[] = 'qodef-testimonials-list-wrapper';
			$holder_classes[] = isset( $atts['skin'] ) && ! empty( $atts['skin'] ) ? 'qodef-skin--' . $atts['skin'] : '';

			return implode( ' ', $holder_classes );
		}

		private function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$list_item_classes = $this->get_list_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		private function get_text_styles( $atts ) {
			$styles = array();

			$font_size = $atts['font_size'];
			if ( ! empty( $font_size ) ) {
				if ( qode_framework_string_ends_with_typography_units( $font_size ) ) {
					$styles[] = 'font-size: ' . $font_size;
				} else {
					$styles[] = 'font-size: ' . intval( $font_size ) . 'px';
				}
			}

			return $styles;
		}

		public function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}

			return $styles;
		}

		public function get_modified_text( $atts ) {
			$text = $atts['text'];
			$svg  = coppola_core_set_svg_overlay();

			if ( ! empty( $text ) ) {
				$split_text = explode( ' ', $text );
				if ( ! empty( $atts['svg_positions_text'] ) && ! empty( $svg ) ) {
					$word_svg_position = intval( $atts['svg_positions_text'] );

					if ( isset( $split_text[ $word_svg_position - 1 ] ) && ! empty( $split_text[ $word_svg_position - 1 ] ) ) {
						$split_text[ $word_svg_position - 1 ] = '<span class="qodef-e-svg">' . $split_text[ $word_svg_position - 1 ] . coppola_core_section_title_wp_kses( $svg ) . '</span>';
					}
				}

				$text = implode( ' ', $split_text );
			}

			return $text;
		}
	}
}
