<?php

if ( ! function_exists( 'coppola_core_add_testimonials_meta_box' ) ) {
	/**
	 * Function that adds fields for testimonials
	 */
	function coppola_core_add_testimonials_meta_box() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'testimonials' ),
				'type'  => 'meta',
				'slug'  => 'testimonials',
				'title' => esc_html__( 'Testimonials Parameters', 'coppola-core' ),
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_testimonials_title',
					'title'      => esc_html__( 'Title', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'textarea',
					'name'       => 'qodef_testimonials_text',
					'title'      => esc_html__( 'Text', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_testimonials_text_color',
					'title'      => esc_html__( 'Text Color', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_svg_word_overlay_source',
					'title'         => esc_html__( 'Word Overlay SVG Source', 'coppola-core' ),
					'default_value' => 'predefined',
					'options'       => coppola_core_get_select_type_options_pool( 'svg_overlay', false ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'textarea',
					'name'       => 'qodef_svg_word_overlay',
					'title'      => esc_html__( 'Text Word Overlay SVG', 'coppola-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_svg_word_overlay_source' => array(
								'values'        => 'custom_svg',
								'default_value' => 'predefined',
							),
						),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_testimonials_line_position',
					'title'       => esc_html__( 'Text Word Overlay SVG Position', 'coppola-core' ),
					'description' => esc_html__( 'Insert the position of the word where the SVG word overlay will be displayed - the graphic is set in the theme\'s General options', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_testimonials_author_logo',
					'title'      => esc_html__( 'Author Logo', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_testimonials_author',
					'title'      => esc_html__( 'Author', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_testimonials_author_job',
					'title'      => esc_html__( 'Author Job Title', 'coppola-core' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'coppola_core_action_after_testimonials_meta_box_map', $page );
		}
	}

	add_action( 'coppola_core_action_default_meta_boxes_init', 'coppola_core_add_testimonials_meta_box' );
}
