<?php
$title_tag = isset( $title_tag ) && ! empty( $title_tag ) ? $title_tag : 'h2';
$title     = get_post_meta( get_the_ID(), 'qodef_team_member_name', true );
$subtitle  = get_post_meta( get_the_ID(), 'qodef_team_member_surname', true );
$sub_color = get_post_meta( get_the_ID(), 'qodef_team_subtitle_color', true );
?>
<<?php echo esc_attr( $title_tag ); ?> itemprop="name" class="qodef-e-title entry-title" <?php qode_framework_inline_style( $this_shortcode->get_title_styles( $params ) ); ?>>
	<?php if ( $has_single ) { ?>
		<a itemprop="url" class="qodef-e-title-link" href="<?php the_permalink(); ?>">
	<?php } ?>
		<?php
		if ( ! empty( $title ) || ! empty( $subtitle ) ) {
			if ( ! empty( $sub_color ) ) {
				$subtitle = '<span style=color:' . esc_attr( $sub_color ) . '>' . esc_html( $subtitle ) . '</span>';
			}
			$team_member = $title . ' ' . $subtitle;

			echo qode_framework_wp_kses_html( 'content', $team_member );
		} else {
			$team_member = the_title();
		}
		?>
	<?php if ( $has_single ) { ?>
		</a>
	<?php } ?>
</<?php echo esc_attr( $title_tag ); ?>>
