<?php

if ( ! function_exists( 'coppola_core_add_team_single_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function coppola_core_add_team_single_meta_box() {
		$qode_framework = qode_framework_get_framework_root();
		$has_single     = coppola_core_team_has_single();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'team' ),
				'type'  => 'meta',
				'slug'  => 'team',
				'title' => esc_html__( 'Team Single', 'coppola-core' ),
			)
		);

		if ( $page ) {
			$section = $page->add_section_element(
				array(
					'name'        => 'qodef_team_general_section',
					'title'       => esc_html__( 'General Settings', 'coppola-core' ),
					'description' => esc_html__( 'General information about team member.', 'coppola-core' ),
				)
			);

			if ( $has_single ) {
				$section->add_field_element(
					array(
						'field_type'  => 'select',
						'name'        => 'qodef_team_single_layout',
						'title'       => esc_html__( 'Single Layout', 'coppola-core' ),
						'description' => esc_html__( 'Choose default layout for team single', 'coppola-core' ),
						'options'     => array(
							'' => esc_html__( 'Default', 'coppola-core' ),
						),
					)
				);
			}

			$section->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_team_member_name',
					'title'      => esc_html__( 'Name', 'coppola-core' ),
				)
			);

			$section->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_team_member_surname',
					'title'      => esc_html__( 'Surname', 'coppola-core' ),
				)
			);

			$section->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_team_subtitle_color',
					'title'      => esc_html__( 'Set Subtitle Color', 'coppola-core' ),
				)
			);

			$section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_team_member_role',
					'title'       => esc_html__( 'Role', 'coppola-core' ),
					'description' => esc_html__( 'Enter team member role', 'coppola-core' ),
				)
			);

			$social_icons_repeater = $section->add_repeater_element(
				array(
					'name'        => 'qodef_team_member_social_icons',
					'title'       => esc_html__( 'Social Networks', 'coppola-core' ),
					'description' => esc_html__( 'Populate team member social networks info', 'coppola-core' ),
					'button_text' => esc_html__( 'Add New Network', 'coppola-core' ),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'iconpack',
					'name'       => 'qodef_team_member_icon',
					'title'      => esc_html__( 'Icon', 'coppola-core' ),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_team_member_icon_link',
					'title'      => esc_html__( 'Icon Link', 'coppola-core' ),
				)
			);

			$social_icons_repeater->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_team_member_icon_target',
					'title'      => esc_html__( 'Icon Target', 'coppola-core' ),
					'options'    => coppola_core_get_select_type_options_pool( 'link_target' ),
				)
			);

			if ( $has_single ) {
				$section->add_field_element(
					array(
						'field_type'  => 'date',
						'name'        => 'qodef_team_member_birth_date',
						'title'       => esc_html__( 'Birth Date', 'coppola-core' ),
						'description' => esc_html__( 'Enter team member birth date', 'coppola-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'text',
						'name'        => 'qodef_team_member_email',
						'title'       => esc_html__( 'E-mail', 'coppola-core' ),
						'description' => esc_html__( 'Enter team member e-mail address', 'coppola-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'text',
						'name'        => 'qodef_team_member_address',
						'title'       => esc_html__( 'Address', 'coppola-core' ),
						'description' => esc_html__( 'Enter team member address', 'coppola-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'text',
						'name'        => 'qodef_team_member_education',
						'title'       => esc_html__( 'Education', 'coppola-core' ),
						'description' => esc_html__( 'Enter team member education', 'coppola-core' ),
					)
				);

				$section->add_field_element(
					array(
						'field_type'  => 'file',
						'name'        => 'qodef_team_member_resume',
						'title'       => esc_html__( 'Resume', 'coppola-core' ),
						'description' => esc_html__( 'Upload team member resume', 'coppola-core' ),
						'args'        => array(
							'allowed_type' => '[application/pdf,application/msword,application/vnd.openxmlformats-officedocument.wordprocessingml.document]',
						),
					)
				);
			}

			// Hook to include additional options after module options
			do_action( 'coppola_core_action_after_team_meta_box_map', $page, $has_single );
		}
	}

	add_action( 'coppola_core_action_default_meta_boxes_init', 'coppola_core_add_team_single_meta_box' );
}
