<?php
$post_id       = get_the_ID();
$is_enabled    = coppola_core_get_post_value_through_levels( 'qodef_portfolio_single_enable_related_posts' );
$related_posts = coppola_core_get_custom_post_type_related_posts( $post_id, coppola_core_get_portfolio_single_post_taxonomies( $post_id ) );

if ( 'yes' === $is_enabled && ! empty( $related_posts ) && class_exists( 'CoppolaCore_Portfolio_List_Shortcode' ) ) { ?>
	<div id="qodef-portfolio-single-related-items">
		<h6 class="qodef-portfolio-related-title"><?php echo esc_html__( 'similar movies', 'coppola-core' ); ?></h6>
		<?php
		$params = apply_filters(
			'coppola_core_filter_portfolio_single_related_posts_params',
			array(
				'custom_class'      => 'qodef--no-bottom-space',
				'columns'           => '3',
				'posts_per_page'    => 3,
				'additional_params' => 'id',
				'post_ids'          => $related_posts['items'],
				'layout'            => 'info-on-image',
				'title_tag'         => 'h6',
				'excerpt_length'    => '0',
				'hide_info'         => 'yes',
				'enable_noise'      => 'yes',
				'images_proportion' => 'coppola_core_image_size_landscape',
				'is_related'        => true,
			)
		);

		echo CoppolaCore_Portfolio_List_Shortcode::call_shortcode( $params );
		?>
	</div>
<?php } ?>
