<?php
$queried_tax = get_queried_object();
$tax         = $queried_tax->taxonomy;
$tax_slug    = $queried_tax->slug;
$tax_id      = $queried_tax->term_id;

$params = array(
	'term_id' => $tax_id,
);
?>

<div class="qodef-grid-item <?php echo esc_attr( coppola_core_get_page_content_sidebar_classes() ); ?>">
	<div class="qodef-artist-item qodef-m">
		<div class="qodef-m-inner">
			<div class="qodef-m-media">
				<?php coppola_core_template_part( 'post-types/portfolio', 'templates/artist/image', '', $params ); ?>
			</div>
			<div class="qodef-m-content">
				<?php coppola_core_template_part( 'post-types/portfolio', 'templates/artist/title', '', $params ); ?>
				<?php coppola_core_template_part( 'post-types/portfolio', 'templates/artist/subtitle', '', $params ); ?>
				<?php coppola_core_template_part( 'post-types/portfolio', 'templates/artist/biography', '', $params ); ?>
				<?php coppola_core_template_part( 'post-types/portfolio', 'templates/artist/social-networks', '', $params ); ?>
			</div>
		</div>
		<div class="qodef-m-filmography">
			<h6 class="qodef-m-films-title"><?php esc_html_e( 'Filmography', 'coppola-core' ); ?></h6>
			<?php
			$portfolio_params = array(
				'behavior'          => 'columns',
				'columns'           => '3',
				'title_tag'         => 'h5',
				'space'             => 'normal',
				'layout'            => 'info-on-image',
				'enable_noise'      => 'yes',
				'images_proportion' => 'coppola_core_image_size_landscape',
			);
			coppola_core_generate_portfolio_archive_with_shortcode( $tax, $tax_slug, $portfolio_params )
			?>
		</div>
	</div>
</div>
