<article <?php post_class( $item_classes ); ?>>
	<div class="qodef-e-inner" <?php qode_framework_inline_style( $this_shortcode->get_list_item_style( $params ) ); ?>>
		<div class="qodef-e-content">
			<div class="qodef-e-top-holder">
				<div class="qodef-e-info">
					<?php
					// Include portfolio category info
					coppola_core_list_sc_template_part( 'post-types/portfolio/shortcodes/scrolling-portfolio', 'parts/categories', '', $params );
					?>
				</div>
			</div>
			<div class="qodef-e-text">
				<?php coppola_core_list_sc_template_part( 'post-types/portfolio/shortcodes/scrolling-portfolio', 'parts/title', '', $params ); ?>
			</div>
			<div class="qodef-e-line">
				<svg class="qodef-line-svg" xmlns="http://www.w3.org/2000/svg"
				     width="1170.4642" height="198.8279" viewBox="0 0 1170.4642 198.8279">
					<mask id="logoMask">
						<g>
							<path d="M27.72,90.4212c-1.1169.0792,4.0459-.6854,2.9274-.6055,12.979-2.0582,4.1522-.7817,13.2338-2.3523C46.1671,87.2224,39.5763,88.6823,27.72,90.4212Zm133.0018-1.8081c7.4868-2.6753,4.443-1.4077,11.3456-3.8611-2.9153,1.187,2.1425-.5591,2.9376-.682C162.4326,88.4388,166.4922,86.738,160.7214,88.6131Zm-46.5133,16.9-8.5,3.0061c.1552-.0823,1.2034-.4774,2.2134-.86l1.37-.52a5.4425,5.4425,0,0,0,.6146-.2549C113.5463,105.5545,114.845,105.1578,114.2081,105.5134ZM81.8092,117.73c9.8037-4.01.6049-.0909,8.463-3.2454.4054-.1087-1.3027.5717-1.3691.6392C83.0571,117.4548,83.598,117.1031,81.8092,117.73Zm2.5355,25.936c-.4186-.0508,1.4277-.0441,1.5256-.082,5.79-.0763,8.6166-.2137,12.08-.182C94.282,143.5859,91.6021,143.5751,84.3447,143.6663Zm96.1334-7.9745c5.7952-.915,7.7067-1.2166,11.9058-1.8005-.5269.121-2.6074.4489-2.9641.5471C188.5128,134.4674,180.3207,135.886,180.4781,135.6918Zm16.38-2.3657c-1.9761.3356-3.95.68-5.9351.972a16.6093,16.6093,0,0,1,2.9615-.5551A15.1906,15.1906,0,0,1,196.8583,133.3262Zm28.0062-5.7928c-3.0394.6432-12.7679,2.3622-16.2521,3.0658C209.649,130.2759,220.9716,128.2759,224.8645,127.5334ZM297.9576,110.45c-4.6388,1.2761-13.3325,3.2372-21.8906,5.25.3688-.0307,2.537-.5161,5.8657-1.2943-3.4531.89-8.63,2.027-13.1705,2.9891l14.5742-3.56C287.9485,112.8361,287.3041,113.0295,297.9576,110.45Zm.1338.554c2.9354-.6431,2.7134-.5229,10.2289-2.3749-2.7665.7642-6.3352,1.5367-10.1935,2.5212C295.3593,111.7555,298.9688,110.8925,298.0914,111.0045Zm30.5173-7.7787c5.2192-1.2187,16.9435-4.4828,20.3408-5.1668-7.281,1.9654-12.7146,3.1747-15.946,4.2039C331.6135,102.5629,327.6163,103.5823,328.6088,103.2258Zm39.1346-10.3349c5.8885-1.535.3263-.0079.0388.1452l-11.5935,3.0782C357.697,95.5927,367.2747,93.2144,367.7434,92.8909ZM383.81,89.1984c-4.4388,1.2836-17.8788,4.8461-24.6034,6.6147Zm10.1748-2.593c-.1718.1155-6.1415,1.6722-8.6791,2.3756C383.9519,89.2321,392.9187,86.8682,393.9845,86.6053Zm14.839-8.1912a30.0682,30.0682,0,0,1-4.3033,1.2917C403.0165,80.0265,402.8463,80.028,408.8235,78.4141Zm12.2057-.7626c-7.4865,1.963-6.1973,1.7328-14.4435,3.9187,2.9521-.8969,8.9064-2.4528,15.8662-4.3981A8.9642,8.9642,0,0,0,421.0292,77.6516Zm-10.6022.949c-3.21.8264,1.7922-.5621-1.47.3057.1644-.1134,6.1246-1.6749,8.66-2.3806C415.7722,77.0795,414.6611,77.45,410.427,78.6006Zm9.1741-6.2191-7.2236,1.96C413.43,73.9842,420.1407,72.0919,419.6011,72.3815Zm28.1924-4.7588c1.1256-.2736,1.5713-.3506,1.4786-.2717l-8.6741,2.3527C444.2831,68.6932,443.0029,68.9055,447.7935,67.6227Zm10.675-.62-8.672,2.32c3.6-1.0185-5.68,1.3649,2.859-.9106,2.8709-.5759,9.0431-2.37,15.9375-4.0847-4.2874,1.0748,2.2452-.4113,4.3657-1.0659-.48.1865.3179.0149,2.9219-.6617C469.1445,64.3671,460.8784,66.4938,458.4685,67.0029ZM450.633,66.68c.1712-.1138,6.1488-1.6345,8.6894-2.3226,1.56-.2958-3.0272.8987-4.3108,1.2922C448.7063,67.3069,456.708,65.0551,450.633,66.68Zm6.5478,1.3138-.0229-.0869c5.7191-1.5443,2.9783-.6935,8.7064-2.2241C465.69,65.7868,459.7189,67.3057,457.1808,67.994Zm8.0937-4.5756L458.0257,65.32c2.7668-.7828,5.4031-1.5422,8.65-2.4183C467.9,62.673,464.6547,63.5038,465.2745,63.4184Zm12.0723-1.1035c-2.1639.6006-6.225,1.722-8.6784,2.303C467.4026,64.8281,475.1247,62.8387,477.3467,62.3149Zm-8.7149-3.8228-.03-.1161c4.12-1.0381,3.7477-1.0132,7.2548-1.9041.5185-.0215,3.839-.8853,7.2921-1.7714-.2279.0935.3392-.03,1.471-.3077C481.2622,55.3616,474.1135,56.9747,468.6318,58.4921Zm14.0264.4148c2.7985-.7125,7.7665-2.01,12.6514-3.196l6.9626-1.6932c2.1113-.4812,3.9127-.8781,5.1188-1.1181-4.6191,1.033-8.4178,1.978-12.2586,2.9224Zm9.2638.0683c-1.3115.3668-2.68.7655-7.227,1.8947l-.0219-.0875Zm-5.4195,2.956c2.9041-.7191,4.5263-1.1452,4.3256-1.1471l4.3721-.9988-5.0494,1.31A29.222,29.222,0,0,1,486.5025,61.9312ZM496.2754,51.56c4.2492-1.0358,4.4753-.9607,2.9625-.5643L486.087,54.1168C489.12,53.2645,495.0723,52.0366,496.2754,51.56Zm-3.6332,4.0611,5.8347-1.3849c.42-.0519-1.3622.3839-1.4478.4443l-2.9015.704C494.2919,55.2891,492.3293,55.7552,492.6422,55.621Zm6.3186.6282c2.5575-.6134,3.3248-.7538,2.9385-.59l-4.3773,1.062C496.8919,56.81,498.5087,56.4,498.9608,56.2491Zm11.29-4.2283c4.8226-1.2107.8239-.2252-4.3753.9841.5515-.2111,7.1215-1.7658,11.6578-2.7568.0208.01.4716-.0825,1.0585-.208l1.8759-.4041c-2.4275.5928.14.0084.0257.1175C515.6151,50.6566,515.7464,50.7993,510.251,52.0208Zm2.0533,2.2032a11.6113,11.6113,0,0,1,1.3882-.3757c.865-.2175,2.044-.4877,3.2614-.7531l5.5378-1.2C522.3224,52.0335,514.225,53.7806,512.3043,54.2241Zm6.9708-3.0369c1.2305-.1827-2.0511.5291-1.4293.4669-1.9871.4255-1.2286.1921-1.488.2028l-2.9155.6559C513.8765,52.357,517.0886,51.67,519.2751,51.1871Zm2.9492-.5232a34.987,34.987,0,0,1,4.4528-1.0379l-1.0853-2.5768-3.702,2.3485-.0491-.0759c1.452-.965,2.4418-1.5744,3.7-2.3493l1.1556,2.7438ZM511.395,58.0052c3.2123-1.9526,2.5518-1.6188,2.2114-1.4631-.17.0779-.26.1113.2531-.2078.5125-.3207,1.6432-.97,3.8347-2.39-2.912,2.0023,5.389-3.402,7.5929-4.82-2.2651,1.5486-3.2157,2.2085-4.8507,3.2781C518.789,53.4509,516.5223,55.021,511.395,58.0052Zm-8.75-.1237c-4.0342,2.3556-2.9109,1.6935-7.7438,4.4368.476-.39,5.6485-3.25,2.5018-1.6161a19.2555,19.2555,0,0,0,2.5693-1.5187l6.4052-3.7875c-1.9095,1.1692-3.0918,1.9285-6.36,3.8653.2256-.0925,2.3466-1.3581,3.8539-2.2441C502.8889,57.6287,502.535,57.8856,502.6447,57.8816Zm-2.9479,6.8305c3.1519-1.78,2.8567-1.56,6.4943-3.7344.4271-.1756-2.6393,1.6838-5.1284,3.1027-.0286-.0008-.4312.2194-.9537.51l-1.6735.9357A8.8452,8.8452,0,0,0,499.6968,64.7121Zm-.2659,2.56c-2.4687,1.49-6.5563,3.7473-13.056,7.3991-.119.0051,2.1613-1.2575,4.9514-2.8391ZM489.33,70.726c-2.6738,1.4885-7.7385,4.1941-7.9432,4.2a20.1553,20.1553,0,0,1,2.6518-1.3738c2.4609-1.3454,4.7766-2.6987,7.8305-4.4291C492.8918,68.6528,488.3081,71.1957,489.33,70.726Zm-14.0018,5.5831L488.41,69.0747c1.0243-.5052-1.0949.7034-3.2339,1.8776-2.1458,1.1625-4.2908,2.3248-3.2527,1.8375C477.8917,75.0081,479.36,74.0907,475.3279,76.3091Zm11.12-7.7127c1.2964-.5731-5.1339,2.879-7.8455,4.36C479.779,72.2461,482.686,70.6859,486.4479,68.5964ZM470.6474,80.2549c3.2641-1.9071,11.5067-6.26,17.0958-9.3236C484.6924,72.8167,475.2817,77.7848,470.6474,80.2549Zm6.8878-2.9952c2.4695-1.4815,6.1986-3.3518,9.2106-5.01-1.0175.6286-2.5773,1.5384-6.5179,3.6816C482.2838,74.7631,481.631,75.0164,477.5352,77.26Zm4.7784-3.76a9.8015,9.8015,0,0,1,1.32-.6836,10.3531,10.3531,0,0,0,1.3361-.6927c-2.2328,1.2472-2.8381,1.6509-3.871,2.2764-9.44,5.0861-8.7727,4.7057-15.8814,8.4115C470.0742,80.0627,478.1093,75.9189,482.3137,73.5Zm-8.3108,6.6716,6.5847-3.5814C482.6464,75.575,472.0374,81.3451,474.0029,80.1713Zm-1.2972-2.4021c-1.9509,1.09-3.1672,1.8491-6.5458,3.627.1985-.1445-.3217.11-1.3522.6476C464.9536,81.9035,470.4186,79.0568,472.7057,77.7692ZM444.4005,94.7039l25.1572-13.31c-1.1231.7159-9.9337,5.2558-6.5824,3.5879C461.0956,85.9634,451.6912,90.9424,444.4005,94.7039Zm20.996-14.7363c.8077-.3472,2.0981-.9525-2.5656,1.5269,1.5634-.8718.4889-.3121-.0423-.0794-2.9829,1.5972,1.6136-.8012-1.2917.7852-7.039,3.717-2.33,1.1262-7.9731,4.0829C454.89,85.4835,461.823,81.8793,465.3965,79.9676Zm-10.6577,8.6255c-1.5346.8-3.3851,1.7314-1.3635.6536-.0233-.0041-.43.2045-.96.4818l-1.7037.8939-.0278-.0532a10.401,10.401,0,0,0,1.3162-.73C455.389,88.05,454.68,88.5344,454.7389,88.5931Zm-7.98,4.1471c-4.86,2.5684-7.7064,4.0944-13.2744,6.9344C433.9365,99.2757,442.1857,95.0909,446.7593,92.74Zm-2.9383-2.398c-.1356.0944-1.1259.61-2.0822,1.1082l-1.2979.6806a5.42,5.42,0,0,0-.58.3276c-1.0268.4778-4.2367,2.141-4.0331,1.951C438.8438,92.7712,441.9525,91.2572,443.821,90.3422Zm-4.2226,4.8529,3.972-2.0888c1.0515-.5137,1.4594-.6785,1.3859-.5818A54.8837,54.8837,0,0,1,439.5984,95.1951Zm-5.8392,5.0134c-.9787.3892,4.6165-2.51,6.625-3.4947C440.2247,96.87,437.0626,98.5046,433.7592,100.2085Zm2.4948-4.9722c4.5429-2.2661-3.0775,1.7349-6.5842,3.5408l-.0546-.1066C431.9586,97.4379,435.17,95.8957,436.254,95.2363Zm-11.4888,7.1107,6.6627-3.3984C431.97,98.8057,423.7819,102.9912,424.7653,102.347Zm3.3418-.0471c-3.0747,1.428-11.9454,5.9725-16.0431,8.1062,2.6731-1.3863-.6455.18-1.3634.6244-3.3608,1.6153,1.3737-.7953,5.32-2.7664,1.6074-.9245-4.3354,2.174-2.7268,1.2489C421.4574,105.3552,426.7506,102.7526,428.1071,102.3Zm-11.1121,7.8917,10.69-5.4235c-1.8876,1.05-4.9374,2.56-9.3092,4.8574C417.3312,110.1259,416.9039,110.2963,416.995,110.1917Zm.8243-4.9931a20.5249,20.5249,0,0,0,2.705-1.3053c-2.4564,1.2962-6.3219,3.2718-10.66,5.4757a22.6933,22.6933,0,0,1,2.4-1.3243Zm3.9106,4.407c-4.3917,2.1829-8.835,4.5355-14.7366,7.4066.5725-.3268,1.6973-.9149,4.0117-2.0675-.2354.0213-5.6359,2.7492-9.4254,4.6328,1.0065-.6321,5.3761-2.64,1.2888-.777C416.1193,112.2068,415.0123,112.867,421.73,109.6056Zm-18.0836,4.0472c-1.4635.7217-.9421.4033-2.7085,1.2834.2592-.243,6.6577-3.3545,10.6805-5.4143C411.1219,109.97,401.8044,114.3546,403.6464,113.6528Zm6.5012-3.7209.04.08c-5.3654,2.6686-9.35,4.6154-6.6492,3.4258-3.3037,1.6185-3.068,1.3812-8.0989,3.9045C398.07,115.874,402.9242,113.57,410.1476,109.9319Zm-6.7162,3.2917c-3.8041,1.8691-3.447,1.7661-6.68,3.364,3.0144-1.6-1.9843.8785-5.39,2.6209,1.9116-1.0809,8.8635-4.4994,13.36-6.7288A8.8175,8.8175,0,0,0,403.4314,113.2236Zm-3.3655,3.3207c-3.2574,1.58-11.6707,5.5948-14.7765,7.2752-2.02.9043-2.9633,1.2783-8.1082,3.8773.0911-.0921.1823-.184-1.3738.5737,4.5947-2.3091,13.0912-6.4055,20.1134-9.9612,1.3062-.5485,6.8872-3.3372,8.1283-3.8518C403.9227,114.5838,399.6309,116.6841,400.0659,116.5443Zm-17.1392,12.6445c6.5369-3.0995,17.757-8.8922,21.5258-10.5746C396.8384,122.4,386.5664,127.5519,382.9268,129.1888Zm-2.0919-4.2534c-1.6991.8251-1.3828.6116-.0265-.0538-9.0764,4.3729,8.8275-4.5479,6.7533-3.2462C384.2311,123.3125,381.0023,124.7784,380.8348,124.9354Zm-11.9395,6.2585,13.4171-6.6492C380.7542,125.461,373.3334,129.091,368.8954,131.1938Zm7.4269-1.8726a7.6643,7.6643,0,0,0,1.3081-.7087c4.3356-1.9576-8.426,4.5229-14.7313,7.39.3173-.2413,2.7456-1.4354-2.7393,1.2224.4347-.3052,4.1489-2.158,7.9175-3.9961C371.8367,131.3715,375.6545,129.5374,376.3223,129.3213Zm2.3646,1.446c-.1511.1344,1.6708-.7488,1.4-.5527-6.1967,3.0706-17.4172,8.5-13.4376,6.6419-1.2478.6844-5.3225,2.527-5.4437,2.5287C366.5895,136.68,369.3285,135.3412,378.6869,130.7673Zm-7.4535-1.59c-4.7219,2.2126-17.2708,8.3846-24.2794,11.658L371.1808,129.07Zm-14.62,4.1292c5.06-2.4,4.1052-1.9131,10.7834-5.1874C367.8269,128.0283,354.2091,134.6252,356.6135,133.3068Zm4.7638,2.9639,6.7375-3.2569C370.2216,132.1059,359.3531,137.3486,361.3773,136.2706Zm1.3468,2.7807a9.851,9.851,0,0,0,1.3267-.6738c4.7568-2.24-2.603,1.3425-5.3677,2.6582-.5986.2195.889-.5173,1.299-.76A24.19,24.19,0,0,1,362.7241,139.0513Zm-11.0178,4.7866c2.5767-1.23,3.4336-1.5861,6.7813-3.2073-1.5046.8391-2.66,1.3364-1.2727.8141l-5.3917,2.6365c-.58.2,2.444-1.2526,1.2916-.79-8.0554,3.947-12.0059,5.6965-17.585,8.3932C336.49,151.0345,351.3773,144.1655,351.7063,143.838Zm-15.5,2.2779c7.1067-3.2672,9.9967-4.7615,18.9106-9.0213-2.6332,1.3688-5.79,2.9008-9.0615,4.4767-3.2809,1.5571-6.6794,3.154-9.7848,4.68Zm19.7606-3.835c-2.5691,1.3013-7.0156,3.4827-10.8062,5.228C347.8334,146.0851,352.8629,143.7653,355.9664,142.2809Zm-25.0194,6.7313c5.7833-2.6585,2.58-1.3251,9.4374-4.5488a16.1957,16.1957,0,0,1-2.6293,1.448C334.4674,147.4541,330.7889,149.1915,330.947,149.0121Zm-2.4133,1.91c-.1582.0931-.8275.4166-1.4579.7226l-.8474.4149a3.0556,3.0556,0,0,0-.3771.2013c1.6429-.6877,7.0662-3.3553,9.4772-4.5-4.7354,2.3847,6.8439-3.3141,5.4561-2.4586l-15.8685,7.64c-5.6578,2.6943-11.2013,5.3251-15.2278,7.1571,4.6313-2.18,6.7537-3.25,5.3323-2.7527,2.8214-1.33,3.5977-1.6558,5.4344-2.5026,3.2932-1.6144-2.0442.8925-1.4215.4979Zm11.1672-.92c-.1039.18-5.8455,2.8777-2.61,1.4722C326.1616,156.7007,330.55,154.28,339.7009,150.0025Zm-18.139,7.2062c-3.0632,1.4537-2.9247,1.4908-6.7355,3.2747,2.8751-1.1924,3.7911-1.6251,4.1993-1.6277-3.572,1.6763-1.1268.3971-5.47,2.4526-2.0068.9509.546-.2123.0381.0818-1.9254.8953-3.8494,1.7907-4.0555,1.925-3.288,1.4634,1.0151-.7091,5.339-2.7227-4.192,1.8618-3.5892,1.5673-4.18,1.6854,8.74-4.0845,15.2478-7.2415,24.4342-11.4337l-7.5438,3.63a48.1864,48.1864,0,0,0-4.59,2.2632l-2.7185,1.2684a10.099,10.099,0,0,0-1.3674.6051c-1.2281.4664,4.4542-2.1238,4.0223-2.0093A10.33,10.33,0,0,1,321.5619,157.2087Zm-2.3076,2.1362c1.8368-.8674,1.1014-.5969,1.3042-.7412l5.4385-2.5374c.2007-.0342-1.63.8305-1.3085.7432,4.6528-2.1476,1.6755-.9109,6.7477-3.2806-3.9331,1.9825,4.6793-2.09,4.1578-1.7089l-9.52,4.4093c-1.7782.9487-10.78,4.9711-17.642,8.2971.1556-.1281-1.6913.7042-1.4091.5135,3.6188-1.6649,7.7642-3.6286,9.5305-4.402,3.0668-1.4491-1.6783.7312,1.31-.7105A7.6879,7.6879,0,0,1,319.2543,159.3449Zm8.3093-3.4467c-1.8887.9721-8.5172,4.0233-16.2738,7.6588,3.9379-1.95,10.321-4.7764,9.4594-4.5455C325.8722,156.5732,323.3927,157.8687,327.5636,155.8982Zm-11.7544-.3753c4.27-1.9694,5.54-2.5885,6.8008-3.14a4.2832,4.2832,0,0,1-.7561.4082l-1.9969.9572-5.3433,2.5111C314.3148,156.2932,316.1429,155.43,315.8092,155.5229Zm-5.1226-.3908c.8234-.4518,6.8384-3.2,5.3685-2.637a21.94,21.94,0,0,1,2.7587-1.1548C316.4221,152.5179,315.3627,152.9235,310.6866,155.1321ZM295.5912,165.251c-.2264.0593,5.49-2.609,1.3022-.7272,2.6-1.2832,8.32-3.7372,12.2524-5.5942-.4019.38-8.8364,4.1039-9.453,4.5128Zm13.72-2.4262c-.7726.48-2.2142,1.2551.1262.2726l-17.4691,8c-3.6282,1.6651-7.4824,3.3489-11.26,5.0377-3.7823,1.6788-7.4968,3.3439-10.94,4.7858l14.0746-6.315c4.7787-2.1032,10.0817-4.5127,17.3619-7.8636,4.011-1.8618-3.18,1.4044-1.4143.5145Zm-12.09,6.0021c.8707-.4421,2.8788-1.3771,5.4232-2.5446-.9817.55,4.7091-2.112,2.7817-1.1063-1.578.716-2.4222,1.114-2.7067,1.27-1.7234.78-1.4009.5748-.0251-.0547C302.4612,166.4372,298.0713,168.4841,297.2211,168.8268Zm5.46-6.0577c.66-.1984-2.8625,1.4137-6.766,3.1913C295.68,165.975,299.2032,164.3623,302.6807,162.7692Zm-5.8246,1.6729c-.87.4418-2.8794,1.377-5.425,2.5453-.6056.2138-3.9048,1.7251-2.776,1.1038C293.4661,165.8743,292.0435,166.6592,296.8561,164.442Zm-2.389,5.5777c-1.6079.8856-3.6454,1.7958-10.9125,5.0125C284.0588,174.6939,290.246,171.9948,294.467,170.02Zm-23.4709,6.2241c5.2889-2.3812,28.6837-12.822,9.5875-4.223,6.0948-2.6409-4.1091,1.9077-6.7805,3.1525C274.7821,174.6471,270.0154,176.7835,270.9961,176.2438Zm-2.9237.7693c.1371-.1205,1.5332-.7535,3.39-1.5741l6.13-2.7753c-.39.26,2.8776-1.1975,5.5-2.3523C279.626,171.9625,275.9573,173.6085,268.0724,177.0131Zm15.0173-3.0218c-.6713.4112-6.5769,2.9805-9.5687,4.2964a1.8029,1.8029,0,0,1,.3315-.1784l.8976-.421,2.8552-1.2895Zm-3.7887-1.1693c-1.0845.5443-1.72.899-4.0446,1.9664-3.494,1.5531-2.7539,1.1169-2.8086,1.0543C275.6254,174.4167,277.6938,173.5107,279.301,172.8221ZM252.9849,183.54c5.3485-2.3237-6.5251,2.6054-5.5984,2.0952l-1.7332.747L230.7393,192.81l15.9056-2.6044c2.8937-.4738,6.8964-1.0905,8.5035-1.4022,6.3679-.9069,6.0551-.8593,11.85-1.9119-1.693.3225,2.5261-.3774,7.4675-1.2079l3.76-.6362,3.5284-.675,4.4734-.8549c5.5065-.9983-6.9983,1.5128-5.89,1.1566-1.7255.4206-5.79,1.1378-10.1565,1.9158-4.3669.7737-9.0389,1.5915-12.0338,1.9225l-11.4915,1.77-17.0569,2.628,16.0265-6.6016c3.9879-1.6427,7.5385-3.0736,8.6969-3.4458-.9807.3289,4.86-2.0695,2.7195-1.21,3.2343-1.3867,5.5043-2.3163,10.9834-4.751-1.8429.8859-4.1709,1.93-6.75,3.0719l-4.0312,1.77Zm.5179,5.2333c.9187-.4442,8.0767-3.4,9.7063-4.1133-1.0381.4653-2.54,1.1441-4.2545,1.8646Zm5.6149-6.0753c-2.96,1.3343-9,3.8131-12.8186,5.3239l-1.668.66,1.7814-.2228,2.5714-.3215-2.5654.3668-2.1633.3093,2.0272-.8342Zm-9.6245,8.2335c.4069-.2419,2.9387-1.3411-1.44.4266.4164-.2139,3.4874-1.4527,5.5627-2.3069C249.77,190.6973,256.9,187.91,249.4932,190.9312Zm2.2377-4.7766c-1.5067.2029-1.5382.1572-4.4473.5961,1.9369-.3735,9.36-1.4448,13.298-1.9946a2.8653,2.8653,0,0,1-.47.0938l-1.2146.1886-3.5372.5182C252.8844,185.9171,250.6746,186.2437,251.7308,186.1546Zm-1.7968-2.04c-.43-.0156.5206-.2072,4.4023-.7714C254.7551,183.3609,254.8491,183.4195,249.9341,184.1149Zm12.235,1.089c.7013-.0129-1.2568.35-5.8987,1.0076C258.4742,185.8436,257.994,185.8464,262.1691,185.2039Zm14.2251-5.3658.0217.1178c-4.3851.7617-5.0079.7913-8.8206,1.4421C267.7627,181.3015,273.8049,180.3054,276.3942,179.8381Zm-4.584,8.3178c.4944-.1266,3.0382-.59,5.667-1.0558l6.1526-1.1769-4.8391,1.0023Zm23.2015-6.6728-10.3157,2.0294a17.0591,17.0591,0,0,1,1.7051-.3962l3.8135-.7777A44.6785,44.6785,0,0,1,295.0117,181.4832Zm1.5726.2435c.2313-.0854-.3336.0176-1.4695.2557,6.3022-1.483,12.3641-2.6349,19.0582-4.1444.0623-.06,7.4557-1.8731,1.4358-.4572.1643-.1063,6.1917-1.4543,8.7567-2.069-5.62,1.4364,6.2573-1.3835,5.8848-1.185l-16.3219,3.8046C308.2114,179.2289,302.3119,180.4775,296.5844,181.7267Zm.717-3.8987,5.8348-1.29c3.287-.69,6.3739-1.2734,10.2557-2.1523C310.4,175.2267,296.4778,178.2327,297.3014,177.8279Zm20.7489-3.233c-3.243.7422-6.0389,1.3107-2.9205.68-.6559.1942-1.9363.4855-3.3247.7888l-3.9835.8134c2.4313-.632,7.9939-1.8276,11.6425-2.7649C321.3228,173.7157,320.1069,174.0786,318.05,174.5949Zm9.172-.1945c-1.5209.4589-10.3037,2.5179-13.1285,3.0867C316.071,176.882,321.8086,175.6371,327.2223,174.4Zm-.7286-3.0646-8.7327,2.0019C316.9988,173.3937,327.8784,170.9264,326.4937,171.3358Zm-.5968,3.9276,11.6559-2.85C333.9305,173.3775,331.9656,173.868,325.8969,175.2634Zm3.6945-3.8786c-.5483.0352,6.2861-1.6066,8.7-2.2444-1.01.2751-2.2507.6416.0216.0873C337.72,169.4421,330.6145,171.1591,329.5913,171.3848Zm3.2788.8282c3.3013-.9277,14.6206-3.7651,16.0114-3.9362Zm17.574-3.8781c-2.8162.85-7.2977,1.8414-13.0847,3.2918C339.15,171.0433,345.2432,169.6869,350.4441,168.335Zm4.7908.55c-.2794.1872-7.9966,2.1465-11.624,3.0492C344.1764,171.7,350.7386,170.1027,355.2349,168.8851Zm-2.7069-4.4719c-2.1536.696-4.9386,1.3555-10.1475,2.6021C345.14,166.26,348.7014,165.4975,352.528,164.4132Zm1.0875-1.8025-5.7919,1.5085c-.6049.042,1.11-.4708,5.7469-1.6826C350.8756,163.1936,354.7661,162.2042,353.6155,162.6107Zm3.5852,1.9495,8.8251-2.3292c3.1823-.8392,6.07-1.63,7.1069-1.8555,2.2662-.6294,1.2107-.427,5.7576-1.6265-.2634.0964-1.4321.42-1.4182.4473,2.7549-.7343,6.1833-1.7762,5.7813-1.54,1.82-.5022,1.4421-.4537-.016-.0579,2.9357-.9042,4.0286-1.02,5.7975-1.505-1.0436.4583-11.2389,3.0439-10.0894,2.8578-4.0563,1.1039-8.9438,2.4022-5.7971,1.4819-5.7507,1.6544-9.1609,2.39-14.4749,3.8362C358.781,164.1974,358.8947,164.1241,357.2007,164.56Zm2.605-1.8874L364.16,161.57c-.3944.1761.556.0061,4.3632-1.03-.0217-.0092-.464.105-1.0414.2588l-1.8556.4822a8.86,8.86,0,0,0,1.4316-.4671c6.4746-1.7136,4.408-1.2888,10.0911-2.8043.8641-.0686-7.3806,2.19-4.2585,1.468l-8.6689,2.3241c-5.0321,1.2606,2.08-.709-5.8361,1.3651C357.7582,163.2651,359.3562,162.8315,359.8057,162.6728Zm21.8983-5-8.9213,2.41a27.0663,27.0663,0,0,1-4.12.9788c1.1648-.2887,8.8859-2.277,8.6753-2.3574,2.0927-.4762,3.6321-.985,7.2334-1.9033C383.64,157.0856,381.2648,157.7317,381.704,157.673Zm-1.7831-.8832c.1871-.2375-1.1791.1642-4.4171.9207,3.9921-1.1851,8.7727-2.2513,5.7639-1.6285,2.5652-.6757,4.2393-1.06,7.2369-1.8961-1.7494.5508-5.4872,1.56-7.1893,2.07.3982-.0208,2.5682-.5771,5.181-1.28l7.8322-2.1807C391.833,153.6353,386.3663,155.0247,379.9209,156.79Zm-.4152,4.2166c-.0657-.0317,1.3523-.4188,3.3419-.9557,1.9889-.5391,4.5535-1.2148,6.7656-1.876C390.8046,157.9781,382.8,160.1,379.5057,161.0064Zm3.9144-2.7427c1.9-.5834,6.3885-1.8182,10.09-2.838C392.9053,155.66,386.4205,157.4534,383.42,158.2637Zm2.5892-1.8846c1.9778-.6169,10.5829-3.0008,8.6677-2.3417C389.1021,155.632,392.2981,154.577,386.0094,156.379Zm8.9675-1.2731c2.2186-.6908,4.1168-1.2983,5.7153-1.8275,4.5667-1.23,12.0609-3.5675,12.9674-3.68,2.6179-.817,5.8831-1.808,10.0317-3.0361.8373-.1779,3.5824-.9505,2.9307-.6631C411.8779,150.1937,406.9211,151.6967,394.9769,155.106Zm-1.0132-3.6105c5.1571-1.4418,8.3333-2.2855,12.9534-3.658-.2238.1012.3308-.04,1.4542-.3595C406.3162,148.1263,394.7592,151.47,393.9637,151.4954Zm8.957-1.3379a45.32,45.32,0,0,1-5.7977,1.508Q403.8672,149.7442,402.9208,150.1575Zm22.61-7.9713,18.7114-5.6134c6.469-1.9347,12.4275-3.7327,15.6871-4.6482-14.8732,4.6036-36.2361,10.9239-53.0781,15.6823C412.7988,145.827,420.38,143.6124,425.5306,142.1863Zm5.8573,4.0178c-5.9937,1.7864-6.7672,2.0347-11.5033,3.3682C422.49,148.7512,429.836,146.5427,431.3879,146.204Zm-8.2446-1.5134c2.3313-.62,7.4089-2.1559,8.636-2.4531-2.02.7753-8.7148,2.6149-12.8926,3.9069C422.23,145.0356,424.1844,144.5185,423.1433,144.6906Zm18.0041-2.4554-8.61,2.5629c3.3828-1.1979,15.7791-4.8832,22.8765-7.1417C454.6373,138.0811,443.8016,141.3251,441.1474,142.2352Zm10.0406-3.0118c-.4105.074,1.3381-.4611,1.42-.5263a7.5864,7.5864,0,0,1,1.4409-.3754l5.7283-1.7728C457.911,137.199,455.0927,138.0693,451.188,139.2234Zm50.1177-20.3795c-5.8652,1.9735-19.85,6.1783,0,0Zm-7.7659,5.2375c.7128-.3333,7.66-2.4884,11.3915-3.7035,1.2393-.3639.8783-.19,2.8864-.812C505.06,120.5448,500.69,121.76,493.54,124.0815Zm13.2965-2.6038c-3.7058,1.2953-4.9144,1.5168-10.0022,3.11C497.9221,124.0866,505.038,122.0165,506.8363,121.4777Zm-3.5419-1.309c-5.0634,1.5268,7.6-2.5495,5.7118-1.7939C505.7587,119.4383,503.6081,119.9894,503.2944,120.1686Zm8.1593.9556c1.2857-.3019-4.7065,1.5275-4.2655,1.4691C503.3629,123.7568,507.0308,122.48,511.4537,121.1243Zm22.39-8.6653c1.4529-.377,2.1108-.598,2.879-.7973-.46.2814-12.176,3.8957-12.7932,4.2076L506.7551,121.22C511.2275,119.5977,524.6759,115.4832,533.8433,112.4589Zm-11.2181,4.2968c2.0634-.6113-.258.2348-1.3531.65C516.95,118.7777,516.76,118.5826,522.6252,116.7557Zm-.5364-1.6868a10.5647,10.5647,0,0,1,1.4492-.429l.0182.0571-5.7139,1.8158C517.13,116.6036,521.6693,115.2564,522.0888,115.0689Zm8.5246-2.8664-7.13,2.2658C521.2722,115.0743,532.7686,111.4209,530.6134,112.2025Zm3.1842.1135c-4.1693,1.3677-4.3812,1.4258-8.569,2.731a1.8306,1.8306,0,0,1,.386-.1565l1.0693-.3669,3.2135-1.0494A28.8847,28.8847,0,0,1,533.7976,112.316Zm10.2728-7.1693c-2.0551.7117-8.4582,2.8046-11.3873,3.6831C533.7173,108.4271,540.66,106.2593,544.07,105.1467Zm-5.0152,8.8855c.1666-.1225,6.0562-1.9554,8.5579-2.7757-.8393.3342-2.17.8153-7.1108,2.3747C540.7236,113.5238,540.1722,113.6811,539.0552,114.0322Zm-1.2076-3.7713a7.59,7.59,0,0,1,1.4466-.4008l5.6932-1.8571c2.3281-.6229-6.152,1.9836-5.6749,1.9142C537.3716,110.53,538.1049,110.2256,537.8476,110.2609Zm7.965.3126c-1.9966.78,4.8472-1.4719,4.3328-1.2l-10,3.144C542.2586,111.8024,541.79,111.8587,545.8126,110.5734Zm-6.0151.8578,8.5532-2.743C548.6738,108.739,539.575,111.657,539.7975,111.4313Zm13.1213-8.1174c2.1325-.7332,6.1116-2.09,8.5281-2.8162C562.7048,100.2108,555.1022,102.6571,552.9188,103.3138Zm6.5155.6707c3.2914-1.0725,5.4642-1.7591,7.13-2.27C566.4647,101.8405,558.0941,104.5329,559.4343,103.9845Zm7.0839-2.4127c-4.5323,1.49-5.4128,1.7194-7.1391,2.2414C559.6884,103.6584,567.4067,101.2086,566.5182,101.5718Zm9.3789-.1933c-2.9136,1.0129-7.4057,2.4927-11.3836,3.74C565.8129,104.6223,573.4135,102.1395,575.8971,101.3785Zm-4.4484-4.0466c7.0978-2.2691,6.0223-2.0509,11.3743-3.7177-4.2889,1.531-11.0253,3.61-17.0519,5.6451.8617-.3077,3.2823-1.1758-1.4537.3748-1.1128.2407,7.5653-2.4642,5.6472-1.9807l4.2879-1.355c.5284-.1282-.1741.1154-1.0079.3987l-1.2119.4124A4.0861,4.0861,0,0,0,571.4487,97.3319Zm-.0532,4.7458c.45-.0359,8.1085-2.5728,8.6036-2.6281l-12.8446,4.0917C567.3,103.4349,571.8575,102.0012,571.3956,102.0778Zm.637,1.9695c4.5558-1.4217,6.2766-2.0216,11.41-3.6955-3.201,1.1111-4.3164,1.6024-12.7789,4.2947C573.3157,103.7351,568.943,105.11,572.0325,104.0472Zm31.2307-10.5356c10.9738-3.3787,34.0168-11.1181,44.1806-14.24L589.08,98.3348c5.4139-1.8768-4.4357,1.2156-10.066,2.98C584.1553,99.5073,593.8521,96.7859,603.2632,93.5116Zm-23.4767,5.2817c-3.8475,1.1344,10.16-3.3183,11.3759-3.7195-.5078.2428-3.3522,1.1609-6.07,2.0242L581.42,98.2606C580.4332,98.5736,579.7865,98.7933,579.7865,98.7933Zm-1.53.1806c.94-.4608,11.1251-3.7031,15.6464-5.1669-2.282.7833-5.5807,1.8744-7.0812,2.4218C584.1147,96.9684,584.817,96.844,578.2564,98.9739Zm2.3066,2.2168,11.3862-3.6913C593.5555,97.0792,579.0157,101.7928,580.563,101.1907Zm10.8678-5.2893c.235.0126-3.4519,1.21-7.0909,2.3933-2.6947.8178,1.9185-.7194-2.8839.809C583.9962,98.1855,585.8477,97.7693,591.4308,95.9014Zm-2.9244.664c-.9177.33-3.2706,1.0933-2.8239,1.01.55-.1191,7.5343-2.567,7.1489-2.2546C587.19,97.0886,588.49,96.79,582.86,98.5538l-.0463-.1428Zm18.9949-4.5249c-10.5959,3.4784-9.6484,3.1987-19.93,6.5,3.727-1.2521,4.863-1.7192,9.9251-3.3767C597.3587,95.3746,604.7523,92.8076,607.5014,92.0405Zm-7.2,2.0547a9.0253,9.0253,0,0,0-1.3978.5485l-9.98,3.2061C591.4017,96.9965,596.5059,95.35,600.301,94.0952Zm3.3731-4.1553c-1.4594.5566-10.0288,3.389-1.3651.6328-3.4518,1.2053-5.9721,1.97-12.8025,4.218.1915-.2026,5.5405-1.9575,5.6393-2.0492C595.288,92.6255,601.1751,90.77,603.6741,89.94Zm-11.6574,2.87c.7885-.3313,5.3576-1.8089,8.5146-2.8592C602.578,89.425,595.8627,91.5547,592.0167,92.81Zm14.2893-4.4508-7.1168,2.3115C596.9877,91.2895,608.4568,87.5644,606.306,88.3595Zm-3.7469,2.9835c2.0173-.6526,4.0359-1.3057,4.2566-1.4139,3.2886-1.0776,1.6208-.4354,4.3055-1.3038.6632-.1274-7.7734,2.5-7.1042,2.3707C602.0842,91.6138,602.8057,91.31,602.5591,91.343Zm9.8023-3.7513c-1.2719.4269-2.5426.8535-2.8337.9833-2.9343.9445-1.3782.33-4.3018,1.271.4864-.1994,2.4946-.86,2.8232-1.0115A42.7274,42.7274,0,0,1,612.3615,87.5917Zm-7.3762,1.5127c.6471-.375,13.5852-4.5669,14.2338-4.6224C613.54,86.4088,611.2469,87,604.9852,89.1044Zm1.2931-.83c-3.8153,1.1928.5521-.3525,4.2313-1.532C609.3791,87.1677,608.7038,87.4561,606.2783,88.2742Zm12.5544-.1659c-3.1667,1.0558-6.5446,2.26-9.95,3.2941a11.6439,11.6439,0,0,1,1.3539-.4948l3.1862-1.0562Zm-1.4685.3505c.0706-.09,2.0865-.7727,4.4983-1.5651l6.8742-2.2213C627.1377,85.2714,622.4469,86.8059,617.3642,88.4588Zm10.6039-6.1548c4.4785-1.4377,5.5433-1.868,8.5427-2.7731-.4278.1816-3.5627,1.1827-5.6823,1.8762.94-.2625,3.0548-.9327,5.71-1.7907-1.1834.4207-1.853.6862-1.3793.6056l-8.5453,2.8055C622.7922,84.1234,628.8043,82.1557,627.9681,82.304Zm9.07-1.1464c-4.8746,1.5587-1.782.7067-7.1011,2.3995.5569-.2567-2.6158.7809-1.46.3164,8.4982-2.7927,15.153-4.9442,27.0672-8.7373-2.6489.9173-.1276.1206.0461.1428-10.6433,3.4042-13.2114,4.2739-22.7828,7.4094C633.2266,82.4779,637.7392,81.0289,637.0384,81.1575Zm7.14-2.2794c2.4787-.811,7.1207-2.2159,8.5383-2.7635C650.0256,76.9594,645.2859,78.4033,644.1779,78.8781Zm-2.02-1.3326c3.559-1.1339,7.5629-2.2587,10.014-3.115,3.4109-1.1168-.7524.3868,4.3008-1.2974-1.2888.4722-4.4321,1.504-8.5266,2.8229-2.7932.7924-2.7487.7679-10,3.1418,1.7407-.64,1.1463-.5755,5.64-2.0464A10.3811,10.3811,0,0,1,642.1578,77.5455Zm-2.0784,3.29c3.0278-.95,9.1742-2.8159,1.478-.32C642.7018,80.0551,639.5152,81.0935,640.0794,80.8351Zm11.6679-7.718c-3.39,1.1819-4.1943,1.3887-9.9592,3.2867C643.2477,75.8069,647.8844,74.342,651.7473,73.1171Zm5.4144-2.7283c-2.1373.7981-7.2767,2.376-12.1715,3.9966,5.7169-1.7719,13.45-4.26,19.3234-6.2045-.9373.4284,6.04-1.8665,5.7643-1.6663-3.5488,1.1473-4.4238,1.3743-7.1426,2.2362-.4627.2122.3068,0,2.8815-.8331-10.9738,3.5413-15.4427,5.0126-24.26,7.7725,6.3273-1.9817-2.16.4518-7.1472,2.22.9362-.2726,3.2852-1.0325,2.88-.8389L614.49,84.44c5.58-1.9152-14.7906,4.7211-19.9551,6.4179l-.037-.1141L642.93,75.0251l1.5366-.4772c.35-.1843,2.5673-.9324,4.12-1.48C653.3154,71.5281,650.1747,72.7078,657.1617,70.3889Zm7.2181,2.845-8.5584,2.7587c2.83-1.1484-4.741,1.4592-8.5808,2.6511,2.7694-1.059,11.7353-3.8264,17.0748-5.61C662.2156,73.8279,661.0784,74.1915,664.38,73.2338Zm-12.2818.9683a55.0852,55.0852,0,0,1-5.7256,1.7587A54.5492,54.5492,0,0,1,652.098,74.2021Zm9.6213.55c-5.3795,1.7772-2.7617.8018-7.1378,2.2409C655.673,76.5634,663.3851,74.1207,661.7193,74.752Zm-1.5553.0594c-2.8685,1.109,15.2923-4.9408,15.7213-4.9028-6.6249,2.1069-13.3141,4.2278-21.3682,6.8845C656.6368,76.0613,654.8814,76.4917,660.164,74.8114Zm-.9121-2.8267c-3.3038,1.0308-3,.8237-2.9268.6916C661.4946,71.055,663.3422,70.5712,659.2519,71.9847Zm10.2256-2.44c4.73-1.4915-1.5711.5683-1.399.5451,3.0322-.8792,11.11-3.6651,11.4427-3.5844L662.4076,72.04c.2028-.2048,3.0889-1.143,1.3466-.7484C668.2305,69.8082,666.575,70.5908,669.4775,69.5443Zm6.41-4.553c6.38-1.9787,2.6635-.7926-4.2637,1.4352.9267-.2657,3.2935-1.0273,2.8767-.8309-3.969,1.3566-8.2063,2.6126-12.848,4.1036,7.3234-2.39,5.9157-1.9893,8.5076-2.9273,9.2288-2.9351,16.7822-5.43,17.1711-5.3112C682.2365,63.0753,683.4449,62.5313,675.8878,64.9913Zm-.9653,1.918c-5.0447,1.6133-3.53,1.05-8.5541,2.7219,1.2161-.4376,2.1057-.7775,5.6688-1.9191a10.0987,10.0987,0,0,0-1.4359.4308C673.0332,67.267,675.8074,66.5382,674.9225,66.9093Zm9.1816-.7966c-4.8015,1.5458-2.6054.6961-7.1624,2.1638.1556-.0727,1.2157-.418,2.2392-.7471l1.3884-.4517a5.3551,5.3551,0,0,0,.6238-.2246C684.9658,65.69,685.5994,65.55,684.1041,66.1127Zm7.4636-1.2175c-4.0386,1.25-8.8029,2.7714-12.8356,4.0977C677.4489,69.3013,692.8029,64.4,691.5677,64.8952Zm-1.79-.72-.0456-.1429C695.4579,62.1738,695.5211,62.3726,689.7774,64.1756Zm25.0984-10.0292-19.9993,6.323c1.8506-.6582,4.65-1.5856,8.5273-2.8277-1.2462.3474-2.1674.5845-5.7458,1.72.956-.4536,6.5205-2.0184,7.139-2.2851C705.0847,57.1373,713.19,54.5569,714.8759,54.1464Zm-4.4471.869c-2.4251.842-10.9091,3.4453-15.6977,4.9965C697.9615,58.8495,703.92,57.0922,710.4287,55.0154Zm-8.951,6.4748c.5-.199,2.5121-.8426,2.8311-.9883,3.654-1.15,2.8636-.7985,2.9114-.73C702.6511,61.2417,704.235,60.6326,701.4777,61.49Zm7.4271-6.34c3.6724-1.3239,13.4832-4.2586,18.551-5.9034C730.5943,48.3806,713.3,53.688,708.9048,55.1505Zm10.2686-2.29c-.6367.172-1.2745.3358-2.88.8381,6.343-2.0953,17.7669-5.6659,28.5906-8.9467C740.0865,46.3192,722.3835,51.6938,719.1734,52.8608ZM731.092,50.85c.6382-.0391-5.5469,1.8955-11.3809,3.7286C722.4551,53.64,726.4456,52.3393,731.092,50.85Zm12.0157-6.7786c-4.2573,1.4229-13.5934,4.3624-22.8613,7.1989C723.1786,50.2324,736.4958,45.9245,743.1077,44.0712Zm-8.6524,2.4331a9.9311,9.9311,0,0,0,1.4286-.413L721.58,50.51c2.8-1.0156,11.1306-3.5379,17.1554-5.3541C738.5117,45.2618,736.1285,45.9739,734.4553,46.5043Zm4.1017,3.1287c-.1693.11-6.0684,1.8976-8.5757,2.6931.4011-.1888,3.8436-1.2573,4.2448-1.446l4.3132-1.3046C738.2467,49.7008,732.6105,51.4683,738.5571,49.633Zm10.6254-6.1624-.0262-.0861c3.5719-1.0934,4.4536-1.3167,7.188-2.1267C756.605,41.2361,751.2706,42.8174,749.1824,43.4706Zm8.0979.8887c-2.8.7933,8.7039-2.6351,11.4492-3.48C769.6449,40.73,760.8665,43.2631,757.28,44.3593ZM766.9354,40.1l.0342.115-5.7389,1.6817C763.465,41.2059,763.3391,41.1678,766.9354,40.1Zm-2.0184-1.5265c-.9586.2816,3.1783-.9869,7.282-2.2236,4.1055-1.23,8.19-2.3859,7.093-1.991Zm1.9585,1.3253c2.1346-.7292,8.889-2.7587,12.904-3.8693C778.3812,36.5835,771.7039,38.4417,766.8755,39.8986Zm6.8391-3.2939a1.36,1.36,0,0,1,.2934-.1153l.7908-.2489,2.5253-.75,5.0015-1.4186C780.3333,34.7289,777.3951,35.5553,773.7147,36.6047Zm6.1489-.2877c-3.1337.8445.1489-.1437,1.3964-.5612C785.5413,34.5162,785.1458,34.8145,779.8635,36.3171Zm36.1986-9.4125c-5.5253,1.5624-10.3181,2.9958-17.2859,4.8307C800.1779,31.1937,808.2261,29.01,816.0621,26.9046Zm-6.0152.6523c4.5728-1.1851,4.8224-1.2881,10.1124-2.7148a32.396,32.396,0,0,0-4.2612,1.4544c-1.3651.3134-5.9061,1.5228-2.923.66l-5.75,1.6319c-.0273-.0075-.4716.111-1.0484.27l-1.8443.51c-1.2562.2526,1.2239-.4615,2.8448-.9532,2.5765-.7319,3.049-.804,5.7747-1.5452C812.0142,27.09,809.6158,27.7334,810.0469,27.5569Zm18.035-7.9062c-4.7194,1.344-12.5107,3.2752-17.4138,4.54C818.2219,22.119,819.7833,21.819,828.082,19.6507Zm-3.7111,3.5946c-5.5376,1.4922-.5229.1152-1.4573.2983-3.6.9616-5.9955,1.6254-7.2184,2-3.3541.8917-3.35.8163-1.4778.2725L824.34,23.129C822.9661,23.5513,828.6964,22.0715,824.3709,23.2453ZM817.6317,26.98c.5783-.2843,6.4872-1.8271,10.0994-2.721C826.9726,24.5283,820.7855,26.1589,817.6317,26.98Zm8.43-3.194c-1.64.4662.9142-.159-5.7559,1.6065.9159-.2968,2.6656-.8138,5.6531-1.6462,2.9966-.7933,7.2352-1.8846,13.12-3.3653-1.6155.5085.432-.0282-1.4136.5145C831.3472,22.5068,828.7179,23.2239,826.0619,23.7863Zm5.161-3.9443c1.201-.201-8.9351,2.3336-10.1447,2.6721.2913-.102,2.4083-.7043,4.6635-1.3089C828.0021,20.62,830.3962,20.016,831.2229,19.842Zm-.9309,2.3727,10.2117-2.5529L850.61,17.1937a28.1956,28.1956,0,0,1-3.2273.9l-7.2508,1.7943-14.1541,3.5784C828.4466,22.809,829.1259,22.5687,830.292,22.2147ZM844.2295,19.42l11.6956-6.0707.6787,1.8544-13.7867,3.2847c-4.7434,1.173-9.53,2.44-14.0959,3.6308,2.0811-.5933,6.3657-1.73,11.4637-3.0557,5.1069-1.2876,11.0471-2.6779,16.3978-3.952l-.6143-1.6783C851.161,15.9105,846.8853,18.0939,844.2295,19.42ZM836.885,17.782c3.4792-.9715,7.72-1.9718,10.1929-2.4929C845.3737,15.77,839.4789,17.09,836.885,17.782Zm5.2988,2.7411,2.9071-.6911c.3195-.0234-2.4456.6611.0212.0872C843.9271,20.2832,837.4486,21.729,842.1838,20.5231Zm2.5816-2.0322c-.4139.0486,1.3612-.3767,1.4468-.4366l-4.38,1.0413c2.016-.5688,7.1887-1.7,8.7438-2.048C850.2329,17.1835,848.0825,17.7108,844.7654,18.4909Zm10.7773-3.3L844.891,20.6991l-.0275-.0532C848.2192,18.9382,856.29,14.6712,855.5427,15.1909Zm-19.915,7.1238c-1.2961.5176,9.5242-5.0369,11.9344-6.2391C844.8014,17.5563,840.5981,19.7468,835.6277,22.3147Zm5.6292,4.3842c2.2062-1.1729,4.6148-2.5112-1.3726.6086.9642-.5751,7.4637-3.873,10.6267-5.5295C848.7564,22.7618,845.5262,24.5818,841.2569,26.6989Zm5.3982-5.8649c-.6624.4579-6.3828,3.3524-9.2911,4.8383C837.8962,25.3214,843.9074,22.2746,846.6551,20.8339Zm-12.3867,8.6683c-.2394-.012,3.3843-1.84,6.63-3.496.4013-.1531-1.2324.6951-1.29.7681Zm-6.6244.2173a26.9029,26.9029,0,0,1-2.7272,1.2413c2.7167-1.3948,3.5626-1.7748,5.3622-2.6716-.16.101-.82.4484-1.44.7755l-.8312.4424A2.6809,2.6809,0,0,0,827.644,29.7195Zm3.8477.9147c-1.9952,1.1028-10.9092,5.6732-10.6681,5.4493C825.2325,33.7447,827.3307,32.7488,831.4917,30.6342ZM820.4625,32.15l7.9753-4.1579C830.9959,26.85,810.2069,37.443,820.4625,32.15Zm-2.0368-.7029c.1639-.1584,3.3259-1.7924,6.6191-3.49-2.31,1.2659-2.9577,1.63-1.2442.8461C817.8026,31.9667,821.441,29.9011,818.4257,31.4466Zm-9.4375,11.0948,3.984-2.06c.3052-.1-2.2269,1.2388.0413.08a10.1084,10.1084,0,0,1-1.3076.71l-2.6627,1.3769C811.2242,41.4532,808.9062,42.6763,808.9882,42.5414Zm-23.9144,5.9159c7.1268-3.7827,14.19-7.3953,22.6-11.7208C803.427,39.0032,792.8936,44.4767,785.0738,48.4573ZM778.5731,52.19c1.0733-.75-4.4156,2.2742-6.6935,3.36l10.5992-5.5825c3.2-1.6119.6639-.1508,4.0254-1.98C790.6807,45.903,781.3019,50.7673,778.5731,52.19Zm8.0552-3.9628c1.69-.7646-4.2927,2.2457-2.5977,1.4781L778.6971,52.43a22.6535,22.6535,0,0,1,2.4171-1.3394ZM766.5368,58.246l.0412.08c-1.9452.9875-6.8688,3.5917-6.6714,3.4163C758.4956,62.3582,764.0309,59.5567,766.5368,58.246Zm-17.873,11.1c2.2552-1.2385,10.4656-5.5259,13.2769-6.9334l-10.5729,5.6364C749.449,69.0333,750.8622,68.21,748.6638,69.3459Zm1.96-2.736c-.5908.2349.8737-.541,1.2775-.7954l5.361-2.6713C757.5147,63.0858,752.5549,65.5928,750.6236,66.61ZM747.87,71.0737c-1.51.8209-1.4556.872-1.243.8456-4.5165,2.397-7.2405,3.7613-10.6613,5.4791Zm-66.2383,38.1711-14.6589,7.5128L740.09,78.8456c.4-.1525-1.2377.6983-1.28.7632-20.227,10.3406-40.6646,21.1759-58.5566,30.2475C675.743,112.2244,683.9589,107.95,681.6316,109.2448Zm29.4658-21.2491c4.106-2.1286,7.556-3.8276,10.6517-5.5082-2.6823,1.339-12.35,6.2579-14.65,7.5415a10.3122,10.3122,0,0,1-1.345.662,10.14,10.14,0,0,0-1.3452.6618l22.5449-11.8273c-1.1143.6843,2.0895-.9747,4.0491-1.9588-1.3138.7466-3.285,1.8171-5.2564,2.8871,3.0179-1.4344,3.5367-1.9146,7.9754-4.1578C730.7509,78.0593,714.217,86.5733,711.0974,87.9957Zm-14.681,7.4565c-.4014.1531,1.2322-.6953,1.29-.7681-10.0944,5.3118-17.6936,9.23-26.5941,13.7859,2.3915-1.3443,8.57-4.44,5.2426-2.9138,1.95-.9787,5.1644-2.6439,4.0391-1.9536,6.6091-3.4037,14.5452-7.6378,22.6111-11.7263-3.2542,1.7734-4.4047,2.3607.0688.1331C702.1474,92.6053,699.0783,94.0983,696.4164,95.4523Zm2.1581.91c4.4509-2.22-2.512,1.4564-3.9113,2.2253-3.5984,1.73-7.5015,3.8271-12.042,6.0583C685.0236,103.2685,695.1069,98.1987,698.5746,96.3627Zm-2.0616-.7239-3.994,2.0654c.1935-.21-3.1847,1.484,2.5938-1.51C694.0475,96.84,697.0218,95.2944,696.5129,95.6389Zm-13.5387,6.4271c-3.9726,1.9736,5.1279-2.766,6.5778-3.57C694.9043,95.8427,684.6435,101.1533,682.9742,102.0659Zm-2.7866,1.1373c4.06-2.1247,4.8638-2.4808,8.0027-4.1049,0,0-.1539.092-.4192.2346l-1.0889.577-3.1794,1.6555C681.2739,102.7166,679.2735,103.73,680.1877,103.2032ZM665.2365,113.4l-5.3116,2.78a2.9068,2.9068,0,0,1,.4061-.2431l1.048-.5649,3.0775-1.6058a22.5049,22.5049,0,0,1,3.4714-1.6906A20.3127,20.3127,0,0,1,665.2365,113.4Zm-11.7542,3.3763c1.78-.9618,7.7031-3.9807,10.6655-5.4818C664.6816,111.1046,653.7608,116.731,653.4823,116.7766Zm4.5093-1.0823-.0413-.08c2.7655-1.4444,3.5225-1.7982,5.3347-2.725C662.9955,113.0985,661.0329,114.131,657.9916,115.6942Zm-5.8021,1.8182-21.2973,10.98c3.9847-2.2191,15.5289-8.004,18.551-9.7617l9.31-4.8146c-.7187.52-7.3417,3.8455-9.2692,4.8944C650.3653,118.3888,652.5517,117.2591,652.19,117.5125Zm-6.5282,3.68c3.9766-2.14,6.2913-3.2876,11.9582-6.2177C656.288,115.7415,649.9056,119.04,645.6614,121.1923Zm-.2069,2.8764c-6.5133,3.3907-23.5073,12.1967-29.289,15.0786,7.1176-3.855,19.55-10.0573,30.5983-15.8231C647.0015,123.24,646.49,123.5258,645.4545,124.0687ZM631.76,130.171c2.6638-1.4835,6.8333-3.6088,2.5811-1.5375,4.5346-2.3593,4.0251-1.9806,6.7018-3.3305-2.2679,1.2383-4.8864,2.649-9.2553,4.9212C632.5994,129.7746,633.3663,129.3478,631.76,130.171Zm-8.1545,3.8114c4.6345-2.4217,11.0816-5.7393,15.9269-8.3375l.0413.08C633.6733,128.8275,629.5085,131.0161,623.606,133.9824Zm9.1864-5.0545c-2.6545,1.4471-10.1292,5.2989-14.6119,7.59C620.4224,135.2811,628.33,131.2565,632.7924,128.9279ZM607.595,142.1273c2.5181-1.3794,3-1.6528-1.3865.5817,1.8879-1.1255,3.54-1.7783,9.3093-4.8141C614.1312,138.6884,611.5251,140.0823,607.595,142.1273Zm.2893.5594c-3.4286,1.7814,1.8428-.8948.0552.1068-1.8846.9716-3.77,1.9438-3.9814,2.0924-4.8814,2.4711,3.0654-1.6359,1.2772-.7958-9.35,4.8436-27.5187,14.1251-34.5327,17.993-1.3271.6374-3.6091,1.8-6.3007,3.1879l-.028-.0793c6.27-1.3757,14.5-3.2444,17.9642-3.9647L564.3962,165.3l-.5123.1163.4672-.2439c16.8424-8.7919,35.2473-18.2728,51.4974-26.6381C615.618,138.8305,611.9119,140.6049,607.8843,142.6866Zm5.6959-5.2758-10.6143,5.5563c1.248-.8522-4.1422,2.0966-4.0905,1.8787,7.3245-3.7048,7.3327-3.86,14.6083-7.6216C612.3145,137.9874,610.76,138.7225,613.58,137.4109Zm-13.8778,9.0342c7.1251-3.626,9.2172-4.8864,13.296-6.91C613.3289,139.498,601.9725,145.3822,599.7023,146.4451Zm7.4241-5.2239c-.2483.1556-1.3287.7207-1.3039.7416l-2.6638,1.3775c.1-.1.1882-.193-1.3727.6083C603.0431,143.1953,606.2741,141.6432,607.1265,141.2212Zm-9.4621,4.5214c4.9708-2.5673,3.8044-1.9293,7.9791-4.1262C606.4752,141.2632,596.4807,146.4774,597.6644,145.7426Zm9.6878-.8219c-3.0743,1.67-11.8045,6.1862-18.6171,9.6611,2.0281-1.1206,9.196-4.77,10.61-5.5882C600.6581,148.3721,603.0624,147.1584,607.3522,144.9207Zm-4.45,1.1866c-4.2524,2.2287-2.79,1.3555-5.3567,2.6688,1.96-1.0919,3.2381-1.7259,6.6329-3.4639C604.7816,145.0709,603.3062,145.853,602.9023,146.1072Zm-14.63,4.2894,9.3093-4.814C599.3355,144.7821,586.6053,151.3652,588.2723,150.3967Zm7.35-2.0779c.3126-.0313-8.32,4.3384-10.6005,5.5828a8.89,8.89,0,0,1-1.3726.6088C586.5861,152.92,590.0727,151.2238,595.6219,148.3188ZM569.986,160.6973c1.8242-1.01,11.2745-5.8717,13.3044-6.88C579.37,155.8911,574.0563,158.6191,569.986,160.6973Zm12.924-4.3528.0551.1063-9.3506,4.7344a1.869,1.869,0,0,1,.3232-.1986l.8721-.4727,2.7728-1.4516Zm-3.5117,2.998c-.3622.256-3.5679,1.9113-3.9288,2.167C570.76,163.8646,574.4188,161.8115,579.3983,159.3425Zm13.3763.4795c.2041,0-.22.1417-1.2064.41-.9849.2761-2.5359.6675-4.6,1.11C586.5664,161.3143,588.6865,160.865,592.7745,159.822Zm3.69-3.8447c-.2753.1009-9.483,2.3807-8.7137,2.059Zm5.8776-1.1707-.0215-.0872C609.0919,153.0519,609.1329,153.2147,602.3422,154.8067Zm29.0852-7.0488c-1.9078.5985-6.4294,1.6954-8.69,2.2932C624.6446,149.4529,629.1788,148.3523,631.4274,147.7579Zm-2.415,2.5714c.1722-.1148,6.1332-1.6535,8.6734-2.3511C636.8232,148.3837,634.4724,148.8461,629.0123,150.3293Zm42.41-15.0645c-4.59,1.2233-17.8351,5.0587-24.4418,6.9739-5.2469,1.3976,7.8765-2.2965,11.481-3.3289a.9328.9328,0,0,0-.2061.04l-.5626.144-1.9788.5386-5.8578,1.6506c-4.1732,1.1915-8.1139,2.347-7.2094,2.1577-7.8726,2.1442-12.64,3.3486-14.478,3.7293,2.9149-.8782,12-3.16,17.3033-4.72,2.1387-.622-.5725.123-.0241-.0867,2.0969-.6136,7.4547-2.0848,7.1914-2.0772-2.5557.8245,7.3171-1.9,12.9721-3.5976.54.0754,12.2211-3.531,12.9548-3.6488,2.8936-.9254,4.695-1.6156,11.4483-3.5094-4.9994,1.5538-7.8143,2.3406-7.1205,2.281-1.687.4771-3.856,1.1091-7.1841,2.1122-1.3144.4482-.7853.3934-7.1388,2.2659C669.8046,135.8093,669.4178,135.8734,671.4222,135.2648Zm-37.0934,11.7482c2.2019-.6287,10.64-3.0087,10.1091-2.7408C641.0834,145.2431,637.6975,146.0955,634.3289,147.0129Zm24.3385-7.382c-.5651.2416-4.451,1.3563-7.1585,2.1614.64-.3314-11.2375,3.2244-12.9931,3.5417-.2069.0279,1.9476-.5623,3.6152-1.0206,1.6608-.4845,2.8369-.8288.6921-.2368C647.7465,142.5807,650.45,142.0316,658.6674,139.6309Zm-18.84,4.8248c2.9044-.8663,8.6045-2.4541,14.3911-4.0894C650.2695,141.5238,644.2583,143.3118,639.8269,144.4557Zm-.024-.0872,11.5026-3.2981C652.2114,140.9193,643.4323,143.3844,639.8029,144.3685Zm9.795-3.8415c-1.9925.5983-7.4117,2.2346-10.0654,2.858-.4492.0635,4.1588-1.1611,4.3033-1.2807C646.0861,141.4773,645.0774,141.8488,649.5979,140.527Zm-2.94.5559a7.5682,7.5682,0,0,0,1.4109-.4637l4.3263-1.2c-1.1642.3969-7.5541,2.2349-10.06,2.8937C643.3676,141.9636,644.9478,141.5648,646.6577,141.0829Zm21.2217-1.9523c-2.8015.9288-19.5113,5.61-21.6264,6.1223C648.449,144.51,657.7958,142.0844,667.8794,139.1306Zm-15.1421,1.5013c3.4615-.9975,3.1405-.8369,7.2089-2.02q-1.8268.5891-7.1845,2.1064Zm3.0869-.0674c3.2825-.9894,7.6141-2.2321,11.5116-3.3065C665.323,137.9238,659.4294,139.5522,655.8242,140.5645Zm18.3748-1.15c3.6665-1.0613.9612-.062-4.2776,1.4125C669.2191,140.9433,673.789,139.6224,674.1989,139.4141Zm.8118-2.559c-5.2482,1.5061-3.106.8416-4.3571,1.0806l5.7341-1.71C673.3162,137.2278,677.2578,136.0963,675.0107,136.8551Zm16.4373-2.556c-.5806.2726-10.9866,3.3666-12.9111,3.9147C679.0115,137.9683,686.7993,135.7,691.4481,134.2991Zm6.14-5.5572c-7.1821,2.0023-5.7369,1.8174-10.004,3.11,2.009-.7619.5229-.3323-4.3474,1.11-.4346.0789,1.3395-.4537,1.3978-.5112,3.9656-1.11,10.0366-2.9164,15.7859-4.6926C699.69,128.0347,698.3287,128.4775,697.5878,128.7419Zm-6.3431-.299c2.8791-.8481,4.4891-1.3458,4.2931-1.3435,2.085-.59,1.9514-.44,5.7544-1.6215-.9692.37-3.7921,1.2557-7.14,2.2541C695.1981,127.3235,690.2047,128.85,691.2447,128.4429Zm10.7393-.6984a8.8949,8.8949,0,0,1-1.4589.3572c3.1215-.9612,3.0959-.8788,2.9078-.7429-4.3817,1.3381-4.1976,1.3554-8.5947,2.6418C694.1535,130.0937,697.8885,129.02,701.9839,127.7444Zm6.5115-4.2757c1.6733-.5228,1.1989-.4282,1.4041-.5287,2.5437-.7592,3.654-1.0431,8.6021-2.599-.2217.1057.3185-.0422,1.4365-.3816-2.9532.8741-10.8574,3.4653-15.7355,4.8376-2.707.889-4.056,1.3937-8.5517,2.6758,2.0315-.6792,6.463-2.0958,11.3876-3.6476C703.5834,125.0188,709.1739,123.13,708.4955,123.4688Zm-3.0263.3082c-.1683.1138-6.0633,1.907-8.5787,2.6684.2288-.1046-.3307.043-1.44.367C698.7068,125.6853,699.9412,125.5142,705.4692,123.777Zm-4.0019,2.2746a7.8988,7.8988,0,0,0-1.4145.5c-4.1768,1.2478-1.6143.4426-1.466.3267l8.5838-2.623C706.7394,124.4316,703.5945,125.3879,701.4673,126.0516ZM717.94,123.624l.0356.1149c-5.6257,1.7758-9.97,2.99-11.4245,3.5661-2.9383.9367-2.9083.74-4.3131,1.2715C700.623,128.903,712.806,125.2537,717.94,123.624Zm-12.0485,1.53c.5305-.2651,7.0692-2.2277,9.998-3.1248C715.28,122.2875,708.842,124.2221,705.8914,125.1538Zm4.1495-1.7551c7.7086-2.5037,10.5127-3.102,18.6245-5.6421C722.1556,119.8708,715.2179,121.8389,710.0408,123.3987Zm16.2128-3.3209c4.35-1.3561,2.4565-.6556,5.7546-1.6844,1.3545-.4843,3.9124-1.3256,8.5273-2.7755,4.5532-1.4219-2.5195.8428-4.2642,1.3879.37-.0622,2.4831-.7181,5.7313-1.76-.4288.1793-3.5691,1.1613-5.7042,1.8459,4.9178-1.5064,10.3275-3.2289,15.7089-4.9656-.5576.2595-4.4158,1.4957-7.1049,2.3861.4052-.212-3.0079.8757-5.7287,1.7278-3.98,1.2969,2.0908-.5807-1.3918.5687-4.1542,1.2939-1.6284.4707-1.4655.34-5.3294,1.6946-4.0519,1.3318-8.5656,2.717-.254.0245,5.0545-1.6162,7.1284-2.2917-.6129.1224-7.8115,2.4948-7.1644,2.1772-1.4971.5791-9.6746,3.1277-14.2725,4.51C718.7338,122.5667,727.0649,119.9757,726.2536,120.0779Zm28.06-10.574c-4.4115,1.5008-10.063,3.2831-16.2451,5.21l-9.5825,2.9808-9.8685,3.0193Zm-25.2975,9.3691a1.4191,1.4191,0,0,1-.2949.1217l-.7883.2656-2.515.795-4.98,1.5083C722.4171,120.8713,725.3581,119.9905,729.0162,118.873Zm14.9766-7.2194c-5.3273,1.7718-10.4412,3.3718-15.6781,4.9871C733.2663,115.012,736.6591,113.9877,743.9927,111.6536Zm9.4034-.0634c1.1845-.2574-6.723,2.1784-9.9671,3.2333C744.44,114.3884,747.8819,113.3867,753.3961,111.59Zm-5.9565,1.0134c2.5271-.7759,2.39-.6445,5.7368-1.6992-.1337.102-4.7074,1.519-4.2452,1.4449-1.9125.5768-2.8339.8164-5.7385,1.7308C743.7554,113.8406,748.7112,112.3,747.44,112.6036Zm-.1824-.5718c3.9446-1.26,4.9124-1.5143,2.8777-.8211.9633-.2639,3.0756-.9194,5.7228-1.7571.2635-.0158-5.056,1.6225-7.1181,2.2957C749.7446,111.3334,746.2521,112.4478,747.2572,112.0318Zm9.561-4.4891-5.6978,1.8124c-1.2831.3065,4.675-1.5305,4.2327-1.4725C757.294,107.275,756.5656,107.5758,756.8182,107.5427Zm2.8871-.8076c2.0491-.7492,7.818-2.5247,7.1527-2.227C761.5494,106.2646,764.5634,105.1345,759.7053,106.7352Zm2.733-1.2656,5.7125-1.7912c.2632-.0172-5.0469,1.6525-7.1036,2.3373C760.6266,106.1011,762.3754,105.53,762.4384,105.47Zm12.6818.2673c-1.0462.4111-7.9946,2.6075-11.3921,3.73C765.84,108.647,771.3911,106.9619,775.12,105.7369Zm2.6935-1.41c.1911-.0056-1.73.6279-1.4.5807-3.4265,1.1252-3.1.9483-7.1262,2.2817.4278-.1816,3.5626-1.1828,5.694-1.88-1.22.3486-4.6033,1.4485-7.1354,2.253C769.4956,106.9415,775.2641,105.1542,777.8137,104.3265Zm10.0157-3.0935c-.4159.2217-17.449,5.7713-11.416,3.6742,1.6724-.4542,6.7619-2.1432,1.4374-.4666C780.402,103.5174,782.2357,103.1068,787.8293,101.233Zm-5.8429,1.4235a20.2991,20.2991,0,0,1-2.8323.9823c1.12-.3354,1.551-.432,1.4627-.3484-5.2874,1.75-2.8253.8107-5.7284,1.7331C775.0771,104.8935,778.4612,103.796,781.9865,102.6566Zm.5952,1.8254c.7131-.1323-1.9926.77-2.7961,1.0967C776.7388,106.5385,777.77,106.0038,782.5817,104.482Zm-4.1054-2.9254c-1.1411.2743,9.07-3.1055-.0464-.1426q1.8037-.6553,7.1013-2.3682c-.968.4111-.9787.3782.0466.1423C781.1843,100.5908,783.8775,99.8489,778.4763,101.5566Zm1.0439-1.632c8.21-2.5538,11.3394-3.7278,19.95-6.4373-5.2221,1.8613-10.5675,3.4327-19.9132,6.5513Zm4.3578-1.1307c3.9211-1.3344,7.6021-2.5427,12.7932-4.227C792.4532,96.0115,788.7727,97.2263,783.8781,98.7938Zm3.13-.07c.0367-.0443.7656-.3013,1.8818-.68l4.21-1.3925,8.111-2.6316C799.265,94.7314,791.32,97.29,787.0085,98.7236Zm8.3144-3.4606c.2425-.0013-2.2048.8232-2.8,1.0792,6.2261-2.085,4.6631-1.5342,9.973-3.2506-5.7681,1.96-8.3736,2.8514-15.6274,5.2047C791.1,96.8145,785.3282,98.5469,795.3229,95.2631Zm30.8437-6.8884c-1.1531.4719,2.0143-.5865,1.4578-.3256-5.5851,1.665-11.1193,3.7144-17.0643,5.61-.2206-.0472,9.2409-3.03,4.2319-1.4881C815.8368,91.7617,822.7721,89.5214,826.1666,88.3747Zm5.67-1.9127c2.4763-.74-2.0586.7822,4.2864-1.359.6215-.14-.9462.3978-1.3906.588-5.32,1.7885-3.13.9176-7.1458,2.244.2708-.1153,1.425-.5041,1.4049-.5291Zm19.44-7.97c-2.4587.9123-7.5813,2.5005-11.37,3.7748C840.608,81.8823,847.5756,79.7418,851.2769,78.4924Zm3.99,2.4993c-3.5145,1.209-6.9251,2.2318-7.1125,2.3644C841.6017,85.4719,857.67,80.0681,855.2665,80.9916Zm-.6813-2.05-.0284-.0854c2.7218-.8916,6.1213-2.0234,5.7068-1.8024Zm25.59-8.44c-2.3371.8506-12.3464,4.1776-18.4495,6.1608a2.9343,2.9343,0,0,1,.505-.2039l1.2964-.4494,3.8029-1.2745c2.6848-.896,5.1512-1.7242,4.2936-1.5208C879.19,70.7067,874.1054,72.4855,880.1755,70.5018Zm16.2633-3.3c-.22.1095.34-.0566,1.4534-.4179-2.5953,1.0026-10.0457,3.3124-17.0646,5.6828C880.0981,72.669,893.082,68.3657,896.4388,67.2015Zm-17.7983,3.3978c2.755-.986,10.7442-3.5549,11.3616-3.7628C889.3764,67.194,883.3041,69.0167,878.6405,70.5994Zm3.0358-.3734c2.1374-.7548,6.2317-2.1147,9.93-3.3518C892.7761,66.6067,884.8859,69.14,881.6763,70.226Zm7.0468-2.5235c2.705-1.0777,15.7364-5.2039,0,0Zm15.0157-2.2549c-1.2423.4361-3.1821,1.0879-5.6584,1.9056C898.1744,67.15,920.4406,59.9739,903.7388,65.4476ZM915.3066,57.48c-.8015.3721-6.9965,2.3713-9.9379,3.32C905.5446,60.6524,911.3061,58.7967,915.3066,57.48Zm34.0091-11.7141c-.5654.2894-7.8368,2.4756-7.1172,2.323C936.5828,49.8244,948.5565,45.9542,949.3157,45.7659Zm9.4583.0431-7.1442,2.3C949.4208,48.7236,960.9325,45.0169,958.7739,45.809Zm11.1437-4.45c-1.96.6739-12.1087,3.8265-14.27,4.5117C958.4708,44.8583,967.311,42.0894,969.9177,41.3588Zm-2.2114-2.0737-7.144,2.3334c.2235-.1053-.32.0422-1.437.39C959.29,41.8831,965.1978,40.09,967.7062,39.2851Zm1.6.1275c2.1521-.7214,6.271-2.0164,9.9919-3.1948C980.4781,35.9673,972.5589,38.37,969.3059,39.4126Zm5.4315-2.74c-1.9352.5971-1.21.3005-1.4795.3381l4.3075-1.35C979.2243,35.2394,975.3289,36.4377,974.7373,36.6724ZM993.06,35.0987l-7.1623,2.1628C983.6771,37.8288,995.2257,34.3511,993.06,35.0987Zm11.5771-8.3477c-2.7961.7712-9.2368,2.8453-12.9388,3.87C992.7618,30.2588,1005.73,26.3116,1004.6373,26.751Zm-11.0461,4.8974c2.9716-.9654,6.0362-1.879,8.5993-2.593C1000.7659,29.5733,996.0892,30.8865,993.5911,31.6484ZM946.28,72.6523c-.4037.3733-7.4388,4.3589-11.6539,6.7591C934.046,79.5878,942.7339,74.7865,946.28,72.6523ZM841.791,131.4541c-1.5049.9178-8.4541,4.2581-12.0444,6.08C831.3177,136.5826,836.5164,134.1617,841.791,131.4541Zm-17.1574,5.8547c.7924-.2128-10.8794,5.3855-13.4475,6.5711C814.4362,142.2015,819.9585,139.6359,824.6335,137.3088ZM802.9342,150.903c1.7906-1.0037-5.2675,2.4611-4.1466,1.7913a20.3353,20.3353,0,0,0,2.68-1.35c2.62-1.2505.1912.06,5.4443-2.5281A28.9756,28.9756,0,0,1,802.9342,150.903Zm-17.4114,7.4617c1.576-.54,3.23-1.04,4.9132-1.5364,1.6786-.5139,3.3817-1.0421,5.0671-1.5941C792.1185,156.4788,787.9352,157.6477,785.5228,158.3647Zm33.8219-11.9776c3.4537-1.2971,7.2167-2.5541,12.7245-4.3874C830.68,142.601,823.5461,144.9474,819.3447,146.3871Zm39.5924-13.67c1.5841-.6654,2.7852-1.0308,1.352-.6671C864.5256,130.5576,864.459,130.8052,858.9371,132.7175Zm5.64-1.9993c-.243-.0132,7.8586-2.838,5.5826-2.1658l5.643-1.9966C877.5569,126.0911,870.0372,128.7516,864.5767,130.7181Zm14.2316-4.6372c-.1648.1167,1.7409-.5585,1.4514-.3943l-11.2775,4.0219C866.7313,130.485,876.9434,126.7955,878.8083,126.0809Zm24.3652-7.46c-1.3905.5972-5.9781,2.1723-8.4354,3.0775C895.0091,121.447,899.7355,119.9,903.1736,118.6212Zm49.9733-20.2787c6.539-2.4484,6.5641-2.3807.01.0281L915.234,112.3692C925.3823,108.4813,938.1572,103.7955,953.1469,98.3424Zm-17.6014,8.5254c-1.2674.5229-4.895,1.8871-7.0154,2.6179C927.144,109.8813,934.5775,107.2,935.5455,106.8678Zm26-11.7049c10.3914-4.0428,22.8478-8.4156,36.4636-13.6505C992.8916,83.6575,970.03,92.0094,961.5453,95.1629Zm74.279-28.0012c-.7261.358-6.7511,2.5552-9.8032,3.7209.2174-.1175-.3382.0683-1.4272.4636C1026.969,70.4228,1034.4313,67.649,1035.8243,67.1617Zm1.4271-.4636c1.9283-.7964,7.28-2.6689,9.8436-3.6082C1045.1561,63.89,1039.815,65.7585,1037.2515,66.6981Zm12.8745-4.0229a8.8937,8.8937,0,0,1,1.4451-.4334c-6.4875,2.37-2.317.9951-11.2012,4.2626-.988.2794,2.8788-1.1264,4.1826-1.6426-1.2391.41-2.1011.7856-5.6362,2.0521,1.2377-.5907,8.068-2.9262,8.4071-3.2047Zm-.3907,3.2447c-.16.13-5.9619,2.2181-8.42,3.1454C1042.6823,68.4542,1046.9444,66.8749,1049.7354,65.92Zm18.8516-9.4939c-1.1861.5555-11.91,4.3889-15.448,5.7528C1053.8549,61.7927,1063.8144,58.1053,1068.5869,56.426Zm-15.7482,4.9362c2.3611-.8222,8.9508-3.2894,8.4814-3.01C1057.0385,59.9214,1052.0633,61.7606,1052.8387,61.3622Zm12.7776-4.3279c-5.43,2.0165-5.0293,1.7637-8.4692,3.0057,3.38-1.4074,16.9923-6.2855,22.5037-8.2693C1078.8469,52.2409,1061.4056,58.303,1065.6164,57.0343Zm25.5381-8.708c-3.8277,1.4316-10.849,3.9615-14.0909,5.11C1079.5069,52.4485,1086.3424,50.0467,1091.1544,48.3263Zm-11.34,3.8959c.1348-.13,4.6961-1.756,8.4358-3.1045C1089.63,48.7357,1082.7113,51.1586,1079.8142,52.2222Zm11.1379-4.4609c4.5-1.5782-4.9711,1.8234-7.0369,2.5679,2.3276-.9023-.1444.0117-.0406-.1127,1.9986-.7176,3.9959-1.4349,4.2132-1.55C1093.081,46.9077,1081.6187,51.1522,1090.9521,47.7612Zm30.0659-11.1161c-2.3407.8649-4.6911,1.7328-12.1948,4.3164C1110.3237,40.3767,1112.7068,39.498,1121.018,36.6451Zm-2.4662,4.6246c.3518-.0286-3.46,1.3125-7.6546,2.7793C1110.4018,44.1263,1114.2921,42.7587,1118.5518,41.27Zm4.6641,3.2028c.2652-.2565,6.3438-4.2436,8.9381-5.9945-.0428.0884-1.5585,1.1127-3.4226,2.3519Zm-4.7159,7-24.83,16.6285L1069.24,84.35c-17.4,11.585-39.12,26.115-51.1307,33.9584Zm-16.4258,11.912-6.2281,4.1477a1.6883,1.6883,0,0,1,.2946-.2338l.8-.5623,2.3814-1.6158A16.4757,16.4757,0,0,1,1102.0742,63.3844Zm-10.9118,5.2491c-1.9783,1.3831-6.74,4.6542,1.3146-.7316-6.3691,4.3535-3.2715,2.32-9.9547,6.6656C1084.3467,73.2621,1085.5859,72.33,1091.1624,68.6335Zm-6.5172,6.3947c.679-.54,4.6689-3.19,7.425-5.0532C1091.5468,70.42,1087.3055,73.3281,1084.6452,75.0281Zm-12.64,8.057c5.243-3.5926,11.6156-7.7873,17.4522-11.6227C1083.88,75.2463,1077.0526,79.8024,1072.0052,83.0851Zm11.4082-7.2009c-8.4541,5.51-13.2173,8.8562-22.4589,14.9212,1.0753-.847,3.6718-2.4676,7.4585-5.0037-5.4877,3.5451,10.3889-7.0795,14.9163-10.0417Zm-18.3086,10.3551c.5045-.4169,6.135-4.1,8.7112-5.8379a1.8043,1.8043,0,0,1-.2966.2313l-.8141.5653-2.5982,1.7495Zm-12.9626,4.884c-4.0477,2.825-7.5746,5.1149-14.9288,10.0143C1038.3489,100.2061,1045.9925,95.2354,1052.1422,91.1234Zm-24.5493,19.8457c-1.0794.69-.7869.4247-2.5363,1.58,2.097-1.49,6.4752-4.2612,11.2086-7.4647a26.6731,26.6731,0,0,1-2.8778,2.0069C1031.6916,108.2144,1029.51,109.6487,1027.5929,110.9691Zm2.5116-1.6369a10.1435,10.1435,0,0,1-1.2307.8557c-.34.2807-1.6339,1.1526-3.666,2.5853l-4.6563,3.0547c-1.3212.8582-2.5762,1.6588-4.0577,2.69C1018.057,117.2092,1023.3486,113.8812,1030.1045,109.3322Zm-13.546,9.287.0865.1223a31.1314,31.1314,0,0,0-4.9455,4.0318,12.4892,12.4892,0,0,0-1.8721,2.4711,11.8765,11.8765,0,0,0-1.47,4.3859,11.0215,11.0215,0,0,1,1.2115-3.9885,10.14,10.14,0,0,1,1.4536-2.2031A27.8372,27.8372,0,0,1,1016.5585,118.6192Zm-6.7256,12.3221a8.3709,8.3709,0,0,1,.2057-2.0228,10.6893,10.6893,0,0,1,1.2682-3.2452,16.31,16.31,0,0,1,3.96-4.1765,20.25,20.25,0,0,0-3.6221,3.8,11.9845,11.9845,0,0,0-1.3577,2.8174A11.8109,11.8109,0,0,0,1009.8329,130.9413Zm-1.5473,11.343a21.6537,21.6537,0,0,1-2.909-7.79,16.9106,16.9106,0,0,1-.0321-5.6193,7.8612,7.8612,0,0,1,.2545-1.2349c.107-.3884.177-.7676.3011-1.105.2679-.6674.4519-1.2661.6839-1.6974C1004.3448,129.9479,1004.7138,136.1259,1008.2856,142.2843Zm.25-12.63-.1.7236-.0212.6752a7.2863,7.2863,0,0,0,.0042,1.1794l.06.978.1225.803a8.5671,8.5671,0,0,0,.2322,1.2073l.2146.904c.2039.5477.3015,1.105.6806,1.9515a14.2858,14.2858,0,0,0,.7052,1.5515,20.941,20.941,0,0,0,1.27,2.1951,12.4487,12.4487,0,0,1-.7992-1.2415c-.2135-.3216-.3772-.7166-.5812-1.0923a9.8394,9.8394,0,0,1-.523-1.1278c-.6053-1.404-.44-1.0068-.5611-1.186a17.022,17.022,0,0,1-.8524-7.5414C1008.3579,130.5016,1008.3245,130.49,1008.5358,129.6547Zm1.321,3.5583a19.4414,19.4414,0,0,0,4.1924,9.298c2.4419,3.0688,6.4844,5.7186,11.0117,7.4616a33.2712,33.2712,0,0,1-5.9662-2.95l-1.2462-.8426-1.1629-.8884-1.03-.9033c-.3329-.3083-.6352-.653-.9571-.9731A18.7614,18.7614,0,0,1,1009.8568,133.2131Zm-.049,3.7689c.0328.0341.3333.6981.7405,1.6l.7465,1.4537.8831,1.47A15.5053,15.5053,0,0,1,1009.8078,136.982Zm-2.105,3.9087a25.0393,25.0393,0,0,0,6.9049,8.238,36.5354,36.5354,0,0,0,10.2554,5.4465,36.7267,36.7267,0,0,1-8.946-4.3987,25.4185,25.4185,0,0,1-4.6127-3.9781A24.7806,24.7806,0,0,1,1007.7029,140.8907Zm12.4393,9.8125a26.0854,26.0854,0,0,1-4.1428-2.5419,23.0744,23.0744,0,0,1-4.5818-4.4644c.3785.3459,1.2478,1.49,2.7,2.829A28.7148,28.7148,0,0,0,1020.1422,150.7032Zm-3.045-3.0591a34.5207,34.5207,0,0,0,6.7118,3.5962,54.37,54.37,0,0,0,7.4647,2.3348,41.3736,41.3736,0,0,1-10.3028-3.5672A31.5612,31.5612,0,0,1,1017.0972,147.6441Zm18.7515,5.317c.66.1823-.7493-.0653-2.6412-.4953-1.8979-.4216-4.2442-1.0764-5.5992-1.5173.0917-.0192,1.1884.3361,2.7553.7525S1033.97,152.5919,1035.8487,152.9611Zm12.6711,4.8951c-2.5654-.26-6.3235-.8652-10.1258-1.5056a96.235,96.235,0,0,1-10.2427-2.3436c2.5614.6754,5.7373,1.4251,9.251,2.0739,1.7517.3372,3.5933.6393,5.4626.9357S1046.6277,157.6285,1048.52,157.8562Zm-10.6264.2169a1.4251,1.4251,0,0,1-.3185-.0306l-.8239-.13c-.6867-.1141-1.6161-.2881-2.6009-.4881-1.9724-.3881-4.1528-.9517-5.08-1.2274.102-.0023,1.6429.4087,3.497.8238S1036.5868,157.8519,1037.8934,158.0731Zm36.0262-.2434c-1.5558-.0137-7.5716-.5716-11.8-.9528-1.0885-.0185,2.5316.3459,1.4435.3277-2.7324-.2932-7.6614-.9857-4.3875-.6711-2.3336-.2637-4.2964-.4854-6.0694-.7158l-4.9374-.7195c-1.5854-.2209-3.1585-.5208-4.9227-.8039-1.7626-.2911-3.7207-.603-5.9812-1.03C1048.76,155.3326,1061.0917,156.823,1073.92,157.83Zm-4.8433,4.5215c-2.9241-.1293-11.2782-1.0792-11.954-1.0792-3.5645-.43-6.7931-.8812-11.8926-1.62-1.0361-.2133,3.5985.4528,8.4133,1.0669,4.817.6,9.8181,1.1027,9.4551,1.0524C1064.5759,161.84,1067.0784,162.2048,1069.0764,162.3512Zm-8.58-4.2523c-.2014.055-6.28-.7039-8.8618-1.0518a1.3916,1.3916,0,0,1,.3159.017l.82.095,2.6.3055Zm4.409.6288c-.7552-.0418-2.4585-.1992-4.602-.41l-7.2289-.8585C1054.5855,157.5779,1060.8463,158.2822,1064.9056,158.7277Zm11.6672,3.9327c.0914.0515-1.8552-.052-3.9742-.1839l-5.0026-.4288C1069.769,162.1179,1070.9373,162.353,1076.5728,162.66Zm2.9788.3672c1.2922.0839.8859.1232,2.9961.2286-2.4429-.046-4.5818-.1888-6.5361-.3583-1.9551-.1572-3.7272-.3157-5.4342-.4822C1074.6112,162.6508,1074.772,162.7968,1079.5515,163.0276Zm22.4758-1.585c-2.1446.0421-3.851.0586-5.4737.0555-1.6224-.001-3.1617.0336-4.97,0-.4718-.0873.2447-.0982,1.4951-.1185C1097.6413,161.3836,1097.4707,161.518,1102.0273,161.4427Zm-2.98,2.0945c1.0248-.0352,3.3218-.0615,5.7135-.084,2.3916-.03,4.8767-.1245,6.2789-.1762C1109.91,163.4512,1105.5521,163.4949,1099.0475,163.5372Zm11.8544-4.6979-5.1868.1405-5.1885.0459c-.3494-.0651,2.7987-.0848,5.0163-.0941,2.2169-.0511,3.5032-.0592-.57-.0347C1106.6938,158.7956,1112.8263,158.6887,1110.9019,158.8393Zm34.0078-2.186c-4.0958.5674-11.1268,1.2979-17.7107,1.7914-.6483-.0045,3.2462-.254,7.56-.7079C1139.079,157.3491,1143.8132,156.7343,1144.91,156.6533ZM408.2891,114.02l-.8759.47A6.7122,6.7122,0,0,1,408.2891,114.02Zm-303.3026,5.2918c-7.5621,2.8638-13.3761,5.1552-19.1976,7.5425-2.9093,1.1951-5.82,2.4169-8.923,3.7768-1.5508.68-3.15,1.3954-4.809,2.1669l-1.255.59-.2943.1405-.0027,0-.0074,0-.0406.0049c-.07-.0139-.1405-.0123-.14-.0643-.1322.1033-.3406.1158-.5269.283.012.065.2365.0339.4171.0337l.5056-.0112.8822-.0049,12.6555.0591c4.62.0032,9.249-.1742,13.9343-.2559,2.3429-.0259,4.7-.1691,7.079-.2868l7.2075-.3754c-1.4771.1135-2.4458.2121-4.4481.3413,7.4092-.1613,15.2657-.8811,22.9-1.5035l21.543-2.2462c1.3807-.184,2.2367-.3171,2.937-.4348l4.4537-.4916c.4512.097-5.356.7994-8.85,1.2787l9.6169-1.149,10.2875-1.3943,4.96-.6808,4.5936-.7213c2.9038-.4658,5.4517-.8911,7.4083-1.2489,2.9506-.4351,5.8926-.9362,8.834-1.4411,1.1178-.0808-5.6033,1.03-5.8623,1.1363-.7164.2447,7.32-1.1724,2.968-.34,8.663-1.326,14.64-2.8188,20.5509-3.6581,5.5957-.988.2628-.1852,5.8569-1.1725,4.9971-.8151-5.0961,1.0138-2.8975.7485l5.3644-.9494,5.046-.96c3.15-.6068,5.76-1.1332,7.1609-1.4979,1.6688-.325.816-.1312.006.0292-.3916.1472.38.04,2.9556-.4629-.3469.1225-2.5133.5673-5.8508,1.22,11.8057-2.2819,26.7493-5.357,35.0913-7.3219.5253.0076,10.3477-2.3675,7.3064-1.5412,4.4548-1.134,10.8047-2.415,10.1814-2.3842,5.365-1.2144,12.1764-2.8016,18.5952-4.3728,6.4141-1.5941,12.455-3.079,16.2788-4.0944,2.5548-.6425,3.3145-.79,2.9182-.6186,7.0162-1.7933,1.0172-.3942,8.661-2.3574-.1023.1131,2.4255-.5618.03.1165,9.9849-2.5992,12.4163-3.1577,24.619-6.404.4126-.0588-1.3645.4142-1.4307.4714,3.7655-.977,5.1935-1.3856,4.314-1.2337,5.298-1.3517-.0785.1316,2.943-.5918,1.9618-.5319,1.1805-.3934,1.4161-.5021,1.2866-.3253,2.597-.6578,2.8937-.7749,3.3534-.8951,6.1063-1.4917,5.7688-1.5757,2.7355-.7291,1.0255-.1719,4.3638-1.0756.4662-.053-4.1788,1.1538-4.3171,1.25.6862-.1233,6.24-1.6967,7.2194-2,18.4475-4.7572,38.8124-10.7859,49.1847-13.165-7.5125,2.0464-11.62,3.0755-17.3563,4.7,1.7836-.457,8.7184-2.2665,10.1251-2.7162,4.844-1.28,1.2832-.2768.0315.116,7.8462-2.2317,8.6268-2.28,17.3482-4.74.4773-.0333,8.3008-2.0975,4.39-.9576,3.418-.91,4.2481-1.1995,8.69-2.3468-4.0931.9165,4.401-1.2516,7.2123-2.0261-1.3109.29-5.8962,1.5155-4.3918,1.0031,3.19-.7747,3.1135-.8292,2.88-.8526l7.2589-1.9042c2.4113-.4711.842-.06,2.9623-.4866-3.4684.9706-7.7228,1.9648-10.1374,2.71,2.9211-.6877,9.0573-2.3522,11.6206-2.969,1.9585-.6146,9.3488-2.5546,18.8858-4.8895.69-.1073-2.0706.5795-4.3555,1.1567,3.7838-.8693,12.4614-3.1027,18.9605-4.5792-4.1513.92-1.2831.2072,2.6613-.6956l5.9608-1.3832,2.1755-.5179c.5422-.1328.87-.219.8918-.236l10.3022-2.1333c1.8385-.41,1.4692-.383-.0126-.0588.2067-.0565.8015-.19,1.5467-.35l18.36-3.94-15.8243,9.96c-1.9478,1.226-5.0919,3.1433-3.8441,2.2507l3.7654-2.3685,15.0976-9.4965-17.525,3.7329c-9.04,1.9255-20.4776,4.47-31.7566,7.265-11.2961,2.7383-22.4583,5.6352-31.0806,7.8416-1.5746.4182-.9709.3163-2.8941.8231.99-.17,3.1063-.85,5.8094-1.5143l-2.87.8654,14.5065-3.8294c3.0121-.74,3.0957-.73,1.4673-.2759.8627-.27,6.9025-1.7327,7.2547-1.8856,2.17-.5318-.5533.1787.0217.0872,4.6484-1.1335,8.86-2.3271,10.2-2.4979,5.7583-1.3909,4.43-1.2168,10.2078-2.5452l11.7369-2.5712c-.4633.1724.2695.059,1.501-.1754,1.82-.4293,3.9-.88,5.952-1.3228L541.86,41.9109,528,50.6568c-2.3164,1.4617-4.5943,2.8958-6.2731,4.032-1.3075.8342-2.665,1.5386-3.859,2.4141-1.9261,1.1835.3356-.2481-1.335.6874l-10.3544,6.157c3.4565-2.044,5.35-3.13,7.2256-4.1953,1.8766-1.0637,3.7448-2.0843,7.067-4.1946-.2438.19-2.1037,1.3964-3.6236,2.3284-1.5355.8954-2.7138,1.5554-1.533.799-1.6519,1.0792-10.0633,5.8385-10.3322,6.179-3.1174,1.8473-2.8787,1.58-6.5394,3.6883,1.4521-.86,3.7-2.1471,2.535-1.6-1.496.8552-3.2852,1.9115-1.28.79-1.1411.7155-9.1865,5.1085-11.7625,6.6614.4247-.1914,3.2867-1.8228,5.2531-2.9248-.0509.2459,5.149-2.6366,10.7206-5.777,5.5211-3.2522,11.4164-6.7538,12.873-7.5011l-12.4086,7.3367-11.6262,6.5685c-3.7833,2.1609-7.5568,4.2064-11.38,6.28L469.65,84.7427l-.0426-.08c-1.7692,1.0145-3.2326,1.875-9.2228,5.0157,2.3148-1.3419-.1783-.1283-4.0812,1.8882a14.0185,14.0185,0,0,0,2.7263-1.2393c-1.1059.636-4.241,2.2932-6.6075,3.5641.3931-.29-.2548.0123-1.389.5557-1.9559,1.0511-3.3431,1.7687-5.3324,2.7584-2.4572,1.2761-.7655.51-2.61,1.4857a27.2345,27.2345,0,0,1-2.7347,1.2457c-3.3024,1.7034-6.4625,3.3366-6.6268,3.4954.4354-.167,4.6089-2.4278,4.04-1.9882-6.5259,3.3459-8.3876,4.3137-14.6895,7.4766.554-.3218,1.6689-.9155,3.9757-2.0842.9421-.5695-2.6809,1.2927-2.73,1.2509a7.3077,7.3077,0,0,0-1.3.7265,42.8173,42.8173,0,0,1-4.094,1.9086c5.1918-2.4954,12.9949-6.6321,16.0485-8.14,2.8953-1.4922.5583-.4088,1.2641-.8229-6.8509,3.5394-10.4721,5.4049-13.3544,6.7865-1.5652.7994-1.1071.6228-1.3083.7646-5.6667,2.9053-10.8716,5.345-12.0234,6.1206-3.9178,1.8754-12.4467,6.09-17.4592,8.6386-1.6271.767-.5439.2184-.04-.0805-1.9888,1.0417-5.4855,2.7467-6.6876,3.3983-3.04,1.4731,1.6219-.8479-1.3751.5745-5.8007,3.0742-17.2179,8.5469-29.5995,14.543l-.0391-.0811c-1.8948,1.0138-7.0627,3.3241-6.7183,3.3091-1.3809.5634-6.988,3.3136-4.1067,1.8173-19.4114,9.306-27.6736,13.2135-37.98,17.8969-1.24.5759-3.5631,1.7745-1.3046.7281-2.0106.9872-11.8246,5.4514-12.2875,5.5831-3.5144,1.6142,1.8862-.8054.0494.1093C276.73,178.5652,262.1909,185,247.43,190.8934l-1.4248-5.4942,4.0249-.6008c4.416-.6324-1.3949.271.0167.1188,5.0435-.751,6.839-1.0424,8.4993-1.3145l2.7781-.4506,4.8947-.8752c-.82.2293-4.3064.9462-8.3864,1.5145l-11.8049,1.7752,1.3406,5.17c1.5658-.6586,2.6982-1.1526,3.1256-1.3806l6.1958-2.4625c1.69-.6613,3.399-1.3635,6.3433-2.6477,1.6139-.7,1.1348-.548,1.3346-.6723,17.2161-7.3665,29.6144-13.0765,41.9814-18.7036l18.991-8.83,22.1823-10.55c1.0275-.3959,4.1406-1.8554,6.8219-3.0923,3.6782-1.8062-2.44,1.0613,1.2969-.7928a25.8681,25.8681,0,0,1,2.7683-1.1368c2.3325-1.201,7.6583-3.774,8.0168-4.0706,4.5364-2.16,1.2148-.512.0524.1077-.6014.3823,7.2815-3.6257,8.0952-3.92,1.58-.7806,1.1084-.6048,1.3014-.7389,6.3561-3.1042,7.3953-3.6172,12.15-5.86,1.4564-.7259.8955-.4993,2.6638-1.3806-.2169.0573-4.561,2.221-5.4114,2.5945,3.0553-1.5805,7.1523-3.4778,10.7419-5.353l-4.0015,2.0622c7.9264-3.81,11.119-5.636,18.7579-9.42-.0492-.0422-3.6841,1.7944-2.744,1.2343,1.0851-.5164,3.6934-1.79,4.0173-2.0132,3.3312-1.6852.4377-.1083.0538.1071l6.6787-3.3885c-2.2235,1.0611-3.7943,1.8071-.0679-.134-.8723.4088-3.08,1.5284-2.7047,1.2715-7.0242,3.7073-17.856,8.8337-21.4656,10.6814l4.0533-1.9541c-.402.2462-3.3506,1.6986-5.3567,2.7045.7705-.3156,4.06-1.9585,1.3967-.5624-6.2548,3.174-4.4757,2.2046-10.761,5.285,1.4473-.8149.5995-.3824-1.4128.5259-4.3464,2.1467-1.0146.7156-8.0083,4.0959-1.043.4087,3.67-1.8646,2.6326-1.4587-5.3732,2.6141-3.8043,1.9935-3.9584,2.176-3.0509,1.3962-12.668,6.2014-13.5391,6.4052,3.9155-1.9886,5.4777-2.6107,8.1208-3.8545,1.9537-.9739,5.2023-2.5746,3.99-2.084-2.0348.9612-3.8313,1.7958-5.4449,2.5206-2.7551,1.3616-2.7385,1.4531-6.6917,3.364-2.6592,1.2217-.465.1025-.0784-.1621l-11.4966,5.5024-14.2382,6.6819c1.1472-.6265,3.1049-1.6186,8.0664-3.964l.0387.0814c1.7031-.8472,7.1362-3.506,4.0641-1.93,7.6913-3.66,14.3979-6.9659,21.233-10.2972,6.8193-3.3637,13.7454-6.7978,21.884-10.7028-.1866.1749-4.5665,2.25-5.3865,2.6425-.8947.5291,2.8059-1.3116,4.0688-1.8956,1.217-.7841,15.6823-7.9547,24.0735-12.1663a18.965,18.965,0,0,1-2.6533,1.4c4.2749-2.0721,6.9287-3.5382,10.6871-5.4423a22.5082,22.5082,0,0,1,2.736-1.2536c5.8334-2.9481,10.5724-5.3726,15.4678-7.9283l16.4883-8.5518c-9.0629,4.9534-25.23,13.1893-33.3047,17.1644.4254-.0778-3.891,2.13-8.82,4.6254-4.9346,2.4841-10.5028,5.2131-12.5317,6.2807,10.0359-4.9048,17.2052-8.5373,26.7971-13.4332a11.11,11.11,0,0,0,2.7719-1.1709c.2286.0466-6.9676,3.52-8,4.1263,1.2633-.5825,4.2068-2.06,8.0546-4.02,2.733-1.3929,2.6252-1.4285,3.9413-2.1523,4.8177-2.4723,8.95-4.5731,13.3152-6.8878a10.1486,10.1486,0,0,1-1.3188.7158c-3.6168,1.9016,4.0842-2.037.0553.1065l5.3315-2.7579c-.1362.0171.5862-.4318-1.3881.5829,1.9546-1.0783,10.9589-5.9266,11.9388-6.2916,3.8812-2.0558,4.8859-2.6625,6.5656-3.61-.8669.4243-3.0726,1.5906-2.6851,1.3189,2.5257-1.3828,8.085-4.34,6.6552-3.4425l14.437-7.7937c4.5726-2.5151,8.9368-5.0192,13.3086-7.4767,8.71-4.9873,17.3161-10.054,26.9347-16.234-1.1018.8288-3.7545,2.4063-7.6328,4.8821.8637-.3209,5.5887-3.4684,8.8735-5.5734l12.2641-7.8595L525.8465,45.703c-1.2922.2885-2.386.5206-3.0364.6254-4.39.9815,1.4219-.2458.0253.1176-5.974,1.3929-7.7452,1.6006-13.1894,2.9439-1.3411.162,4.7739-1.2559,8.7764-2.07-1.2275.0132-19.8984,4.5037-10.2546,2.2894-4.8673,1.1332-9.5667,2.2465-14.1624,3.3626-4.6033,1.09-9.09,2.2273-13.5347,3.3916a23.5294,23.5294,0,0,1-2.9225.6422c-4.6537,1.1611-4.4878,1.2111-7.2673,1.8661-3.1085.8494,1.0573-.1976-1.4165.5207,3.31-.8464,5.4559-1.4167,5.7971-1.56,5.6323-1.4122-9.72,2.661-1.4275.524-6.6591,1.8282-11.9227,3.0151-17.3992,4.5318-.1229-.0793-11.7938,2.969-.0306-.116-2.0872.5051-2.1528.4475,2.8779-.8521-3.9022.9393-7.2057,1.8563-11.5915,3.0643-1.285.2889-4.605,1.1417-1.4873.2426l-18.7788,5.17c-4.3433.9667-15.3989,4.1583-17.3484,4.7-15.9224,4.4249-26.0609,6.98-39.0121,10.6049-4.7432,1.3194-14.8688,3.76-17.3513,4.6152,1.051-.2208,10.8549-2.9259,5.8047-1.4417,3.1013-.8052,2.7443-.77,2.8744-.8528,4.105-1.0076,6.1736-1.573,11.59-3.009,2.1378-.5858-.5751.1144-.0233-.0868l7.2391-1.8842c2.1381-.5911-.575.1154-.0234-.0869,3.02-.8289,3.84-1.0161,5.7952-1.5343-7.1445,2.0028,3.851-.9052,4.3347-1.1708,9.2252-2.4563,19.0725-4.998,26.0181-7.0266,8.6066-2.2363,17.0111-4.4756,30.4-8.1241-.2262.0969.3382-.035,1.4641-.3295a31.1889,31.1889,0,0,1-4.3226,1.25c-.44.1966,8.1091-2.1942,5.8077-1.4571.5244-.21,6.3372-1.701,5.7717-1.6462,2.0731-.509,3.3306-.76,1.4884-.2376l10.1259-2.7377c4.5024-1.1553,5.6543-1.3757,8.7408-2.1329,1.1714-.3212,3.9775-1.0186,4.3466-1.1546a23.9481,23.9481,0,0,1,2.9327-.6445c6.0809-1.5883,8.9545-2.1694,11.6192-2.9914,4.668-1.056,4.3225-1.0265,8.7488-2.0992-1.8939.532,7.9575-1.687.0413.1754.3892-.0557,12.1109-2.7974,11.6849-2.7511,2.7642-.514,2.0807-.3176,8.826-1.8409l1.57-.232,10.636-1.5723-9.1068,5.203c-.8361.4777-1.848,1.14-6.2831,3.9766,2.4543-1.6461-2.7567,1.5613-3.9575,2.2277-2.1065,1.3222.1833.0161,1.3412-.7089-.4279.3189-2.2477,1.4133-2.5317,1.6245-3.01,1.6854-6.226,3.4985-7.903,4.3593l-5.15,3.0795c2.3593-1.4617,2.3546-1.4194,1.2335-.8687,5.8525-3.45,6.8362-3.8729,12.9314-7.6133-1.43,1.0876,11.7012-7.354,7.73-4.6942l2.4651-1.5677,8.6916-5.5278-10.0509,2.3c-3.0251.6924-1.1738.4167-4.4438,1.1555-8.5956,1.8411-14.3158,3.1044-21.9473,4.9559.7437-.1126,3.9087-.8351,4.4159-.8626-.3706-.0146,3.183-.8468,7.8-1.9073l14.2194-3.1317,8.5168-1.8757-7.3209,4.7151c-1.7985,1.1583-3.1391,2.0434-3.6838,2.4531-5.2634,3.2977.4392-.3823,1.19-.9329l-5.07,3.254c.0129-.0255.4-.2781.9061-.6029l1.6209-1.0366c.1307-.1469-1.5849.9308-1.3251.699-2.29,1.4409-2.6605,1.75-5.0764,3.24,1.1222-.6475.7909-.3944,2.5916-1.52.0354.0929-3.514,2.1241-2.5134,1.6485-2.2183,1.1964-6.239,3.6127-9.0956,5.2729.3279-.2743,3.4193-2.1014,5.1524-3.0811-.4453.1818-4.0289,2.3044-5.2281,2.9518-1.507.8965-1.061.6907-1.2531.8454-1.9378,1.1249-3.73,2.1337-5.4517,3.0833l-4.9837,2.807c-3.2783,1.8295-6.5232,3.7366-10.5177,5.8,5.5242-3.47-6.4812,2.9954-18.6633,9.583-1.43.7648-.8669.5261-2.6237,1.456,1.13-.5761,3.2842-1.6921,7.9583-4.2,2.0947-.9193,7.4622-4.0714,4.0854-1.88-1.0573.43-7.2187,3.7539-11.9872,6.1864-1.9811,1.0773.3875-.1544-1.2582.8013.3954-.1393,3.5631-1.8179,5.3345-2.7208-7.3478,4.0249-12.1976,6.4664-21.2143,11.168-1.2756.532,7.0192-3.6537,7.9255-4.2385-2.0687,1.0452-1.2357.48-1.4326.4864,3.7421-2.0152,5.5032-2.947,9.2743-4.9072-1.5551.6059-14.78,7.8873-15.9887,8.2336-2.1418,1.1655-2.1282,1.27-5.2383,2.9122-.8788.5456,2.7766-1.371,4.0311-1.9837-2.3227,1.1882-10.0754,5.4653-13.284,6.9053,4.2368-2.2114,4.1409-2.0786,6.6489-3.4395-1.7507.808-6.85,3.4741-7.9951,4.1274-1.0743.4957,1.67-.9365-.0957-.187-.6134.407-3.9946,2.1492-5.2561,2.8688-.7888.25-7.7217,3.774-10.7809,5.2344-2.184,1.1391.1743.0768-3.9342,2.1625,5.2555-2.5058,16.5238-8.2249,21.4678-10.66.0571.0567-2.2623,1.252-1.2642.8483.8243-.3155,12.2568-6.2426,13.3524-6.8312,3.9875-1.9531-1.855,1.0854-3.9519,2.1794.3675-.0858,6.6513-3.3836,5.4111-2.5964l-13.3285,6.8271c.393-.2489,3.3139-1.7421,5.3046-2.7777-2.3493,1.1108-3.4913,1.796-8.0045,4.0853-.52.1634-5.5377,2.7235-4.1083,1.8489l4.0264-2.0093c.4037-.3868-8.9584,4.44-5.4315,2.554-2.5426,1.3488-7.8082,4.0109-9.2959,4.851-.9548.5994,5.4429-2.7186,4.0682-1.8957-3.95,2.0493-10.6857,5.4133-12,6.152-1.9175.9114-3.595,1.6434-1.4125.5031-8.5641,4.2722-12.5325,6.452-24.1217,12.0594.6023-.4331-4.6288,2.3029-1.3871.58-15.4521,7.7246-19.1516,9.3763-32.33,15.7287a8.9469,8.9469,0,0,0,1.3119-.7319c-1.4061.5929-5.7435,2.7421-8.1182,3.8651l5.4507-2.4893-10.7738,5.25c-1.15.5069-1.8186.7746-1.4188.5075l-10.84,5.113c-2.4131,1.0562-3.0981,1.3478-1.4353.4711l-5.4125,2.5582c1.0334-.3508-5.3827,2.5071-5.3734,2.6727-4.1964,1.8479-4.25,1.9924-9.54,4.3543-1.2384.4149-5.7732,2.4479-5.569,2.2484,3.3-1.506,7.4318-3.3626,6.7828-3.1989,4.94-2.2155.8433-.1357,6.94-2.8567,2.9526-1.459,5.4138-2.7009,6.67-3.41,5.2035-2.4,8.8295-4.1858,12.2542-5.6278a31.723,31.723,0,0,0,3.9885-2.0607c6.931-3.2493,1.3936-.7586,4.0243-2.0109,1.5786-.6608,4.5859-2.0726,7.23-3.3092,2.6458-1.2337,4.9243-2.301,5.049-2.2663,3.4279-1.62,7.6686-3.7728,4.0057-2.0341.2914-.2264,2.34-1.0842,5.3959-2.6052-1.4707.7952-4.0609,2.1033-8.0256,4.0415,5.8127-2.71,11.8345-5.66,14.8167-7.22-4.1221,1.9482-4.7766,2.22-1.4269.5221-.8608.3478-6.8091,3.2785-5.4424,2.4947,11.54-5.62,11.1676-4.9388,24.4255-11.4348,1.5447-.8081,3.8533-1.9723,3.9662-2.113-2.53,1.1389-6.3707,3.1638-10.7637,5.28.1011-.0974.1812-.1837-1.38.5767l21.5027-10.5986c.3925-.1414-1.2428.6774-1.3018.75,6.7716-3.4123,6.793-3.2882,10.7776-5.24,2.2277-1.2137,7.031-3.4412,13.3572-6.7619-.5583.2184-6.1112,3.0977-4.0543,1.9224l-5.8016,2.9263c1.5028-.8378-2.2523.9223-7.6605,3.652-.7815.3447,3.8752-2.0422,7.719-4.03,3.8427-1.99,6.8539-3.619,2.8385-1.6461a47.3867,47.3867,0,0,1-5.3621,2.6838c-1.2267.7367-3.4912,1.9039-11.96,6.1985-.7714.31,2.5446-1.3168,2.6318-1.4133.9336-.5194-6.3373,3.106-5.3563,2.6708a23.872,23.872,0,0,1-4.11,1.8338c6.8912-3.4435,16.5164-8.2845,18.7816-9.3167,3.0215-1.5315.4473-.411,1.24-.886,6.19-3.0594,12.6062-6.36,14.7245-7.4123,2.2993-1.1233,1.7166-.7108,5.4052-2.5744,5.5008-2.816,11.9261-6.2067,13.2321-7.0122,5.2309-2.6882,10.14-5.1616,14.6622-7.5368-1.5206.8549-1.5061.8827.056.1064,2.31-1.213,6.5541-3.5635,7.93-4.1958,1.6207-.8474,4.5281-2.4941,1.2938-.7866.1178-.1426,5.6049-2.96,7.899-4.2557-3.9233,2.1769-4.7935,2.8234-9.1788,5.0686-.7309.4948,2.5329-1.2352.07.1323,1.1766-.6431,2.3543-1.2866,2.6516-1.403,3.1165-1.67.7281-.523,5.2349-2.9283-2.7232,1.679,9.3858-5.098,6.662-3.4186,4.6486-2.6064,4.8182-2.5505,10.5452-5.7263-4.9628,2.8712,1.759-.801,4.0269-1.9938.1022-.3445-2.0868.7684-14.6294,7.6146.7835-.4736,2.7984-1.5853,5.2518-2.9243l3.91-2.1275,3.9412-2.2191q.2957-.0351,5.2755-2.8351c-.2894.0815,1.014-.7326,7.75-4.5772a27.6022,27.6022,0,0,1-2.6417,1.4235c-1.0911.6471-8.2968,4.7483-9.1362,5.1479,6.77-3.93,21.6041-12.3533,27.161-15.8843,2.2112-1.436,2.2621-1.56,3.7209-2.54,1.7255-1.0844,1.0918-.6041,1.3325-.7039l2.4506-1.5682,2.2859-1.4628-2.6553.5857L515.8381,50.063c-3.2522.7266-6.191,1.4585-8.6237,2.0771l-.0272-.1169c-7.2458,1.629-7.15,1.7672-13.1022,3.1861,2.0838-.56,1.322-.3912-2.93.649,2.6759-.7087,2.6672-.6714,1.43-.47,2.2974-.56,5.56-1.3342,5.8217-1.4434-4.9009,1.0546-19.39,4.8763-21.831,5.3471l-2.902.78c-1.7527.5775,17.369-4.2108,13.1161-3.1306-6.4276,1.6345-7.2241,1.7646-11.6078,2.9268-.732-.0123-10.7672,2.5251-20.3619,5.0573-1.2808.3514-2.5739.7056-2.8718.8192,1.2365-.28,4.6663-1.1858,7.2521-1.8506,1.469-.4066,1.4786-.4635,4.3292-1.2014l.03.1158c2.0646-.656,4.8132-1.2263,5.7925-1.5273,2.6415-.5491-8.9359,2.35-13.0128,3.5225,1.124-.3239,1.5385-.4756,1.4189-.4983-2.7739.7888-1.13.3549-5.78,1.555-1.0612.3757,4.9951-1.2794,2.9253-.6161L449.11,66.7424c-1.5577.592,7.3726-1.92,8.7094-2.2058-4.002,1.1237-9.4852,2.6055-12.9837,3.6292,5.0262-1.3492-.9231.37.0541.2028-5.5464,1.48-7.4515,1.9022-10.1624,2.5668-5.0458,1.3721.138.0468-2.8717.8688,1.2479-.29,3.6519-.9232,7.2536-1.8887-1.1227.3281-1.53.48-1.4288.5065l-4.3463,1.1087c-.0937.0743.7124-.0756-1.416.5055-4.9913,1.3816-3.9279.8779,1.2044-.4513-2.1855.5563-4.195,1.0612-5.6019,1.39-1.8987.5659-3.9117,1.3391-10.0374,3.0584l28.9315-7.7625c-2.2621.69-9.3152,2.5231-17.3317,4.7171-2.0652.6758,3.98-1.0153,2.9208-.6333l-14.4578,3.91c.1449-.1188,4.8306-1.3737,8.6656-2.4078-1.76.3989-12.973,3.47-14.4486,3.9457-2.0953.5124-.3528.0006-1.5015.19,6.5842-1.7017,5.8539-1.696,2.8458-.9587,2.5221-.7128,4.9969-1.4136,4.2894-1.3194l4.3564-1.12c3.3073-.9358,4.6145-1.3746,7.189-2.1284-2.0272.4874-7.4612,2.0781-11.5612,3.19-2.7189.6832,1.6946-.55-1.4736.2446-3.598.98-4.467,1.27-7.2339,1.9626,3.118-.7469,3.2594-.6213,3.0031-.38-5.87,1.494-1.7139.408-8.6682,2.3518-1.1514.3175,8.592-2.5895-1.5449.0773-2.838.85,1.4663-.2718-1.3717.6208-4.3967,1.1095-6.4639,1.6831-11.5992,3.049-3.0327.8276,2.1268-.4916-1.4037.5032-3.9956,1.0054-.6089.0383-4.3969.97,2.5372-.6565,7.7537-2.0953,7.26-1.8672l8.6466-2.4363c-5.296,1.2642-17.1208,4.7114-20.2625,5.4182-2.7749.7579-1.1.4158-5.7566,1.6359-1.66.6345,5.1375-1.17,7.317-1.6534,3.7811-1.0052,4.8727-1.4964,8.6433-2.397,2.6819-.7289.8674-.3395,2.87-.8992,3.953-.9482,4.71-1.2333,10.1484-2.5961-2.0366.71-6.9625,1.7992-10.1093,2.7411-.656.3083,6.7782-1.7549,10.1406-2.6255-1.1255.413,2.1946-.4758,1.5135-.1929-5.5914,1.5439-5.1705,1.3268-8.704,2.2679l-2.88.8112a41.4164,41.4164,0,0,1,4.3654-1.0587c5.7511-1.5656,8.4435-2.3,12.9857-3.6163,2.0212-.5092.6624-.0275,4.3787-1.0328-1.4669.2695,6.4226-1.72.0315.116-.5615.161-2.134.5319-2.9008.7562-2.55.746-5.5126,1.6962-10.0757,2.8888.6282-.101,7.1315-1.9221,10.1227-2.7155.2952.0393-1.1725.33-4.3207,1.2037,4.051-1.0831,2.8374-.623,7.2607-1.8148,4.1068-1.1528-6.3025,1.6194-1.4856.2479,12.364-3.2746,14.0793-3.9559,24.5194-6.8516-5.0129,1.3484-14.6451,4.0079-20.2418,5.4419,1.443-.4531,2.4657-.8015,5.736-1.7114,5.5524-1.4087,12.2157-3.3292,17.3777-4.5927,1.9576-.5333,1.1812-.3937,1.4106-.5015,3.9364-1.0118,10.9174-2.926,7.2645-1.82,9.9174-2.6786-.3727-.1249,5.7142-1.7936-.4514.08-3.6371.9278-5.7913,1.5039.9844-.3285,3.8373-1.1031,7.21-2.0018.1495.0627.58.1448,7.33-1.5919,1.695-.4525,1.2126-.3735,1.4219-.4658,2.5726-.6369,1.8765-.3592,7.2719-1.7858-5.0447,1.422,6.7534-1.5706,10.1811-2.4749-2.092.5252-3.2667.7487-8.7155,2.1581,1.7252-.53,6.73-1.8124,7.2036-2.0251,2.5536-.6347,3.3206-.7817,2.9356-.6144,3.9906-1.0172,7.7762-1.9753,11.7677-2.9287,3.9888-.965,8.1684-1.9908,12.9615-3.0778-.6187.192-4.5869,1.09-2.8923.7938l9.9384-2.3908L526.51,48.839l-.472-1.1207-4.9713,3.1609c.8733-.4555,2.2758-1.3986,4.9891-3.1343l.4476,1.0628-3.0181.6589c-1.07.15,2.8906-.6952,2.9014-.7585l-4.3791.9591c.3577-.1116,2.5079-.5787,4.4645-1.0071L526.14,47.87l-1.184.7529c1.2079-.8857-1.8107,1.0332-5.0931,3.1268-1.7186,1.0161.5685-.4661-1.37.6562-2.5928,1.657-.2142.3224-3.7552,2.4372-.32.2705.3828-.0745,2.5919-1.4854-1.8772,1.2583-4.6006,2.8019-7.8771,4.7347-3.2909,1.9094-7.1123,4.2487-11.4487,6.6777,2.2832-1.3087,8.62-5.0275,7.6861-4.6473l-10.3861,5.962c-4.3333,2.43,3.3729-2.0508-1.3677.5986-3.6359,2.0822,1.9275-.9943-1.2458.84L481.4329,73.71c-3.1445,1.7248-5.8156,3.1906-8.4706,4.5344-.4329.2693-2.392,1.33-4.08,2.2493-1.6975.9023-3.1241,1.6638-2.4681,1.3786l-7.9509,4.1732c6.8051-3.94-9.0709,4.7868-10.72,5.3412a39.0563,39.0563,0,0,0,3.95-2.1324C475.99,76.6315,505.9,60.2321,525.8026,47.3649l.7959,1.89-1.5435.3288a13.2631,13.2631,0,0,1,1.5345-.3706L525.8264,47.4l-4.97,3.15c3.389-2.0805,1.8162-1.0338,5.0339-3.0541l.6751,1.603-.0915.0193.0538-.0092.0219-.0035.0092-.0014.0041-.0005.0019,0h.0016l-.6785-1.611c-.0159.0084-.02.0089-.0024-.0037l.6819,1.6191-.6819-1.6191c-.3175.1827-.3012.1567-.0225-.0338l.7129,1.6927c-1.0789.2953-7.5242,1.7209-8.8212,2.0956-5.1736,1.0182-8.852,1.9767-13.1394,2.9466-.19-.0113,1.7771-.4771,1.4313-.4551-1.2432.24-7.5372,1.6761-8.75,2.0531.65-.1121,1.8734-.4668,4.38-1.0627-1.5883.4852-7.575,1.9442-8.6851,2.3232-4.4429.9052-11.708,3.0372-13.0927,3.1707l11.6074-2.9335c-6.0338,1.324-13.6785,3.49-17.3857,4.5288.2449-.0241,2.6472-.6652,4.3733-1.0877-6.0269,1.6989-16.3893,4.2472-23.1837,6.0538-.2264.0955.332-.0325,1.4653-.3242.264-.0018-5.1331,1.3658-7.2258,1.9382a9.0468,9.0468,0,0,0,1.4144-.4678L432.16,72.9338c3.0164-.7482,6.7736-1.6987,13.0469-3.3768-4.2509,1.2245-6.5941,1.8934-2.822,1.0038-9.9748,2.6174-8.848,2.52-15.868,4.4258-.6222.1031.9683-.344,1.4106-.5053-11.8176,3.3269,10.8575-2.7189,8.7689-1.9949,7.05-1.8784,7.0253-2.0218,14.4212-3.9794-.1931.1281,2.308-.5125,2.9353-.619,4.55-1.1848,3.8015-1.1095,7.2234-1.9363-12.9648,3.5676-16.4794,4.3855-27.4434,7.4316,6.6066-1.7083-5.1833,1.5087-4.2651,1.4009-5.6545,1.4954-1.847.3578,1.3954-.5325-5.0553,1.1882-9.0746,2.3834-14.4828,3.7633-2.433.7113-1.7687.6483-4.2733,1.377l-.0229.0062-6.762,1.84a15.6216,15.6216,0,0,0-1.88.5666c-5.4932,1.5361-.317-.0529-5.8113,1.4835-4.2273,1.1732.8962-.1428.0393.1448-4.7909,1.3083-1.6128.2882-8.7065,2.2638-2.132.5893.5873-.1189.0236.0869-4.4994,1.1981-7.2319,1.8807-8.7,2.1946.4471-.0247-3.1155,1.0417-1.3815.6837,7.7664-2.1957,13.3036-3.6705,26.032-7.0455,2.0247-.6409,3.5221-1.1458,7.146-2.2186l.0109-.0029.0121-.0033,2.8542-.8364,10.13-2.6829.0315.1161c-5.7451,1.5288-5.8157,1.5532-11.55,3.13-1.3816.4882,7.0367-1.895,4.3676-1.03,4.9641-1.44,14.5282-3.9684,18.7806-5.139-4.2233,1.2341-11.4371,3.2149-14.3931,4.1353-2.1556.571.5656-.1935-.0236-.0869-3.1625.8629-3.085.9153-2.8547.93L406.515,81.31c-.5962.2193-3.2224.921-1.4135.5389-2.5068.5328-7.73,2.0624-15.9274,4.2539,4.41-1.09,4.1588-1.0616-1.4039.5037.2128-.007,6.0183-1.6562,10.1185-2.7385.4332-.0837-12.3016,3.42-4.2731,1.3768l-8.6934,2.317c1.337-.4689,2.6573-1.1011-7.3138,1.6317,6.1768-1.5381,3.29-.7256,2.9824-.4617-6.4036,1.7292.6614-.2624-2.9279.6646-3.166.8524-3.09.9054-2.858.9207-6.6589,1.8121-6.0083,1.51-8.7311,2.1828,1.31-.4355,2.7174-.645,7.2515-1.9108.7363-.4066-9.829,2.63-8.7266,2.15-.625.282-6.8364,1.9109-13.0157,3.5379-.7756.41,7.0394-1.6685-4.2843,1.4062.0406.0557,3.9623-1.001,2.9333-.6459-3.8763.9445-6.7008,1.6185-11.6116,2.9938,1.4574-.4561-6.5758,1.6618-13.092,3.2663.4832-.2288,8.3629-2.1629,13.0544-3.4114,2.679-.701.8716-.3313,2.8737-.8707-3.0333.743-6.4232,1.5673-1.49.2321-1.8059.37-4.9824,1.3394-8.7028,2.2507.96-.2092,3.3406-.8225,2.929-.6573-7.37,1.9012-3.9474.9806-5.8369,1.3969-6.3932,1.6428-7.4487,2.0912-14.4935,3.8448.5656-.05,3.1255-.6664,5.5361-1.2783a43.5039,43.5039,0,0,1,4.69-1.079c-6.2122,1.561-6.33,1.6416-15.9915,4.0016.411-.165,3.9181-1.0311,4.33-1.1962-2.18.4372-13.3685,3.3311-7.2522,1.8889l-20.3773,5.0469c-1.287.1843.9731-.34-7.3424,1.5745,4.6459-.9885-7.1124,1.8079-13.1584,3.0349,2.1838-.3632,5.9565-1.1718,1.5249-.0612-3.0621.6907-3.8911.84-5.8676,1.2678-.1071.1075,2.4515-.4805.0258.1174-1.5928.3448-1.0018.16-2.952.5916-2.8431.7216-2.5236.7-7.3055,1.7049-.1757.1125-.1857.1865,1.5078-.1329l2.936-.6484c3.7881-.8036-2.0323.3748-.0251-.1172,3.82-.7728,4.4407-.9061,8.7994-1.9-3.7162.7347,2.7346-.7537,2.927-.6784,4.0956-.9365-2.14.3916,1.4294-.439,7.3726-1.6693,4.8735-.98,7.3651-1.4787,8.2823-1.9625,9.6552-2.1067,19.0149-4.3309-.998.3427-6.8247,1.6985-8.7422,2.08-2.44.6154-2.6807.7679-5.8141,1.529l4.3993-.9553q-1.8512.496-7.3,1.7487c.1121-.11-2.4421.5026-.0267-.1168-2.57.6012-3.3214.8206-2.9017.7937-3.39.7347-2.804.5582-.0265-.1168.2389-.1075-5.1981,1.1612-7.3263,1.6085,2.4685-.4952,1.2075-.0865,1.515-.0587l-7.3524,1.4735c-1.8989.48-5.9171,1.36-10.3943,2.2871l-13.1056,2.7512c-3.27.6038,1.8448-.44-1.48.2017-4.1316.8481,2.15-.3442-1.4636.4122-4.9381.999-4.8336.8943-7.3811,1.37-1.94.3992-2.3057.5074-4.41.9009,1.2062-.0763,6.079-1.1833,8.8463-1.6572-.26.1069-2.9517.6451-5.7021,1.1938-2.7546.53-5.5743,1.0408-6.0695,1.1866-3.1925.5634-2.4061.31-4.4717.642.6046-.0263-3.4128.91-13.2941,2.5266.4515-.1179,3.7118-.6558,5.9185-1.0358-2.14.3158-4.6931.7574-6.729,1.1343s-3.5547.689-3.626.746c-5.6516.999-8.9215,1.4048-12.0975,1.9148-3.1837.4692-6.2812,1.009-11.6851,1.7535-.71.192,4.5911-.557,3.0048-.2279-9.5829,1.2738-6.5677,1.0726-14.88,2.2523-5.3116.6127-3.6876.3493-8.9916,1.0237-1.3285.2534,4.8887-.53,6.002-.6127,1.3275-.0588-3.8779.517-4.48.6459-1.1653.0694-4.9735.5018-4.5093.3471-.5138.0376-1.5125.1664-2.8214.3116l-4.6794.435c.2783.066,7.1353-.6584,6.0223-.4523-5.7091.6091-9.3812.905-10.51.9459a20.1817,20.1817,0,0,1,2.9857-.3485c-.1891-.05-6.3636.6046-9.0034.8354-.2534-.1495-6.8582.3979-14.0492.9822-3.599.2529-7.3524.43-10.5239.5927-3.1729.1469-5.7656.2642-7.0609.1727-4.5044.12-7.5839.1777-10.0746.21l-3.3993.0278-3.1475-.0663-3.0258.014c-1.0823.0756,7.135.0159,6.0533.0917-.522.12-3.9736-.0219-7.567.02a47.2437,47.2437,0,0,0-5.2958-.2382l-1.2294-.0217a4.0416,4.0416,0,0,1-.792-.1122l-.8911-.1659-3.9138-.7186L56.782,140.537c-.9944-.1021,6.9545,1.33,7.7582,1.5607l-10.7383-1.9826a9.9688,9.9688,0,0,1-1.1477-.2425,5.4342,5.4342,0,0,1-.4436-.9258,4.4122,4.4122,0,0,1-.2617-1.1626,5.4667,5.4667,0,0,1,.0087-1.0175,6.52,6.52,0,0,1,.5142-1.8971,8.2459,8.2459,0,0,1,1.4132-2.2169c.1169-.1128.3208-.3256.6683-.6264l.5538-.5073.7877-.62a39.43,39.43,0,0,1,5.06-3.2048c1.077-.579,2.208-1.18,3.3864-1.7567l1.7679-.8669,1.0989-.5159c1.3033-.6061,2.5637-1.1634,3.6332-1.6285l-1.5392.8352-1.4092.7279-3.3164,1.6775,1.6361-.8033,1.0714-.5057,1.9135-.879,3.8962-1.7258c2.6254-1.14,5.3041-2.2585,8.0128-3.3663,5.417-2.2157,10.9548-4.3807,16.4243-6.4883-5.3545,2.17,1.194-.3749,2.8739-.9086,2.4963-.9716,5.8243-2.2236,7-2.71-7.8038,2.8791-12.8109,4.4166-22.5129,8.5019,1.8884-.9638-6.4012,2.6447-5.6357,2.1586,2.913-1.23,3.6993-1.5107,5.5907-2.27-4.995,1.9211-8.4325,3.2668-8.5352,3.0923,5.209-2.2218,8.02-3.28,9.8344-3.94,2.6608-1.0776,2.4957-1.1,6.9778-2.8281-7.8317,3.1812,8.0767-3.0251,5.726-1.8925,8.1158-3.0981,12.6816-4.6982,19.6967-7.3331-.1514.1362-2.6567,1.0732,1.4469-.4019,4.3075-1.6974-5.7777,1.9811-1.4985.2609,6.0811-2.172,16.8987-6.1019,18.4005-6.465,16.0935-5.9165,33.85-12.119,38.2289-13.2537,7.5208-2.6,5.1893-1.959,9.8367-3.6161-2.9835.9537-6.2992,2.1005-9.9261,3.3613,3.4976-1.334,14.2034-4.9725,19.762-6.9587-3.262.9614-1.1708.1556-1.5416.1315a86.8139,86.8139,0,0,1,10.0321-3.0248c-1.8889.6436-2.7883.91-5.6577,1.92-3.0984,1.17,2.4987-.7812,2.8688-.8292,3.7545-1.4268,6.46-2.3635,9.512-3.4183l4.8357-1.69c.4459-.1437.9806-.331,1.5786-.5706a10.2031,10.2031,0,0,1-1.5315.4489c.0643-.0479-.7843.2408-1.498.4851l-3.0858,1.0927,2.3107-.9167,2.5442-.9562a.6709.6709,0,0,0-.3175-.0988l-.118-.0008-.0669.0048-.0355.0038c-.0308.0078.0226-.0142-.1069.03l-2.9551,1.03,3.2706-1.2548a4.6794,4.6794,0,0,1,.5967-.1554,5.6215,5.6215,0,0,1,1.1737-.1442,9.8446,9.8446,0,0,0,2.3339-.8842c-.3208-.2314-.7211-.2956-.158-.4277a6.8235,6.8235,0,0,1-1.66-.0937c-.3282-.0195-.4453.0118-.8265-.0023.4728.0779.1075.1564-.07.2413-.1968.0842-.2148.168.3469.2825a18.2143,18.2143,0,0,1-1.9447-.1011c.5045-.0636.2935-.09-.0148-.11l-.2206-.0136-.7643-.0116c-.3746-.009-.2756-.0217.7488-.0438-.1656-.0225-1.7869-.0425-3.4646-.0015-1.6831.0563-3.4336.1157-3.8873.1051a23.406,23.406,0,0,0-4.407.296c-9.8036.6132-22.4891,1.7234-33.9391,3.2847L156.88,73.546l-7.6143,1.12c-2.1526.3171-4.7155.7032-10.0692,1.6123-16.0022,2.7155-30.0358,5.3354-39.7439,7.0285-3.5485.6747-3.1768.6705-7.3437,1.4559-17.3241,3.0761-33.35,5.8739-45.9595,7.7087-12.6057,1.8583-21.781,2.772-25.287,2.7386-2.9515.4188-1.88.3333-5.9554.84-1.2538.1243-1.9742.17-1.4971.0391-7.2126.86-9.6272.9426-10.3362.899-.71-.0469.2745-.272-.1838-.3278-.7936-.0973-2.6727-.142-2.49-.353a7.1558,7.1558,0,0,1,2.2092-.4681l7.6381-.963C6.97,95.1277,9.09,94.8148,8.71,94.682c1.9817-.22,3.9652-.4191,5.9425-.6865-3.8234.3806-5.072.359-4.77.2408.3-.1447,2.1488-.4087,4.4988-.8218,4.7063-.7568,11.4268-1.9492,11.9426-2.231,1.25-.27,3.63-.6454,8.8315-1.4838,2.9307-.7938,12.7476-2.65,23.1368-4.765,10.39-2.1051,21.3627-4.408,26.6366-5.7136-2.5887.4135-7.8186,1.5374-11.7433,2.2731.5844-.3117,8.9171-1.863,14.6626-2.9624,2.2681-.5894,12.673-2.5851,13.18-2.8641,14.2394-2.84,25.4186-5.12,36.8679-7.2845,11.4557-2.1368,23.1677-4.2491,38.6031-6.1805,1.0387-.1708,3.6053-.4893,6.3164-.8213,2.72-.2883,5.5852-.5876,7.2068-.7874,6.689-.5179,12.4351-.9611,17.6506-1.1528l3.807-.1594,4.3535-.0564c1.1268-.0146,2.2421-.0259,3.3134.0128,1.0878.0207,2.162.0449,3.1481.1222l5.9718.3779,2.2352.1446,1.1045.0717c.1781.0136.3782.02.5374.0394l.3582.0972,2.8191.7666,2.75.7509.6787.1857a1.6045,1.6045,0,0,1,.3052.0964l.0776.1227.3082.4886.608.97.3011.483a1.37,1.37,0,0,1,.2545.5352,4.9152,4.9152,0,0,1,.0942.8767,3.8614,3.8614,0,0,1-.0259.5659,3.1162,3.1162,0,0,1-.3479,1.11,5.9343,5.9343,0,0,1-2.0444,2.7389,30.2821,30.2821,0,0,1-6.6931,3.4525c-2.845,1.1872-5.9843,2.393-9.27,3.626L214.77,79.6319l-22.574,8.1871-7.0983,2.4036c-22.6266,8.1868-46.4377,16.5212-73.1564,26.3732C109.8595,117.4092,106.2375,118.7779,104.9865,119.3114Zm81.35,14.8727c4.668-.7379,3.9451-.49,7.4271-1.1236C194.4711,132.8426,188.5009,133.8016,186.3362,134.1841Zm-5.9858.6471c4.246-.6469,8.1167-1.2441,7.4135-1.2307C182.6312,134.3657,181.2233,134.6343,180.35,134.8312Zm91.3916-17.8845-5.8672,1.3023.02.0877C270.5992,117.3209,270.4652,117.2825,271.7419,116.9468Zm-67.74,13.4926c-.1945-.0448-.2979-.1063-4.4738.6075a8.7793,8.7793,0,0,1-1.4551.3385Zm23.6527-4.2535c-7.7365,1.5106-1.5577.2481-.0228-.118-2.9111.6458-12.93,2.4715-10.311,2.0409,6.1041-1.1346,5.951-1.0623,4.4575-.701,2.2147-.3973,5.44-1.0353,5.8878-1.163C221.54,127.4536,227.37,126.2833,227.6552,126.1858Zm7.3494-1.5778c-.9032.2172-9.4056,2.0167-2.9205.7313C230.69,125.5327,241.1578,123.4712,235.0045,124.608Zm8.8053-1.8217c3.9564-.8077,5.8722-1.2245,1.5009-.2236l4.4063-.8956c-1.093.1462,2.9048-.6725,2.9156-.7356C248.8859,121.7524,245.6091,122.3148,243.81,122.7863Zm-28.017,5.33c-4.6323.89-3.59.6141-5.9166,1.0308-2.6317.5962-.2637.1617,1.5214-.0674-.83.1531-1.68.3345.0052.0294C214.8535,128.4125,212.6008,128.7986,215.7928,128.1166Zm45.5833-9.3944c-2.7424.6052-3.106.711-1.46.3843l-7.3152,1.6786C258.2693,119.6019,261.0139,118.8926,261.3761,118.7222Zm-45.6267,9.158c2.7173-.3627-1.3043.4705,5.9624-.826a8.9292,8.9292,0,0,1,1.4552-.36C219.3375,127.389,220.47,127.0678,215.7494,127.88Zm64.5929-13.63a20.31,20.31,0,0,1-2.9266.6149c-4.3929.9971-8.2621,2.04-4.3491,1.19.98-.3176,3.71-.9733,5.8456-1.3821A8.7943,8.7943,0,0,1,280.3423,114.25Zm17.4814-4.3539c-3.6669.9312,1.2623.0239,5.86-1.2621C300.8567,109.3,299.8523,109.4549,297.8237,109.8965Zm24.6934-6.2671c-7.2255,1.8795-13.5066,3.3185-14.52,3.6891,4.4708-1.13,2.8141-.6118,7.2861-1.7427-1.0215.04,6.1938-1.4849,8.7026-2.2582C321.2671,104.0109,320.9064,104.0771,322.5171,103.6295Zm29.0354-7.4689c3.4188-.9046,4.281-1.0779,8.6963-2.2682,1.0079-.316-1.1633.2385-3.588.8783l-3.4612.9255-1.1875.3267C351.7224,96.1042,351.5525,96.1606,351.5525,96.1606ZM320.98,103.6181a20.301,20.301,0,0,1-2.9233.6815c-2.5491.6644-7.267,1.8119-8.7231,2.2247C312.058,105.8556,318.9982,104.2172,320.98,103.6181Zm1.4711-.25c-7.344,1.8063,2.9867-.7274,2.9-.7685-1.4064.3065-13.3976,3.3621-8.7184,2.2408a11.064,11.064,0,0,1,1.46-.3951C315.8414,105.0936,323.045,103.2769,322.4509,103.3678Zm17.4332-4.44c.573-.2234-2.6718.627-1.4891.2321C332.6931,100.6385,333.2825,100.6743,339.8842,98.9277Zm2.8622-.8679a10.6575,10.6575,0,0,1,1.4562-.4092,35.0083,35.0083,0,0,0,4.3512-1.1008c-1.135.29-2.8513.7408-2.9117.7267,1.132-.3013,1.6821-.4633,1.4364-.4353C344.2539,97.5606,339.6921,98.8439,342.7463,98.06Zm25.9827-7.2653c-2.2983.6786-5.0857,1.485-8.6494,2.46l4.3571-1.1244C363.72,92.2328,373.3933,89.6177,368.729,90.7946Zm53.3464-15.0121c-.2236.11-3.205,1.0359.0627.2319,4.6328-1.4,10.7529-2.9009,12.9716-3.6594-2.5462.67-8.484,2.3295-8.6785,2.3132,3.5776-.9618,7.0134-1.8887,7.2072-2.0089Zm-5.7827,1.538c-5.7783,1.6031-4.5618,1.5235-12.9539,3.732,6.2268-1.6243,4.9587-1.0882,11.6445-2.7863-.7134-.0225-5.4586,1.2886-4.4307.7978,2.8864-.7183,6.163-1.6711,7.2057-2.017C410.6665,78.9687,421.01,76.0934,416.2927,77.32Zm56.3149-15.4245-4.3531,1.1246c1.6569-.36,1.7107-.2711,5.8364-1.322C474.8279,61.3829,466.7725,63.4682,472.6077,61.8959ZM481.3,59.6506c-3.607.8936-7.0513,1.7811-7.2468,1.9025C477.04,60.837,480.9775,59.8145,481.3,59.6506Zm34.9263-8.3793a27.18,27.18,0,0,0,2.9579-.4944,2.8629,2.8629,0,0,1,.4125-.1123l.9184-.2125c.6824-.1556,1.4066-.3194,1.5815-.3743C518.2457,50.93,520.925,50.2153,516.2268,51.2713Zm-58.1094,14.397c-2.9617.7616-.4512-.0378-5.8154,1.41C450.3956,67.6866,455.5717,66.4321,458.1174,65.6683Zm5.8442-1.3219c5.0256-1.4147-10.3762,2.533-11.59,2.9926C457.3418,66.0256,462.757,64.5815,463.9616,64.3464Zm-1.4217.4658c2.8848-.7189,6.1854-1.5756,7.24-1.876-1.1333.2858-1.6923.4112-1.4655.3167C465.01,64.0971,462.8671,64.6674,462.54,64.8122ZM358.3917,92.739c3.9937-1.0163,8.9181-2.5125,14.452-3.9467C369.369,89.6217,360.88,91.9929,358.3917,92.739ZM135.231,137.0051c4.2189-.4124,10.2461-.9631,10.4309-1.0673C141.4482,136.35,135.4346,136.8989,135.231,137.0051Zm208.464-41.3c2.5151-.7167-1.1007.2255,1.4083-.49l-4.3486,1.0991c1.6512-.24-1.5437.4555-1.39.6093,1.6938-.4143,3.8912-.97,7.25-1.8532-.7184.0946,4.4275-1.2322,2.8551-.9353C345.5157,95.1555,346.5725,94.9542,343.6949,95.7055Zm-10.1228,2.7238c-7.1187,1.7789-1.0985.228-1.5023.2016l-5.8118,1.4471c3.681-.8028-2.7255.7317-2.87.8847a54.51,54.51,0,0,1,5.8221-1.3879c-2.1733.5037-5.9349,1.4864-7.2455,1.8734C326.3568,100.32,333.2678,98.6136,333.5721,98.4293Zm7.3032-1.65c6.6722-1.5653,13.582-3.5638,17.3395-4.7075-1.8481.446-7.1055,1.8305-7.2273,1.9415a20.6174,20.6174,0,0,1,2.9137-.7081c-6.1814,1.7478-9.0536,2.379-8.7222,2.2007-.545.23-6.8459,1.6634-8.6937,2.2593C341.1951,96.5312,344.2211,95.8384,340.8754,96.7794Zm20.2687-5.3575,5.7946-1.5452c.3827-.1731-.3823-.0143-2.9268.6594Zm-59.4508,15.3864c-8.58,2.0673,6.0162-1.5737,1.427-.4759-2.7167.7184-12.5765,3.1249-8.6914,2.2809C294.7429,108.4088,299.8424,107.349,301.6932,106.8082Zm72.4119-19.0993c2.3209-.5-3.7332,1.0639-4.3018,1.2762,4.7081-1.2689,4.1919-1.026,7.26-1.82.5944-.0435-9.0388,2.4333-10.1014,2.7981,7.2988-1.8623,8.1259-2.1674,15.8948-4.2988-3.6161,1.0521,2.9355-.724,5.8008-1.4736,1.0591-.382-4.9868,1.3091-2.921.6339-2.1665.58-5.3275,1.45-5.7852,1.5312,2.1434-.665,5.92-1.545,7.2164-1.98-2.8447.7775-2.8816.7365-4.3579,1.1149-.88.3151-7.3025,1.987-5.7933,1.5l5.7855-1.5295C383.3059,85.2219,376.5182,87.1092,374.1051,87.7089Zm-13.03,3.452c.7544-.1743,12.5922-3.2984,8.6821-2.35C367.2107,89.5753,363.61,90.3558,361.0747,91.1609Zm-4.366,1.03a42.1758,42.1758,0,0,1-4.3528,1.1818c2.0491-.4526-3.8959,1.1877.0459.1741C353.9917,93.0756,360.6246,91.2213,356.7087,92.1908Zm2.84-.9371c-.4341.2184-6.8916,1.7286-5.77,1.5875,4.766-1.2391,4.9023-1.1487,10.1713-2.537a8.783,8.783,0,0,1,1.4126-.4714C356.5061,92.2347,362.5382,90.4971,359.5486,91.2537ZM346.47,94.52c4.5543-1.2285,3.5354-.8832,5.8015-1.4661.0013-.093,3.7441-1.0952,4.3141-1.3268C351.2482,93.1351,350.0581,93.5457,346.47,94.52Zm-42.0879,10.6653c-5.066,1.341-4.5067,1.1646-11.6332,2.9056,3.0618-.717,4.1891-.9288,8.7592-2.04C300.3993,106.232,305.4812,105.0076,304.3824,105.1851Zm84.0244-21.9206c-1.7426.4642-.8906.2061-.0157-.058l-10.0861,2.8489c2.2609-.6026,1.0291-.21.0233.0867C383.548,84.7155,382.9766,84.7963,388.4069,83.2645Zm36.119-9.8531c.2454-.03-.2126.1457,1.4825-.3074.3787-.211,5.4089-1.3828,5.7694-1.5892C430.0281,71.9523,429.1314,72.1409,424.5259,73.4113Zm18.7769-5.177c-2.7638.7526-6.2136,1.6741-5.77,1.6372a10.35,10.35,0,0,1,1.4678-.3617A29.9734,29.9734,0,0,0,443.3027,68.2343Zm-33.2606,8.948c-4.7694,1.295-5.506,1.5821-5.7343,1.7418C408.4148,77.7952,408.4249,77.6892,410.0421,77.1823Zm-75.27,72.9029c-.56.1862,6.1744-2.9142,4.0142-2.0064-3.2549,1.5594-2.9531,1.3419-6.7744,3.1843A22.1369,22.1369,0,0,0,334.7717,150.0852Zm56.6605-27.3586c4.0861-2.0507,6.8549-3.33,8.0287-4.0369C396.8816,119.9377,391.1554,122.702,391.4323,122.7266ZM432.62,101.2709c1.2694-.7283,10.6434-5.6375,3.9124-2.2267-1.52.9225-2.8561,1.5622-6.6485,3.4646C429.7189,102.67,429.7163,102.7717,432.62,101.2709ZM420.1033,74.2349c.2587-.0239-.489.2469,1.4779-.2768-.6309.1439,9.6251-2.5977,5.7678-1.62l-2.8936.8126A30.4685,30.4685,0,0,0,420.1033,74.2349Zm82.68-21.2827c1.1048-.3369,12.0347-2.7833,13.129-3.0862C511.2245,50.8665,498.4263,53.8672,502.7831,52.9522Zm12.6729,3.07-14.244,8.3186C502.777,63.615,512.4254,57.895,515.456,56.022ZM497.4946,66.8829c7.3058-4.095,4.9492-2.9465,6.42-3.8623-2.56,1.4722-7.465,4.1944-10.459,5.8629.1746-.0131,2.49-1.2963.0734.1306C497.9913,66.4727,500.27,65.248,497.4946,66.8829Zm16.8408-9.8147c3.9677-2.4044-.2241.0811,2.496-1.6522,2.0329-1.1082,7.1953-4.6766,8.9357-5.5662-.1787.0632.3629-.3111,1.1408-.8292l4.4268-2.9487-5.1484,1.2353-3.01.7222,3.02-.6752,4.8462-1.0837-4.1611,2.71-1.18.7689c.2466-.2235-1.4764.859-1.3358.706l2.4614-1.5569,3.79-2.3972-4.4.9493c-5.1648,1.1143-10.7925,2.2918-5.9667,1.189-4.7733.9572-10.1455,2.1989-11.6832,2.694,7.6441-1.8624,4.2742-1.0018,5.8648-1.2664,3.6-.7845,7.0555-1.54,8.7638-1.95A26.5115,26.5115,0,0,0,526.24,47.56l3.76-.7871-3.2348,2.0331-2.4651,1.5493a36.3633,36.3633,0,0,1-3.3143,2.2519l-4.36,2.8132c-1.762,1.1136-3.876,2.3265-6.2751,3.7608C510.2456,59.363,512.944,57.8115,514.3353,57.0682ZM470.61,60.15l10.1468-2.6517c-.9677.2282-3.4716.8377-5.745,1.4346S470.6874,60.0836,470.61,60.15ZM458.949,62.9359c-3.4872.9323-3.1734.78-7.2466,1.88C450.3278,65.2924,458.8413,63.0567,458.949,62.9359Zm26.1069-6.7967c-1.3527.373-5.368,1.3591-4.3428,1.1844.94-.21,6.8245-1.6188,7.2827-1.8a23.4362,23.4362,0,0,1-2.9326.6447c5.143-1.3112,3.5983-.7986,8.7516-2.0669C493.45,54.0956,488.62,55.2548,485.0559,56.1392Zm-181.1522,47.094c4.5416-1.11,4.6184-1.21,4.3134-1.2229C303.8674,103.085,300.8756,103.9192,303.9037,103.2332Zm53.6119-13.8c1.0847-.2351,7.0868-1.8831,5.8165-1.4481l2.8944-.7751c-.02-.0258,1.156-.3464,1.4257-.444C362.6747,88.1447,360.81,88.455,357.5156,89.433Zm21.702-5.8c2.8365-.7571,2.8477-.8113,4.3134-1.2272,1.6923-.4622,4.1062-1.1038,4.32-1.1979-2.5153.6879-7.22,1.8625-8.6565,2.3382C381.4307,82.9506,380.2051,83.3414,379.2177,83.6334ZM332.951,96.0181c.8787-.3491,2.2345-.7476-2.9539.54-1.989.5764,3.7573-.8391.03.1163-2.5669.6523-4.2434.9053-7.2727,1.7875,3.2858-.8149,7.2924-1.7614,4.3923-.9622Zm13.0253-3.3849a22.67,22.67,0,0,0-4.41.8979C338.1234,94.5156,343.3926,93.248,345.9763,92.6332Zm10.1492-2.6464c.33-.1317,2.365-.6777,2.8613-.85-5.8635,1.6254-4.8865,1.2712-7.2653,1.8278-.3.1036-1.1921.3511-2.8768.7913C349.1388,91.7759,351.5779,91.1832,356.1255,89.9868Zm7.2452-1.8568c.2261-.0966,2.274-.6425,4.328-1.19-.1348-.1035-3.31.8488-5.8064,1.46C362.1508,88.3766,361.4028,88.6472,363.3707,88.13Zm82.3951-22.2939c-6.834,1.91-13.6924,3.5444-17.347,4.69C433.453,69.1372,444.0666,66.4412,445.7659,65.8361Zm37.7476-9.6806c-.6675.0952-5.0436,1.1454-9.2386,2.22l-5.6808,1.48-1.84.4929c-.4417.121-.69.2011-.69.2011C470.5643,59.3847,475.993,58.02,483.5134,56.1555Zm-2.903.761a5.4808,5.4808,0,0,1-.64.1856l-1.4195.3652c-1.0455.2663-2.129.5414-2.2866.6033,1.76-.4359.9024-.1923.0148.0581,6.284-1.6023,9.0269-2.1992,11.63-2.9543C483.6632,56.25,482.8783,56.3807,480.61,56.9166Zm15.9608-4.1319c-2.7856.7326,1.281-.2064,2.96-.564C502.5535,51.4261,499.5427,52.0864,496.5712,52.7847ZM373.46,85.3043c2.0249-.54,5.5293-1.4877,2.8866-.8044l-5.7811,1.58s-.2987.0623-.626.1477-.6853.1857-.81.2369c4.7277-1.231-.338.194,5.8092-1.4317C375.0305,84.9537,374.5968,85.027,373.46,85.3043Zm20.21-5.5455c-5.568,1.44-10.0476,2.7056-11.5393,3.2125C388.5435,81.2461,392.9575,80.1145,393.6694,79.7588ZM437.0114,67.93c-.437.1588-2.0344.6035-1.4053.5,6.3963-1.7542,9.201-2.3091,10.1212-2.74C439.4249,67.42,440.479,67.0217,437.0114,67.93Zm-20.2655,5.3813c-.0071.0429.3434-.0035-.0159.1275s-1.4281.4393-4.2739,1.1917l.0234.0867,4.3213-1.2033a20.4771,20.4771,0,0,0,2.91-.7272c2.8893-.8478-.6514.1154-1.4792.2768,3.94-1.0723,2.9186-.74,5.7772-1.5639C422.7745,71.699,419.7837,72.5936,416.7458,73.3118ZM289.3126,106.54a9.1235,9.1235,0,0,1-1.4362.4371c3.7144-.905,6.6785-1.6461,8.7144-2.1836Zm26.1238-6.4725-.0219-.087a55.0256,55.0256,0,0,0-5.78,1.524Zm23.1819-6.0181c2.2756-.5885,5.02-1.3087,4.3647-1.0723-3.6073.9329-7.0316,1.8215-7.2336,1.9418,8.5021-2.1933,10.2615-2.7767,15.9187-4.1571l-.0306-.116C344.7,92.5185,342.11,93.0076,338.6183,94.0494Zm46.5,32.828c1.1375-.7284,9.7013-4.7866,13.3982-6.7451-1.5734.7792-1.4828.6865-1.3933.5945-11.8336,6.0549-19.19,9.3882-24.126,12.0633C377.2146,130.7285,382.8744,127.9222,385.1187,126.8774Zm90.8678-46.18L465.4536,86.42C471.2455,83.38,473.6438,82.0894,475.9865,80.6976Zm-23.7871,12.769c2.9451-1.5845,7.1873-3.8223,7.9187-4.2916l-5.5,2.9219A23.0065,23.0065,0,0,0,452.1993,93.4666Zm12.0009-6.18c-4.3,2.261-4.2647,2.1158-8.0089,4.0682.7316-.3378-1.4821.96,1.3854-.5636,2.9505-1.56,16.5869-8.6314,14.69-7.5237l14.4417-7.9913c-3.8475,2.063-1.4958.7623-1.3828.6152-4.0881,2.2453-19.2684,10.4869-13.201,7.1118C467.1649,85.6367,468.3888,85.0765,464.2,87.2863Zm19.7159-10.8677a8.9976,8.9976,0,0,1-1.2758.7966c1.785-.96,2.5414-1.3336,5.2812-2.8383C488.11,74.1887,485.86,75.3918,483.9161,76.4186ZM402.2,76.8541c2.2061-.7092-4.9205,1.3163-4.3625,1.0906l-.0157-.058,5.7872-1.5392a74.8458,74.8458,0,0,0-7.25,1.874c4.29-1.08-6.3344,1.83-8.64,2.4946C391.4631,79.82,397.3289,78.12,402.2,76.8541Zm7.2295-1.93c1.5349-.4865,5.4-1.5557,7.1831-2.1045-3.3376.9157-5.553,1.5016-7.23,1.9308,1.9843-.4133.4673-.0448-4.3131,1.2325-2.23.7153,4.8982-1.31,4.3523-1.0879C408.6215,75.1118,407.7811,75.3651,409.4292,74.9238Zm18.7942-5.1215c3.6994-.9826,5.0706-1.3293,7.219-1.98-2.5483.6682-8.4886,2.33-8.6881,2.3146a10.4824,10.4824,0,0,0,1.4458-.4214c-5.2574,1.39-1.4438.524-4.3165,1.3211C426.7349,70.2756,426.751,70.22,428.2234,69.8022Zm21.6935-5.8185c6.1078-1.5717,7.8038-2.0756,13.0368-3.4978C458.942,61.567,449.3376,64.0117,449.9169,63.9837ZM406.4651,75.4482c2.7318-.7273,8.6935-2.4009,7.2382-1.9019,4.47-1.19,2.755-.8326,7.219-2.0206-5.0869,1.5512,13.8439-3.6776,15.949-4.1168C434.07,67.936,411.7018,73.9014,406.4651,75.4482Zm30.3439-8.2711c7.1675-1.9009-1.4919.4152-1.4212.4424l11.5949-3.041,2.8572-.8848C445.6673,64.9,435.5138,67.4331,436.809,67.1771Zm-59.26,16.0682c1.7041-.4654,4.1178-1.107,4.3315-1.2011-2.3987.5794-8.4448,2.2077-14.4679,3.8236,3.156-.7654-1.2791.5183-4.3118,1.2477.8-.2142,1.6287-.4614-.0078-.0291a9.9175,9.9175,0,0,1-1.44.415l.0155.058c2.546-.6608,8.4849-2.309,8.6792-2.2918-1.0294.3459-10.0082,2.6534-8.6483,2.408,4.6637-1.1821,11.5382-3.01,17.3622-4.6215-3.8749,1.0262-9.0394,2.41-11.5875,3.0452L394.92,78.6425a40.4949,40.4949,0,0,1-4.38,1.0007C385.5724,80.9926,380.5953,82.5652,377.5486,83.2453Zm50.5731-13.82c3.0309-.7488,4.1141-1.131,8.6639-2.3356C438.2461,66.5611,428.3335,69.2767,428.1217,69.4256Zm-23.21,5.9778c-3.6.9718-5.9932,1.642-7.2158,2.02,3.0969-.8226,6.9351-1.754,8.667-2.3514C405.2316,75.3718,404.686,75.5007,404.9117,75.4034Zm-89.76,23.5292c5.4823-1.4019,7.8436-1.8473,8.699-2.2356C321.3071,97.3584,315.3284,98.834,315.1519,98.9326ZM211.4451,120.9868c-.18.3187-16.1586,2.7152-11.7314,2.1778,1.6971-.3751,1.72-.243.01.0592C204.6,122.4348,218.9592,119.6912,211.4451,120.9868Zm-54.5037,8.2922s-.3027.0186-.64.0559-.7092.0851-.8514.1188c1.4373-.0218,5.5465-.5558,10.3678-1.1893-.9678.1724-2.6919.4325-4.4161.6926l-4.4242.62c4.5483-.5576,2.8539-.231,7.394-.8736,5.1851-.7529,13.5277-2.0278,8.8221-1.535-3.6233.5339,2.6552-.2705-1.4668.3209-1.2479.0507-12.8939,1.6855-8.8884.999C158.0645,129.089,161.7343,128.7374,156.9414,129.279ZM432.4495,74.006c1.45-.4718,2.3307-.8132,7.1887-2.12-2.9641.8905.9982-.2268,4.3386-1.13-2.6591.8094-2.0966.7449,4.3726-1.046C446.958,70.2106,435.1168,73.246,432.4495,74.006ZM484.8887,55.47c-3.43.8718-2.6844.7823-7.2444,1.9139,5.3021-1.4331-9.4921,2.1854,1.3856-.596-1.13.312-1.5455.4586-1.4151.48,4.8794-1.2686,7.4542-1.8809,14.5422-3.6277a22.3891,22.3891,0,0,1-2.912.7373c-1.6442.4156-.7985.2282.0072.0292-.1747.0568-.8948.2454-1.574.4216l-.9136.2411a2.8554,2.8554,0,0,0-.4094.1251C484.65,55.6176,485.1227,55.4474,484.8887,55.47ZM33.631,89.5569c-1.9893.4819-9.26,1.7793-10.2513,2.0524-1.9716.2715-3.94.5821-5.9142.8187-.8411-.06,2.6426-.5526,4.3693-.9927,1.4874-.21,11.1378-1.7217,7.3694-1.1835C25.4888,90.7662,31.6637,89.8768,33.631,89.5569ZM389.5658,87.55c3.9642-1.0389,6.443-1.5829,10.14-2.7151,4.9438-1.19-10.9,3.0729-15.8724,4.45.0143-.0189.4573-.1447,1.0363-.3042l1.8524-.5071C386.9563,88.3607,389.4313,87.7036,389.5658,87.55Zm61.6909-18.5215,8.6906-2.2919c-.1725.0622-.89.2565-1.5652.4409l-.9089.2512a2.827,2.827,0,0,0-.407.13,10.2924,10.2924,0,0,0,1.4558-.3529c-1.3679.4965-9.0358,2.46-11.5734,3.0652C446.3532,70.3514,453.5438,68.53,451.2567,69.0289Zm9.9213-3.454a41.384,41.384,0,0,0,4.3157-1.3145c2.4011-.5892,1.6-.2817,2.9338-.5718-5.2073,1.3132-6.9958,1.89-10.1346,2.6472.1772-.0665.8966-.2641,1.5726-.4413l.9083-.2318C461.017,65.6031,461.178,65.575,461.178,65.575Zm23.2545-5.7525c4.0726-1.0283,4.1977-.98,4.3939-.95,13.8952-3.44,25.0551-5.9532,37.8655-8.7261a5.6846,5.6846,0,0,1-.8321.23l-2.1539.4992-6.7181,1.4786-12.1661,2.7122c-1.9615.48-2.8834.7567-4.3342,1.1517l-13.0962,3.139c.1792-.062.9009-.2487,1.5782-.4251l.9091-.24a2.887,2.887,0,0,0,.4026-.1211c-.23-.0156-3.6506.9565-7.25,1.82C483.4749,60.2069,485.3012,59.7042,484.4325,59.8224Zm2.8209-1.0189c3.0422-.7832,3.857-.9356,5.824-1.405-1.0012.2675-2.2411.6282.0214.0874C492.0689,57.7863,487.8541,58.6958,487.2534,58.8036Zm8.7482-2.0526c.0089-.0637,3.9539-.9988,2.8819-.8229l4.3629-1.02c-.9421.2452-3.33.8359-2.8846.7853,1.3355-.2473,3.2391-.8736,5.8217-1.3735C504.9492,54.7037,498.6093,56.14,496.0016,56.751Zm3.1273.1978L503.4816,55.9c.3967-.0123-3.2673.8783-2.8615.872C494.9818,58.1213,502.75,56.1873,499.1289,56.9488Zm26.1642-6.2507,1.5322-.3721-1.6307-3.872-1.1484.793L516.5975,51.91l-2.1347,1.3466L512.3677,54.5l-3.5381,2.13c-.5994.29,1.6533-1.075,5.0023-3.0668l11.3319-7.1547,1.673,3.9722-6.3022,1.3434-1.8876.3914c-.442.0894-.6813.1342-.671.1245C521.5969,51.442,525.0654,50.681,525.2931,50.6981Zm-3.0432.0832c2.4946-.5529,3.79-.7777,4.3735-.9579l.0914-.0194-1.2239-2.906c-1.2642.7949-.6682.3914-.0163-.0245l1.2463,2.9592-.0912.02.0925-.0144-1.2508-2.97c-.73.3983-1.9657,1.0892-.0906-.1357l1.3752,3.2653-3.0113.6708a23.6892,23.6892,0,0,1,2.9037-.7279C526.0425,50.0141,520.9877,51.1563,522.25,50.7813ZM498.1233,64.9791c3.8395-2.0841,7.42-4.2383,11.0227-6.3583l5.4131-3.2136c1.812-1.09,3.5883-2.2812,5.4324-3.4543.1476.0445,2.9641-1.7792,6.27-3.9l.1656.3932-4.47.9871c-1.5663.2712,1.8131-.481,4.4528-1.0687l-.1021-.2422c-2.0325,1.3-3.5614,2.2786-1.1533.8018.23-.1352-12.7031,8.0193-8.92,5.5212-3.2483,2.0884-8.46,5.1153-13.6022,8.1608-5.1975,2.9509-10.3815,5.8271-13.5508,7.6747Zm25.23-16.1285c.1731-.0648,1.5888-.376,3.0139-.6891l.4035-.0887-.3477.2214-1.1854.7548c-.5125.2871.3532-.2977,1.1382-.8256l.0089.0212c-1.0947.27-2.0563.5037-.0783.082a9.9962,9.9962,0,0,1-1.4455.3472l-2.9291.6415C520.1516,49.6163,530.6656,47.2626,523.3531,48.8506Zm-2.5773,1.574c-6.7316,4.3421-10.6376,6.5279-14.0914,8.4489L510.547,56.59c-.061.1006,2.35-1.3028,4.8318-2.8237C517.831,52.2019,520.3919,50.5735,520.7759,50.4247Zm-8.29,6.4824c4.059-2.377,5.0041-3.0267,7.6826-4.6755,1.2816-.8015-.6671.456-2.9153,1.8816A50.2757,50.2757,0,0,1,512.4856,56.907Zm5.021-.3922-12.9,7.7c-2.1884,1.2245.0974-.1019-.06-.1039-5.724,3.38-11.4221,6.5775-18.2325,10.37-6.8591,3.6939-14.7828,8.079-25.1208,13.5148-.6068.25.8682-.5494,1.27-.8077-3.6652,1.9436-4.5235,2.4584-2.6672,1.3776L455.8,90.6111c-1.5067.8037-.73.42.0139.0263-.1218.0838-.4541.2645-.757.4222s-.58.2853-.58.2853l-2.6533,1.4039c.0946-.1372,5.1564-2.7765,5.25-2.9131l10.6133-5.5818c-.0961.2114,7.7457-4.1173,7.9856-4.1368,1.5181-.8368,4.4833-2.5875,1.2579-.8549,3.1469-1.8258,10.5267-5.67,14.4519-7.9366-.0768.137,2.2106-1.1759.0587.105l5.2089-2.97c-.5189.223,3.4909-2.0141,5.1749-3.0534-.1335.0613-.4642.2391-.7635.3983a4.9318,4.9318,0,0,1-.5744.2869L490.0446,72.01c1.076-.7539,11.0807-6.235,14.3212-8.2109a15.6289,15.6289,0,0,0,2.7719-1.4635l7.6639-4.4979a4.45,4.45,0,0,0,.8359-.309c.4377-.2032,1.2618-.6576,3.1647-1.8006A10.5362,10.5362,0,0,1,517.5066,56.5148ZM507.324,59.9589c-.1915.1542.3206-.127,1.3315-.7174-1.2885.79-5.1744,3.1286-7.7719,4.5269C500.6506,63.8638,505.4677,61.0814,507.324,59.9589ZM485.7589,70.4648c-18.6808,10.24-34.1,18.5-60.8846,32.0961,2.9561-1.6048,8.0891-4.28,13.7292-7.21,5.6432-2.9246,11.8094-6.0751,16.7637-8.7527-.0147.0243-.4156.243-.9417.5247l-1.6918.9024,13.8-7.2649c4.3148-2.2838,8.3687-4.5245,12.405-6.7077l6.0389-3.2878,6.066-3.4127,6.2668-3.5464c2.14-1.2083,4.34-2.4451,6.5723-3.7982,2.8672-1.6447-1.5743,1.0161,1.3375-.686-.866.5782-2.52,1.5743-4.4319,2.6654-1.9235,1.0732-4.0849,2.2725-5.9128,3.3419.4421-.2941,2.277-1.3371,2.5641-1.548-7.577,4.2032-9.411,5.4561-14.3415,8.0633C483.7,71.5465,484.2795,71.2621,485.7589,70.4648Zm10.2981-6.1119c.229-.0887,2.3871-1.3162,3.9154-2.1718.4422-.1581-2.675,1.5959-5.1707,3.0165,2.1457-1.2974-1.5562.6823,5.126-3.0944C500.5739,61.8127,498.0905,63.204,496.0569,64.3529ZM458.1333,88.63c3.0673-1.6339,5.0906-2.6881,6.6434-3.4811-5.8009,3.1962,3.5206-1.7447,1.4428-.4579,5.29-2.7533,10.0946-5.4363,15.3286-8.2523,5.2426-2.7991,10.7958-5.9648,17.5411-9.7654-.7209.5123-6.41,3.6941-9.0882,5.2588,2.4339-1.5258-4.4523,2.5944-6.59,3.5665-3.7061,2.0218-1.5823,1.0229-6.5236,3.685,1.0416-.6634-1.9019.9458-1.4008.5908-4.8716,2.7912-9.119,5.0011-13.3212,7.1879-4.2062,2.1793-8.3542,4.362-13.1313,6.8983-1.69.7941,9.1668-4.9705,2.5116-1.6431C454.175,90.743,461.6679,86.9529,458.1333,88.63Zm12.2982-11.9116c.5121-.4853,9.8352-5.381,13.1328-7.1427C481.4465,70.7845,474.03,74.6832,470.4315,76.7183Zm5.6848-2.0676a10.43,10.43,0,0,0-2.6718,1.3508c-3.12,1.647,4.6165-2.6146,7.8442-4.3689C482.9349,70.79,481.9038,71.5386,476.1163,74.6507Zm-32.283,18.9615c-3.0679,1.4929-8.2567,4.3488-8.0161,4.0451-4.9119,2.6227-6.06,3.1854-13.3156,6.8475.1556-.0973.816-.4382,1.4381-.76l.8362-.4367a2.8461,2.8461,0,0,0,.3708-.2123c-1.1494.5334-3.397,1.6512-6.7036,3.3339a23.7193,23.7193,0,0,0-2.6262,1.4332c.1605-.06,1.1591-.5555,2.118-1.0419l1.2991-.6671c.35-.183.5814-.32.5814-.32,2.0325-1.0013-.3545.23,1.4019-.5764l-12.5911,6.42-14.1289,7.1069c4.104-2.1321,7.8214-4.082,6.5343-3.66,21.11-10.52,28.0524-14.1257,45.395-23.0223C446.6661,92.0618,444.3809,93.2645,443.8333,93.6122Zm-66.5992,34.1923-10.256,5.0044-8.6021,4.1443c-3.1713,1.5309.4587-.3126,2.6742-1.3576-2.9021,1.29-3.8793,1.9727-8.0726,3.964-3.379,1.5219-6.9635,3.3338-9.5245,4.3761C356.0015,137.918,373.56,129.348,377.2341,127.8045ZM345.8506,142c-2.0587.9492.3547-.2181-1.4062.5353,2.2133-1.0478,5.894-2.7837,2.7042-1.2936,4.2094-2.1823,12.68-6.1566,14.8081-7.183,3.6764-1.7448-3.0421,1.5434-2.6461,1.4109C354.696,137.6818,350.1713,139.853,345.8506,142Zm-16.5287,7.0538L305.57,160.17l-18.343,8.398c4.0881-1.8918.9644-.5256-2.7841,1.1091l9.062-4.1a47.5673,47.5673,0,0,0,4.5382-2.14c20.2456-9.2771,41.9768-19.6536,54.1794-25.4456C348.2791,140.0776,332.8274,147.1774,329.3219,149.0535Zm-5.1375,3.1576c-1.6014.7717-9.2322,4.3544-10.7876,5.1989-3.0192,1.3947-1.1433.3575-.076-.1635-.3638.0843-2.3125,1.1241-5.42,2.5289-1.6367.871,4.3923-2.0238,2.7545-1.1525-1.7893.8029-5.0114,2.3085-6.8228,3.092.7791-.4611-2.5865,1.08-.0626-.136,6.4558-2.87,8.3339-3.86,14.9207-6.97C313.924,156.9547,323.5052,152.4406,324.1844,152.2111Zm-6.9106,2.8932c.6233-.1776-4.0175,1.9741-5.3612,2.6667C310.1852,158.5646,313.5669,156.8232,317.2738,155.1044Zm-6.3663,4.0627c-.1187.1177-4.479,2.1127-4.0361,1.9824l4.1716-1.92a19.371,19.371,0,0,1,2.67-1.139c-6.32,2.91-8.9008,3.9782-14.996,6.82-4.8495,2.14,1.9053-1.0179,2.6509-1.4091,1.4771-.667.9452-.3665,2.74-1.1867,1.94-.9125.3177-.3-.0629-.1365.4-.2239,3.4022-1.58,5.4282-2.5408C308.1775,160.3176,310.296,159.382,310.9075,159.1671ZM275.712,179.5119c-1.6519.98,15.6123-6.8561,17.8746-7.7705-9.926,4.4261-18.728,8.4251-30.2131,13.3048.0164-.0319.5865-.2947,1.4642-.6837l3.3092-1.4418,6.2421-2.6554c.0573-.177-4.0605,1.73-6.9294,2.8907C270.3608,181.8583,271.4755,181.44,275.712,179.5119Zm-16.9753,6.1808c1.9476-1.01,3.24-1.1711-9.7092,4.0677.11-.0906.2064-.1762-1.4147.4816l-.3748.1637-1.1636-4.4869c2.29-.3928,4.82-.7762,8.0435-1.25,3.2218-.4821,7.1448-.9894,12.1809-1.9189-.4723.1388-1.4252.3473-2.7247.6047-1.298.27-2.9463.56-4.8132.8321-3.73.5732-8.3125,1.2377-12.67,1.8546l1.1019,4.249Zm-6.897-1.0039-4.1871,1.6151c4.5469-1.9581,4.0544-1.518,11.1151-4.4354l-12.8036,5.3026-8.467,3.5065,9.0359-1.3127,5.5424-.8052a7.0589,7.0589,0,0,1-1.4607.398c-2.06.3035-3.1471.4432-4.062.5541l-10.5614,1.28,9.9186-3.7585C247.2825,186.5129,248.2549,186.166,251.84,184.6888ZM345.09,165.51l.0367.1458,15.0918-3.91c3.3912-.8672,6.5859-1.6487,13.8672-3.5879-1.2885.455-3.2289.881-5.7633,1.6284,3.4866-.8642,4.26-1.1273,10.1182-2.6871-1.1094.3288-1.5328.4868-1.4012.5049-2.8992.7982-4.519,1.2218-4.3514,1.12-21.1156,5.9054-44.9108,11.7136-68.2421,16.733l-8.4121,1.874c-3.1494.7033-6.5411,1.31-9.7479,1.947l-8.7218,1.6655-5.3618.8712c-.2338-.0675,3.5936-.6627,7.33-1.4158-1.2644.2166-.8773.1046-2.9469.4712,2.3021-.4435,2.1656-.5135,5.84-1.2227-.26.1891-3.66.7872-1.4148.4919,20.8453-4.0776,38.94-8.24,58.3055-13.0455C342.6167,166.2546,339.7289,166.8154,345.09,165.51Zm1.5409-.01c2.8469-.7017,2.8539-.7768,4.334-1.1757,2.0817-.5074,3.542-.889,4.3271-1.1583C351.55,164.0576,348.36,165.02,346.6307,165.5Zm-50.976,11.7624c3.1168-.6548,7.9855-1.6176,8.7717-1.8933C301.8661,175.93,297.1115,176.8617,295.6548,177.2624Zm-.214-1.0278c2.0818-.4289,4.55-.7944,7.3092-1.4858,2.2139-.4509-.3821.1285,1.4982-.2l-5.8434,1.2612c2.8146-.7886-1.33.2987-7.3125,1.4635.8876-.2017,1.752-.3989-.012-.059-.2988.0213,1.37-.3,2.8243-.5888C295.3547,176.3123,296.5916,176.0406,295.4408,176.2346Zm-1.5343-.0984c5.915-1.2625,14.7848-3.1194,20.418-4.4009-2.47.649-4.6373,1.1913-7.2393,1.8016.0854.0208,1.3055-.2273,2.989-.5851,1.6846-.3517,3.82-.8784,5.7542-1.32,1.3918-.2609,1.8368-.2809,5.8506-1.2081-.9374.26-3.088.7766-5.8037,1.4127.6477-.082,7.1708-1.6566,10.1813-2.3387-1.3328.3834-4.7124,1.1993-8.4292,2.0685-3.7151.8785-7.77,1.7932-10.4646,2.3229.387-.165,3.8845-.8841,5.8188-1.3174,2.1848-.5353-.4124.05,1.4293-.4562l-14.5894,3.1738c2.1257-.5759-6.5192,1.4013-4.4052.8281,4.5339-.9815,4.1871-.8072,10.2224-2.145,1.4192-.4492-6.0044,1.1969-8.7809,1.7418C298.9795,175.1188,292.5775,176.5438,293.9065,176.1362Zm45.1636-10.032c-3.7914.9795-3.5956,1.01,2.9247-.6313-.9979.4166-11.1963,2.7479-15.9453,3.9949-1.6293.3735-.8119.1581-.0068-.029a2.0219,2.0219,0,0,0-.3085.0553l-.734.1632-1.8641.4269c-.26-.0133,9.522-2.1954,7.2542-1.8a7.6038,7.6038,0,0,1,1.4547-.2983c1.162-.2912,4.3673-1.1832,1.43-.4468C333.481,167.4108,338.182,166.3152,339.07,166.1042Zm2.0289,1.9083c9.6276-2.36,5.7883-1.5,11.5636-3.0762-.1738.0227-1.2545.3015-2.2963.5692l-1.4149.36a5.4082,5.4082,0,0,1-.647.1436c-1.7848.54-9.3948,2.3863-5.771,1.6173-8.2925,2.0748-6.672,1.5278-14.5486,3.4548-.9531.2015,6.4089-1.573,4.32-1.2008,3.8124-.9114,6.0739-1.4055,8.7584-2.0134,2.0764-.5317,3.5337-.9231,4.3279-1.1642.4692-.23-5.3168,1.2228-8.74,2.04-.0022-.061,3.95-1.0175,2.8671-.8336l9.6208-2.3069c2.6714-.6545,4.5708-1.0914,4.9644-1.1035,4.5491-1.2059,5.9164-1.5374,7.228-1.9136.7886-.1591,1.4462-.34,2.9292-.6389l-4.3556,1.1036,5.6873-1.3857a23.7352,23.7352,0,0,1,3.0557-.6611l-7.225,1.93c.4968-.17,2.5334-.7087,2.876-.8425-7.8414,1.9781-1.7264.6188-5.7537,1.6848,3.7357-.8847,5.8931-1.4451,11.6027-2.9628-1.9746.729-7.3987,1.9952-14.4645,3.8629-.4773.0528.2065-.1729,1.4121-.5225l-17.433,4.3383C339.4712,168.4839,341.4312,167.9886,341.099,168.0125Zm11.6158-2.873c4.2373-1.1,5.9131-1.7213,1.4105-.5534C355.191,164.4033,351.6541,165.321,352.7148,165.14Zm-24.7579,5.8249c1.9961-.5493,5.3645-1.4885,10.1183-2.6979C336.16,168.8336,332.8033,169.77,327.9569,170.9644ZM372.93,159.6223c-1.7329.4475-1.8148.2866,5.7238-1.7418C373.0482,159.453,376.7675,158.53,372.93,159.6223Zm10.1088-2.7469c-1.4453.3489-1.68.2988-.1869-.2073,1.4956-.4973,4.7142-1.4678,10.1649-3.0046.7572-.32-9.31,2.4743-8.6442,2.4144-2.1011.533-2.2168.4836-4.3643,1.03-4.2761,1.1672-8.9324,2.5107-11.5542,3.1705.2527-.2326,8.9569-2.42,8.64-2.4721,7.0129-1.774,15.6106-4.3078,21.6456-5.88a.7873.7873,0,0,1-.165.0643l-.4265.1367-1.2256.3669c-.8451.2448-1.563.4351-1.0542.2406-4.3087,1.2341,1.3882-.3242.0326.1157C385.8446,155.689,389.8079,154.9449,383.0385,156.8754Zm65.93-19.8622c-3.5.9434-19.11,5.8215-25.8674,7.5334-2.092.6344-5.5538,1.6367-4.2814,1.3676-5.2478,1.5156-5.5209,1.5588-10.0592,2.9191-3.7424.95.4712-.3452-5.8235,1.382,4.4771-1.262,5.1537-1.4654,12.933-3.7579l-11.5354,3.24c-1.8063.4174,4.6537-1.348,2.8469-.9369,1.3387-.3657,2.1908-.5787,2.9011-.748,1.6836-.4936,1.2015-.4057,1.4025-.5009-9.3772,2.5037-30.8916,8.7887-38.9458,10.6627,8.1046-2.2468,11.0775-2.9573,17.3-4.8,3.2841-.8184,14.7828-4.0858,18.7476-5.146,3.8448-1.2148,7.05-2.137,14.3544-4.228-3.9528,1.1021-1.6808.4091-.0422-.144,6.28-1.7791,20.3064-5.9626,21.4978-6.4377,8.6467-2.454,16.2111-4.9365,24.3245-7.4535-3.5469,1.0634-25.4354,7.7736-10.0275,3.0256,1.5477-.4781.95-.3511,2.8494-.9291.2137-.1329-5.084,1.5317-7.1742,2.15,1.92-.6757,3.6533-1.2126-1.4763.2923a10.0337,10.0337,0,0,1-1.4135.4609,2.04,2.04,0,0,0,.3051-.076l.7229-.212,1.8356-.5513c-.49.19-2.5145.8137-2.8289.9542-6.0341,1.7557-11.9228,3.4794-18.6567,5.5231.35-.187,2.9235-.9731-2.897.7686,2.4268-.9379,15.3566-4.5732,17.1394-5.3257,4.0987-1.1264,10.985-3.3011,14.321-4.3858-1.427.4758-2.3392.8058-4.2645,1.4221.7684-.1089,9.3895-2.8143,2.8958-.7548.4193-.0616,3.8145-1.2053,5.734-1.7123.6245-.1244-.955.3734-1.3977.55,1.6713-.5134,2.5541-.7691,2.8755-.8437,5.6213-1.815,9.1887-2.8123,18.58-5.7507,1.0466-.4313-5.817,1.76-4.3263,1.1823,2.7379-.8342,6.147-1.8915,5.7513-1.6859,1.2534-.4,2.5381-.8228,2.8307-.9484-.5873.1248-8.921,2.7743-4.3181,1.2516-6.5235,1.9908-8.0828,2.5541-12.8441,4.0383.1639-.1926-3.4927,1.0912-7.16,2.1777l2.8294-.9943c4.105-1.2333,7.6038-2.2877,11.4443-3.511-1.91.417,8.3054-2.6174,11.3792-3.7259a7.515,7.515,0,0,1,1.447-.3918c4.7645-1.496,4.84-1.6222,9.967-3.2249-1.9852.5512-5.9093,1.7551-8.61,2.547-.9636.387,2.9694-.8718,4.3033-1.2573-1.038.3953-8.0024,2.529-11.403,3.6093.4775-.1861,2.4974-.8309,2.8215-.9769l-5.7008,1.8052c-1.8591.5013.1693-.1106-1.4871.3033,3.7736-1.0668,9.5868-2.8824,14.2983-4.4675,3.9243-1.1617,8.6418-2.6429,14.2754-4.4614.6229-.1321-.952.386-1.3807.5648l-10.0126,3.1171c-.5472.2471,6.5025-2.06,4.3154-1.261,3.327-1.0527,6.1478-1.9654,7.1052-2.3348l7.1641-2.151c1.67-.5357,1.19-.4355,1.4124-.5431,3.4377-1.1053,3.1038-.929,7.137-2.2366l.0364.1144-5.7121,1.8152c9.1656-2.7726,8.2941-2.6971,17.1275-5.4359.9614-.3929-2.9649.89-4.3088,1.2871,2.5439-.9448,8.5129-2.5778,7.1045-2.3412,2.9526-.9282,5.42-1.69,4.3378-1.2336,1.9414-.7311,8.0627-2.6257,7.15-2.2015l-9.9847,3.1737c-2.5544.81-.0571.1406,2.881-.8293-3.147,1.1149-12.368,4.04-17.0941,5.5406-.9618.3919,2.9668-.8832,4.31-1.2833,6.465-2.1221,10.7659-3.532,17.09-5.5123.811-.1841-11.0981,3.673-9.9765,3.1994-1.4446.4836-1.4532.5385-4.2632,1.43,2.6533-.804,6.7926-2.118,11.4229-3.6a9.9782,9.9782,0,0,1-1.4068.4829l.0184.0573-7.1614,2.2017c-2.8307.9084-1.7974.6625-5.6781,1.884,3.0032-.8485,7.1258-2.2762,11.4251-3.5692-1.9891.6775-.0264.1747-5.6646,1.9424.228-.004,3.6039-1.088,7.1523-2.2305-3.6241.9842,2.5509-.8458,1.3519-.6541,5.0559-1.63,5.41-1.6,1.4636-.3433.9673-.2155,3.0423-1.0046,5.6949-1.8325a23.9112,23.9112,0,0,0,2.88-.8351c-2.5471.9149-4.3847,1.3318-9.983,3.1825-.1863.1381,2.2784-.6334,2.8995-.7726,2.4372-.78,3.6816-1.21,4.25-1.432,4.2562-1.3315-5.3255,1.8289.0552.1714,5.7615-1.904,2.7787-1.1486,4.1979-1.6708-.9175.2321-7.2146,2.32-5.742,1.7278,3.8433-1.2861,5.075-1.5728,11.3987-3.68-.26.1093-1.4168.4888-1.4076.5173,4.6761-1.5363,15.1254-4.8286,15.6381-5.1823,5.1216-1.5884.3734-.0338-1.3914.6085,2.2589-.7,6.0789-1.9539,11.4059-3.6977.736-.1009-4.3734,1.485-1.37.6334l5.6825-1.8737c-2.0361.7517-2.2146.9133.0648.2-2.6138.9083-2.5887.8643-1.3767.5724-1.2024.3213-5.399,1.68-5.75,1.7066-.5665.3079-8.4537,2.8467-12.8026,4.2133.166-.1235,6.0475-1.974,8.5457-2.8019-1.7514.2875-14.7087,4.7706-22.8033,7.3422,4.4933-1.3932,6.9785-2.26,12.8251-4.14-2.7661.9514-1.4505.6655,4.3126-1.239-4.8989,1.6448-15.64,5.02-18.5666,5.8719-.8959.4588-12.2466,3.9453-18.5062,6.01a13.5167,13.5167,0,0,0-1.4007.5434c-.6251.2039-8.9948,2.7537-7.1145,2.313l-9.9851,3.1731c-.1639-.034,2.35-.81-.0363-.1144-4.6328,1.4332-1.0621.4395-5.6949,1.8726,4.1941-1.426-3.4521,1.0463-7.1489,2.2021,6.0906-2.0714-7.647,2.0392-17.25,5.0405l12.9258-3.8085c.2635-.0145-5.0634,1.6047-7.1328,2.272,8.1993-2.5734,10.0612-2.9888,17.1869-5.2241-3.2562,1.1194-6.3408,2.0518-11.4125,3.63.2287-.1086,2.5964-.842,4.2683-1.3723-.9014.2192-7.2088,2.2555-5.7427,1.6781-2.24.7168-1.1917.4731-5.6888,1.8495,5.4558-1.8212-8.3492,2.6041-2.8944.7835l-7.14,2.226c-.1161.08-.2083.1534,1.4459-.3535-2.5993.87-8.6274,2.61-10.0423,2.9823-1.0912.4318,2.5958-.6747-5.6812,1.9155,5.8367-1.7419,15.6028-4.8782,17.22-5.1725l-4.3053,1.3326c-1.2286.481,4.737-1.4232,4.3409-1.2182,7.4832-2.3564.2376-.3022,2.7686-1.149,7.158-2.2131.8444-.0331,7.2288-1.9873.6809-.1469-2.0288.6972-4.2716,1.4042,1.6409-.425,3.9879-1.0873,7.1995-2.041,1.6553-.567,4.1105-1.3677,4.2446-1.49,17.8384-5.4131,27.7631-8.9429,44.2463-14.0025,5.2995-1.7874,9.447-3.0627,18.5178-6.0035,1.4727-.4341,1.43-.3456,2.8925-.7764l9.9757-3.23c-.7088.1929-2.4935.7584-4.1049,1.2638l-2.1309.6589a5.417,5.417,0,0,1-.9339.2442l11.4049-3.6659c-3.5107,1.2616-1.515.5833,4.2953-1.33-2.7041,1.0623-10.2226,3.3968-19.9113,6.5446.6669-.3143-4.9358,1.51-1.4783.3193-2.9147.95-13.2433,4.4148-9.9793,3.2216-3.2173,1.0616-4.2283,1.46-5.6478,1.9811-27.42,8.9067-58.2095,18.5077-82.7794,26.2238-2.4729.8292,1.0875-.2751-1.3961.5577-7.4073,2.2343-13.3622,4.0908-9.9807,3.192,1.8121-.7213,12.587-3.8323,14.2834-4.4925q5.4488-1.68,5.75-1.654c-2.4316.6754-7.89,2.57-10.0177,3.0693-2.3113.7346-3.2755,1.08-1.3994.5512l32.9082-10.1323c-9.1321,2.9285,11.1008-3.3271.0449.1431.4637-.11,6.8115-2.019,5.72-1.7964,8.6431-2.5712-7.6319,2.5422-7.1467,2.2128-4.5794,1.4428-10.9482,3.4088-9.9722,3.2233-3.84,1.21-2.7885.7982-4.3333,1.2465-2.5127.7855-3.2444,1.0585-2.8166.9976-6.6268,1.87-9.9753,3.2108-18.5876,5.7538-.394.1706,1.3663-.3617,1.448-.3462,3.6834-1.0791,6.8013-2.1766,8.5967-2.6379-3.7455,1.2087-11.3248,3.6321-17.1444,5.3937.0215.0087.4631-.1194,1.0381-.2911l1.8381-.552c-.0131.0191-.4516.1584-1.025.3359l-1.8338.5645c2.4619-.7,5.2138-1.5963,10.0343-3.02-2.8389,1.0087,10.2332-2.998,11.5271-3.27,1.3322-.4354,2.1488-.7219,2.8369-.972,3.0955-.9633.6835-.1,1.476-.3l-5.2809,1.6645c-1.7721.5652-3.2139,1.0182-3.2986.991-1.3323.4353-2.1487.7224-2.8369.9725-.2252.1379,5.0789-1.5577,7.1568-2.1837-2.7441.9429-2.681.9445,1.485-.271-1.6541.6113-5.6419,1.8449-10.26,3.2582-4.6244,1.3919-9.8788,2.9632-14.0563,4.2842-1.4959.572,3.5926-1.003,2.92-.7l-8.6057,2.6166c-1.509.486-1.2915.6152-7.1024,2.3693,3.1354-.9986-1.29.2825,1.3937-.5714-18.4609,5.6116-10.4937,2.8985-15.8926,4.3212,1.1531-.3122,3.93-1.15,4.3152-1.22,2.251-.6834,1.2064-.4575,5.73-1.7684-10.9842,3.1667,3.9288-1.2405-5.7812,1.5957.9347-.32,3.0448-.9646,5.73-1.7681-3.0241.7753-6.7027,1.9993-12.9415,3.7661,7.2692-2.2341-2.5725.58-4.3767,1.0512-.6853.1323,2.0319-.6492,4.3008-1.31-1.3313.1768-12.601,3.578-20.1923,5.6143,2.4408-.7715,5.2174-1.5206,10.0623-2.9249-2.787.715-16.1016,4.5793-17.33,4.7533,6.3542-1.7489,5.8978-1.6627,10.0676-2.8972l7.2129-2.0288c-.2251.1019-2.6145.7849-4.31,1.2819.2325-.0309,2.6285-.7364,4.3263-1.2244,2.5549-.9024,10.5209-3.3458,17.1617-5.2913-.8053.1758-4.3365,1.2295-1.47.3126,3.2415-.8942,5.7616-1.6982,10.0615-2.9637-.8246.2162-4.0052,1.1447-1.4591.3715-.231.0112-4.8679,1.43-5.7549,1.65.4235-.2,4.9686-1.537,4.265-1.4261-.8575.3218-5.89,1.7889-10.3437,3.0822-4.46,1.2706-8.3381,2.3852-6.8665,2.0788-4.772,1.3247-12.9784,3.5715-18.712,5.3164,4.3652-1.26,4.4781-1.1951,12.968-3.6495-3.4381,1.0461-3.78,1.311-10.0188,3.068,1.1929-.4375-2.5.4481-5.8086,1.48-4.9094,1.348,7.1741-2.2-2.9254.668.1156-.1308,3.26-1.0388,6.9606-2.0792,3.7037-1.028,7.9508-2.235,10.2833-2.9176l17.24-5.0533c-3.6667,1.131-2.8549.9557,2.8983-.769,4.0277-1.199-3.4448.94,2.8427-.9086,1.2338-.4677-3.73,1.0451-4.3306,1.1641-.9742.3126,12.26-3.6454,15.7493-4.8131C442.7169,138.9363,443.3286,138.7319,448.9686,137.0132Zm-9.4017,5.129c-3.6666,1.0945-5.0072,1.5473-7.1576,2.2242,3.681-1.0028,6.9749-2.1558,10.0458-2.99C442.87,141.191,440.499,141.8962,439.5669,142.1422Zm-.103-.3452c6.7181-1.9958-1.552.5074.0342.1149,6.5969-1.8712,9.4532-2.9286,12.9276-3.8175,2.778-.9194,9.4734-2.9438,15.7358-4.8481,1.0135-.3937-2.8626.8085-2.9041.7582-4.3885,1.4431-11.9507,3.5505-12.8666,3.9747-.7558.1522-9.1591,2.7625-7.2177,2.0246C440.5645,141.3481,440.6906,141.3864,439.4639,141.7969Zm12.788-4.2772c-.42.2105,3.0071-.8332,5.7506-1.6542C457.874,135.82,454.6848,136.7234,452.252,137.52Zm-1.6712-.3069c-7.74,2.3521-3.6817,1.2076-5.6751,1.9l4.3055-1.2957C447.39,138.2758,448.0817,138.0388,450.5807,137.2129Zm109.606-35.741,18.49-6.1034c-6.8806,2.2484-1.7231.4549-7.1639,2.1631-1.2393.4459-1.1005.4774-5.6777,1.9274-1.7322.6612,4.6224-1.4682,2.89-.8069-4.6039,1.5253-1.12.2594-5.7238,1.7848C564.6541,100.0026,560.7861,101.2288,560.1868,101.4719Zm-45.636,14.5757c3.7646-1.1866,4.6838-1.5319,4.2368-1.472a54.9267,54.9267,0,0,0-5.6737,1.8974A10.3013,10.3013,0,0,1,514.5508,116.0476Zm17.12-5.4441c-.4049.1963-2.8374.99-4.2415,1.4778,3.4094-1.0976-.747.3844,4.3054-1.2776C531.9268,110.627,533.3036,110.1317,531.67,110.6035Zm7.0837-2.429c-13.6575,4.4131-15.634,5.2292-25.595,8.4415,3.5822-1.0769,11.3655-3.6151,12.8419-4.081-1.6625.5231-1.5588.4457-1.4553.368C530.598,110.9533,536.759,108.9351,538.7542,108.1745ZM452.875,134.4458c-3.0568.9607-15.2814,4.5717-11.4523,3.4814,6.2536-1.9074,3.0823-.7846,8.62-2.4949C448.3847,135.8376,452.2826,134.675,452.875,134.4458Zm67.2706-20.5849-9.9763,3.2016c2.1857-.7662-4.8821,1.449-4.3076,1.3255,7.8522-2.32,16.94-5.3375,25.6809-8.1845-2.5521.76-3.62,1.1783-8.5506,2.7209.3129-.1441,2.33-.7934,2.8177-.99C518.4028,114.25,521.79,113.3224,520.1456,113.8609ZM504.48,118.9473c-1.915.4887.06-.134-1.4924.2484,10.6119-3.326,8.159-2.7613,19.9586-6.414a6.3855,6.3855,0,0,0-.8685.2266l-2.1345.6429-5.86,1.8156c-3.8779,1.2062-6.7175,2.0842-2.6333.7164-3.8594,1.25-11.3406,3.5269-12.8411,4.0735,8.1938-2.6113-.3077.3229-4.2407,1.4579-2.6069.8867,1.092-.1023,4.3217-1.2-2.3215.7383-3.8535,1.1676-1.4352.3879,4.5589-1.3773,1.58-.3557-1.3812.6226C504.9511,118.5771,494.0818,122.2628,504.48,118.9473ZM454.4557,134.498c-3.2209,1.0685-12.2187,3.7284-14.2963,4.4315C446.2383,137.2,451.0408,135.6171,454.4557,134.498Zm31.6822-8.9824c-1.4908.5789,3.5861-1.02,2.9164-.7172,1.6888-.5352,4.0579-1.2689,4.2795-1.3754C487.2043,125.3738,490.793,124.0764,486.1379,125.5156Zm-5.7139,1.7686c-4.1459,1.3754-8.3956,2.6605-12.8434,4.0693.91-.228,4.3319-1.2893,5.7454-1.6841-3.5447,1.0906-5.9288,1.8561-7.1357,2.264l7.1623-2.1779c-3.1772.8389,11.3828-3.5834,7.116-2.3281-2.1431.6578-5.2689,1.642-5.723,1.74,2.14-.6678,5.2751-1.6216,5.7052-1.7972C478.2258,128.05,479.4421,127.6133,480.424,127.2842Zm-40.1185,12.1339-5.7521,1.6808c-.99.3447,1.1629-.2766,3.5652-.99l3.4281-1.0307,1.1755-.3627c.2867-.09.4545-.1517.4545-.1517-.9156.2552-4.3655,1.1722-5.7462,1.679l1.84-.5406C439.844,139.5343,440.2834,139.41,440.3055,139.4181Zm8.5591-2.75c2.7216-.6771-5.6781,1.7592-4.261,1.4389,2.76-.76,2.5969-.7968,7.1707-2.1668a41.6738,41.6738,0,0,0,4.2889-1.3041c-2.6647.806-4.7838,1.434-5.7514,1.6858.13-.1191,5.3171-1.6907,7.1584-2.2076C458.7966,133.5981,451.8185,135.7893,448.8646,136.6686Zm-1.4883.296c-.078.0783.3526-.01,1.48-.3248,3.8508-1.1492,2.7433-.899,4.2626-1.39C451.18,135.8292,450.3784,136.0383,447.3763,136.9645Zm-4.2255,1.5126c-.757.0806-7.5873,2.1724-10.0722,2.8729a30.8583,30.8583,0,0,0,4.2748-1.3663c2.0786-.6357,7.4276-2.1743,7.164-2.1634a54.5464,54.5464,0,0,1-5.757,1.6191l-12.8745,3.9554,4.312-1.2187c-5.7584,1.7652-11.1083,3.1385-12.9171,3.81,2.9739-.8483,9.44-2.77,10.063-2.8975-2.9606.8947-9.4468,2.7076-10.0463,2.9549C430.9569,142.1472,428.4352,142.8063,443.1508,138.4771Zm-11.4225,3.5878c2.8089-.8939-.0637-.1063-3.82.9768-3.7572,1.08-8.411,2.4105-9.1387,2.7Zm30.1652-8.8562-1.8384.5657c-.5717.1769-1.0071.3153-1.0208.3347a69.4243,69.4243,0,0,0,7.112-2.319,23.7247,23.7247,0,0,1-2.8929.7856C455.0322,135.1006,462.7365,132.8862,461.8934,133.2087Zm85.6129-27.1479,7.1364-2.31,2.0576-.7052a3.36,3.36,0,0,0,.7437-.31c8.4941-2.7444,17.4756-5.5227,21.39-6.8819-1.2962.505-4.4523,1.5784-8.51,2.913-1.7173.5129-.5716.1345-.0278-.0859l-14.2214,4.6539c.0217.0085.4584-.1263,1.0291-.3074l1.8325-.5845c-.2746.1816-10.6177,3.3232-9.9673,3.2746C544.82,107.0208,547.3546,106.1882,547.5063,106.0609ZM481.535,125.81c-2.338.764-7.7366,2.4758-9.9964,3.1253C473.2781,128.2952,478.8242,126.6473,481.535,125.81ZM377.33,158.6754l-7.2451,1.9064C377.75,158.41,397.7063,153.2032,377.33,158.6754Zm-4.0651,2.1925c1.9063-.6577,12.041-3.3267,15.89-4.3407,2.8926-.81,6.6492-2.0839,7.1925-2.088l-2.8866.8129c1.2179-.3066,1.9341-.4609,1.4833-.2617l-18.7737,5.1811C376.6489,159.9794,375.8633,160.1578,373.2654,160.8679Zm17.2018-5.24c5.4619-1.4609,7.717-2.263,8.64-2.4017-4.8708,1.36-2.2159.762-8.6077,2.5171Zm21.092-2.4839c-7.6095,2.0967-1.1886.3674-10.09,2.8765,1.5974-.4948,1.53-.507-1.4808.3235,10.891-3.1,10.1931-2.9595,23.0464-6.6862.4175-.05-.32.21-2.8481.9512-3.8729,1.1454-2.7887.7446-4.3488,1.1684C413.748,152.4113,410.2682,153.4185,411.5592,153.144Zm-6.2533-.0428c3.5551-1.1359,16.6259-4.76,23.0126-6.7035.0679-.114-2.8063.7316-6.0613,1.6927-3.2539.964-6.8861,2.0523-8.3312,2.43a26.87,26.87,0,0,1,2.6788-.86l6.4689-1.8994,12.3848-3.6132c1.4673-.457,1.4758-.5115,4.3055-1.3444-1.1287.308-1.5615.394-1.4771.3145l10.0237-3.0512c-.489.1944-2.51.8-2.8356.943-.2158.1706,9.3706-2.8732,7.2024-2.0825,10.0282-3.0579,8.4169-2.74,14.26-4.5553a13.49,13.49,0,0,0,1.4969-.2363l-15.74,4.8492c5.3762-1.5544,9.7321-2.9,15.7572-4.7916.4215-.0775-1.3378.4612-1.4091.5229,4.0557-1.2463,9.826-3.01,10-3.1506a9.9742,9.9742,0,0,0-1.43.4114c-2.2167.6689-.1023-.0012,1.4124-.4689,4.7456-1.4062-3.5024,1.2184.0444.1434-4.7512,1.638-14.9741,4.5989-17.1261,5.4429,2.2184-.6362,6.1882-1.7929,9.5826-2.8337l4.3729-1.3835a9.1054,9.1054,0,0,0,1.7845-.6711c6.9332-2.1744,12.7005-3.95,17.1788-5.27.1373-.1338,7.8337-2.4767,7.1045-2.3573,2.838-.8907,1.8383-.4914,5.74-1.74L488.59,128.3054c1.9127-.5-.8732.4327.0893.2864-7.0989,2.2158-7.1193,2.0656-5.7925,1.5731-8.1529,2.5162-.7457.3939-4.2346,1.53,6.5956-2.0679,8.2582-2.4694,14.3263-4.3873-6.7719,2.0342,4.1784-1.3815,5.7226-1.7972-2.9577.998-7.7626,2.5427-9.95,3.31,5.3028-1.5889-2.4619,1.0328,8.6307-2.4869-13.5136,4.189,9.0638-3.017,8.5869-2.6654l-5.723,1.7974c.6239-.13-.9528.3827-1.3826.56.0419.0749,3.8627-1.288,2.8671-.8374,3.73-1.1856,3.9624-1.3415,9.9953-3.2061-2.5112.8741-3.8386,1.2842,2.8832-.79-.8628.3022-1.7149.6012.0181.0571-.3217.1547-2.4293.8505-5.6888,1.8638,2.5912-.7832,3.952-1.1705,7.1631-2.1749-.0046.064-3.8921,1.2769-2.8217,1.0223.2294-.0035,3.6269-1.085,7.1521-2.21l-4.2943,1.3016c.7918-.3279,9.2418-2.9219,8.5475-2.81a29.3752,29.3752,0,0,0,4.3215-1.2161c4.1517-1.3464,1.59-.5524,1.3925-.5683l9.9942-3.169c-.97.3732-3.7841,1.2977-7.1058,2.3732,3.2932-.9683,7.55-2.4639,11.4254-3.6321-1.2814.4764-4.186,1.4382-8.5395,2.8329-7.794,2.3605-29.1341,9.3422-28.65,8.79-8,2.584-17.6157,5.4351-22.8757,7.1614,1.2-.4081,1.8631-.6608,1.4-.59l14.3247-4.3566c-1.4622.3062-17.7612,5.4185-14.3782,4.1848,5.3046-1.5815,8.35-2.461,17.1853-5.255l-17.2031,5.1977-5.7221,1.8022c-1.0436.42,3.9543-1.1633,2.9094-.7432-3.2035.946-6.9294,2.0657-12.8992,3.93-.1655.1074,1.7659-.4806,1.4557-.3252-3.797,1.1776-3.66,1.04-5.7588,1.642-.6527.24-.653.2814-7.1458,2.2352,3.9183-1.282,9.3054-3.0132,14.3049-4.4678,3.7713-1.1761,2.9762-1.1061,7.125-2.2993-3.7278,1.0468-7.3632,2.1061-15.8067,4.6808.6249-.2492-2.0011.42,2.8254-1.0157-9.8108,2.8528-23.7136,7.3416-28.7191,8.5471,4.0362-1.207,6.1039-1.871,5.7012-1.8532,2.9534-.8052,5.6735-1.71,8.6063-2.6252a2.8841,2.8841,0,0,0-.4667.1166l-1.183.35-3.4324,1.048c-2.4059.7215-4.5563,1.3614-3.5587.9954-2.6744.8006-4.7855,1.4453-5.7266,1.7672.2386-.0343,2.62-.7532,4.3154-1.2527-6.52,1.9868-9.7462,3.0079-17.2173,5.1743,4.8731-1.5123,2.0587-.7533,5.6785-1.9277,1.858-.51,6.2487-1.8287,10.0586-2.9627a3.7621,3.7621,0,0,0-.7477.1619l-1.9814.5391-6.31,1.8127c-4.794,1.4174-10.19,2.9789-12.5461,3.73C416.8867,149.7889,410.1483,151.7661,405.3059,153.1012ZM481.65,131.2385c5.378-1.7182,6.5532-1.8794,8.6019-2.6025-2.3077.6893-3.302.94-1.4565.3284C485.23,130.0629,481.84,131.1107,481.65,131.2385Zm-1.53.1283c-.0051.0638-3.9017,1.2474-2.8293,1.001l4.2971-1.33c.1428.0052-.1613.1586,2.8807-.7973-3.1325.85,1.2995-.5006,4.2644-1.4769C485.7065,129.6641,483.1484,130.5111,480.12,131.3668ZM442.7046,142.21c2.5419-.69,12.1432-3.52,12.9178-3.8647C449.3058,140.3271,445.548,141.2909,442.7046,142.21Zm5.7014-1.827c-2.38.722-9.1646,2.629-8.59,2.593C442.3346,142.2056,448.264,140.5039,448.4059,140.3826Zm-38,8.7541c2.5693-.8953,5.23-1.4734,11.5006-3.3374C418.3208,146.9672,417.2308,147.1237,410.4064,149.1367Zm10.015,2.279c1.63-.4671.8173-.2057.0083.0286.25-.0358,2.6317-.7372,4.3325-1.2256.6272-.1171-.9619.3614-1.4078.5332C420.2885,151.6165,417.7057,152.2625,420.4214,151.4157Zm93.3627-32.8264-32.8981,10.185c.8658-.2962,1.7184-.5882-.0178-.0575,5.6326-1.8725,10.1531-3.1779,15.6877-5.0166-2.14.8144,5.5-1.66,7.18-2.1293-.0135.02-.4507.1629-1.0225.3456l-1.8294.5812c.64-.1619,1.8436-.5143,4.3087-1.29,1.6724-.5305,1.1919-.4318,1.3908-.5311,2.8858-.8358,6.2294-1.8844,7.1371-2.2874,2.6524-.7877,10.1292-3.1111,5.766-1.6121A56.0762,56.0762,0,0,0,513.7841,118.5894Zm-.3351-1.0583a10.0757,10.0757,0,0,0,1.4373-.4249l.0181.057c-5.6534,1.9042-15.9041,4.908-19.9707,6.3547C493.56,123.7361,507.53,119.5453,513.4489,117.5311Zm74.5061,41.3815c2.4946-.4518,15.1844-3.7217,24.7125-5.9709a3.3184,3.3184,0,0,1-.648.2073l-1.5766.4167-3.5565.9243c8.6955-2.0479,17.6217-4.5545,26.6782-6.9449-.6873.1627-1.3777.319-2.0593.5027,1.8484-.6293,8.7758-2.4414,14.41-4.0085,1.387-.1913-16.0533,4.3716-10.0714,2.8791l-.32.103c19.12-5.19,38.5332-10.8416,56.43-16.2229-5.2295,1.6575-14.8743,4.5812-23.7886,7.1642-8.93,2.5285-17.0972,4.8281-19.2959,5.5167-.1616.0978-6.0925,1.7836-8.637,2.4515-1.3475.3831-2.174.6379-2.8708.861,5.0913-1.0967,44.3881-12.1544,34.5574-9.8281-5.3314,1.5438-3.725,1.1971-10.0482,2.972.0274.0073.47-.1125,1.0458-.2733l1.8448-.5182c-5.5444,1.6576-9.7761,2.8151-17.2646,4.944-.1412-.0095.6483-.3038-1.4855.2976,4.7558-1.4471,15.977-4.3929,17.2592-5.0041,6.3722-1.6891,10.5132-3.0729,20.1282-5.8743l.0427.1436c-1.7057.4624-5.988,1.75-5.7788,1.5992-3.903,1.1932,2.0351-.5093.0509.1725.6039-.1092,8.4022-2.5232,5.7793-1.599l5.7248-1.7393c-1.7765.6531,3.4059-.923,7.2074-2.0563-2.0037.7849-16.7565,4.9584-14.3887,4.1989-10.6343,3.26-19.578,5.81-27.12,8.0184-7.541,2.2138-13.69,4.0527-18.852,5.4836-2.1469.5607.5662-.1912-.0236-.0869l-12.5518,3.3733c-4.0166,1.065-8.42,2.2637-14.959,3.842,1.5842-.4324,4.0241-1.0527,6.9229-1.7853l9.6413-2.5968c6.8215-1.8336,13.9178-3.712,18.1375-4.9242-1.8786.4117-7.0147,1.7223-11.6169,2.9022a27.4825,27.4825,0,0,1,4.2843-1.3322c.3982-.1568-1.3788.3154-1.46.2972-3.9592,1.0366-2.897.8365-5.7745,1.6068.6432-.1443,1.2852-.2883,2.9113-.7167-5.112,1.4448-11.3142,3.058-15.8959,4.314-.2283.1389,2.2361-.501,4.3664-1.0437a31.3178,31.3178,0,0,0,4.3267-1.2507c7.3857-1.9009,4.6686-1.0752,13.06-3.2759-11.1224,3.1707-22.16,5.8508-31.8653,8.319a8.84,8.84,0,0,1,1.4719-.27c2.2556-.5978,5.65-1.4824,8.715-2.1887-2.4776.69-7.5071,1.9224-13.0679,3.2922,3.2595-.7276,5.1782-1.1937,1.4982-.1838,9.588-2.2537,28.4147-7.4707,26.1219-6.659,1.6981-.49,5.1-1.4,8.6689-2.35.4025-.1892,11.1772-3.244,20.1529-5.7664-2.525.7468-7.1046,2.1084-1.3978.5227l-14.59,4.236-11.9994,3.19-10.9741,2.8632c-1.8357.4715-3.6884.9815-5.6144,1.4539l-5.9939,1.4622-12.5349,3.1624-6.8087,1.6667c-2.1193.4524-4,.8386-5.42,1.1028,2.4518-.58,4.3344-.9511,6.475-1.4675l8.1044-1.985-5.8537,1.3981c-1.785.4408-3.56.8913-5.817,1.3513,1.6036-.4178,10.5486-2.5156,14.5416-3.5806,1.0333-.3392-2.9014.6526-2.9275.5977-5.4118,1.31-3.7745,1.0826-10.1589,2.57,1.4457-.3434,3.9175-1.0112,4.3312-1.1641-3.2147.8058-6.4291,1.4512-10.2386,2.2212-1.7573.4012.3977.0446-4.3564,1.1143-3.6563.8472-3.576.6458-5.848,1.2593.6873-.2185-2.6224.4595-7.7427,1.6353l.2548.72.9517-.5042c-2.1919,1.2006.1371-.0282.0551.1066l-.9559.4961-.3281-.9275c4.6835-1.0339,6.08-1.2764,9.197-1.9348,2.807-.6224-1.7338.28-.038-.1759l5.8521-1.2907c-.5151.154-2.56.6129-2.9073.7334,14.6588-3.1031,23.8148-5.5836,34.9281-8.4331a20.5222,20.5222,0,0,1-2.8943.7753c.5973-.07,6.6524-1.6161,4.3367-1.1307.5624-.2125-6.6179,1.6483-4.3732.9855,3.0424-.6871,4.6841-1.1494,7.2512-1.8279-1.8165.3726-4.981,1.2665-8.7191,2.1583.88-.1693-5.5312,1.5067-10.1627,2.5669.1978-.1164,3.6516-.9666,7.2589-1.8511-3.6075.7308-11.1372,2.8075-11.632,2.8364-4.5308,1.1631,4.3-.9266.0416.1751,3.0307-.7338,3.8513-.9706,5.8122-1.4636,2.2654-.53-7.3069,1.9177-10.149,2.5983a2.014,2.014,0,0,1,.3026-.0833l.7341-.17,1.8594-.4651c-3.9974.933-1.6915.3365-.0344-.1458-12.4279,2.9238-14.7563,3.2961-26.69,6.0159l.4134,1.1688,4.9219-2.5911c-3.5,2.1457,7.0087-3.2939,21.3928-10.7922,3.4285-1.7814-1.8418.894-.0552-.1068,3.724-1.8729,8.1979-4.154,9.3931-4.6547-2.5071,1.36-3.3385,1.73-6.6467,3.4372,1.9037-.8287,1.8643-.7446,12.0557-6.0318,1.2452-.6675-.92.3176,2.58-1.5367.3858-.2891-7.4352,3.8765-5.3678,2.6744l10.6612-5.4791c-.8888.5634-.9047.5327.0688.1331-2.74,1.3494-3.55,1.8269-5.3072,2.778,4.44-2.2374,10.1629-5.1821,13.2933-6.8743-1.4333.6759-7.6564,3.9514-8.0137,4.0429,6.5646-3.5034,20.8766-10.9536,31.89-16.5073l1.2-.597c-.5206.3192-4.2029,2.1939-3.7939,2.0558-3.9493,2.0186-5.8219,2.91-11.9894,6.1327.1364-.0948,1.1284-.6108,2.0863-1.11l1.3-.6815a5.446,5.446,0,0,0,.5813-.3278c-4.3156,2.1362-8.0747,4.2836-11.9181,6.2979,11.8162-6.0169,23.1732-11.9926,37.24-19.2574-3.0249,1.4753-9.4521,4.8586-13.5057,6.89l.1655-.0929-1.3657.69-1.32.6315c7.544-3.9841,16.5179-8.572,27.93-14.4434-.7756.3069-5.181,2.5847-8.0343,4.0194,2.4794-1.44,5.1216-2.5936,9.2968-4.8411-.16.1014-.8212.4489-1.44.7755l-.828.4407a2.5192,2.5192,0,0,0-.3574.2091c.9261-.3854,6.933-3.6794,5.3455-2.6631l5.5266-2.87a22.6469,22.6469,0,0,0,2.4212-1.3415c6.0911-3.107,10.6826-5.397,17.3271-8.8926a23.2253,23.2253,0,0,0,2.7039-1.2972c.2461-.054-4.7137,2.453-6.6439,3.47.4948-.0784,7.84-4.0238,11.9869-6.1649,12.7624-6.5887,31.2377-16.1245,41.2887-21.2159,1.0358-.665-6.4247,3.2822-5.3943,2.62,4.75-2.3552,8.84-4.5537,13.364-6.7758-.9019.5763-7.4971,3.9008-3.9306,2.2015-2.7216,1.3174-7.91,4.0721-6.6329,3.4638l-7.9644,4.152c-1.0007.4258,2.614-1.4195,2.6077-1.4833-.3645.1184-5.8489,3.0156-6.6852,3.39-2.81,1.4633,1.45-.6328,4.0363-1.9863-2.327,1.3115-5.9091,3.1411-10.6141,5.5565-3.91,1.7261-27.9338,14.3821-37.3278,19.1-.15.1725,3.2877-1.6026,6.6935-3.36-1.6407,1.0438-9.6069,5.0862-14.5668,7.7018.2748-.107,8.6025-4.4855,4.0253-1.98,7.5526-3.9948,13.1027-7.0038,23.85-12.57.3271-.109-1.2734.8278,2.7178-1.27-.52.4268-8.0654,4.1169-10.6031,5.5505,7.5826-3.8305,23.7687-12.2482,21.2631-11.0294.3981-.2518,3.3174-1.7437,5.3072-2.778.751-.3136-2.53,1.3561-2.6214,1.4567,1.81-.85,8.7017-4.4786,6.6165-3.5227l5.329-2.7222c.64-.259-1.8683,1.03-3.9675,2.1193,10.0392-4.9974,22.02-11.5173,41.2308-21.3552-.4424.0464-10.2906,5.1987-10.7757,5.2686,6.7477-3.5079.0808.0775,5.3677-2.6747,1.9473-1.0486-3.267,1.5911,1.2625-.8215l-6.27,3.2551-3.8857,1.99c-1.061.5363-1.782.89-1.8452.8932,9.3386-4.7329,5.6183-2.9968,13.2631-6.96-.88.42-3.0671,1.5511-2.7041,1.2969l-7.9515,4.18c1.368-.8837-12.2769,6.2534-6.768,3.23,2.25-1.1147,5.3936-2.6246,9.338-4.7614-2.3234,1.0793-10.2867,5.22-17.33,8.86,1.0109-.5528,1.4089-.8047,1.2762-.795-4.8407,2.4711-1.293.8143-3.9195,2.1957-2.5912,1.2924-5.39,2.6976-9.3464,4.7316,4.9428-2.4883-.2829.2218-3.9636,2.1512.2323-.0805,2.436-1.2311,4.0189-2.0444-2.7067,1.4657-2.7109,1.6016-7.9063,4.2914-.4544.1564.1633-.2141,1.2623-.822-5.9081,3.0071-3.4275,1.8867-7.9366,4.2057,1.5-.8675.6042-.3965-.0828-.16l-11.9318,6.2715c.94-.6238-8.6191,4.4508-6.7156,3.3038l10.6447-5.47a20.2637,20.2637,0,0,0-2.69,1.3234c.015-.0241.4207-.2405.951-.5182l1.6979-.8854c-3.3121,1.6614-8.3007,4.2324-9.3782,4.6808l-9.2965,4.8416c1.9163-1.0707,2.7887-1.5054,1.2623-.822-3.2092,1.6457-2.8646,1.5433-6.6439,3.47.5874-.4562,8.4816-4.5074,14.5817-7.6757,2.3439-1.1429-.97.5676,1.3865-.5818l5.3015-2.7753c-.5612.2026-4.0046,1.9689-4.0666,1.9005-9.1428,4.8182-9.3558,4.7269-14.6634,7.515-3.9067,2.0495,3.1168-1.5611,1.3865-.5817-6.7139,3.4944-10.0881,5.1393-13.2907,6.9064.38-.1661,5.0047-2.4745,5.34-2.7277,4.4153-2.2722-3.4473,1.93,1.3892-.5494-1.31.7562-9.3536,4.704-5.2878,2.8021l-5.3292,2.7218c8.9506-4.9915-10.5563,5.1357-17.381,8.7856-4.5883,2.2719-14.42,7.429-22.6562,11.6146-.8881.6165-8.4614,4.4108-18.5922,9.6821,1.5266-.99,6.91-3.7,11.89-6.3515-.1186.075-.4479.2538-.746.4171a4.988,4.988,0,0,0-.5579.3245l13.2659-6.9274a8.7638,8.7638,0,0,0-1.2788.7629c4.019-2.0442,2.3292-1.28,2.6075-1.4836,3.1991-1.668,2.9051-1.4406,6.66-3.4106,3.6257-1.9053-4.0792,2.0339-.0551-.1063a30.665,30.665,0,0,1,4.0253-1.98c3.5114-1.806,1.0074-.6519,5.2852-2.8342-1.0165.5556-1.3978.799-1.2719.7925,2.7772-1.4218,3.5034-1.8351,5.3071-2.7781,3.134-1.5822-4.3918,2.3583-7.95,4.1788,2.0816-1.0416,5.7964-2.958,8.9561-4.6152s5.7639-3.0552,5.6246-3.06c1.8011-.9211,1.1275-.4984,1.3765-.5767,9.09-4.7608,7.3962-4.0035,9.1716-5.0805-3.5806,1.8842-5.9805,3.1876-7.9091,4.259l-10.6557,5.4761c2.8311-1.5565,6.12-3.1306,9.2968-4.8411,1.7835-.9551,1.685-.9853,3.9277-2.1662-2.5389,1.35-14.1586,7.2168-15.9008,8.3578-4.2056,2.137-3.0109,1.5538-7.9791,4.1262-.6705.2139,2.7109-1.5771-1.4277.5021-3.9795,2.08,1.3075-.6042.0551.1064-3.0861,1.6067-5.1113,2.638-6.66,3.4105-.2.1427.306-.0982,1.3489-.63-4.5978,2.4925-5.1374,2.4842,1.2817-.7979-.3208.0833-5.4576,2.6991-.0689-.1332-.2279.0782-2.4316,1.2288-4.0144,2.0422q.2085-.2368,5.2714-2.8609c-2.6469,1.25-6.6789,3.4291-11.9871,6.1646,6.7443-3.6749,22.7983-11.7909,31.9216-16.5409,1.5132-.7878.699-.3979-.0138-.0267l33.2142-17.2771c-1.1772.6686-3.1756,1.7408-3.9263,2.199-2.7754,1.45-3.5278,1.8013-5.3345,2.7251-1.3545.7225-1.3541.7777-3.9719,2.1217-.8282.5745,6.2181-3.1249,10.693-5.4285-.4573.2811-2.3161,1.251-2.6213,1.4568,6.5629-3.4143,6.3939-3.3418,8.03-4.0512,11.6819-6.01,8.309-4.4283,18.5784-9.7089,1.7851-.8325,2.9384-1.3218,9.3784-4.6805,1.4364-.7515.8715-.5181,2.6362-1.4309-.1762.0044-4.9806,2.5212-6.6992,3.3628,4.1828-2.2328,9.4245-4.9636,14.6219-7.5952a21.8208,21.8208,0,0,1-2.2354,1.2186l-4.4085,2.251a9.28,9.28,0,0,1,1.3839-.6141l9.2909-4.8387c2.2385-1.0425-5.79,3.0394-3.9068,2.2231-4.9636,2.4479-23.6249,12.42-21.28,11.038-3.0266,1.4692-6.4844,3.4329-9.2679,4.8942.2033-.0306,5.6559-2.9106,8.0027-4.1049-3.5083,1.9178-8.3557,4.3787-10.6555,5.4766-2.52,1.3069-.8746.5637-3.9527,2.1452l9.3645-4.7074-3.9564,2.1136c.88-.4209,3.067-1.5514,2.6994-1.2949,3.9705-2.0456,4.4686-2.4355,7.9587-4.1493-.8357.3483.686-.5453-.0965-.1866,5.0456-2.6589.332-.0208,5.3679-2.6743l-2.6087,1.4839c4.357-2.1621,7.2677-3.7223,11.9731-6.1915-.321.0151-4.4564,2.1-8.0883,3.9124,3.1974-1.6958,4.87-2.6013,2.6074-1.4838,1.075-.6027,8.7888-4.5222,8.0344-4.0193l7.97-4.1552c-.0122.0225-.4169.2383-.9468.5158l-1.6976.8855c1.6769-.7645,4.5533-2.3912,7.978-4.1256-1.183.5622-1.1031.44-5.361,2.6712,7.4908-4.0734,21.7187-11.2351,27.9483-14.4192,5.7283-3.1971,17.2317-8.9956,26.6088-13.76-5.1667,2.7455-6.4987,3.2724-11.9731,6.1916.0385.0472,3.6434-1.8414,2.7122-1.2675-5.16,2.6365-5.4178,2.9337-9.3011,4.8434a19.53,19.53,0,0,0,2.69-1.3235c1.508-.7733.751-.3543.0139.0269l.0275.0532c-3.0948,1.5765-3.7034,1.7525-9.3921,4.6541,1.3192-.7936,10.1074-5.2623,10.573-5.6361-7.903,3.98-17.13,9.1141-23.9462,12.3831-7.1973,3.7526-8.7285,4.7175-17.2159,9.1049,1.35-.6526,3.621-1.8059,4.0492-1.9586,1.42-.81,6.3728-3.3582,5.2327-2.9086,3.6025-1.7764,7.0065-3.6434,11.9731-6.1915a30.71,30.71,0,0,1-2.8229,1.5728l-6.4324,3.3484c4.3013-2.1639,10.9371-5.5949,10.7492-5.3224l9.2957-4.8406c1.7191-.9736-5.3042,2.6371-1.3864.5818,4.5316-2.2484,5.4722-2.736,13.3319-6.8267.946-.3984-2.7224,1.4733-3.9538,2.1458,1.2837-.5714,6.7437-3.41,10.6833-5.4228,2.36-1.2211-2.1923.9743,1.2485-.8486,2.7766-1.45,3.5279-1.8011,5.3291-2.722l-3.9565,2.1134c1.3965-.644,6.1344-3.1021,10.6694-5.45-10.2793,5.5656-24.1,12.4547-34.5179,18.0189a23.9332,23.9332,0,0,1-2.704,1.297c-3.8853,2.0393-4.08,2.14-7.9791,4.1262.5685-.229,5.1643-2.644,4.05-1.9594-5.45,2.8328-8.5439,4.3869-12.0007,6.1382,6.2307-3.0218,27.7569-14.3,37.2533-19.2307,7.1085-3.6852-.3955.3491,6.7018-3.3306.4644-.1616-.1533.209-1.2525.8163,2.347-1.194,7.8-4.074,7.993-4.0992,1.5507-.8076,1.0844-.6226,1.29-.7686,3.91-1.9913,4.1041-2.0916,7.978-4.1256l.0551.1066c4.5629-2.3453,3.9537-2.1459,6.6026-3.5495,4.179-2.1614,7.9749-4.0257,5.3844-2.6152l3.98-2.0923c-3.8275,2.11,4.7966-2.3472,1.4178-.4969,4.5368-2.4231,5.7681-3.0142,11.9456-6.2448a41.0847,41.0847,0,0,1-4.0666,1.9005c6.9014-3.6492,7.775-3.9692,15.7158-8.0607l5.9982-3.0905-6.56,1.5552-1.7585.4169c-.1968-.0084,1.7711-.4859,1.4388-.4652l.2924-.0712,7.78-1.893L856.817,15.074l-7.7253,3.9594c-1.9637,1.03.5488-.24.0413.08-6.3671,3.3284-11.3547,5.98-18.6058,9.6557,2.3953-1.1523,8.5663-4.3544,12.0281-6.0851-6.5624,3.5214-7.6713,3.977-15.967,8.2569-3.2231,1.7,2.6692-1.2311-3.929,2.1666-.8353.4006-3.1467,1.5031,1.279-.7625-1.74.8265-8.6373,4.47-9.2817,4.8674,2.9568-1.4982,6.0255-2.9673,2.7591-1.19,4.5673-2.4183,7.795-3.9767,12.0144-6.1116-1.9526.9461-3.0273,1.4161-8.0442,4.0248.11-.105.1882-.193-1.3616.6028,1.1917-.7193,11.7693-6.053,15.9836-8.1979-.95.5513-2.4124,1.2524-3.984,2.06,2.3322-1.0106,8.6354-4.354,17.3572-8.8071q-.2561.2585,2.7316-1.2437c-2.132,1.1561-4.2048,2.1874-6.6566,3.4423,3.1916-1.7859-4.0675,1.8988-6.688,3.3572,6.4553-3.2231,2.2957-.8668,14.76-7.3286-1.6946.7819,4.4023-2.55-.1929-.3731.6594-.3654,2.0457-1.0834,3.7086-1.9354l10.4041-5.33L856.0619,12.83l-9.0677,2.1093c6.1244-1.5241.813-.43,8.9984-2.4125L869.8871,9.162l-12.7009,6.6262-1.0511.5484q.2561-.1025,1.076-.5L870.2462,9.51l-14.2657,2.9639c-2.5363.527-8.6046,1.9269-12.0007,2.7811,1.294-.2624,2.2086-.4273,5.8666-1.3026-.593.2534-6.0474,1.5383-7.2657,1.8511-1.2626.2379,2.7318-.7519-.05-.204-4.5616,1.1115-10.68,2.6811-13.0843,3.3322,1.694-.3739,7.718-1.9421,5.8453-1.3323-5.121,1.3073-6.52,1.5511-11.6456,2.89-4.2352,1.1635,1.9055-.433.0382.1452-2.5288.6507-5.591,1.4315-2.9291.6624-1.6674.4733-3.8671,1.079-7.228,1.9713-.4658.0534,4.1752-1.1553,4.32-1.2529-2.9406.7448-12.7934,3.481-14.4869,3.8559-2.3484.75,2.0509-.4584,2.9465-.6076,4.61-1.2706,4.4594-1.27,7.2284-1.9664-3.895,1.0706-4.04,1.1851-8.653,2.49-3.8707,1.1066-2.8009.7206-4.3467,1.1251-2.5165.7827-2.3721.71-5.7734,1.618.2465.04,7.1313-1.9241,5.83-1.4158-5.8452,1.6038-6.5109,1.7629-11.5543,3.1985.611-.2116,1.8184-.6031,4.31-1.2932-3.6727,1-13.6747,4.0343-15.79,4.75l-14.32,4.143c-4.1577,1.2051-8.1,2.3461-12.9756,3.9118-1.379.3486-.1333-.0607-1.5072.2405,4.5516-1.439,6.3032-1.9441,11.4849-3.4721-4.15,1.3163-1.7018.5633,2.8719-.8259-2.2594.7211-1.0286.4349,1.48-.2855-.46.0775,2.7946-.9538,4.2405-1.4847,7.205-2.1653,20.3192-5.997,18.7229-5.4091l12.94-3.82c-.9477.2338-3.3212.8983-2.9138.723-4.9638,1.4152-12.8934,3.761-14.4113,4.0878,3.45-.9788,9.5635-2.754,11.5021-3.3658-5.8514,1.5681-14.576,4.1515-18.7659,5.2549.2521-.05-2.5926.8713-1.4069.5335-.6953.2305-2.4936.7617-4.12,1.2238l-2.1511.5968-.679.1763a1.1224,1.1224,0,0,1-.2548.05c-12.5833,3.7884-11.8684,3.7278-14.2623,4.6157-3.07.8428,2.2889-.9808-5.8134,1.462,2.0519-.7126,5.5924-1.6822,10.0341-3.0489-3.1006.7667-9.3613,2.7462-15.8077,4.6868.1953.0164-10.3567,3.3278-8.5219,2.9034-6.6671,1.9672-10.3416,3.2907-15.7014,4.9786.4357-.1964,4.006-1.4446-2.8942.7549.0914-.1169,6.116-1.9513,4.2364-1.4864-2.5059.9349-13.3322,4.2194-15.6849,5.0691,1.7529-.3986,7.9843-2.3259,15.7834-4.7541a46.6147,46.6147,0,0,1-5.6687,1.97c1.6506-.381-2.0243.8367,4.3536-1.1523-2.8177.9979-6.5436,2.0737-12.8488,4.0857,5.9265-1.756-4.4164,1.48-7.1494,2.2568,1.0485-.4018,8.0172-2.5431,11.4293-3.6393l-.0272-.086c-.6356.13-7.0425,2.21-10.006,3.1273,1.5815-.5383,1.2134-.4477-1.46.3978.2-.132,3.5839-1.1988,7.1316-2.3141-1.7214.5018-.5607.1273-.0271-.0856-2.2192.6252-5.7637,1.6891-8.6219,2.5375,1.3671-.5282,3.8264-1.1656,5.71-1.8386-3.7,1.1182-6.845,2.0665-12.8765,4-5.5586,1.8265-.5395.3133-7.0953,2.4227-2.6942.8-.174-.0235-.0458-.143-3.3639,1.0919-9.838,3.217-12.8372,4.12,7.1063-2.3085-7.0285,2.1547-10.0345,3.0413.8627-.306,1.7123-.6077-.0185-.0573,3.0246-1.0284,10.8649-3.4444,12.87-4.0167l2.84-.9457c-.9474.2625-3.0636.9275-5.7217,1.7784,6.4834-2.1736,13.9248-4.519,17.0494-5.7164l32.839-10.43c.4266-.1044,2.9094-.7453,4.3079-1.2772,3.385-1.0445-1.6121.5853-1.39.5582,7.1263-2.2172,8.9329-2.81,17.1849-5.269l-4.3425,1.1482a11.707,11.707,0,0,1,1.29-.4509l2.9855-.931,2.9958-.8985a11.7037,11.7037,0,0,1,1.3212-.3541c.8005-.1751-2.7286.8779-2.8426.9622,3.9794-1.1235,13.2894-4.0407,18.6658-5.5811-1.1755.2216-9.6889,2.87-14.3624,4.2668,1.7224-.6238,3.28-1.2007,2.7739-1.1921-3.9267,1.1764-2.8756.94-5.7219,1.81l4.3163-1.2557-20.0417,6.2117c.6036-.296-.6092.0134-1.4927.2128l-10.01,3.1255c1.2823-.392,5.2961-1.5308,5.7319-1.7315,2.7381-.7617-8.141,2.5251-5.66,1.9607-3.4128,1.0964-10.3829,3.2381-11.4317,3.64-2.4814.6467-9.1177,2.7131-14.3149,4.3918-1.5534.5035-.9571.3681-2.8384.9691.46-.104,3.585-1.1182,5.7116-1.7921L675.64,64.22c.0805-.1446,8.8848-2.873,7.0748-2.4507a7.4978,7.4978,0,0,0-1.41.5131c-4.59,1.3774-7.8207,2.4827-11.4293,3.6039-2.6533.7484,5.17-1.7626-.0643-.2l5.7187-1.8094c1.6532-.4328-2.2294.7943-2.8186,1.0336a10.1016,10.1016,0,0,1,1.4315-.4293c2.5095-.8161,3.2274-1.0919,2.8118-1.03,6.2524-1.9007,15.2964-4.9211,11.3823-3.7913-2.5109.7927-7.1054,2.3568-8.5714,2.7363-1.3447.4347-1.6793.5894-1.045.4127l-20.3349,6.4925c1.2271-.3273,6.2758-1.9692,8.5806-2.6676-1.9944.6891-4.53,1.526,1.4455-.402-.9276.341-3.0355,1.0356-5.6792,1.8911.53-.1014,2.6012-.67-1.3745.663-1.9591.5991.5991-.2448-2.871.83-8.764,3.0831-17.1221,5.4855-32.7993,10.5587-1.3977.5488,3.193-.9806,5.7224-1.7945-1.2135.4494-5.2776,1.8226,1.4534-.3772-3.6562,1.2514-11.2053,3.6555-12.8214,4.1621-2.7056.8611,4.603-1.4916,2.8235-1.0112-1.0014.27-8.073,2.5647,1.4071-.52-2.5721.7591-3.2619.9624-5.7675,1.6515-1.4315.4853-1.4508.5433-4.2477,1.4423l-.0557-.1714,5.692-1.8478c-.4529.1043-3.5667,1.1314-5.7012,1.8195,10.8141-3.6555-4.2858,1.2439-8.61,2.6069l-2.8358.9525c-.2349.1655,5.37-1.6706,1.4778-.322,2.7081-.8931,6.1161-1.9983,5.6632-1.9344,7.1294-2.2319-2.8069,1.1827-7.0669,2.4847-2.035.78,3.9346-1.2173,2.8913-.7813-2.0173.6525-4.0346,1.3051-4.2564,1.414-4.2546,1.3389.3106-.2271-8.582,2.6919,2.0486-.7133,5.7311-1.9233,4.2222-1.56,3.8756-1.2817,2.8812-.8731,5.7156-1.7935.769-.3715-7.5051,2.1415,1.3387-.75-5.7654,1.8174-9.0453,2.6884-17.144,5.4064,1.4379-.4241,2.3817-.677,4.3149-1.2725l-5.6572,1.9915c-3.7355,1.1989-4.0049,1.1972-9.9868,3.1746l5.6283-2.077c-.0276-.0063-.4668.13-1.037.3117l-1.8233.5841c-3.1951,1.049.0087.1646-2.7957,1.0957l-11.3884,3.712c-1.7652.441,5.2463-1.951,8.4529-3.0442-1.9193.557-9.311,3.0017-7.1652,2.1556l-14.25,4.6c-1.41.55,3.1816-.9713,5.7115-1.7809-.4559.2532-8.7484,2.8842-7.1382,2.2385l-25.6641,8.2133a22.5889,22.5889,0,0,1,2.4319-.8683l5.2526-1.708c3.8273-1.2425,7.6964-2.4973,7.93-2.6663,5.1217-1.5834,7.6067-2.448,14.2435-4.574-1.4523.42-6.0522,1.9136-8.5554,2.6868l2.8058-1.0261,8.5646-2.6957c-2.39.8246-1.0822.5347,4.325-1.2385.3435-.2031-3.2339.9474-2.8964.7459,3.3132-1.0793,5.86-1.9536,8.54-2.7569-.1531.072-1.2148.4175-2.2393.7518l-1.39.4575a5.3963,5.3963,0,0,0-.6248.2273c9.7531-3.02,24.5086-8.1573,44.1276-14.4268a9.1529,9.1529,0,0,0-1.41.5522c4.1514-1.3821,5.3262-1.8639,11.3682-3.8179-.4681.2155.308-.0011,2.8685-.8365,1.5143-.5455,1.6415-.6066,2.8051-1.0684,1.6717-.5376,1.2111-.3358,1.4535-.3772,7.0721-2.4139,16.1527-5.3138,22.7878-7.4181L666.5439,65.32c8.1877-2.65,19.41-6.2342,25.722-8.1113-6.3853,2.009-10.942,3.4166-17.13,5.44-.6223.2963,3.07-.8844,7.1587-2.1935-2.65.74-.1736.0394,4.2705-1.3952-3.8259,1.2952,3.4848-1.0583,11.8571-3.7161,8.3779-2.6428,17.81-5.6105,18.1981-5.6161,3.2213-1.02-1.7446.4938,1.4056-.5315,11.8081-3.6826,12.73-3.92,21.4913-6.6007-.2322.0351-2.6226.7723-4.3145,1.2886,24.0495-7.5363,54.3241-16.6771,84.9911-24.7048,2.127-.59,1.3466-.539,7.2487-1.9976L823.09,18.3709l5.8408-1.4437c3.2908-.8547-1.79.407,1.4292-.4564,3.4664-.8358,3.2515-.7349,4.3973-.9953,4.813-1.2712-3.04.6978-1.4943.2253,3.8714-1.0025,7.4026-1.951,10.1866-2.6325,4.4749-1.0264-2.1048.6183,1.5122-.2053l10.5353-2.5091L887.18,2.8084,858.21,17.7678l-6.3814,3.2952c.9367-.5767-2.6682,1.3118-2.7178,1.27-4.8105,2.5565-7.9434,4.1138-11.9868,6.1651-3.5329,1.816,1.3331-.5-3.929,2.1666.5687-.2288,5.1644-2.6439,4.0391-1.9536-4.4221,2.1667-11.716,6.1045-14.6771,7.4885l-15.9147,8.3311L787.94,54c-2.5159,1.3048-.8855.57-3.9538,2.1458-5.058,2.45-12.5962,6.4972-17.3711,8.78,2.3245-1.2646,3.8825-1.993,6.6617-3.4108-1.62.69-9.5242,4.825-13.3276,6.8244-3.0721,1.4736,15.3058-7.9843,17.2663-8.9966.0063.0638-3.6084,1.909-2.6074,1.4837,3.01-1.581,3.9314-2.1348,5.2463-2.8821l49.25-25.401c-.7783.3262-2.0506,1.1016-4.0088,2.0395l32.99-17.0558,26.2515-13.572-28.78,6.6622c-16.8407,3.8983-33.7314,8.3817-43.99,11.1574a23.8134,23.8134,0,0,1-2.9155.6893c-4.7347,1.3023-4.1624,1.2589-7.2027,2.1351-7.5386,1.9343-21.4192,6.1418-27.4312,7.7606-2.53.744-3.2621,1.022-2.8465.9653-4.4062,1.1927-8.3722,2.4123-14.3679,4.2574.2625-.1037,1.43-.4578,1.4149-.4849-4.5961,1.35-4.4312,1.3884-7.1782,2.1668-1.5607.4842-.9506.3523-2.8525.9338l15.128-4.516c5.8242-1.7286,11.6428-3.4294,15.0949-4.3477,3.8129-1.0964-1.3951.23,4.2929-1.3707-1.78.6117-1.07.4316,1.48-.2419,6.8057-2.1241,9.7889-2.8,17.29-5.0364-6.8761,2.07,10.1379-2.6939,7.2579-1.9321,2.101-.6792,8.2419-2.0947.0158.0578-1.4113.6283,12.9349-3.3151,16.0167-3.9883l-20.281,5.5177c3.7879-1.1428-2.916.7219-2.9288.6343-5.4749,1.7708-6.6306,1.7672-11.5946,3.1021-6.0214,1.8477-13.3008,3.8381-20.1375,5.9324.52-.1139,2.5385-.7082,2.9014-.7717l11.5015-3.3718c1.2739-.2965,3.7169-.9635,6.97-1.8728l11.8452-3.279c.2372.0318-5.8381,1.6968-7.1851,2.1385,1.9651-.497,8.077-2.3279,11.5433-3.2351-2.64.803-.1447.1227,4.3739-1.09-6.0978,1.5477,2.26-.6693,4.3514-1.1682-1.4575.5045-11.0235,3.0166-11.6006,3.1265-2.7115.8662-.4058.25,3.0565-.7088l10.0285-2.6608c.43-.0654-1.3609.4188-1.4222.475,3.56-.96,6.9794-1.8793,8.7-2.3035a1.9378,1.9378,0,0,1,.4276-.1412l1.1718-.31,3.882-.9756c3.04-.7573,6.6766-1.6606,9.0592-2.3035-2.4968.5851-5.3258,1.2615-10.2029,2.5032,2.3624-.7283,10.3889-2.7593,17.451-4.4634-1.3778.4413,5.1581-1.1,9.1137-1.9716l21.2962-4.69-19.472,9.6745c-1.1234.5582-2.011.9887-2.4322,1.1678-.7936.43-6.2687,3.32-6.6467,3.4371-14.5853,7.6144-29.0856,15.127-41.2474,21.2959-1.7946.9609-1.675.98-3.94,2.1725,11.3818-5.876,24.5712-12.6063,33.2555-17.1972,4.6765-2.3649,6.6858-3.4947,8.03-4.0516,2.6985-1.4162.2985-.3246,5.26-2.855,1.957-.7255-15.9274,8.3881-25.2362,13.1516-1.4355.75-.87.5172-2.635,1.43,1.5294-.7048,10.2892-5.3345,12.0006-6.1384a8.8428,8.8428,0,0,0-1.28.7632c-4.1688,2.1268-6.6306,3.3079-7.9753,4.1578l-17.3286,8.86a41.22,41.22,0,0,1,4.0492-1.9587c3.4911-1.7663,5.6729-3.038,5.329-2.7222-7.996,4.1695-10.3465,5.2753-14.68,7.4562-3.7925,2.0067,3.5637-1.7563,2.7316-1.2434l-10.6932,5.4279c-2.1188,1.236-11.83,6.2013-15.9156,8.3321-.7571.5246,3.0275-1.4159,6.7155-3.3041-4.6412,2.5391-5.0917,2.5155-10.6683,5.4492,1.7021-.9251,1.7025-1.006-1.3864.5819-1.5575.8109-1.1011.631-1.28.7633-3.5732,1.8712-2.6047,1.2771-4.0464,1.9911l-9.2966,4.8416c2.8149-1.4031,8.5866-4.41,9.3655-4.7083-2.426,1.3049-6.2856,3.3149-10.6032,5.5505-.4012.1532,1.2323-.6951,1.279-.7626l-10.6075,5.553q1.8305-.8574,5.375-2.6442c-3.1479,1.6855-12.6162,6.5644-11.9859,6.1641-2.0835,1.0923-1.0939.6721-5.2877,2.8021.59-.2633,1.7165-.8184,4.0115-2.007-3.34,1.874-14.8709,7.6462-18.5645,9.7355L672.01,113.4436c5.4136-2.9579,1.16-.6744-1.4389.5077,3.21-1.6464,2.876-1.5486,6.6329-3.4638.4125-.1586-1.2322.6954-1.2788.7629,1.1844-.6276,2.369-1.2548,2.635-1.43a15.5652,15.5652,0,0,0,1.7694-.8533l6.2363-3.2188c-1.1047.6213-4.2556,2.25-6.6291,3.4957,11.7826-5.9215,26.3039-13.54,25.1635-13.3166-1.8672.8991-8.17,4.206-10.6793,5.4549-3.8859,2.0381,1.7662-.8284.0688.1331,2.56-1.3372,1.0075-.6517,5.2841-2.8336-4.1611,2.2475-4.4278,2.5795-11.848,6.4308-.1306.0137.5858-.4322-1.3876.5822.5572-.33,1.6722-.9338,3.9675-2.1193-3.0855,1.4885-7.0291,3.6786-10.638,5.5349,2.6088-1.4267-.34.1384-1.3627.6034-7.6439,4.1087-14.81,7.5222-23.9313,12.4092-2.9562,1.502-1.7973.7708-5.3954,2.6209-1.8533,1.032-9.5086,4.9611-6.619,3.4906-3.2371,1.7522-5.8694,2.832-4.1052,1.853-13.1374,6.9883-.7346.6877,10.8208-5.1569-3.913,2.0916-14.1541,7.44-21.2549,11.0588a20.4734,20.4734,0,0,1,2.6351-1.43c-1.2319.522-13.6938,7.0153-11.9316,6.2717-4.1715,2.1732-3.5444,1.742-6.6881,3.3571l-3.98,2.092c-1.0551.6412,1.908-.8991,1.4-.5552,6.0748-3.1113,7.5117-3.9406,11.9455-6.2449,2.1135-.768-13.92,7.4141-19.8795,10.4828l-17.3022,8.9136c-3.3833,1.8338-11.2776,5.9286-18.2123,9.4982l-2.3361-6.6049,10.6263-2.3019c-.4021.1516-3.8821.9178-5.815,1.3748,1.9191-.3212,13.1-3.0166,7.261-1.6937,2.16-.578,3.5707-.7237,7.2923-1.5776-3.3212.6843-2.125.3934.3945-.1714l4.3727-.965,3.9471-.9324c-6.3489,1.7183,3.2528-.8219,4.3633-.9831,3.7281-.9221,2.31-.6846,4.319-1.2191-1.4922.3472-9.7366,2.2809-8.6962,2.1436l-28.0767,6.2689,2.3745,6.7134c5.4467-2.8363,10.5-5.4571,14.26-7.3511l1.5115-.7547c.2913-.1427.3994-.1918.4123-.1926-1.2238.6573.0742-.0168,0,0l.7526-.403c8.0038-4.2633,17.8177-9.1366,26.6364-13.7068,1.9638-1.03-.5376.2346-.0413-.08L746.599,75.142c1.2351-.5295-4.3116,2.2772-5.2739,2.8288,2.803-1.3963,7.0321-3.5667,12-6.1376,3.1087-1.5522-.351.408.0137.0264l-18.6022,9.6871a8.9065,8.9065,0,0,1-1.3625.6036l-14.5945,7.6481c-1.3705.6642-1.35.5735-2.7314,1.2439-2.4628,1.34-4.8677,2.5276-7.978,4.1256.2535-.0124,8.1466-4.1718,8.0468-3.9926-5.7857,2.9258-12.4986,6.5555-17.2885,8.94.5574-.33,1.6712-.9333,3.9676-2.1192-.1754.0724-.8409.4108-1.4662.7275l-.8416.4226a2.6957,2.6957,0,0,1-.3835.1741c-1.4542.8475-5.84,3.0862-9.2954,4.8409-3.929,2.0607,3.0945-1.55,1.3752-.5764-6.8116,3.3817-10.5008,5.27-19.9813,10.2315l-.0552-.1068c-4.1845,2.1479-5.4278,2.8492-6.6162,3.5233-1.3006.6147-4.2083,2.1021-6.6993,3.3625-1.2236.6577-1.9879,1.09-2.6212,1.4572-3.35,1.7214-15.05,7.6695-13.3072,6.8474l-76.7972,39.6667-2.4794-7.01c10.3293-2.2921,19.4985-4.23,26.63-5.8722,4.5374-1.14,1.87-.5435,1.4162-.5036,3.2531-.6823,8.7546-2.0226,14.5026-3.4344l8.5559-2.1034,7.3955-1.9131c1.8422-.5,1.88-.5956-.0228-.0868,3.4654-.9694,12.7224-3.3465,18.785-4.9625.0358.0359-6.0529,1.7172.0239.0867-16.948,4.5843-25.9647,6.9428-36.1359,9.4306-4.4279,1.1278-.3229.2119-5.7612,1.6054,1.2473-.217,4.6683-1.1692,7.251-1.7872.2211-.0906-.3259.0253-1.4608.2982.0146-.0187.4557-.1334,1.0346-.2791l1.8615-.4654,2.9022-.7153c.6292-.0908-.9833.324-1.4338.4767,1.3953-.3806,3.2318-.8515,5.07-1.3046,1.8329-.4786,3.6638-.9584,5.0622-1.293,3.3986-.9186,2.6706-.8224,7.1961-2.018.94-.18,3.1014-.7588,5.0344-1.2749a33.7126,33.7126,0,0,1,3.6636-.8965c-4.5267,1.2457-3.2655.8766-8.66,2.3162,1.46-.3284,6.3922-1.6606,5.8079-1.3979l10.1883-2.82c3.8919-1.111,7.7571-2.1873,9.991-2.7615l10.3184-3.0057c3.79-1.0835,7.9689-2.2809,12.6376-3.73-2.049.6663-1.2982.4586,2.8812-.7968-1.1572.4019-7.5255,2.3513-10.0344,3.0046-1.7222.5251-2.5744.8214-7.1693,2.1023.3544.0428,6.8351-1.86,1.4975-.2078l11.5-3.3c1.56-.4736.9626-.35,2.8524-.9135.54-.2363-6.5282,1.9648-4.3293,1.1973,6.9047-2.1064,3.0132-.7552,8.6309-2.45-4.4733,1.3788-8.1149,2.4815-12.0459,3.6349l-13.785,3.9352c3.1475-.9233,4.1384-1.31-1.4662.2923,1.9155-.3843-8.2807,2.3807-5.7429,1.6967-1.4312.4858-6.3615,1.7851-5.7761,1.55,6.1345-1.7161,6.097-1.7579,12.936-3.7123-14.0416,3.95-25.7512,7.1362-41.26,11.2995,1.4442-.3431,5.0314-1.3383,5.2386-1.3381,2.8375-.7665-4.2683,1.2064-7.2173,1.9408,2.3466-.6373-.4756.0546,1.1825-.4053l-7.0128,1.7187c-.2248.1326,2.259-.46,4.3906-.9586-6.1865,1.5714-11.0008,2.7436-16.034,3.9577-2.5206.5874-5.0793,1.2685-7.9223,1.8638l-9.4839,2.0673c1.7318-.3265,7.6083-1.6541,10.2272-2.1942-4.65,1.187-15.3083,3.4321-23.7317,5.3067l1.8855,5.3311,3.6115-1.8892-3.6564,1.8025-1.821-5.1486,1.8782-.3718c2.99-.7205,1.3644-.3618,4.3731-.9647.8268-.2872,1.4463-.4114,8.7381-1.9885,4.6323-.9963-2.5783.609-4.36.9922,4.5021-.9109,5.9424-1.267,8.7654-1.81,3.7211-.8755-2.7289.5189-.0333-.1461,6.3436-1.3936,2.6642-.5343,2.9474-.4966,2.3638-.509,2.51-.5761,4.3621-1.041,1.6331-.3906-.3965.1887-3.4736.8714l-9.6281,2.1274,9.6324-2.0655c3.1665-.6747,6.5-1.5416,10.7664-2.5773-.3668.0358-2.519.5507-5.8242,1.3737,2.1471-.6416,14.4367-3.4312,13.0384-3.3066l10.3658-2.5148c2.9534-.7772,5.5982-1.4845,8.4691-2.288a9.1236,9.1236,0,0,0-1.4347.4767l-7.6117,2.0136-8.3193,2.0432c3.1262-.7072,4.5653-.9441,8.7589-1.9518-6.4386,1.731-13.3441,3.295-20.2908,5.103l-.0209-.0873c-2.6179.636-3.6814.9218-4.6456,1.1851-.9626.2711-1.8285.5076-4.0629.9887,2.1342-.3718,4.5482-1.0026,6.4985-1.5034a31.2482,31.2482,0,0,1,3.6925-.8505c2.7123-.7927,8.6536-2.13,13.05-3.2781,1.5634-.2708-4.8759,1.2619-5.7707,1.5457l11.0589-2.6492,10.7161-2.7232c-4.9548,1.3548-10.9359,3.0233-15.9014,4.2338,1.8568-.4512,3.995-.9429,6.2476-1.5288l6.9907-1.857,12.8239-3.3794c-4.3484,1.2237-9.4233,2.5582-13.9409,3.7478l-10.6192,2.8016c-7.1835,1.7271-3.0252.5441,1.3818-.5878-3.0914.6788-4.0906,1.145-11.5988,2.92-2.7994.5909-2.198.3854-10.2029,2.33.3764-.1568,6.4253-1.5914,5.7794-1.5175-.2767.0433-1.4477.3259-1.4547.2968-1.1947.4471-7.8107,1.9124-8.69,2.262l-8.7454,1.9595c-1.47.2833-3.9562.8124-4.4081.8494-1.0453.3422-11.0767,2.6378-8.6965,2.1948l-.4094.098,1.194,3.3759c3.9915-2.15,14.64-7.5358,10.3256-5.196,7.752-4.06,7.94-4.0137,12.0283-6.0848,2.5513-1.3666,1.9095-1.1624,3.8864-2.2462,1.3913-.7057,4.73-2.3152.0413.08,1.1466-.5429,4.3077-2.1786,6.6853-3.39,3.53-1.9581,24.1664-12.5414,31.8829-16.5886-.7329.4275-2.0448,1.14-3.9482,2.143,1.3118-.6095,5.129-2.5793,9.3436-4.7641-3.3209,1.6581-2.7153,1.3294,2.6239-1.4246l-5.3566,2.6688c1.2535-.76,2.63-1.3227,3.9977-2.0336,2.04-1.1763-6.0664,2.8613-14.7322,7.382,7.7363-3.8785-6.5106,3.3823-7.9311,4.2027-2.7753,1.4252,1.9381-1.0936-2.7,1.2947.1324-.1432,5.6343-2.9278,7.9642-4.1523-15.5818,7.9017-30.2127,15.4931-43.9512,22.5934l-.0415-.08c-3.0547,1.6024-6.7442,3.5148-9.2552,4.9214-.6036.3842,1.9208-.9288,4.0115-2.007-1.0828.59-3.0656,1.6423-4.916,2.6025l-1.1352-3.21,3.3376-.7121c-.181.0565-.9077.2219-1.59.3784l-.9152.2133a2.6666,2.6666,0,0,0-.405.1115l16.0946-3.3961c.2251-.1635,3.6357-.7995,7.3212-1.5534-2.5431.5592-8.3583,1.9913-1.44.4713l-22.3076,4.956.819,2.3157,14.2258-7.4183c-.5945.2576-1.695.89-3.984,2.06.2117-.2265,7.8286-4.0967,5.2244-2.938,5.9006-3.0352,6.59-3.4544,10.6351-5.5-4.3706,2.16-10.9568,5.6085-17.3011,8.913a3.9525,3.9525,0,0,0-.6713.2961l-1.4373.7118a17.7063,17.7063,0,0,1-1.9555.9248l-4.9427,2.5508-.522-1.476,20.8405-4.6213c1.5335-.35,3.0379-.67,4.51-1.0294l4.3532-1.1021,8.5873-2.2005-8.8476,2.1615-4.9061,1.2021-5.09,1.1263-19.4777,4.3163.6213,1.7567,10.2828-5.2787c-1.1217.7041-5.073,2.7975-10.1885,5.4613l-.7571-2.1406c11.3237-2.54,27.8143-6.01,33.9475-7.7947-.027-.0084-.4745.0959-1.0558.236l-1.8588.4515c.6317-.1832,1.2632-.3668,2.8934-.7751l2.8965-.7139c-.1878.103-1.048.38,2.9435-.5709C599.2686,156.1466,593.7244,157.5733,587.955,158.9126Zm82.9258-94.7992a54.8594,54.8594,0,0,0-5.726,1.7481c.1146.0179-.2958.1933-1.4023.5777C667.8054,65.1607,667.4414,65.2073,670.8809,64.1134ZM853.1324,20.3212c1.0484-.5139,2.93-1.4807,5.0626-2.5826L886.8685,2.92l-31.3646,7.4658-4.6884,1.116.0205.0876,4.6885-1.1133,30.5723-7.26-27.9445,14.44C855.5222,19.0154,853.2268,20.21,853.1324,20.3212Zm-54.39,5.7533c-2.097.6609-3.0289.9066-1.405.5493l4.3364-1.2153ZM754.0321,38.79c2.6637-.799,4.7988-1.4139,5.7676-1.6631-4.2871,1.3348-13.7773,4.1711-7.2111,2.0728-3.772,1.1423-4.6842,1.4741-4.2708,1.43,10.7032-3.1232,12.15-3.7862,20.079-6.1C769.3963,34.08,755.2474,38.3427,754.0321,38.79Zm5.7072-1.8642c3.6712-1.0994,5.013-1.5538,7.1536-2.2291C761.2762,36.2908,759.861,36.8183,759.7393,36.9255Zm-10.0881,2.8887-8.6021,2.6583c-1.2066.4327,1.3032-.2028,2.8962-.79a10.1321,10.1321,0,0,1-1.4437.41l8.6074-2.5974C750.8511,39.5264,751.5907,39.2317,749.6512,39.8142Zm-2.8961.79c-3.5906,1.0269-8.4459,2.5691-12.9019,3.9506-.0148-.0268,1.1428-.3928,1.4028-.499-2.1418.6713-5.28,1.631-5.71,1.8075C734.0961,44.518,741.2917,42.3479,746.7551,40.6047Zm-115.65,36.8329c2.4946-.84,7.1213-2.3207,8.5386-2.8306-4.5394,1.4958-4.4157,1.38-7.15,2.2539C632.0537,77.0461,630.4825,77.574,631.1048,77.4376Zm28.4965-9.2524c-2.5112.6756-16.32,5.2327-17.0961,5.5271C650.1675,71.2607,654.1508,69.8726,659.6013,68.1851Zm54.2858-17.1872c10.6055-3.3516,15.6683-4.8967,24.3364-7.5054l-.0176-.0573c.7934-.2419,1.626-.5222-.0089-.0287-.43.1818-2.0317.6181-1.4419.3774-5.6086,1.7639-8.3367,2.5209-11.4617,3.56l2.8291-1.0056c-7.4678,2.3545-4.9754,1.746-11.3943,3.7332,1.0129-.3972,5.1317-1.6927,5.67-1.9523-13.3452,4.1791-39.9034,12.5716-58.535,18.6629,19.7958-6.2961,40.8307-13.064,51.4065-16.3461C712.7989,51.28,716.3575,50.1537,713.8871,50.9979ZM611.2307,84.11l-.0277-.0853c-2.3638.81-9.0617,2.9317-8.52,2.8616C606.84,85.5082,607.0494,85.44,611.2307,84.11Zm1.4136-.4591c3.8074-1.2572,8.8991-2.9019,11.3879-3.76-2.2281.7153-1.0162.2609-.0278-.0856C616.1925,82.3059,616.0051,82.4976,612.6443,83.6513Zm.0371.1143c4.0307-1.3981,18.4464-5.9378,19.9232-6.5624C627.06,79.0731,614.8741,82.8616,612.6815,83.7656ZM688.31,59.5737c1.4092-.5574-10.7531,3.358-11.4374,3.62Zm-56.9921,18.52c-.1981-.016-2.1.56-5.7408,1.7377Q625.89,79.85,631.3177,78.0941Zm1.5-.2345,6.8526-2.2737c2.4091-.7946,4.4257-1.4708,4.499-1.5606l-1.8237.5831c-.5706.1815-1.01.3177-1.038.3112-4.1,1.3459-7.3165,2.4883-9.9711,3.2314.8677-.1684-8.5086,2.7631-7.0817,2.4252l8.5259-2.8308C635.1753,77.0305,632.6639,77.8231,632.8175,77.86Zm18.4778-6.1407c5.02-1.572-3.2955,1.1594-4.2635,1.4112l.037.1142c5.6239-1.8611,2.9409-.8482,8.5649-2.709-1.4028.3358,6.408-2.0909,5.66-1.9493-7.5317,2.3812-6.5718,2.1-2.88.8008C656.34,70.0679,651.0383,71.735,651.2953,71.7188Zm-11.4393,3.5446c-.2061.1577,8.5888-2.6357,10-3.1422l-1.8282.5847c-.5692.181-1.0059.3163-1.0335.31l9.9824-3.1982C655.24,70.1893,645.6715,73.4424,639.8561,75.2634ZM761.3472,37.1028c8.7626-2.4155,18.0729-5.3068,31.6811-9.2088-1.0473.1127-8.8245,2.3829-10.167,2.6179-6.4495,1.9254-7.6985,2.2021-11.5547,3.2739-4.386,1.3458,1.5311-.1567-7.0926,2.43a4.9515,4.9515,0,0,0-.6271.1536c-.3281.0894-.69.19-.8278.218q3.0957-.95,4.2875-1.3734c-6.4394,1.8417-10.0644,2.9246-15.7982,4.74-2.5651.7048-1.8289.5243-7.1716,2.1585,1.22-.4732-2.2434.5873-4.3393,1.2-3.5,1.1107,2.6046-.7005-1.4.5528-3.3331.929-6.3972,1.9373-11.4609,3.52-.2963.0522-4.2006,1.153-1.4767.3023,2.4605-.7138,13.4411-4.1716,8.63-2.5593,3.31-1.1041,9.0714-2.87,11.4066-3.6817L729.6437,46.179c1.2765-.3322-4.6827,1.5759-4.2789,1.394,1.1213-.356,1.6573-.5422,1.4144-.5029-6.1288,1.9394-5.5271,1.7375-10.0241,3.087-.3967.246-2.0195.7339-8.5358,2.8185-.08.09,1.7307-.472,3.5521-1.0461l2.5049-.7909c.6808-.2136,1.1292-.35,1.11-.3307-.1132.0854-3.6438,1.1749-2.8332.9887,2.5115-.7909,7.1183-2.3234,8.5884-2.69-2.3491.8256-16.6193,5.1976-15.6829,5.0866,10.1462-3.3418,17.6743-5.5226,25.7684-7.9728,3.3019-1.2325,12.1978-3.7383,15.7295-4.9557,1.2984-.3412,5.82-1.7379,4.3356-1.1675-2.7017.8389-8.6436,2.597-7.1448,2.2451l9.8381-2.994C757.7233,38.2292,761.0514,37.2428,761.3472,37.1028Zm-2.8186,1.0294a2.864,2.864,0,0,1,.4031-.1427l.9-.28c.6691-.2059,1.3792-.4233,1.55-.4912-2.3292.6433-7.41,2.1769-8.6017,2.613C755.4942,38.9913,755.9535,38.908,758.5286,38.1322Zm-69.69,62.2187a30.8568,30.8568,0,0,0,3.9426-2.14c-3.7454,1.9647-3.4624,1.7431-6.66,3.4105C684.5188,102.5587,690.4386,99.4139,688.8381,100.3509Zm-23.96,12.3561c-3.7327,1.8534-6.5474,3.4689-10.61,5.5886C656.82,117.0228,662.0079,114.24,664.8781,112.707ZM702.2,93.61l2.65-1.4041a31.2239,31.2239,0,0,1,4.0353-1.9855c-3.1027,1.6155-5.718,2.9916-6.6164,3.5228,5.2557-2.7309,7.1876-3.8256,10.5784-5.6392-3.5728,1.7278-13.7973,7.1086-10.7161,5.3729-3.1368,1.7343-8.24,4.23-10.5949,5.58C697.4868,95.8485,707.0566,91.3535,702.2,93.61Zm-2.6627,1.377c-5.2487,2.7988-13.3905,6.8983-18.5508,9.762C692.6517,98.8113,696.5538,96.7532,699.5377,94.9866ZM730.485,79.8273c5.4107-2.7762,8.0954-4.3522,2.57-1.5318,2.3459-1.1934,7.8-4.0739,8.0031-4.1044.4033-.1493-6.2206,3.3211-2.6076,1.4834l13.262-6.9595c-5.803,3.0392-5.257,2.541-9.4195,4.6011.76-.2291-7.1539,3.8091-10.5729,5.6361-1.7977,1.0066,3.4727-1.6688.0552.1069-1.9911.9775-10.3157,5.3755-6.7075,3.3332-3.8238,1.93-7.2258,3.8414-6.666,3.4133-3.3256,1.7141-4.1456,2.1959-5.2783,2.8311l6.6577-3.46a18.0885,18.0885,0,0,1,2.6848-1.3033c-2.488,1.2908-4.4406,2.3184-5.299,2.8076,5.83-3.0277,4.3316-2.0781,8.0662-3.9686-.2493-.02,3.2493-1.6771,6.6385-3.4665C734.5071,77.8137,731.26,79.4952,730.485,79.8273Zm92.0366-46.9863c-3.0943,1.6562-11.363,5.858-10.5965,5.6151l11.9719-6.191C824.1746,32.0574,822.3734,32.9783,822.5215,32.8411ZM783.94,52.7927c4.4532-2.3483,7.0444-3.6245,9.2967-4.8413-1.0428.5318-1.5491.7728-1.3544.6329l-5.5234,2.868A22.5813,22.5813,0,0,0,783.94,52.7927Zm14.691-7.4617c-1.5816.8129-3.0443,1.5137-3.994,2.0654,1.5854-.7812,4.7244-2.4053,7.9917-4.0991-2.1.978-.5206.1208,5.2712-2.8613-1.2236.5136,3.35-1.9059-1.4138.529-.5348.3188-1.6935.9445-3.9676,2.1191-.4963.3146,2.0062-.951.0413.08-2.6646,1.3216-1.687.8755-5.3153,2.7487a7.56,7.56,0,0,0-1.3589.6351C794.2292,47.5377,800.2864,44.3408,798.6306,45.331Zm-13.2494,6.9864c3.3616-1.8321,2.2259-1.2435,6.6384-3.4667a8.89,8.89,0,0,1,1.2857-.7659L774.644,57.6332c1.1774-.4834,8.0252-4.0071,12.0146-6.1112C786.8708,51.457,781.2872,54.4014,785.3812,52.3174Zm10.6693-5.45,17.28-8.97-.0413-.08C806.2469,41.5385,797.8253,45.79,796.05,46.8674ZM573.9727,161.878c2.5781-1.3556.83-.6495-1.3727.6086,2.2141-1.0952-3.728,1.954-7.5872,3.9656l-.9066-2.5632c1.979-.4432,3.462-.7849,3.3233-.7869l-3.3345.7321.9435,2.6678C567.315,165.3089,569.8423,163.962,573.9727,161.878Zm43.9236-22.6465c4.3467-2.2609,8.5836-4.4678,9.2554-4.921C622.9149,136.5176,619.06,138.5369,617.8963,139.2314Zm26.5951-13.7866c-6.1654,3.1615-3.8,2.0028-5.2976,2.8074-2.5921,1.3043-1.9147.8345-4.0668,1.9,0,0-.2631.155-.5652.3137s-.64.3286-.7773.38c3.4466-1.8253,3.9858-2.1356,7.9754-4.1578-3.067,1.4047-11.6369,6.0457-13.2631,6.96,2.2889-1.17,3.3894-1.8027,3.994-2.0654-1.19.7218-4.1417,2.2851-7.9478,4.2111-1.2778.8191,10.0007-5.1777,10.6943-5.4285-2.3645,1.2524-3.35,1.8265-7.9615,4.1845C636.3469,130.0174,637.9085,128.951,644.4914,125.4449Zm31.9407-16.45c-7.6749,3.9156-15.2863,7.7966-20.0364,10.1249-.34.2449-4.9456,2.5889-5.2852,2.8342,4.47-2.3155,7.0093-3.6923,9.3242-4.7881a2.6894,2.6894,0,0,1-.3638.2124l-.8313.4424c-.62.3272-1.2807.6746-1.4412.7758C665.08,114.795,671.4025,111.6852,676.4321,108.9954Zm50.61-26.0367c3.778-1.9261,3.4225-1.8174,6.6329-3.4638-2.0674,1.2021,5.7635-2.9687,5.3677-2.6745-.2662.1754-1.4518.8032-2.6363,1.4306-1.4979.7632-3.8779,1.8389-5.3428,2.6956,3.7383-1.9-1.901,1.0729,1.3865-.5818,6.5622-3.4429,4.669-2.3005,10.6693-5.45-2.1989,1.1326-2.2917.9531-.0965-.1866l5.3843-2.6154c.2237-.2575-5.1083,2.5-5.4255,2.5357C738.1729,77.17,727.5076,82.5735,727.0422,82.9587ZM705.76,93.9644c-.0569.0623,1.1137-.5193,2.9135-1.4352l6.6885-3.4413c4.9195-2.55,9.9619-5.1989,10.34-5.47C716.6658,88.3637,713.2062,90.1122,705.76,93.9644Zm-4.0254,1.98c-3.41,1.79-7.5319,3.9287-9.2746,4.8975,3.9326-1.9341,5.3833-2.8183,7.946-4.1765C700.5066,96.6484,702.1271,95.8018,701.7344,95.9445ZM643.37,126.5655c4.0645-2.0892,2.2234-1.2727,5.2713-2.861-1.7786.8859-4.96,2.5332-5.3678,2.6745,7.361-3.9686,7.6859-3.6826,14.691-7.4617-1.6047.8226-.8268.39-.0276-.0533-1.9933,1.0248-4.8981,2.5449-5.3293,2.7217.81-.4764,3.9947-2.1212,5.2741-2.8285-2.493,1.2811.7356-.4358-1.3478.6295-3.3577,1.8912-12.75,6.4666-15.9258,8.3369C642.871,126.6094,646.3658,124.9291,643.37,126.5655Zm35.85-18.7078c-.2181.0048-4.5063,2.2184-5.3981,2.5886.4365-.1368-5.1526,2.6911-3.94,2.1725C675.2169,109.8294,676.3249,109.2634,679.22,107.8577Zm-14.6534,7.51c-5.2668,2.6823-7.1128,3.7964-2.6074,1.4837C660.2693,117.6155,666.2408,114.6115,664.5665,115.3676Zm28.0723-14.1794c3.3545-1.7263,5.5457-2.7678,2.7272-1.2412,4.1294-2.1241,6.3221-3.3477,9.32-4.82,1.2271-.757-5.9976,3.0732-5.3814,2.6481,3.8315-2.116,16.8611-8.6254,17.2194-9.0737-8.1289,4.2331-18,9.3677-18.6335,9.6021-2.6294,1.4412-9.2871,4.8842-11.9731,6.1916,1.0552-.6412-1.908.8992-1.4.5552,3.7565-1.97,3.4625-1.7429,6.66-3.4106-.6829.2444-6.5364,3.1177-9.3918,4.6545,1.81-.9033,2.6993-1.306,4.049-1.959-5.8436,3.0529-2.4208,1.3392-1.2623.8219-.2339.0774-8.1366,4.1641-3.9885,2.0626,2.674-1.2356,13.56-6.9285,17.3753-8.7831C695.4944,99.7442,693.47,100.6573,692.6389,101.1882ZM728.4976,82.51l-9.31,4.8146c.7461-.3367-1.4763.9379,1.4014-.5557,3.4883-1.9023,8.6132-4.2231,14.6632-7.5153-2.2128.9482,9.3831-4.9376,11.9261-6.2689-1.8369.8138-8.4827,4.3042-11.9812,6.1622-.1041.0106-1.7294.8478-1.3837.6143C729.2534,82.1133,726.4214,83.7877,728.4976,82.51ZM771.1148,60.573c-5.2511,2.74-10.9614,5.7054-13.26,6.9924C763.39,64.6855,770.7424,60.9124,771.1148,60.573Zm18.62-9.6287c2.397-1.1489-5.8408,3.0857-1.3011.7741.9039-.5341,7.4293-3.8337,7.9614-4.1848C793.196,49.202,793.48,48.98,789.7346,50.9443Zm22.6589-11.5823c-.683.2469,6.0943-3.1768,6.6152-3.5225-2.6041,1.3572-2.6491,1.3245-4.0215,2.0123,0,0-.1132.0731-.306.18l-.7737.42-2.0256,1.0861C810.6274,40.2124,809.9757,40.5768,812.3934,39.3619Zm-136.951,70.9554c1.6166-.7617,9.8062-4.9155,13.321-6.8209-2.8741,1.4463-12.5018,6.3347-5.4395,2.5087-7.95,4.18-18.6027,9.5286-26.5977,13.7543C665.5787,115.2275,683.708,105.873,675.4424,110.3173ZM716.7036,89.048l-10.6958,5.3959c-.9541.5974,3.6846-1.8405,2.7317-1.2435L696.7664,99.392c1.7433-.7692-3.0984,1.7025-6.6055,3.5168,2.7455-1.2576,11.5206-5.8984,15.9571-8.2518a40.6561,40.6561,0,0,0,5.3666-2.6741,20.2691,20.2691,0,0,1-2.69,1.3238c6.1493-3.3231,11.1835-5.7269,17.2791-8.9692-2.69,1.3094-5.6644,2.9865-6.68,3.3867-1.3361.5978,7.2222-3.8376,3.94-2.1727-3.6381,1.8787-2.6617,1.4332-5.3264,2.7544A7.8289,7.8289,0,0,1,716.7036,89.048Zm-98.38,51.01c-3.2092,1.5671-8.4921,4.4574-11.9857,6.1644,1.6022-.7216,4.2225-1.9958,8.08-3.9418C614.1176,142.3243,617.2312,140.7572,618.3235,140.0577Zm4.108-1.82c2.3-1.2578-1.0125.4575,1.2873-.8008l-6.6578,3.4429Q617.3582,140.8549,622.4316,138.2373Zm29.1063-15.4565c-3.198,1.6675-2.9151,1.4458-6.6606,3.41l.0276.0533C645.7832,125.8726,651.1213,123.0349,651.5378,122.7808Zm-9.3232,4.7872c-2.1262,1.05-7.4117,3.8433-9.2828,4.868C636.6972,130.4828,642.0589,127.7451,642.2146,127.5679ZM576.9412,161.12c1.0428-.5319,1.5712-.7842,1.37-.641l6.6467-3.4371C585.4858,156.6553,577.1362,160.9128,576.9412,161.12Zm31.9214-16.5411c-.92.5294,1.0782-.4824,3.3061-1.6331l3.1783-1.6547,1.0886-.5768c.2652-.1425.4188-.2343.4188-.2343Zm-15.88,8.4147,10.5948-5.58-7.1165,3.6851-2.5422,1.3428A5.38,5.38,0,0,0,592.9828,152.9933Zm43.85-22.7776c-1.8622.96-5.0906,2.64-2.6489,1.4036l7.9753-4.158c-1.7338.8122.6219-.4274-1.3864.5821C639.46,128.7669,639.5683,128.7917,636.8331,130.2158Zm-62.5159,32.3284c-.1837-.01,2.2606-1.28,5.2327-2.9085-7.8357,4.0313-4.2952,2.4148-11.9318,6.2715C567.1833,166.2347,571.9877,163.7178,574.3171,162.5442Zm13.3519-4.8585c-6.9443,1.59-19.9336,4.3864-23.3257,5.2678l2.92-.6442c3.6226-.7946.4489.005.0245.1172,9.098-1.9976,2.5642-.7435,14.5732-3.3065C581.46,159.1082,587.4979,157.812,587.6691,157.6857Zm13.027-3.3076a32.9469,32.9469,0,0,0,3.8755-.8693c2.0226-.51,4.2037-1.0882,4.8275-1.2757C603.9894,153.5635,605.2578,153.2189,600.6961,154.3781Zm1.7267-5.9625,3.9564-2.1136c-3.6954,1.8767-7.8193,4.0629-5.3677,2.6745-7.308,3.8564-10.3034,5.28-15.9985,8.1718-1.8829,1.0265-6.9174,3.6038-6.5916,3.5438C588.3508,155.4824,595.1028,152.1157,602.4228,148.4156Zm-23.7534,12.756c1.4914-.7783,2.0521-1.0986,2.6307-1.4279-4.9722,2.5509-5.4816,2.68-10.7162,5.3727C571.0507,165.0113,574.9029,163.0684,578.6694,161.1717Zm1.3627-.6034c-3.872,1.9684-9.22,4.6141-14.3053,7.2647l-1.9335-5.4668,3.3227-.7617-3.3307.7229,1.96,5.5408C571.7074,164.8234,578.1262,161.6075,580.0321,160.5683Zm-13.2668,6.9282-.9615.4851-2.0441-5.7794c3.4253-.7275,12.6874-2.7375,12.06-2.7021-3.7573.899-8.9965,1.968-12.066,2.6754l2.0621,5.83Zm45.3528-16.706a25.96,25.96,0,0,1,2.9321-.6084c3.6118-.9918,12.4467-3.269,11.5344-3.1473C617.9868,149.3917,617.0966,149.457,612.1181,150.7905Zm.0223.0872c-5.6407,1.3442-15.009,3.6643-17.3966,4.2878C599.5,154.0436,609.3851,151.6334,612.14,150.8777Zm-29.0317,7.015c.7144-.1315,1.7256-.3347,3.1477-.6374,1.4252-.2873,3.2531-.7157,5.597-1.3157a56.844,56.844,0,0,1,5.7653-1.6061c7.0131-1.717,15.0212-3.6633,17.3641-4.4129-7.6281,2.01-17.7536,4.4282-26.0805,6.53,3.3019-.8224,5.4541-1.337,5.8206-1.3728l-6.6989,1.6656ZM594.6678,153c-5.1976,2.7372-7.6981,4.0583-13.2989,6.8771-2.7713,1.6069,6.7834-3.4769,5.3887-2.6177,4.4769-2.3541,2.0622-1.1335,7.9653-4.1529Zm22.5449-11.8272c-.3336.1238-2.21,1.086-2.6984,1.2943a20.1982,20.1982,0,0,0,2.63-1.4276c-1.7295.8478-5.7834,2.9574-9.3231,4.7874-.7461.3368,1.4763-.9379-1.4.5552-.9639.63-12.346,6.386-11.9042,6.3248-.2983.1133-1.48.7451-2.6638,1.3775,2.3-1.2581-1.0114.4568,1.2819-.7977l-11.9859,6.1641c-1.03.5955-2.1743,1.2481-2.5755,1.5345,6.989-3.5712,14.8628-7.58,22.6174-11.6625,1.1412-.5507,1.7852-.8324,1.4114-.5608L626.61,136.5157c1.7888-.9586,2.6214-1.4459,3.9343-2.17-7.46,3.8812-4.9866,2.51-1.3726.6086ZM641.0762,128.63c-6.618,3.4139-8.1327,4.0928-2.7051,1.2976.0991-.1535-6.9558,3.5022-2.7343,1.2112-4.1548,2.2733-8.56,4.4615-14.5943,7.6486,6.449-3.3412,9.1274-4.636,12.0408-6.0579-2.327,1.177-4.9454,2.5341-6.9958,3.6236a38.79,38.79,0,0,0-3.587,2.0179l7.9891-4.1313C630.9944,133.7838,636.678,130.989,641.0762,128.63Zm6.5972-3.5464c3.5941-1.8715,8.2469-4.1761,9.301-4.8438C654.2225,121.6827,648.21,124.73,647.6734,125.0831Zm9.4663-4.524c-6.7227,3.5021-2.7419,1.33-1.3974.5878-4.1385,2.1852-12.2084,6.3722-14.6386,7.5357-2.4763,1.3406,1.62-.7386-1.2624.8218C649.8314,124.2545,652.5345,123.0618,657.14,120.5591Zm57.1824-29.604-11.9676,6.1887C701.908,97.5137,713.156,91.6587,714.3221,90.9551Zm2.7535-1.1876c1.7649-.9123,1.248-.586,2.69-1.3237a2.6891,2.6891,0,0,1,.3636-.2122l.83-.4418c.6185-.3265,1.2765-.6726,1.4314-.7711-4.82,2.3539,3.5984-1.8767,2.5938-1.51-3.3151,1.759-3.29,1.5442-5.3291,2.722C723.7629,86.17,715.3734,90.5347,717.0757,89.7675Zm25.2638-13.0981c-4.6915,2.4417-7.25,3.8345-10.5867,5.6095-.3547.0558-8.684,4.4585-11.9593,6.2183l-4.9761,2.4962-2.1642,1.0723a4.77,4.77,0,0,1-.92.3971c-4.1017,2.096-2.5162,1.3939-6.6191,3.49a15.9734,15.9734,0,0,0,2.9307-1.403l2.5671-1.3a10.1988,10.1988,0,0,1,1.2316-.5745c-3.9988,1.9772-1.9859,1.1995-6.5778,3.57l14.5834-7.6425-5.3613,2.6706,2.6434-1.4005c3.1327-1.6091,3.02-1.4573,5.3705-2.6418,2.2714-1.2071,2.6391-1.4769,5.2712-2.8613,1.7693-.8494,7.0081-3.6917,8.0167-4.0779-3.481,1.8132-7.2893,3.7864-9.2883,4.8708,3.9734-2.0154-4.3506,2.2914-3.9583,2.1479C732.4591,82.1316,740.0353,78.1038,742.3395,76.6694Zm-6.6882,3.3568c-2.5379,1.2488-6.9188,3.574-7.9615,4.1848C730.4306,82.7733,736.9572,79.4733,735.6513,80.0262Zm-2.7326,1.2445c3.8435-1.96,10.5606-5.1575,10.7245-5.3431a22.0288,22.0288,0,0,1-2.7178,1.27c3.3893-1.7892,6.3848-3.1991,7.978-4.1256C743.21,76.02,735.7822,79.6436,732.9187,81.2708Zm9.2278-4.9745c2.3829-1.2278,3.1034-1.6387,2.6213-1.457-3.1528,1.5973-8.4536,4.3605-8.0442,4.0248,4.0805-2.0856,4.8358-2.535,7.9753-4.158,1.7556-.7457,21.581-11.0667,19.9374-10.3437,2.7635-1.3694,1.1956-.5134,2.7076-1.2654,2.4747-1.3439-.8041.3549-.0688-.1331-5.9045,3.0167-6.58,3.46-10.6031,5.5506-2.0358.9727-5.6217,2.8735-6.6852,3.39-.6474.2071,6.94-3.6378,7.9227-4.2324-4.2034,2.1793-8.0206,4.149-9.3368,4.7609,4.0444-2.0493,6.86-3.66,3.939-2.1718-3.4175,1.9468-8.9547,4.5707-14.5834,7.6426l4.0252-1.9805c-4.1854,2.1489-3.7108,2.0043-5.2712,2.8612.8416-.3885,5.1334-2.65,5.3539-2.7012-8.0656,4.1165-18.6309,9.6616-11.9455,6.2449-2.82,1.4718,7.59-3.9081,9.3657-4.7078l-2.65,1.4039c-1.7422.8746-7.09,3.5342-8.0056,4.0723,2.426-1.12-11.5611,6.1135-9.2553,4.9212,1.4861-.7612,2.0783-1.037,2.68-1.3184-5.99,3.0634-3.8453,2.0079-5.3566,2.6688,2.1313-1.16,8.3518-4.3318,7.9229-4.2321-7.0415,3.6-12.774,6.8949-21.2411,11.0854,1.5676-.8159,3.78-1.9489,3.9814-2.0924-7.3477,3.8068-15.9146,8.3068-22.6149,11.6946,8.3365-4.1494,23.3474-11.9218,33.3656-16.9842,6.9208-3.6514,15.394-8.2268,23.9048-12.4631,1.9925-1.0808,5.8131-3.06,9.2817-4.8674,2.44-1.2634,4.5746-2.1924,6.6743-3.3838-.736.3806-1.5154.7562-.0138-.0267.24-.04,4.5079-2.3215,5.3264-2.7544.43-.1766,1.9208-.9287,1.3865-.5819,2.844-1.48,14.2031-7.3184,10.6281-5.53C763.5281,65.3221,751.9178,71.1013,742.1465,76.2963Zm94.2747-49.157c.4424-.3262,1.2013-.7009,3.9263-2.1991l-5.3154,2.7487c-.2011.1436.2553-.0361-1.3012.7739,2.0372-1.1548-7.424,3.7379-5.3153,2.7487C833.0051,28.8117,834.049,28.3362,836.4211,27.1392Zm-34.6171,17.8c-6.5411,3.337-14.2789,7.3836-21.2742,11.035a7.7806,7.7806,0,0,0-1.3644.6382c-.3792.2746.2689-.01,1.4059-.5579l10.6351-5.5c.5071-.3207-2.0054.95-.0416-.08.5141-.2285,5.3789-2.653,6.6718-3.4159-1.572.8073-3.7756,1.9579-4.008,2.0384C797.7708,47.01,801.9849,44.9982,801.8041,44.9392ZM781.9659,55.502c3.85-2.0009,12.57-6.403,19.9759-10.2964-8.9908,4.6613-1.0362.4523-4.05,1.96C795.0259,48.76,783.9227,54.4037,781.9659,55.502Zm34.6282-17.8057c8.1145-4.3941,21.3562-11.0368,29.2339-15.1852-.2358.0764.5387-.39-2.7491,1.1854-1.8428.9737-.152.2087-2.6075,1.4835-3.1717,1.5364-.7959.3981-5.3154,2.7487-1.37.6413-2.3646,1.0785-5.3952,2.6214a5.02,5.02,0,0,1-.8271.49l-2.0983,1.1159-5.0086,2.6315c1.4429-.8966-9.6689,5.0206-6.7157,3.3036-1.99,1.0349-4.9088,2.5268-5.3013,2.7757,1.8777-.9059.9351-.3135-3.9114,2.2251,1.0362-.5284,1.5591-.7778,1.3588-.6353C812.0168,39.9758,813.7137,39.1575,816.5941,37.6962Zm31.8828-16.5886,9.0455-4.6695L875.94,6.9308l-20.11,4.8825-7.5968,1.8444,7.61-1.7866,19.2-4.5075-17.5479,9.0217C853.8828,18.2426,850.2186,20.14,848.4769,21.1076Zm-68.374,10.673c-5.6366,1.6775-5.3592,1.5426-11.51,3.41l.0256.0863,2.8749-.8582c3.2039-1.0811.5426-.2086,7.1937-2.1332A8.8751,8.8751,0,0,1,780.1029,31.7806Zm-14.3058,4.4949c.6254-.3378-11.3608,3.347-5.7991,1.512-4.0637,1.2249-3.3907.88-7.1919,2.13-.2179.1473,4.86-1.4108,2.9227-.6989C760.2742,37.8563,760.5559,37.8608,765.7971,36.2755ZM711.36,52.96c2.8233-.7732-1.3293.4882-2.8159,1.0462,3.8994-1.1967,6.69-2.0934,8.5521-2.7611-5.1478,1.6382-1.9848.56,1.423-.4739C718.2109,50.7272,716.0107,51.4933,711.36,52.96ZM762.9482,37.22c2.5042-.6931,8.892-2.62,10.0541-3.0328C770.3572,34.9194,764.9335,36.5793,762.9482,37.22Zm-64.3932,19.97c4.1765-1.347,4.3741-1.4094,8.5683-2.7048,1.0646-.4763-8.5982,2.6726-5.7721,1.6017l-4.3106,1.3293C697.9337,57.21,699.1511,56.8941,698.5549,57.1906Zm-2.8867.8214c-3.9466,1.2653-4.9147,1.5209-2.8837.8263l-5.7083,1.8223c1.588-.3784-4.8834,1.64-5.6613,1.9648,0,0-.1647.0381-.4062.1107l-.8983.279c-.6666.2119-1.3728.4453-1.5413.5188,2.6957-.857,1.0053-.217,4.3014-1.2787a9.99,9.99,0,0,1,1.45-.5408l3.4893-1.1469Zm27.15-8.5472c1.251-.27-4.7138,1.6141-1.3633.644C726.2151,48.6667,724.8873,48.8286,722.8177,49.4648ZM794.59,27.9236c-2.517.7168-7.7368,2.2092-7.1848,2.1442C789.8278,29.3988,795.8839,27.6769,794.59,27.9236Zm56.37-8.5394-4.0161,2.0091c-12.0026,6.2678-3.0715,1.6622,1.3672-.6055,1.2814-.6-7.6016,3.9514-2.6351,1.43,3.5039-1.82,4.3448-2.316,4.0215-2.0122l7.7228-3.9643,16.2859-8.36L855.879,12.0292c-6.4944,1.5109-10.9478,2.4729-16.36,3.9062,4.384-1.102,8.3116-1.8576,4.4116-.8846-1.8746.3124-14.7194,3.7461-17.4766,4.3021,4.16-1.1786.8387-.2687,8.7209-2.2191-1.6918.3328,2.2664-.6519,2.8816-.857-5.16,1.2635-9.0394,2.3544-11.6478,2.9018.2993-.1108,1.5977-.4548,2.8961-.7988,3.62-.926,4.5154-1.1,7.2817-1.791,3.1046-.8749-.8825.0952,1.4048-.5741-12.6143,3.1273-13.0261,3.3459-18.8657,4.9427a20.4352,20.4352,0,0,0-2.917.7208c.4693.0272,6.4169-1.7155,7.27-1.8276-4.9057,1.4075-11.0259,2.9067-15.93,4.3168a7.442,7.442,0,0,0-1.4491.3438,1.5419,1.5419,0,0,0,.4032-.0692l1.065-.2595,3.3963-.8661c2.5834-.67,5.4774-1.4544,6.7361-1.8524,5.387-1.4277,3.5443-.7994,8.7462-2.14-2.0049.5363-.1888.15-2.8761.875l-13.8719,3.7076c-4.2621,1.1614-8.2319,2.2995-12.1656,3.4106,2.0341-.562,1.6684-.3992,2.914-.7232l-1.8481.5247c-.5748.1643-1.0138.2934-1.0333.314,7.3989-2.1727,12.7874-3.6441,17.0813-4.7264,4.2877-1.1034,7.4595-1.8892,10.428-2.6929.7-.324,5.0486-1.4371,10.8976-2.9075l4.6344-1.163,5.0164-1.1821,10.3157-2.4715,15.1183-3.6221-13.7586,7.3373ZM825.592,32.2665c1.2946-.5367-4.5922,2.46-2.5607,1.5605,7.5984-3.9576,10.0529-5.1828,14.6081-7.6219-5.1888,2.5938-5.26,2.7231-9.334,4.7933-.0162-.0585,3.6085-1.9087,2.6075-1.4835ZM804.3152,43.2692c2.3557-1.1881,1.7454-.7654,6.688-3.3572.0479-.0677,1.6758-.9135,1.28-.7632C807.2961,41.7634,806.1666,42.1655,804.3152,43.2692ZM756.3964,67.9816c-2.0138.988-7.6091,3.8853-6.63,3.4962C751.7039,70.5273,756.7189,67.9152,756.3964,67.9816Zm5.274-2.8286c-.3851.13,5.1-2.7935,5.274-2.8286.1562-.043-1.9108,1.04.0275.0532,1.8613-1.0165,8.2647-4.234,6.5888-3.5761-8.2693,4.3065-10.571,5.3736-17.33,8.86-4.024,2.1948-16.3474,8.6626-5.1887,3.0207-.4476.1425,2.7359-1.5015,5.2852-2.8342,1.7432-.8212,4.3542-2.1132,8.0469-3.9923C765.4479,63.1445,762.2715,64.9081,761.67,65.153Zm74.4477-38.6c1.19-.486-11.211,5.7527-6.6053,3.517,1.252-.7631,7.7122-3.8978,9.2966-4.8413a9.5693,9.5693,0,0,1-1.3351.6567A10.5687,10.5687,0,0,0,836.118,26.553ZM780.1853,55.308,774.9472,58.22c6.05-3.1588,7.5574-3.8522,12.0007-6.1382l-.0413-.08C780.1534,55.5533,785.0034,52.8068,780.1853,55.308Zm17.2928-8.9426,7.9931-4.0991C806.0911,41.794,799.3291,45.3532,797.4781,46.3654Zm-13.3044,6.88a8.8927,8.8927,0,0,1,1.29-.7682c-1.7182.8423-6.5372,3.3282-6.6429,3.4689C782.4426,54.0491,781.5332,54.6108,784.1738,53.2455ZM712.31,90.3406c-1.1.6335-5.7867,3.0841-7.9542,4.1471C703.4453,95.1152,717.807,87.56,712.31,90.3406ZM671.059,111.605a24.3806,24.3806,0,0,0-2.7041,1.2968c-.2776.2078,1.5237-.713,1.3754-.5759,3.2844-1.7424,6.4834-3.2775,6.6467-3.4371a10.0227,10.0227,0,0,1-1.334.6561c2.2886-1.2525-1.0236.4631,1.2651-.7893C668.9138,112.5507,673.6395,110.2268,671.059,111.605Zm-8.0718,3.9714c-3.5169,1.8088-4.3539,2.2984-3.9343,2.17.7671-.3343,10.3688-5.3273,5.3069-2.7786-.4976.3093-1.5942.8293-.0137-.0264C661.8571,116.23,661.51,116.3818,662.9871,115.5764Zm-12.0006,6.1383c-2.9308,1.5756-8.2023,4.3031-7.9063,4.2914,9.9-5.1338,6.402-3.3289,11.9316-6.2717C650.8835,121.885,648.5643,123.0267,650.9865,121.7147Zm23.96-12.3564c4.1357-2.1907,12.9967-6.7063,14.5944-7.6485C683.2391,104.9663,676.4357,108.47,674.9465,109.3582Zm-91.8436,47.3595a29.9129,29.9129,0,0,0-2.5883,1.5071c.8361-.3855,5.1167-2.6411,5.3474-2.6976-5.2746,2.8384-2.9129,1.61-9.2515,4.9531,2.102-1.0837,4.6207-2.394,4.0282-2.0156,2.32-1.23,6.6254-3.4376,7.9449-4.176-2.2729,1.1769-3.4093,1.7371-4.0116,2.0069,2.6537-1.397,10.743-5.6387,11.9594-6.218-2.3041,1.2225-7.1448,3.6937-6.6054,3.5169,8.95-4.6619,16.7874-8.82,23.9407-12.38.2037-.2011-5.0282,2.5216-1.4058.5581-4.1634,2.1915-3.2486,1.6267-5.3429,2.6953-2.3024,1.3048-6.81,3.5206-13.2906,6.9067-.1861.0123-2.5324,1.2049-.0689-.1332-3.7454,1.9647-3.4625,1.7429-6.66,3.4107A44.8114,44.8114,0,0,1,583.1029,156.7177Zm32.5542-4.1826a10.1216,10.1216,0,0,1,1.44-.4162c-2.2291.6724,4.9354-1.2286,4.3494-1.1323-3.0377.8035,2.0812-.64-1.4836.2726C616.2943,152.2291,613.2024,153.1661,615.6571,152.5352ZM825.0133,31.1472c5.4174-2.804,6.3513-3.1743,13.3275-6.8245C835.1511,26.1693,826.0743,30.637,825.0133,31.1472ZM538.25,111.5181c-3.8425,1.2266,17.4145-5.6421,15.7169-4.949-4.2924,1.38-10.3163,3.4272-11.4183,3.665-4.5192,1.4749-1.9241.8252-8.4861,2.9105C531.1275,113.8534,539.9666,111.022,538.25,111.5181Zm13.681-1.489c4.4429-1.4757-5.6768,1.7814-2.9012.7729l8.5914-2.67c-2.2037.8727-9.1141,2.9573-15.6639,5.1273C542.5221,113.0247,550.2966,110.48,551.9312,110.0292Zm1.7141-4.4594c-.968.41-.9788.3764.046.1429-2.26.7336-5.4464,1.7328-5.6985,1.8619-1.5458.4882-.9819.2523-2.8679.8566.1315-.06.4885-.1788.8133-.2807s.62-.1789.62-.1789l2.8344-.94c-2.3105.637-5.3246,1.712-8.57,2.6854C542.3161,109.1085,547.619,107.55,553.6453,105.57Zm11.6126-3.0236c-9.4374,3.0974-9.3417,3.1542-21.3433,6.9979-.6381.0864,3.2485-1.3658-1.5582.09-.19.0043,1.7333-.6227,1.4023-.576,3.9548-1.2353,13.36-4.3546,12.8506-4.0673-4.0291,1.3264-3.7117,1.1558-7.1436,2.2684-2.0494.6752-3.4556,1.1574-4.2491,1.4576.7429-.14,8.1568-2.5622,10.01-3.0905,2.7186-.9419,4.0616-1.4208,8.5406-2.82.0443.06-2.4312.8777-1.371.6315,4.9083-1.6131,7.1622-2.447,5.636-2.04,5.4044-1.6443,8.5977-2.66,17.1234-5.4492-.1179.1505-.1085.1391,2.9255-.6961C577.0319,98.81,571.663,100.7673,565.2579,102.5461Zm-17.5405,4.1716c2.1251-.6548,3.0862-.91,2.9-.7724a7.537,7.537,0,0,0-1.4086.5148C542.5074,108.5486,551.4941,105.6066,547.7173,106.7177Zm7.114,2.5355c-4.0874,1.2832,2.2868-.7745,2.8545-.9215-.1622.1317-2.0516.7877-5.6719,1.9545a31.5975,31.5975,0,0,1,4.2427-1.4611A9.7127,9.7127,0,0,0,554.8314,109.2532ZM643.18,75.7957c.2478-.1057,1.405-.486,1.3958-.5147-4.92,1.6182-6.0234,1.89-8.5458,2.766,7.1549-2.3133-.7609.4211,1.5093-.2048,4.0483-1.1107,16.8245-5.37,35.6587-11.418l5.7466-1.7191c-7.6742,2.6112-16.8909,5.3257-22.7944,7.4286-4.9828,1.5864-7.6147,2.3591-14.2787,4.5269-1.7172.5143-.5715.1353-.0277-.0856-6.7735,2.2269-10.6711,3.3642-14.2458,4.5872l4.2847-1.3277c-1.8592.6671-4.6407,1.6132-8.507,2.8879a31.0577,31.0577,0,0,0-4.3046,1.3029c2.5229-.91,11.4642-3.762,9.9037-3.4359-5.7861,1.9893-15.8072,4.9671-17.0672,5.6039-4.1417,1.2746-11.83,3.8979-12.8569,4.05-10.3232,3.29-19.7225,6.502-24.2157,7.8533A21.9235,21.9235,0,0,0,572.03,99.13c-8.25,2.6092-13.4238,4.3535-17.1536,5.4117,1.6119-.4821,1.2717-.346-1.3972.5139-.4844.0833.1975-.1846,1.37-.6l11.4106-3.6837L562,102.21c6.4937-1.9777,9.2584-3.0917,17.0842-5.5862l-19.9719,6.361c.9456-.3834,6.3394-2.14,11.4753-3.77l6.9207-2.1691a28.9672,28.9672,0,0,1,3.0048-.8534L597.5971,90.62c-.6456.1817-1.2628.3538-2.8588.8655,4.769-1.65,11.6237-3.7422,12.7828-4.2779,4.7344-1.4411,10.0161-3.2664,15.6783-5.0275,1.95-.6651-.629.1519,2.8127-1.0081.5571-.2563-6.4689,2.1176-4.2939,1.2995,3.5148-1.0924,9.69-3.1076,10.0161-3.0939,4.259-1.403-1.3883.3836-.037-.114,5.9088-1.9271,5.5646-1.7631,9.9706-3.2313-.3932.1917-3.8256,1.3-4.2307,1.4953,7.9511-2.6258,12.52-4.064,19.9456-6.4545-.4247.1917-12.17,3.9595-7.0924,2.3892C650.5419,73.45,645.2384,75.1119,643.18,75.7957Zm-38.4634,12.481c4.8713-1.5693,1.8327-.51,7.126-2.2829a7.78,7.78,0,0,0,1.4321-.4022c-1.3619.384,4.2467-1.4847-.037-.1139C614.9323,84.9751,600.27,89.6387,604.7164,88.2767Zm-30.5142,12.7371c-4.1917,1.2953,5.9666-2.0695-2.89.8071,2.6755-.918,5.7212-1.956,11.3811-3.7808-.9373.3463-3.0433,1.0455-5.6848,1.9058,2.65-.7163,9.9186-3.2329,15.6745-5.0815l.0371.1144C581.278,98.6514,582.49,98.2429,574.2022,101.0137Zm4.7289.0438c2.6824-.9734-.9274.2227-5.7,1.7834-.7788.2078,5.52-1.8646,1.3867-.5431,3.5192-1.2014,8.8352-2.9426,9.9812-3.2039,4.4683-1.4707,1.83-.6774,1.38-.605,7.1091-2.2211,12.68-4.0064,19.97-6.4174-.3907.0615-6.2625,2.0256-7.1473,2.2584,2.861-.9761,8.9492-2.9445,8.5795-2.6606C594.4158,95.86,589.9469,97.41,578.9312,101.0575Zm-3.0062.4071c3.2724-1.0882,3.9-1.25,4.2406-1.5011,5.1384-1.6169,12.3076-4.1095,17.0621-5.6271.0436-.06-8.4766,2.7039-1.4333.4026-5.1132,1.537-8.3365,2.74-12.8326,4.1285-1.0262.153,3.111-1.0356,5.6743-1.9026,6.5928-2.23,2.8225-1.2134,11.2852-4.04-.4186.21-4.9324,1.6606-4.22,1.528,3.9128-1.2889,4.9548-1.7087,9.9415-3.3233,1.664-.3993-5.7132,1.9391-8.5172,2.8927l31.3887-10.0352c-5.1277,1.7285-9.6617,3.1563-12.8293,4.1332-2.0209.7029-1.06.444,2.8788-.84.6285-.1172-5.2993,1.75-5.6743,1.9372-2.8383.8118-8.5109,2.6374-14.2736,4.5413,2.5464-.7206-1.4385.6613,5.7622-1.6507a23.3108,23.3108,0,0,0-2.8741.8389c1.2612-.4963,5.2573-1.6459,5.673-1.9055a23.8538,23.8538,0,0,1,2.8788-.8405L651.361,76.774c-.1139.0817-.2054.1555,1.4476-.374-11.87,3.9439-31.79,10.4249-46.99,15.2719-4.3591,1.55-18.56,6.0646-25.6349,8.3487.0217.0083.4583-.1272,1.0288-.309l1.8321-.5872c-4.3522,1.4927-.0483.1666,2.9152-.6924-2.4986.8687-4.1666,1.3369-7.14,2.2827C578.572,100.6615,581.5447,99.673,575.9249,101.4646ZM596.95,93.48a10.384,10.384,0,0,1,1.4163-.4913l2.851-.926c-.6231.2306-1.2356.4579-2.8325.9831a8.857,8.857,0,0,1,1.4533-.3774L595.572,94.054C593.665,94.5943,601.1644,92.1392,596.95,93.48Zm11.3035-4.0179c1.0833-.47,4.9716-1.6166,7.0984-2.3683a9.27,9.27,0,0,1-1.4653.3808c-4.3879,1.4017-2.71.9672-7.0983,2.3686,3.2827-1.136-.5226.0472-.0648-.2l-8.5331,2.803c3.0376-1.1028,10.8925-3.6669,14.1992-4.77,1.6243-.5214.7975-.2272.0093.0288.2249-.0148,4.827-1.5485,5.7207-1.7944a23.6031,23.6031,0,0,1-2.8233,1.011c5.6687-1.8007,3.798-1.1693,7.1541-2.1963C617.0657,86.4935,613.76,87.756,608.2531,89.4622Zm17.2239-5.1194c-2.5445.8029-.2245.0155-.0278-.0856l-4.2952,1.3311c1.575-.6328,5.5646-1.6848,7.1289-2.3141C632.97,81.8086,626.6517,83.9316,625.4771,84.3428Zm17.407-9.46a9.9631,9.9631,0,0,0,1.405-.4863c5.5213-1.7035-6.8082,2.2387-4.22,1.5239-2.6642.8356-5.7758,1.829-7.1588,2.2247.4749-.1136-4.7489,1.6727-8.5259,2.8308a8.6693,8.6693,0,0,0,1.3873-.5447c6.1081-1.8674,9.2989-3.1895,14.26-4.6252.2084-.1465-3.2239.9669-4.3167,1.2711C638.76,75.9948,640.9493,75.475,642.8841,74.8824Zm9.3431-.2807,4.2916-1.3259L660.78,71.84c1.0558-.4587-1.7831.4233-1.5.2311,6.8276-2.2164,6.7161-2.0452,12.84-4.1017.2932-.0055-5.5911,1.8787.0367.1142-7.7346,2.42-8.5994,2.9144-15.61,5.2779l9.9967-3.1874c-.4772.0286-4.9551,1.63-4.3195,1.2958,7.3226-2.3881,11.4286-3.712,12.8731-4.0177a30.8975,30.8975,0,0,0-4.2476,1.462c-7.5688,2.38-15.0508,4.8474-19.9219,6.5185-1.0378.433,3.931-1.2117,2.8979-.78-8.7809,2.8667-4.3964,1.4921-8.51,2.912-2.118.6168-3.1085.8431-8.5909,2.6232.1018-.0825-.7192.1124,1.3888-.576-2.1947.66-9.5825,3.0417-5.7488,1.7074-.5115.1219-2.5053.8106-2.843.9545a9.81,9.81,0,0,1-1.423.43,10.4194,10.4194,0,0,0-1.4466.4383C633.0161,81.02,648.0613,76.1948,652.2272,74.6017Zm6.0037-.9012c-4.4976,1.4178-3.2186,1.0378-8.5449,2.7645.2891-.1768-5.2862,1.5144-8.5724,2.68-3.2888,1.04,2.4135-.8912,2.8056-1.0655l12.8209-4.118C654.6279,74.7949,657.9106,73.6591,658.2308,73.7005ZM710.4849,58.3l.881-.309C713.321,57.3885,711.9023,57.85,710.4849,58.3Zm0,0-.5058.1754c.021-.0123-.0845.0181-.028-.0059Zm10.9344-3.2788c-5.1843,1.5406-13.252,4.2709-17.1467,5.3664-5.7979,1.8253-7.0815,2.3339-8.5051,2.8834-6.4739,2.0319-15.0991,4.8193-14.2267,4.6677-3.5162,1.1226-6.8658,2.2084-8.5585,2.7151.9617-.3921,6.4634-2.149,7.0881-2.4349-2.1783.589-3.4733,1.1808-7.1248,2.3209,3.6757-1.2647-2.317.6359-7.1607,2.21,3.6894-1.2629,12.7255-4.1294,9.9077-3.4409,1.82-.4872,11.1252-3.5072,17.1293-5.4121-.6046.2311-1.8032.64-4.2591,1.4224,6.0349-1.8708,17.2245-5.433,21.4163-6.8437C709.7383,58.6862,721.6669,54.7916,721.4193,55.0212Zm-27.1337,8.5339c-.9355.3926-9.5338,3.0637-9.944,3.3C690.1528,65.0326,698.4179,62.3187,694.2856,63.5551ZM672.3032,68.54c1.6389-.5164,3.6237-1.1109,1.445-.402l4.2877-1.3164c-.2213.1068-2.5914.86-4.26,1.402C674.4429,67.91,668.8337,69.7314,672.3032,68.54ZM702.429,59.491c-2.1243.7966-7.6709,2.4955-11.4171,3.66l-.0455-.1427c-7.6887,2.4414-5.9416,1.9849-12.83,4.1272.0187-.0212.4553-.1667,1.0247-.3516l1.8214-.5884c1.728-.6388,4.4836-1.5836,11.3749-3.7575-3.2133.992-5.6544,1.72-5.7545,1.6486l5.6907-1.8486c.623-.1328-.9506.387-1.3912.57l5.7015-1.8515c-2.3991.7361-5.0251,1.4875,1.39-.5381-.9154.1768-7.1733,2.3751-5.7183,1.7621,9.8261-3.1577,10.9916-3.515,18.5585-5.8784-.8137.3574,2.7064-.757.0452.1434l7.1232-2.31-4.3069,1.2949c3.7839-1.2112,1.5568-.6777,7.106-2.3857-.682.3107,4.9455-1.4556,1.4756-.3019,5.7881-1.7415,9.5289-3.0077,17.1458-5.3515,4.1823-1.2783.0907.0486,4.326-1.2266,1.1432-.3445,5.2535-1.6962,2.835-.96,9.6434-2.9442,11.3566-3.4221,18.6932-5.4242L742.36,46.7463c.6209-.2177,1.2432-.4357,2.8486-.9328-5.4848,1.5623-10.2113,3.1885-12.8455,4.0754-6.0245,1.8792.01-.0518-.0267-.0862-12.2109,3.8134-22.8578,7.0839-34.2968,10.7593C697.6835,60.8106,693.569,62.3887,702.429,59.491Zm11.7433-2.543c-1.6515.5161-2.5306.806-2.8425.9287-1.3378.399-2.1838.6323-2.88.8145-11.1024,3.6359-22.6257,7.2834-32.7941,10.5033a20.292,20.292,0,0,1,2.8287-.9732c.2234-.1411-5.0615,1.6146-7.1307,2.2634.9369-.27,3.2863-1.0255,2.88-.8326L664.26,72.8626c.32-.1585,2.4316-.8545,5.6765-1.89-3.9128,1.1683-10.9766,3.5573-14.2629,4.5636,3.72-1.368,15.3732-5.0887,21.3687-6.9452a10.8069,10.8069,0,0,1,1.5724-.611c1.2053-.4207,3.3041-1.1176,6.9349-2.2654-.1752.0729-.8846.3047-1.55.5234l-.8931.2968a2.6715,2.6715,0,0,0-.3934.1483c5.588-1.9251,12.4238-3.9083,15.6622-5.0624,4.4721-1.374,9.7292-3.0123,8.637-2.5064,4.3846-1.4059,2.7358-.8855,7.1329-2.2516ZM704.1459,59.987a55.1768,55.1768,0,0,0-5.6887,1.8906l5.716-1.8043Zm4.7138-4.98c-3.1049,1.178-16.588,5.3562-24.223,7.8495,2.62-.8922-.4005.03-2.8927.7972,3.6481-1.2175,8.9283-2.889,13.33-4.2778l5.6341-1.7685c1.45-.4564,2.3654-.7519,2.4331-.7953C703.4668,56.6284,705.6178,56.0739,708.86,55.0072Zm8.9813-1.386c-1.7155.4976-.5731.1284-.027-.0861-8.1039,2.63-16.1132,5.1067-24.2925,7.6188-1.67.5381-1.1913.4376-1.4005.5415-2.8481.8567-1.81.58-5.7,1.82-1.1548.31-2.4254.6589-2.91.74,12.92-4.0884,16.2766-5.1963,27.1349-8.5531-3.0778.9085,1.0443-.42,6.729-2.2161L733.4993,48.53C727.5858,50.5272,727.6919,50.4567,717.8409,53.6212Zm-13.1525,3.1116c1.01-.4045-2.8545.838-2.8845.7848-3.5045,1.1266-18.0757,5.8588-15.73,4.9116,11.4105-3.6558,16.1952-5.1389,22.8582-7.193.6822-.1483-2.0289.7-4.2705,1.4109.9166-.2144,8.797-2.7819,10.0257-3.1018C712.1226,54.4521,710.3094,54.944,704.6885,56.7328Zm-13.223,2.9044c1.8674-.6853,3.7978-1.1315,2.9018-.7691-4.3942,1.4264-1.7734.4578-7.1542,2.2211C685.166,61.5891,695.8483,58.2939,691.4655,59.6372Zm19.6932-2.3041c-3.5312,1.2217-5.5093,1.653-11.4243,3.575.2214-.1068-.3422.0518-1.4589.3975C696.3748,61.8411,708.0771,58.2756,711.1587,57.3331Zm47.8708-17.5345c.9262-.1578,5.9957-1.8234,5.7761-1.5991l-9.8321,2.938a20.5705,20.5705,0,0,1-3.1155.8258c-1.3865.5076-9.014,2.7855-11.4333,3.5861-3.3486,1.0145-.8672.127-.044-.1434L721.83,51.3118c1.114-.3185,1.5565-.4133,1.4612-.3289l-4.2881,1.334c-1.2514.2891,1.2114-.4963,2.8179-1.034-3.3047.95-5.0865,1.5421-10.0109,3.1076,1.3632-.58,10.5035-3.4324,19.556-6.2285,9.0486-2.8085,18.0323-5.4891,19.0262-5.908,8.2327-2.507,15.2576-4.5092,20.1267-5.8851C770.2035,36.5078,763.3615,38.4767,759.0295,39.7985ZM722.6171,53.8317l-5.6951,1.8709c3.47-.9041,14.5514-4.6708,15.7514-4.8109l-8.5692,2.6973L759.85,42.5278c-1.106.3583-1.5267.5266-1.3945.5417,5.7457-1.7,6.9193-2.1938,10.0349-2.9954,1.3248-.4186,2.1556-.7006,2.8459-.9432,7.3637-2.2412,15.5189-4.3647,20.1149-5.8325,2.687-.6124-13.3766,3.885-15.7673,4.7314-14.8945,4.2539-31.9359,9.6692-42.9484,13.0624-1.62.51-.7819.2751.009.0291-9.6942,3.1193-10.8313,3.2328-18.6171,5.6837.43-.1752,3.569-1.16,5.7093-1.8256-6.0588,1.8488-2.4152.6445-4.35,1.1132Zm30.7715-11.9909c1.8055-.45-4.6214,1.4354-2.8217.9875,1.8635-.5339,10.471-3.1859,12.9223-3.7976-11.0031,3.2421-31.88,9.741-42.9921,13.0414l16.062-5.1178C742.1674,45.2134,747.8992,43.4594,753.3885,41.8408Zm-7.7593,5.35c-2.5341.8535-6.2407,1.996-12.8494,4.0449C736.1594,50.1223,741.4217,48.5069,745.6293,47.1907ZM758.77,38.9365a17.8588,17.8588,0,0,1,2.0505-.6921l1.5262-.4847a3.9423,3.9423,0,0,0,.6869-.2523C769.0155,35.7591,761.8905,37.9817,758.77,38.9365Zm13.6068-1.5255c2.3412-.5922,9.7656-2.7206,14.4384-4.017-1.8265.4811,3.4318-1.1445,9.2413-2.7526l8.2661-2.293c2.3338-.636,3.9707-1.066,4.085-1.0572L778.181,35.9c-1.6772.4916-1.1959.4038-1.4136.5038-5.6357,1.6479-9.1289,2.6825-11.5073,3.32.229-.1052,2.6085-.805,4.288-1.3113-.4551.0934-3.5912,1.0458-5.7408,1.6825-1.9246.54,9.48-2.8714,8.5614-2.7124C774.0045,36.9,773.1709,37.1741,772.3771,37.4111ZM782.92,30.7136c-3.5756.99-5.6768,1.5031-7.2076,2.0916a22.8221,22.8221,0,0,1-2.9048.7206C777.1342,32.3217,786.8829,29.3766,782.92,30.7136Zm14.5566,1.8845c-6.2816,1.75-6.6125,1.9235-10.071,2.8428,3.6826-1.1988,8.5132-2.4507,14.3584-4.1377C807.2394,29.83,794.3539,33.36,797.4763,32.598Zm-7.769.0506c6.0414-1.7762,6.3311-1.7368,10.0969-2.79C802.1526,29.212,788.5126,33.1008,789.7073,32.6486Zm33.4814-13.9005c.3965-.0143,4.3865-.9913,9.1981-2.1989l7.489-1.8866,6.6788-1.5618c-6.2377,1.49-12.4595,3.1243-23.3048,5.8792.234-.0986-.3312.0341-1.4542.3284C827.8586,17.6281,818.923,19.9844,823.1887,18.7481Zm4.4646-.7531c1.704-.4386,1.2064-.3635,1.4341-.458,5.2161-1.312,8.4141-2.12,13.1227-3.249-2.1232.5845,6.1631-1.4154,13.4662-3.1467l25.1576-5.9639L857.8391,17.05c-4.4619,2.3038-8.5224,4.3832-9.0864,4.59l9.0452-4.67,22.8-11.7714-24.9011,6.0294c-3.4556.8367-6.2432,1.5181-10.5312,2.48.2013.0237-2.583.6636-5.8386,1.4641l-8.7512,2.1405c-2.5813.68-.1938.1055.0224.0873-3.1251.8686-3.0211.5455-7.325,1.6668C823.8369,18.8121,829.9315,17.3359,827.6533,17.9951Zm20.1432-1.4663c2.2094-1.2211,4.9206-2.6887,5.205-2.9621l2.4122-1.2063,1.4378,3.9285c-4.0915.94-9.6085,2.2979-14.8542,3.4769,1.8218-.4331,4.2174-1.0793,7.2684-1.7589,2.0315-.494.1175-.0823-1.4689.2874,1.2666-.3616,5.0147-1.28,9.0031-2.2318L855.52,12.5668Zm6.0169,1.2293c1.6558-.3878.81-.1617.0068.0291-.2281.09.3316-.0239,1.4621-.2861L846.5847,19.6c-.6295.085.9737-.3133,1.4146-.46C850.705,18.4676,852.8765,18.0731,853.8134,17.7581ZM808.84,35.7281c-2.2466,1.0948.1023-.0956-.055-.1063-2.9781,1.5629-5.73,3.0871-9.2956,4.8406,13.96-7.3619,30.5941-15.9482,51.82-26.9325-1.5443.9558-8.1394,4.2672-11.9317,6.2716a30.8479,30.8479,0,0,0,4.0253-1.98c.267-.0651-4.7137,2.4531-6.633,3.4636-.1571-.01,2.1906-1.2-.055-.1063-9.4207,4.998-19.4312,10.13-26.6088,13.76,1.4686-.662,4.0939-2.0052,8.0166-4.0781a18.1164,18.1164,0,0,1-2.6149,1.437Zm37.584-18.5912c2.9324-1.44-9.0406,4.8582-10.603,5.5508,3.3683-1.8706,7.5877-3.9539,10.5618-5.6306C850.87,14.75,842.2815,19.37,846.4236,17.1369Zm-69.022,36.0646c21.3724-10.9891,40.1046-20.8,57.2281-29.5264-6.3911,3.44-10.0266,5.1794-13.28,6.9008-1.8223.986-.3284.24.069.1335,8.849-4.6447,14.18-7.31,21.2824-11.0056a6.6374,6.6374,0,0,1-.95.5508L839.44,21.4755c-1.7706.9269-3.7766,1.97-4.6726,2.4661-6.2394,3.1108-7.2185,3.7631-14.65,7.5418.5173-.062,12.2971-6.3068,10.7482-5.3217a30.873,30.873,0,0,0,3.9427-2.14c3.9957-1.9833,1.8978-.7885,8.0855-3.9449-.1621.1892-8.1144,4.2612-8.0029,4.1047,6.5427-3.32-.7277.2366-6.6743,3.3839q2.7829-1.3061,8.0718-3.9715l-18.5757,9.741c-.4.1526,1.2322-.6954,1.2911-.7689l-10.628,5.53a23.3835,23.3835,0,0,1,2.6114-1.4515c-.881.421-3.0673,1.5508-2.6941,1.2916-2.3456,1.2211-3.0181,1.6188-2.6075,1.4835-2.9278,1.4755-5.4706,2.7418-10.6694,5.45,2.1631-1.1774,9.2426-4.9457,11.9318-6.2714,1.4466-.7562.8816-.523,2.6351-1.43-5.0812,2.4841-13.332,7.0658-21.2548,11.0589-.364.277,5.1631-2.6436,4.0392-1.9535-5.8856,3.1184-9.3691,4.8859-17.2747,8.9667l5.26-2.8553L744.408,70.905c-1.2071.4261,18.7767-9.7491,15.8981-8.39.087-.1088,5.6923-2.9352,4.0355-1.985,3.58-1.8887,7.5892-3.951,10.6555-5.4767,6.7043-3.6055,15.0309-7.9726,25.2362-13.1514,1.5862-.8585,2.3638-1.3191,6.619-3.4906-.4948.2115-2.3595,1.167-2.7039,1.297-3.5015,1.8005-.9864.6411-5.2852,2.8344-2.8859,1.29-7.3888,3.5424-16.0949,7.9852-1.2646.7114-3.6449,1.9716-7.9505,4.1788C778.7543,52.6223,774.8585,54.6,777.4016,53.2015Zm47.7811-24.9786c-4.023,2.0392.1447-.2228,3.9525-2.1457-.7757.3311-3.8433,1.8787-1.4.5554-1.55.7958-2.3569,1.2266-2.6489,1.4036-3.5494,1.7868,4.8621-2.59,2.58-1.5369,3.2926-1.5933,6.4788-3.2836,10.6831-5.4232-4.5833,2.4935-2.0037,1.2195-6.6027,3.5494-2.9644,1.5379,1.7607-.8253.0689.1332C829.8128,25.7411,826.3715,27.5493,825.1827,28.2228ZM795.0721,44.9756a23.5779,23.5779,0,0,0,2.7039-1.2972c1.4866-.6816-8.2263,4.3085-3.9525,2.1457-2.8246,1.436-12.9924,6.7416-17.33,8.86C779.6951,52.863,787.5356,48.9471,795.0721,44.9756ZM722.8928,84.6989c1.7325-.7629-3.0982,1.703-6.6163,3.523.0947-.0967.1882-.193-1.3727.6083C716.6312,87.8727,719.3086,86.63,722.8928,84.6989Zm-37.42,15.6695c.1639-.1584,3.326-1.7922,6.6192-3.49-2.8124,1.3535-6.9753,3.652-11.9731,6.1916,6.7878-3.7483-13.3814,6.8235-18.6887,9.4954.4314-.228,3.4258-1.92,2.1815-1.2749,8.2927-4.4191,23.3814-12.0407,36.3177-18.8365-.0356.0508-1.6244.8661-2.65,1.4042-.5078.3438,2.4553-1.1964,1.39-.55-2.9006,1.4086-4.0017,1.9717-9.3381,4.7612-.3319.26.5583-.1428,4.05-1.9592,1.8575-.9724.0888-.1054-1.3589.6351,5.2347-2.7715,9.62-4.8251,15.967-8.257.2607-.0527-8.1865,4.4125.0689.1333C703.6011,91.0125,691.2923,97.4161,685.4725,100.3684Zm2.58-1.5364c-4.6807,2.411,3.283-1.8236-1.3976.5874a3.9274,3.9274,0,0,1-.6274.3755l-1.4078.76a17.6632,17.6632,0,0,0-1.88,1.0584C684.5336,100.729,686.7646,99.5525,688.0527,98.832Zm-17.3578,15.3592c.8043-.4878,8.1713-4.2573,9.31-4.8146C678.9693,109.9214,673.5974,112.7456,670.6949,114.1912Zm-32.0937,12.915c-1.4662.8-1.13.6538,1.3589-.635-.9061.5571-7.5756,3.95-7.924,4.2327l13.44-6.9178a84.7834,84.7834,0,0,0,7.7612-4.2483c5.5893-2.8275,1.1856-.28-3.8574,2.3323.9884-.5962-8.5026,4.3854-7.9641,4.1526l-21.3376,10.8989c4.9174-2.562,14.9507-7.7554,11.8892-6.351-1.7832.9556-2.6258,1.4481-3.9388,2.1721-.5691.2524-1.5554.7061-4.064,1.9327-2.0908,1.2357-17.1252,8.8946-22.589,11.7148,7.866-4.2091,8.24-4.2964,17.2873-8.94C617.4832,137.8212,628.943,132.15,638.6011,127.1062Zm36.0146-18.3876c.5052-.1369-4.8136,2.5914-7.9338,4.2381.0283.0018.4395-.2043.9725-.4766l1.7039-.8738c4.1536-2.1045-3.749,1.9821-3.984,2.06.5731-.3263,1.1447-.6527,2.6361-1.431-2.8937,1.49-7.9654,4.0441-13.3292,6.8593C659.3261,116.5631,669.9125,111.192,674.6157,108.7186Zm-25.3,16.2917c2.0336-1.0014,2.0858-.9276,6.7017-3.3306a2.0565,2.0565,0,0,1-.2714.1583l-.6664.3529-1.7012.8871a10.0981,10.0981,0,0,0,1.3463-.6624c4.0966-2.0543-7.6958,3.9839-2.6913,1.3242l-6.6467,3.4371c-4.59,2.5865-10.6776,5.5914-15.9808,8.23C634.9818,132.42,644.7111,127.5406,649.3161,125.01Zm-6.52-2.843c-.5318.3518-17.11,8.8854-19.8934,10.4559-1.2916.605,3.938-2.149-.0551-.1066-.246.0541,4.7138-2.4529,6.644-3.4694-1.6242.7062-6.5853,3.4226-10.6683,5.449-.6114.2523,1.725-1.0953-2.7326,1.2445,1.7408-.986,8.6843-4.5123,6.6879-3.3574,5.2637-2.8242,10.3659-5.3193,18.5922-9.6821-.2213.0748-2.436,1.2311-3.9966,2.0332,3.6165-1.9722,6.9866-3.5215,13.317-6.853-4.6043,2.4772-11.3748,6.02-19.896,10.4237C631.3071,128.1533,638.4828,124.3833,642.7966,122.1674Zm-6.4432,10.3564.0276.0535,7.9532-4.1464c-1.6058.9266-11.5236,6.05-11.976,6.1589ZM616.578,150.1152c-3.3358.8037,2.7052-.7642,8.6461-2.375-.2258.0964.3434-.0367,1.4608-.3284-2.0718.6219-6.5736,1.8134-11.19,3.0443-4.63,1.1706-9.3878,2.3239-11.93,3.0605a10.0773,10.0773,0,0,1-1.4593.3287l-2.9042.7158c5.5053-1.4442-2.7927.6635-7.2715,1.7C599.1,154.3568,605.2146,153.05,616.578,150.1152Zm86.4164-24.191c-3.3393,1.0347-6.18,1.8633-7.1782,2.0939-4.6575,1.5525-9.94,3.0127-18.6373,5.5916-1.5613.3,12.6539-3.8405,7.1725-2.1086,2.3145-.6771,4.7758-1.5415,1.4018-.5435l14.4653-4.3495c5.9739-1.8336,11.67-3.56,12.7634-3.837C707.4424,124.4994,703.99,125.4749,702.9944,125.9243ZM630.952,145.9908c4.07-1.1144,3.7472-.9588,7.2228-1.9011-.572.2128-5.588,1.5194-4.2933,1.2727l-5.7978,1.4887C629.5995,146.3955,633.82,145.3675,630.952,145.9908Zm63.643-16.7944c-6.4364,2.0261-12.0047,3.6885-21.4847,6.504,1.856-.6383,10.58-3.1759,11.4382-3.5378-.959.1924-3.0489.94-5.7354,1.7112C682.3905,132.6805,688.63,130.9706,694.595,129.1964Zm34.2412-10.8958c-.2193.1138-2.5974.8334-4.2827,1.3615l4.31-1.2756c4.62-1.43,1.0621-.44,5.6821-1.87-.2213.1069.3358-.051,1.4457-.397-.3761.1844-6.3125,2.0155-5.6838,1.9023,5.2186-1.5988,12.9173-4.2,19.9465-6.4391-3.6,1.2424-9.3654,3.1507-19.9194,6.5251,1.4-.381,5.4987-1.6813,10.0016-3.1185-2.1589.7693-6.3366,2.0844-10.7376,3.4606-4.4056,1.3607-9.0448,2.7475-12.1033,3.742-4.6234,1.3763,7.4357-2.3011,5.699-1.8575-2.4094.6619-13.18,4.0956-15.75,4.8108,5.3992-1.835,15.9269-4.9394,20.0107-6.2234-4.5648,1.3383-17.1832,5.1448-18.6063,5.6942-3.045.9572-2.73.8-2.8777.7965-5.5905,1.7937-5.333,1.64-11.471,3.4686.4553-.0057,7.61-2.2007,7.2305-1.968-2.3826.7482-4.777,1.4557-7.17,2.1692.5627-.0717,12.3209-3.6093,11.4717-3.4691,2.7012-.8322,1.0062-.2077,4.3091-1.2391-.706.313-9.3112,2.96-14.2814,4.4483a12.7754,12.7754,0,0,0-2.3817.5739c-1.603.4505-4.0941,1.1854-7.71,2.2806a54.855,54.855,0,0,1,5.7093-1.7972,22.7075,22.7075,0,0,0-2.6509.6917l-5.9781,1.7576c-4.5267,1.399,1.8368-.36-1.3874.6331l-11.5031,3.2751c-1.31.381-3.7921,1.217-1.4186.5286-2.1553.6979-4.66,1.2422-5.7839,1.5208-3.8326,1.2087-9.1932,2.5939-11.5276,3.2177-.5124.202-3.6982,1.1071-6.778,1.9843-3.0743.8986-6.0711,1.659-6.1575,1.7594-2.98.7783-10.0306,2.733-8.6823,2.26,8.1912-2.21,10.6958-2.9216,18.72-5.2417-3.3055.9051-4.0063,1.1366-7.217,1.9476,4.5549-1.2967,8.7407-2.5584,17.2558-4.9288-1.3015.5005-.928.3878,2.93-.6464,4.8179-1.3994.6993-.2568,1.3987-.554,4.5349-1.3231,5.108-1.358,10.07-2.8735,2.5109-.8276,2.3625-.7267,5.7188-1.7686a37.1805,37.1805,0,0,0-4.3174,1.2256c-2.3825.618,4.37-1.3688,8.5859-2.6558a20.4418,20.4418,0,0,1-2.853.914c4.8716-1.3047,10.4982-3.1678,15.7585-4.7643-3.0707.994-1.6657.6346,1.4493-.3383,3.0394-.8051-7.0506,2.0922-7.13,2.2522,2.1007-.584,8.6879-2.61,10.0577-2.9208,1.5782-.5888,14.301-4.55,11.4385-3.5393C716.7985,121.92,722.9952,120.0245,728.8362,118.3006Zm-45.8223,13.9125c-2.665.7372-5.028,1.5494-7.1514,2.2278,1.4581-.4386,2.9429-.7427,4.3152-1.2562C675.4269,134.5554,682.5807,132.3793,683.0139,132.2131Zm-52.0073,13.98c4.3945-1.1769,5.6342-1.4415,8.685-2.23C639.2389,144.1071,629.2631,146.8346,631.0066,146.1935Zm21.9916-4.6378c6.8975-2.0563,9.6359-2.7578,17.26-4.9737a16.5527,16.5527,0,0,0,2.8856-.7665c2.283-.6119.1818.0248-2.6914.8813-2.8824.8231-6.5411,1.85-7.3481,2.108-2.3212.52-12.6841,3.5945-17.31,4.8007a3.4242,3.4242,0,0,1,1.4041-.5867C650.2867,142.2139,650.378,142.1563,652.9982,141.5557Zm6.692-3.8379c-4.1851,1.1217,2.2166-.5916,1.4189-.4352-.4558.0876-3.6115,1.0017-5.76,1.608.1675-.1034-1.7776.44-1.4659.2924,3.6163-.9838,5.66-1.535,10.0715-2.8344-.3988.1953,5.5775-1.5624,4.34-1.11-1.7582.4907-8.869,2.5286-4.2986,1.2545C663.5831,136.6392,660.1185,137.625,659.69,137.7178Zm19.6757-1.9742c-1.69.4993-1.2247.3082-1.4572.3406L670.6,138.3109l-8.5055,2.4035c.8066-.3272,6.5256-1.9276,11.3182-3.35C678.2073,135.9487,682.1135,134.84,679.3659,135.7437Zm-18.3229,1.3085a8.9363,8.9363,0,0,0,1.4142-.4959c6.8905-1.7893,11.1143-3.3491,18.6744-5.3779-4.8035,1.4366-7.5642,2.32-10.0378,2.9634-3.6131,1.0881-2.5206.8315-1.39.54C666.3839,135.7263,665.1931,135.8564,661.043,137.0522Zm24.5128-6.7555c1.27-.4034,3.2217-.9951,5.7235-1.7389-1.944.6336-4.5911,1.4926,1.4751-.3151-.1174.1158-5.5862,1.7114-5.7039,1.8272-1.5658.4594-.9977.2355-2.8876.7987l4.2877-1.3419c-1.2609.33-2.1737.5494-5.7531,1.6228a.7774.7774,0,0,1,.1639-.067l.4243-.1432,1.2192-.3856C685.3458,130.2959,686.0607,130.0946,685.5558,130.2967Zm57.21-17.56c.2211-.1071,2.5914-.8509,4.2728-1.3909L721.361,119.488c-3.2278.8195-24.5837,7.4868-18.7,5.3463,4.2805-1.3241,6.0172-1.8055,7.1765-2.0952,8.21-2.6511,17.3049-5.1952,22.8378-7.1709.8527-.2108,3.741-1.1144,6.4058-1.9421l3.5475-1.0885a8.705,8.705,0,0,1,1.5186-.398c2.4485-.7776,3.701-1.2006,4.2636-1.419-1.22.341-3.6169,1.0825-7.1438,2.2092,4.8032-1.6927,16.2637-5.0761,17.0685-5.5607,6.6254-2.1147,21.16-6.7141,19.927-6.4686,3.5506-1.1328,6.1655-1.8568,4.33-1.2162l-15.2766,4.9079c-4.8581,1.5639-8.6409,2.8008-8.8242,2.9458l-.0922.031.0927-.03c-.0206.0175-.18.0765-.0834.0583,1.55-.5091.8422-.3024.0834-.0583l0-.0013c8.572-2.907,10.51-3.2453,17.04-5.3411C766.7549,105.28,755.7817,108.6623,742.7656,112.7366Zm11.5848-3.1182c.25-.1751,7.8353-2.5709,11.3569-3.7593-1.2547.316-2.1424.66-5.6984,1.8185.1568-.1072-1.77.5078-1.4617.3483,7.1938-2.2206,3.21-1.0811,8.514-2.89a9.901,9.901,0,0,1,1.4223-.43,10.35,10.35,0,0,0,1.4341-.4342c-4.2078,1.4367-5.8226,2.1437.0926.2858C766.8571,105.6921,759.4582,107.919,754.35,109.6183Zm-31.371,10.0283c-1.0029.3027,6.4085-2.0276,9.9577-3.2488.3174-.0471-2.4145.8495.0272.086C731.8263,116.9238,725.4653,118.9478,722.9794,119.6467Zm29.9407-9.5421c-1.1817.5429-6.27,2.0261-11.3715,3.7115-1.1218.3289-1.5526.423-1.4756.3438C745.188,112.6,747.331,111.9017,752.92,110.1046Zm-21.3355,6.9437c6.2618-2.0121,5.8283-1.8484,9.9641-3.2322-.38.1927.37.0005,2.8807-.7905-3.9592,1.3389-9.2634,2.8259-12.8176,4.1091C729.4837,117.7979,732.1564,116.9209,731.5846,117.0483Zm6.9913-2.6956a20.3043,20.3043,0,0,0-2.8741.8511c-.2858.0229,8.3194-2.6959,8.5731-2.6638Zm35.84-10.7842,15.6265-5.2094c.4148.0166-6.2835,2.1877-8.4838,2.9853-4.73,1.4507-11.7579,3.83-15.7037,4.9715C755.6516,109.69,771.5474,104.36,774.416,103.5685Zm38.0223-13.7812-5.6939,1.8741c.7388-.3293,10.9575-3.73,1.3963-.5541,1.1931-.4654,7.36-2.5363,9.9321-3.3348C819.2778,87.4993,811.2222,90.0674,812.4383,89.7874Zm5.5779-2.1855c-4.1432,1.3233-7.0756,2.2131-8.5934,2.61C815.211,88.3134,815.39,88.3922,818.0162,87.6018ZM876.8986,70.07l5.66-1.9064c-2.457.8784,1.09-.2985-1.3733.5814-5.3386,1.7924-3.1377.916-7.1409,2.2413A22.8265,22.8265,0,0,1,876.8986,70.07Zm8.4787-2.9346c3.9644-1.44,8.134-2.5189,12.8057-4.21,1.8453-.5538,4.7049-1.478,8.5694-2.7368-.991.4195-8.0242,2.6758-4.2358,1.5547-3.7944,1.183-10.9163,3.6373-12.8066,4.21-3.97,1.3462,2.108-.614-1.3734.5811-2.9579.9933-3.7789,1.23-5.7024,1.8572l7.0569-2.4952c-.0187-.0565-3.8757,1.2433-2.8611.8212l4.2583-1.41C890.7244,65.3727,888.6141,66.0552,885.3773,67.1357Zm90.8662-30.6525c3.5387-1.0919,7.7057-2.3922,14.3516-4.37,12.6668-3.82,31.2458-9.5117,7.192-2.106,1.2455-.35.8648-.175,2.9011-.7809-2.7717.8711-17.7688,5.3328-20.1247,5.9659-4.4215,1.3934-2.3779.9019-8.5552,2.8073.222-.106-.3426.0514-1.4388.3881l3.4875-1.1415,1.5506-.5147A3.3215,3.3215,0,0,0,976.2435,36.4833Zm10.0547-2.98c2.9861-.9191,9.4513-2.8114,10.04-3.0587C995.1391,30.7792,985.0963,33.7484,986.2982,33.5029Zm12.7832-4.3873c-9.7829,3.0152-14.7311,4.3707-22.9807,6.9095,1.75-.6783,4.1669-1.294,7.1755-2.2176,2.7953-.8982-2.2926.5228,5.6855-1.86-3.9483,1.2816,1.516-.3049,7.2117-2.0492C995.7241,30.0969,996.5046,29.8969,999.0815,29.1157Zm9.295,6.5181c-.7743.5956-.5241.4191.3236-.3342l4.0191-3.5945,11.4431-10.2341-14.74,4.499-7.472,2.2807c1.4128-.4741,4.3046-1.3619,7.4593-2.3236l15.09-4.6-11.75,10.4106c-1.7331,1.5355-3.5264,3.23-5.1669,4.59-1.6433,1.3549-3.0534,2.5257-3.894,3.25-3.1749,2.4612-1.0139.6352-4.8979,3.6245,1.1872-.9947,2.3549-1.8694,3.8548-2.9788C1004.139,39.1028,1005.9165,37.6574,1008.3764,35.6337Zm-80.0607,50.93c1.9372-1.0151.25-.0613-2.7084,1.5956L915.2347,93.91c-.93.3737,6.0689-3.421,10.4725-5.8531-20.3456,11.1531-35.459,19.1241-54.27,28.9207-1.2467.6168-2.0427.99-2.71,1.2934-4.7376,2.4344-4.7977,2.5719-10.6334,5.5236,1.1112-.6155,3.32-1.7625,6.6489-3.4524-2.142,1.0222-9.3539,4.7539-12.0619,6.051-2.4813,1.256-.7822.5079-2.6258,1.458-4.0076,2.0254-5.6536,2.77-6.7506,3.2491-1.9206,1.0139-6.8636,3.4582-10.7353,5.3713,7.4451-3.8234,9.9218-5.0872,20.0576-10.1855-1.5942.8478-.5008.3054.0406.0806,12.782-6.5187,18.1649-9.1237,32.0287-16.4256-.2324.0813-2.4371,1.24-4.0189,2.0571.1133-.1506,4.4366-2.3634,7.9561-4.22.6933-.2546-4.5446,2.4766-1.2692.8384,3.5474-2.0109,8.1763-4.38,11.8652-6.4382,17.7634-9.2822,32.9236-17.8539,47.2538-26.1736,3.4424-1.7126,13.0286-7.6923,16.8972-9.8093,1.178-.7472,1.9133-1.2357,2.52-1.6491,7.8214-4.7221,15.44-9.51,23.153-14.8029a210.1679,210.1679,0,0,0,23.4982-18.2156l10.1014-9.2641-13.1624,3.9393-3.1568.9448,3.1494-.97,12.8654-3.9637-9.7788,9.3333c-17.611,16.8085-55.1151,38.7437-78.937,52.2128C933.9268,83.4841,932.0068,84.5049,928.3157,86.5633Zm81.96-53.4316c-.0557.08-1.2511,1.2-2.7272,2.45L1003.28,39.06c.491-.448,1.48-1.2865,3.498-2.9309,1.38-1.1345.9652-.8553,1.1313-1.0432C1013.8271,29.8221,1004.5627,38.2455,1010.2758,33.1317ZM803.1034,151.2545c27.6539-13.38,56.718-27.7157,77.8513-38.7236C857.3449,124.9652,829.35,138.7755,803.1034,151.2545Zm-19.0259,7.4977c2.071-.5061-4.8055,1.5791-4.23,1.5062l-7.127,2.22c.0136-.02.4473-.1607,1.0166-.3412l1.831-.5771c-.2806.0617-1.4363.4159-1.4451.3871a10.2275,10.2275,0,0,0-1.42.4736c-4.1362,1.2712,2.1805-.7282,1.4025-.5311,3.4566-.9982,5.3568-1.605,7.1231-2.25Zm110.0257-38.8015c8.2531-3.1447,11.8044-4.2483,21.09-7.6942-1.3947.5515-3.78,1.4418-4.176,1.6512-1.6149.53-9.9269,3.66-11.28,4.02l-8.4084,3.1635c-2.9329,1.0592,2.0566-.8337-2.8461.9394-2.0823.762.574-.1656.0306.0846q-5.1034,1.79-7.0875,2.3883c8.2-2.8919,7.3713-2.6777,7.0057-2.6141C893.5259,120.0059,889.6563,121.5873,894.1031,119.9507Zm202.7495-74.812-32.8811,11.7634c-3.4463,1.2656-.2638.202,1.4391-.4312l-8.408,3.1749c-.4177.1013,1.3107-.535,1.3772-.6l-7.0367,2.5768c-.5309.2711,6.4012-2.3619,4.2512-1.4608-20.1736,7.4257-30.8895,11.73-51.9127,19.4351,1.802-.7154,7.85-3.0222,8.4318-3.1334,2.2009-.8315,1.1675-.5345,5.589-2.141-6.0938,2.147-18.46,6.7672-22.5448,8.1229-4.603,1.7142-5.3388,2.0768-11.2075,4.2327,3.6764-1.41,3.4779-1.4171-2.8348.9588a11.1909,11.1909,0,0,1,1.8087-.7584l4.2617-1.5811c3.2164-1.1817,6.741-2.4724,7.9195-2.9927,4.2959-1.559-2.0162.8724,1.4571-.3818,4.1334-1.5779,9.2326-3.4292,12.6572-4.64,2.32-.8585,4.7688-1.9691,5.6-2.1127,5.2589-1.9794.0547-.1323,2.7581-1.1848l5.6216-2.0891c-2.0424.8388-2.9608,1.2345,1.4265-.465,4.3434-1.5753-3.0292,1.1735-2.78,1.1276,4.86-1.6869,6.47-2.5006,11.2065-4.2437-4.7095,1.8489,3.3559-1.1544,5.656-1.9638,3.7985-1.433-2.98,1.0251-4.2381,1.4715,5.7666-2.2276,12.8772-4.6443,18.2548-6.77-1.1917.3991-1.8828.6038-1.4543.3725,5.6928-2.0964,6.5034-2.2942,9.8948-3.4954l7-2.6592c-.963.3845,1.9957-.6586,5.4782-1.9126,3.489-1.24,7.5006-2.6934,8.626-3.1689-2.1583.684-6.1909,2.2527-9.868,3.562-.5518-.0162,9.3535-3.41,12.67-4.6037,3.9189-1.5037-7.973,2.7788-8.52,2.8795l10.6277-3.8475,5.105-1.84,2.504-.9008,3.6692-1.28,33.0358-11.3873c-2.936,1.1088-14.6836,5.1288-12.6614,4.5059l-10.87,3.6754-6.9541,2.39-3.4431,1.2029-1.657.5856-.9851.37,18.9777-6.4855c-3.0338,1.0961-10.6933,3.732-7.4538,2.7377l-11.3493,3.9011c-1.7669.6115-3.3336,1.1584-5.751,2.08.7061-.2183,2.4663-.8665,4.0561-1.4434l2.1036-.7493.917-.2981A1.4654,1.4654,0,0,1,1096.8526,45.1387ZM986.96,86.1669c6.0547-2.4041,10.3231-3.81,16.8265-6.2894C1002.2478,80.6011,993.5408,83.6582,986.96,86.1669Zm28.0475-10.491c4.103-1.5534,4.3147-1.6321,8.4317-3.1334C1020.007,73.9459,1005.16,79.235,1015.0071,75.6759Zm7.1-2.4144c5.3545-1.8619,7.9253-2.9946,16.8407-6.2632-.7537.3158-5.01,1.9456-9.0553,3.4639l-5.4449,2.016A17.9819,17.9819,0,0,1,1022.1067,73.2615Zm91.4125-17.4269c-.9323.4883,8.1617-5.5443,13.4308-9.0887C1122.8408,49.5353,1121.2228,50.7047,1113.5192,55.8347Zm-33.3068,20.6679c.1716-.1806-3.0741,1.8946-5.0984,3.1428,4.4443-2.8691,6.9835-4.5322,13.7382-9.0773-1.4777,1.1007,4.0493-2.669,2.5622-1.5622C1087.7716,71.3849,1082.5883,74.8387,1080.2124,76.5026Zm-11.1739,7.5493c-2.73,1.7936,2.3083-1.6568,3.6762-2.5924-.36.1652-5.4817,3.6408-6.2618,4.0978.8857-.6707,6.9819-4.6636,9.9538-6.6647C1075.8585,79.3961,1071.7627,82.1613,1069.0385,84.0519Zm-10.1777,75.2234c-.62-.1389,1.02.0482,1.4965.0458,7.0657.79,6.8724.7947,16.33,1.5129C1074.41,160.7762,1065.2784,159.9856,1058.8608,159.2753Zm43.1514.1876c3.9816-.0358,11.6731-.121,19.2749-.6064C1115.1121,159.3428,1107.045,159.4979,1102.0122,159.4629ZM132.4438,98.59l9.8086-3.3773a27.9116,27.9116,0,0,1,4.4357-1.3245l-9.9143,3.4359C139.2552,96.2532,128.6412,100.0645,132.4438,98.59Zm297.273-23.2562c-.483.0583.1927-.1716,1.3954-.5323,5.6105-1.5875,8.38-2.1458,14.4665-3.8539C442.6021,71.8876,436.4939,73.4193,429.7169,75.3343Zm2.6-1.821c-.2071-.02-.26-.0793,1.4-.5645,2.7556-.7321,2.6337-.6226,7.2464-1.8834C438.5223,71.7712,437.4,72.1436,432.3167,73.5133Zm34.7361-9.16c4.6774-1.1017,6.4493-1.6226,14.512-3.6558-.1646.0969,1.7988-.387,1.4814-.2484-2.7716.7095-6.243,1.58-5.7809,1.5458-4.5387,1.1247-13.6111,3.512-14.5128,3.63C461.6416,65.8019,468.6247,64.0612,467.0527,64.3535Zm6.7327-3.8464c1.1268-.3188,1.5408-.4683,1.4336-.4946,3.85-.985,8.2944-2.1013,10.1713-2.5344,1.2652-.2191-2.27.6663-2.8711.8763,4.6483-1.0546,12.3016-2.955,17.4725-4.2081-1.6642.47-6.303,1.6192-10.9323,2.7462-4.6219,1.1568-9.2381,2.2772-10.8756,2.6136.9269-.2643,3.3257-.8682,2.8744-.8154C479.2618,59.0458,475.5248,60.1254,473.7855,60.5071Zm-39.08,41.5424a19.0785,19.0785,0,0,0-2.6686,1.3467c-1.3748.6859-1.4226.647-4.0381,1.9867l17.301-8.9489c-1.4743.8116-1.3963.8048,1.374-.6093C445.8679,96.3631,440.2892,99.118,434.7051,102.0494ZM388.7864,120.76c-9.0933,4.42-14.6564,7.2419-22.8728,11.1543,7.8019-4.0106,16.4991-8.09,26.8561-13.241C393.3353,118.4724,386.6572,121.7031,388.7864,120.76ZM291.17,177.6555a20.2745,20.2745,0,0,1-2.92.6346c.0205.0108.4688-.0714,1.0549-.1835l1.8828-.363c-3.59.85-10.4474,2.0313-14.663,2.8022C277.4276,180.2919,284.7513,178.9479,291.17,177.6555Zm101.4181-25.523c-.4233.0688,1.3573-.4359,1.4164-.4928l10.3525-2.8849c3.6121-1.0256,6.8812-2.014,8.3372-2.5l14.3958-4.03C419.2886,144.6078,402.7418,149.3978,392.5879,152.1324Zm25.463-3.4963c.8258-.2584,3.3308-1.1148-.0417-.1439,2.47-.8044,3.76-1.1208,8.63-2.5359-.0193.0209-.46.1547-1.0339.3246l-1.8378.54c2.127-.5439,3.0482-.8265,1.4768-.2726ZM530.8872,113.06c-1.7064.506-5.0444,1.5676-8.58,2.6954,1.5919-.545,1.236-.4576-1.4346.3928C521.0962,115.8469,532.9492,112.2238,530.8872,113.06Zm80.6974-23.0079c-2.5649.9019-11.15,3.6266-14.2272,4.6841-1.66.4923-1.67.4626-.0371-.1144l-9.962,3.2623C594.4014,95.4189,602.5561,92.8735,611.5846,90.0519Zm61.7508-23.1991c-8.4185,2.9417-20.6008,6.7625-35.5836,11.6456-2.4838.8329-3.124,1.1119-2.7961,1.0956,1.2193-.35,4.6046-1.4456,7.1375-2.2482-1.7482.6533-4.4323,1.5847-9.9238,3.3735,3.4763-1.1705-1.6.4019,1.3885-.5769-1.303.3674-5.0129,1.57-7.1569,2.2286-1.6143.5522.9066-.2064-5.673,1.9048,1.3148-.3715,5.0129-1.57,7.1568-2.2288-2.9381,1.1143-14.3347,4.6472-18.5331,5.9857-1.06.2478,2.4309-.8823,1.3711-.6346l19.9391-6.505c2.9648-.9717-2.1462.6114,2.8127-1.0076-1.32.314-4.2076,1.3467-8.5533,2.7452a25.7474,25.7474,0,0,0,2.769-1.1829c8.9155-2.9269,16.99-5.3693,22.7845-7.4145l11.4081-3.62c-.6041.2333-1.7917.6413-4.2513,1.4316Zm14.3428-4.306a21.6216,21.6216,0,0,1,2.8875-.7956c-2.9309.9182-3.3853,1.1406-1.399.5094a10.3407,10.3407,0,0,1-1.4247.4863,9.9173,9.9173,0,0,0-1.4128.4824c-1.9448.56-4.0074,1.1535-10.0107,3.1046-.567.0713,5.9792-1.9689,5.6541-1.9657C684.6222,63.4921,686.771,62.9307,687.6782,62.5468Zm70.3273-20.9711c-5.1069,1.4666-2.8456.8194-8.6047,2.6124-1.6682.4629-1.6773.433-.035-.1151L743.6523,45.85c-3.2233,1.0018,1.75-.4854-1.4069.5237-2.5948.6418-12.4608,3.8372-11.4911,3.3873l-7.15,2.2244c4.7183-1.43,4.108-1.174,2.9108-.717-6.171,1.9058-8.2974,2.4147-8.6379,2.4672,2.8472-.98,7.9536-2.6125,15.6846-5.0048-5.4853,1.7936,17.2424-5.3757,24.3749-7.3847C755.1039,42.2529,757.0747,41.782,758.0055,41.5757Zm30.7175-6.9234c-4.5665,1.3866-10.0828,2.9347-16.3582,4.7528-6.2681,1.8448-13.326,3.8447-20.9609,6.1785,2.9276-.9216,5.0321-1.6187,5.6771-1.8848,3.1117-.8582,4.8879-1.4852,10.0341-2.9952,1.0617-.2313-2.83.9078-2.8356.9716,7.631-2.2361,18.4359-5.4537,30.1675-8.7891C793.3453,33.1927,787.4191,35.0485,788.723,34.6523Zm7.71-5.75c5.44-1.4651,6.12-1.6558,11.5295-3.2313,3.43-.8623-2.7415.88.04.1447-2.5083.808-7.3958,2.0717-14.4078,4.0692C792.812,29.9871,791.7258,30.267,796.4327,28.9027ZM634.2817,146.8392c-6.1474,1.57-11.6779,3.0844-18.797,5.0278.2258-.0983-.3293.0416-1.4664.3091,1.21-.3726,4.6528-1.2145,7.2379-1.9149,2.0748-.5621.4723-.2191,2.8714-.8615-3.85.8934-3.9064.9941-7.2714,1.79,6.4361-1.7354,10.5312-2.7947,14.47-3.8083-1.304.4029-3.2052.977-5.7717,1.606-1.4891.5135,4.8847-1.2457,5.8184-1.4321,3.22-.8748.5493-.3,1.38-.5865,1.9169-.5624,8.1775-2.2193,10.1184-2.7186,2.0125-.4883-3.6826,1.1435.032.1155C639.6672,145.3,634.4528,146.6787,634.2817,146.8392Zm145.7125-45.46c-1.6592.5333-2.5359.83-2.83.95-1.6823.4987-4.1471,1.269-4.3214,1.2451l4.2842-1.3594c-1.3979.3685-4.0392,1.1686-7.1816,2.1422.4276-.1817,3.5494-1.1783,5.68-1.8754-.102.0778-.2051.1558,1.4647-.3809,1.41-.6313,8.3651-2.5587,18.5136-5.9832-2.4366,1.0175-7.08,2.3788-14.2214,4.6846C779.4616,101.4359,780.2235,101.2578,779.9942,101.3793Z"/>
						</g>
					</mask>
					<g mask="url(#logoMask)">
						<g class="qodef-line-svg-paths">
							<path d="M-1.4,96.4c62.5-4.7,177.8-39.1,235-31c11.4,1.6-194,65-178,73c151,8,344.2-63.6,469-90c-50.8,33.9-223.2,117.6-280,140c159.2-21.2,453.5-138.3,610-174l-292,151c128.9-26.5,319.7-98.9,446-136c-41.9,39.6-205.5,118.3-258,142c92.2-25,292.7-105.6,383.5-135.5c-31.5,21.3-87.1,57.7-118.7,79c-3.7,2.5-7.4,5.1-9.7,8.9c-4.8,8-0.8,19,6.4,24.9s16.7,8,25.9,9.6c34.9,5.8,70.4,6.5,105.5,2"/>
						</g>
					</g>
				</svg>
			</div>
		</div>
	</div>
</article>
