<?php

if ( ! function_exists( 'coppola_core_add_scrolling_portfolio_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function coppola_core_add_scrolling_portfolio_shortcode( $shortcodes ) {
		$shortcodes[] = 'CoppolaCore_Scrolling_Portfolio_Shortcode';

		return $shortcodes;
	}

	add_filter( 'coppola_core_filter_register_shortcodes', 'coppola_core_add_scrolling_portfolio_shortcode' );
}

if ( class_exists( 'CoppolaCore_List_Shortcode' ) ) {
	class CoppolaCore_Scrolling_Portfolio_Shortcode extends CoppolaCore_List_Shortcode {

		public function __construct() {
			$this->set_post_type( 'portfolio-item' );
			$this->set_post_type_taxonomy( 'portfolio-category' );
			$this->set_post_type_additional_taxonomies( array( 'portfolio-tag', 'portfolio_artist' ) );
			$this->set_extra_options( apply_filters( 'coppola_core_filter_scrolling_portfolio_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( COPPOLA_CORE_CPT_URL_PATH . '/portfolio/shortcodes/scrolling-portfolio' );
			$this->set_base( 'coppola_core_scrolling_portfolio' );
			$this->set_name( esc_html__( 'Scrolling Portfolio', 'coppola-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of portfolios in a vertical swiper', 'coppola-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'bottom_right_text',
					'title'      => esc_html__( 'Bottom Right Text', 'coppola-core' ),
				)
			);
			$this->map_query_options( array( 'post_type' => $this->get_post_type() ) );
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'coppola_core_scrolling_portfolio', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['post_type']       = $this->get_post_type();
			$atts['taxonomy_filter'] = $this->get_post_type_filter_taxonomy( $atts );

			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );

			$atts['query_result']   = new \WP_Query( coppola_core_get_query_params( $atts ) );
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['slider_attr']    = $this->get_slider_data( $atts );

			$atts['this_shortcode'] = $this;

			return coppola_core_get_template_part( 'post-types/portfolio/shortcodes/scrolling-portfolio', 'templates/content', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-scrolling-portfolio';

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$item_classes[] = 'swiper-slide';

			return implode( ' ', $item_classes );
		}

		public function get_title_data( $atts ) {
			$data = array();

			$title_color = get_post_meta( get_the_ID(), 'qodef_portfolio_title_color', true );

			$data['titleColor'] = ! empty( $title_color ) ? $title_color : '';

			return json_encode( $data );
		}

		public function get_list_item_style( $atts ) {
			$styles = array();

			if ( isset( $atts['custom_margin'] ) && 'yes' === $atts['custom_margin'] ) {
				$margin = get_post_meta( get_the_ID(), 'qodef_portfolio_item_padding', true );

				if ( isset( $margin ) && '' !== $margin ) {
					$styles[] = 'margin: ' . get_post_meta( get_the_ID(), 'qodef_portfolio_item_padding', true );
				}
			}

			return $styles;
		}

		public function get_image_styles( $atts ) {
			$styles = array();

			$image_position_top  = get_post_meta( get_the_ID(), 'qodef_scrolling_portfolio_image_position_top', true );
			$image_position_left = get_post_meta( get_the_ID(), 'qodef_scrolling_portfolio_image_position_left', true );

			if ( ! empty( $image_position_top ) ) {
				if ( qode_framework_string_ends_with_space_units( $image_position_top ) ) {
					$styles[] = 'top: ' . $image_position_top;
				} else {
					$styles[] = 'top: ' . $image_position_top . '%';
				}
			}

			if ( ! empty( $image_position_left ) ) {
				if ( qode_framework_string_ends_with_space_units( $image_position_left ) ) {
					$styles[] = 'left: ' . $image_position_left;
				} else {
					$styles[] = 'left: ' . $image_position_left . '%';
				}
			}

			return $styles;
		}

		public function get_slider_data( $atts, $include = array() ) {
			$data = array();

			$data['loopedSlides'] = isset( $atts['posts_per_page'] ) ? $atts['posts_per_page'] : 6;

			return json_encode( $data );
		}
	}
}
