(function ( $ ) {
	'use strict';
	
	qodefCore.shortcodes.coppola_core_scrolling_portfolio = {};
	
	$( window ).on(
		'load',
		function () {
			qodefScrollingPortfolio.init();
		}
	);
	
	var qodefScrollingPortfolio = {
		init: function ( settings ) {
			var $slider = $('.qodef-scrolling-portfolio');
			
			// Allow overriding the default config
			$.extend($slider, settings);
			
			if ( $slider.length ) {
				$slider.each(function () {
					qodefScrollingPortfolio.createSlider( $( this ) );
				});
			}
		},
		createSlider: function ($slider) {
			var options = qodefScrollingPortfolio.getOptions($slider),
				events  = qodefScrollingPortfolio.getEvents($slider, options);
			
			var $swiper = new Swiper($slider, Object.assign(options, events));
		},
		getOptions: function ($slider) {
			var sliderOptions     = typeof $slider.data( 'options' ) !== 'undefined' ? $slider.data( 'options' ) : {},
				loopedSlides = sliderOptions.loopedSlides !== undefined && sliderOptions.loopedSlides !== '' ? sliderOptions.loopedSlides : 6;
			
			var options = {
				loop: true,
				slidesPerView: 'auto',
				slidesOffsetBefore: -185,
				loopedSlides: loopedSlides,
				centeredSlides: true,
				speed: 600,
				direction: 'vertical',
				sliderScroll: false,
				grabCursor: true,
				spaceBetween: 0,
				autoplay: false,
				breakpoints: {
					// when window width is < 481px
					0: {
						slidesOffsetBefore: -185
					},
					680: {
						slidesOffsetBefore: -80
					},
					// when window width is >= 1025px
					1025: {
						slidesOffsetBefore: -185
					}
				},
			};
			
			return Object.assign(options, qodefScrollingPortfolio.getSliderData($slider));
		},
		getEvents: function ($holder, options) {
			return {
				on: {
					slideChangeTransitionStart: function() {
						var activeSlide = $holder.find('.swiper-slide-active'),
							activeTitle = activeSlide.find('.qodef-e-title'),
							activeIndex = activeSlide.data('swiper-slide-index'),
							title       = $holder.find('.qodef-e-title'),
							container   = $holder.find('.qodef-e-media-container'),
							line        = activeSlide.find('.qodef-e-line'),
							activeColor = activeTitle.data('title-styles').titleColor;
						
						title.css('color', '#fff');
						
						if ( '' !== activeColor ) {
							activeTitle.css('color', activeColor );
						}
						
						if ( '' !== activeIndex ) {
							activeTitle.css('color', activeColor );
						}
						activeTitle.on('mouseenter', function () {
							line.addClass('qodef--active');
						}).on('mouseleave', function () {
							line.removeClass('qodef--active');
						});
						
						container.each(
							function () {
								if ( $( this ).length ) {
									var item = $( this ).children().first();
									if (  $( this ).data('image-index') === activeIndex ) {
										if ( item.hasClass('qodef-video--on-hover') ) {
											$( this ).find('video').get( 0 ).play();
										}
										$( this ).addClass('qodef--active');
									} else {
										if ( item.hasClass('qodef-video--on-hover') ) {
											$( this ).find('video').get( 0 ).pause();
										}
										$( this ).removeClass('qodef--active');
									}
								}
							}
						);
					},
					init: function () {
						var activeSlide = $holder.find('.swiper-slide-active'),
							activeTitle = activeSlide.find('.qodef-e-title'),
							activeColor = activeTitle.data('title-styles').titleColor;
						
						if ( '' !== activeColor ) {
							activeTitle.css('color', activeColor );
						}
						
						var scrollStart        = false;
						
						$holder.off().on(
							'wheel',
							function ( e ) {
								e.preventDefault();
								
								if ( ! scrollStart ) {
									scrollStart = true;
									
									if ( e.originalEvent.deltaY > 0 ) {
										$holder[0].swiper.slideNext();
									} else {
										$holder[0].swiper.slidePrev();
									}
									
									setTimeout(
										function () {
											scrollStart = false;
										},
										1000
									);
								}
							}
						);
					}
				}
			};
		},
		getSliderData: function ($slider) {
			var dataList = $slider.data(),
				returnValue = {};
			
			for (var property in dataList) {
				if (dataList.hasOwnProperty(property)) {
					// It's required to be different from data options because da options are all options from shortcode element
					if (property !== 'options' && typeof dataList[property] !== 'undefined' && dataList[property] !== '') {
						returnValue[property] = dataList[property];
					}
				}
			}
			
			return returnValue;
		},
	};
	
	qodefCore.shortcodes.coppola_core_scrolling_portfolio.qodefScrollingPortfolio = qodefScrollingPortfolio;
	
})( jQuery );
