<?php
$portfolio_list_image = get_post_meta( get_the_ID(), 'qodef_portfolio_list_image', true );
$has_image            = ! empty( $portfolio_list_image ) || has_post_thumbnail();
$portfolio_list_video = get_post_meta( get_the_ID(), 'qodef_portfolio_featured_video', true );
$portfolio_video_type = get_post_meta( get_the_ID(), 'qodef_portfolio_video_type', true );
$has_video            = ! empty( $portfolio_list_video );

if ( 'click' === $portfolio_video_type && 'false' === $is_related ) {
	$media_class = 'qodef-video--on-click';
} elseif ( 'autoplay' === $portfolio_video_type ) {
	$media_class = 'qodef-video--autoplay';
} elseif ( 'hover' === $portfolio_video_type ) {
	$media_class = 'qodef-video--on-hover';
}
if ( ( 'autoplay' === $portfolio_video_type || 'hover' === $portfolio_video_type ) && $has_video && 'false' === $is_related ) {
	$portfolio_url = coppola_core_get_portfolio_list_item_url( get_the_ID() );
	?>
	<div class="<?php echo esc_attr( $media_class ); ?>">
		<a itemprop="url" href="<?php echo esc_url( $portfolio_url['link'] ); ?>" target="<?php echo esc_attr( $portfolio_url['target'] ); ?>">
			<?php if ( 'autoplay' === $portfolio_video_type ) { ?>
				<video autoplay="autoplay" loop="loop" muted="muted" playsinline>
					<source src="<?php echo esc_url( $portfolio_list_video ); ?>" type="video/mp4">
				</video>
			<?php } if ( 'hover' === $portfolio_video_type ) { ?>
				<video loop="loop" muted="muted" playsinline>
					<source src="<?php echo esc_url( $portfolio_list_video ); ?>" type="video/mp4">
				</video>
			<?php } ?>
		</a>
	</div>
	<?php
} elseif ( $has_image ) {
	$portfolio_url       = coppola_core_get_portfolio_list_item_url( get_the_ID() );
	$image_dimension     = isset( $image_dimension ) && ! empty( $image_dimension ) ? esc_attr( $image_dimension['size'] ) : 'full';
	$custom_image_width  = isset( $custom_image_width ) && '' !== $custom_image_width ? intval( $custom_image_width ) : 0;
	$custom_image_height = isset( $custom_image_height ) && '' !== $custom_image_height ? intval( $custom_image_height ) : 0;
	?>
	<div class="qodef-e-media-image ">
		<?php
		if ( $has_video && 'click' === $portfolio_video_type && 'false' === $is_related ) {
			?>
			<div class="<?php echo esc_attr( $media_class ); ?>">
				<a href="<?php echo esc_url( $portfolio_list_video ); ?>" itemprop="url" class="qodef-m-play qodef-magnific-popup qodef-popup-item" data-type="iframe">
					<svg xmlns="http://www.w3.org/2000/svg" width="62" height="62" viewBox="0 0 62 62">
						<polygon points="38.28 31 27.028 24.504 27.028 37.496 38.28 31"/>
						<polygon class="qodef-fill" points="38.28 31 27.028 24.504 27.028 37.496 38.28 31"/>
						<circle cx="31" cy="31" r="30"/>
					</svg>
				</a>
			</div>
			<?php
		}
		?>
		<?php if ( true === $is_related ) { ?>
			<a itemprop="url" href="<?php echo esc_url( $portfolio_url['link'] ); ?>" target="<?php echo esc_attr( $portfolio_url['target'] ); ?>">
				<?php echo coppola_core_get_list_shortcode_item_image( $image_dimension, 0, $custom_image_width, $custom_image_height ); ?>
			</a>
		<?php } else { ?>
			<a itemprop="url" href="<?php echo esc_url( $portfolio_url['link'] ); ?>" target="<?php echo esc_attr( $portfolio_url['target'] ); ?>">
				<?php echo coppola_core_get_list_shortcode_item_image( $image_dimension, $portfolio_list_image, $custom_image_width, $custom_image_height ); ?>
			</a>
		<?php } ?>
	</div>
<?php } ?>
