<?php
$portfolio_list_image = get_post_meta( get_the_ID(), 'qodef_portfolio_list_image', true );
$has_image            = ! empty( $portfolio_list_image ) || has_post_thumbnail();
$portfolio_list_video = get_post_meta( get_the_ID(), 'qodef_portfolio_featured_video', true );
$portfolio_video_type = get_post_meta( get_the_ID(), 'qodef_portfolio_video_type', true );
$has_video            = ! empty( $portfolio_list_video );

if ( 'click' === $portfolio_video_type && 'false' === $is_related ) {
	$media_class = 'qodef-video--on-click';
} elseif ( 'autoplay' === $portfolio_video_type ) {
	$media_class = 'qodef-video--autoplay';
} elseif ( 'hover' === $portfolio_video_type ) {
	$media_class = 'qodef-video--on-hover';
}

if ( ( 'autoplay' === $portfolio_video_type || 'hover' === $portfolio_video_type ) && $has_video && 'false' === $is_related ) {
	?>
	<div class="<?php echo esc_attr( $media_class ); ?>">
		<?php if ( 'autoplay' === $portfolio_video_type ) { ?>
		<video autoplay="autoplay" loop="loop" muted="muted" playsinline>
			<source src="<?php echo esc_url( $portfolio_list_video ); ?>" type="video/mp4">
		</video>
		<?php } if ( 'hover' === $portfolio_video_type ) { ?>
		<video loop="loop" muted="muted" playsinline>
			<source src="<?php echo esc_url( $portfolio_list_video ); ?>" type="video/mp4">
		</video>
		<?php } ?>
	</div>
	<?php
} elseif ( $has_image ) {
	$image_dimension = isset( $image_dimension ) && ! empty( $image_dimension ) && 'custom' !== $image_dimension ? esc_attr( $image_dimension['size'] ) : 'full';
	$image_url       = coppola_core_get_list_shortcode_item_image_url( $image_dimension, $portfolio_list_image );
	$style           = ! empty( $image_url ) ? 'background-image: url( ' . esc_url( $image_url ) . ')' : '';
	?>
	<div class="qodef-e-media-image qodef--background" <?php qode_framework_inline_style( $style ); ?>>
		<?php
		if ( $has_video && 'click' === $portfolio_video_type && 'false' === $is_related ) {
			?>
			<div class="<?php echo esc_attr( $media_class ); ?>">
				<a href="<?php echo esc_url( $portfolio_list_video ); ?>" itemprop="url" class="qodef-m-play qodef-magnific-popup qodef-popup-item" data-type="iframe">
					<svg xmlns="http://www.w3.org/2000/svg" width="62" height="62" viewBox="0 0 62 62">
						<polygon points="38.28 31 27.028 24.504 27.028 37.496 38.28 31"/>
						<polygon class="qodef-fill" points="38.28 31 27.028 24.504 27.028 37.496 38.28 31"/>
						<circle cx="31" cy="31" r="30"/>
					</svg>
				</a>
			</div>
			<?php
		}
		?>
		<?php echo coppola_core_get_list_shortcode_item_image( $image_dimension, $portfolio_list_image ); ?>
	</div>
<?php } ?>
