<?php

if ( ! function_exists( 'coppola_core_add_portfolio_list_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function coppola_core_add_portfolio_list_shortcode( $shortcodes ) {
		$shortcodes[] = 'CoppolaCore_Portfolio_List_Shortcode';

		return $shortcodes;
	}

	add_filter( 'coppola_core_filter_register_shortcodes', 'coppola_core_add_portfolio_list_shortcode' );
}

if ( class_exists( 'CoppolaCore_List_Shortcode' ) ) {
	class CoppolaCore_Portfolio_List_Shortcode extends CoppolaCore_List_Shortcode {

		public function __construct() {
			$this->set_post_type( 'portfolio-item' );
			$this->set_post_type_taxonomy( 'portfolio-category' );
			$this->set_post_type_additional_taxonomies( array( 'portfolio-tag', 'portfolio_artist' ) );
			$this->set_layouts( apply_filters( 'coppola_core_filter_portfolio_list_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'coppola_core_filter_portfolio_list_extra_options', array() ) );
			$this->set_hover_animation_options( apply_filters( 'coppola_core_filter_portfolio_list_hover_animation_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( COPPOLA_CORE_CPT_URL_PATH . '/portfolio/shortcodes/portfolio-list' );
			$this->set_base( 'coppola_core_portfolio_list' );
			$this->set_name( esc_html__( 'Portfolio List', 'coppola-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of portfolios', 'coppola-core' ) );
			$this->set_scripts(
				apply_filters(
					'coppola_core_filter_portfolio_list_register_assets',
					array(
						'jquery-magnific-popup' => array(
							'registered' => true,
						),
					)
				)
			);
			$this->set_necessary_styles(
				array(
					'magnific-popup' => array(
						'registered' => true,
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'coppola-core' ),
				)
			);
			$this->map_list_options();
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_image_highlight',
					'title'         => esc_html__( 'Enable Image Highlight', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
					'dependency'    => array(
						'show' => array(
							'behavior' => array(
								'values'        => array( 'slider' ),
								'default_value' => 'columns',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_image_shadow',
					'title'         => esc_html__( 'Enable Image Shadow', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'enable_noise',
					'title'      => esc_html__( 'Enable Noise Hover', 'coppola-core' ),
					'options'    => coppola_core_get_select_type_options_pool( 'yes_no', false ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'enable_reveal',
					'title'      => esc_html__( 'Enable Appear Reveal', 'coppola-core' ),
					'options'    => coppola_core_get_select_type_options_pool( 'no_yes', false ),
				)
			);
			$this->set_option(
				array(
					'field_type'  => 'text',
					'name'        => 'decimal_value',
					'title'       => esc_html__( 'Carousel Item Decimal', 'coppola-core' ),
					'description' => esc_html__( 'Set a decimal value to display part of carousel item (e.g. 0.5).', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'full_screen_slider',
					'title'         => esc_html__( 'Full Screen Slider', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'behavior' => array(
								'values'        => array( 'slider' ),
								'default_value' => 'columns',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'bottom_left_text',
					'title'      => esc_html__( 'Bottom Left Text', 'coppola-core' ),
					'dependency' => array(
						'show' => array(
							'full_screen_slider' => array(
								'values'        => array( 'yes' ),
								'default_value' => 'no',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'bottom_left_text_link',
					'title'      => esc_html__( 'Bottom Left Text Link', 'coppola-core' ),
					'dependency' => array(
						'show' => array(
							'full_screen_slider' => array(
								'values'        => array( 'yes' ),
								'default_value' => 'no',
							),
						),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'disable_links',
					'title'         => esc_html__( 'Disable Links', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'behavior' => array(
								'values'        => array( 'slider' ),
								'default_value' => 'columns',
							),
						),
						'hide' => array(
							'layout' => array(
								'values'        => array( 'info-on-image', 'info-follow', 'info-on-hover', 'info-below' ),
								'default_value' => '',
							),
						),
					),
				)
			);
			$this->map_query_options( array( 'post_type' => $this->get_post_type() ) );
			$this->map_layout_options(
				array(
					'layouts'          => $this->get_layouts(),
					'hover_animations' => $this->get_hover_animation_options(),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'hide_category',
					'title'         => esc_html__( 'Hide Category', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values' => 'info-on-image',
							),
						),
					),
					'group'         => esc_html__( 'Layout', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'hide_info',
					'title'         => esc_html__( 'Hide Info', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values' => 'info-on-image',
							),
						),
					),
					'group'         => esc_html__( 'Layout', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'hide_awards',
					'title'         => esc_html__( 'Hide Awards', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
					'dependency'    => array(
						'hide' => array(
							'layout' => array(
								'values' => array( 'info-follow', 'simple' ),
							),
						),
					),
					'group'         => esc_html__( 'Layout', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'custom_margin',
					'title'         => esc_html__( 'Use Item Custom Margin', 'coppola-core' ),
					'description'   => esc_html__( 'If you set this option to “Yes”, the margin values defined in the Portfolio Item Custom Margin field will be applied', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'no_yes', false ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'behavior' => array(
								'values'        => array( 'columns', 'masonry' ),
								'default_value' => 'columns',
							),
						),
					),
					'group'         => esc_html__( 'Layout', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'enable_gradient',
					'title'         => esc_html__( 'Enable Dark Background', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'yes_no', false ),
					'default_value' => 'yes',
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values' => 'info-on-image',
							),
						),
					),
					'group'         => esc_html__( 'Layout', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'skin',
					'title'         => esc_html__( 'Skin', 'coppola-core' ),
					'options'       => array(
						'dark'  => esc_html__( 'Dark', 'coppola-core' ),
						'light' => esc_html__( 'Light', 'coppola-core' ),
					),
					'default_value' => 'light',
					'dependency'    => array(
						'show' => array(
							'layout' => array(
								'values'        => array( 'info-below', 'simple' ),
								'default_value' => '',
							),
						),
					),
					'group'         => esc_html__( 'Layout', 'coppola-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'hidden',
					'name'          => 'is_related',
					'title'         => esc_html__( 'Is related', 'coppola-core' ),
					'default_value' => 'false',
					'group'         => esc_html__( 'Layout', 'coppola-core' ),
				)
			);
			$this->map_additional_options();
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'coppola_core_portfolio_list', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function load_assets() {
			parent::load_assets();

			wp_enqueue_style( 'magnific-popup' );
			wp_enqueue_script( 'jquery-magnific-popup' );
			do_action( 'coppola_core_action_portfolio_list_load_assets', $this->get_atts() );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['post_type']       = $this->get_post_type();
			$atts['taxonomy_filter'] = $this->get_post_type_filter_taxonomy( $atts );

			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );

			$atts['query_result']   = new \WP_Query( coppola_core_get_query_params( $atts ) );
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts                   = $this->get_column_number( $atts );
			$atts['slider_attr']    = $this->get_slider_data( $atts, 'yes' === $atts['full_screen_slider'] ? array( 'sliderScroll' => true ) : array() );
			$atts['data_attr']      = coppola_core_get_pagination_data( COPPOLA_CORE_REL_PATH, 'post-types/portfolio/shortcodes', 'portfolio-list', 'portfolio', $atts );

			$atts['this_shortcode'] = $this;

			return coppola_core_get_template_part( 'post-types/portfolio/shortcodes/portfolio-list', 'templates/content', $atts['behavior'], $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-portfolio-list';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-item-layout--' . $atts['layout'] : '';
			$holder_classes[] = 'yes' === $atts['hide_info'] ? 'qodef-item--hide-info' : '';
			$holder_classes[] = 'yes' === $atts['full_screen_slider'] ? 'qodef--full-screen-slider' : '';
			$holder_classes[] = ! empty( $atts['skin'] ) ? 'qodef--skin-' . $atts['skin'] : '';
			$holder_classes[] = 'yes' === $atts['enable_gradient'] ? 'qodef--gradient-enabled' : '';
			$holder_classes[] = 'yes' === $atts['enable_image_highlight'] ? 'qodef--image-highlight-enabled' : '';
			$holder_classes[] = 'yes' === $atts['enable_image_shadow'] ? 'qodef--image-shadow-enabled' : '';
			$holder_classes[] = 'yes' === $atts['enable_noise'] ? 'qodef--noise-hover' : '';
			$holder_classes[] = 'yes' === $atts['enable_reveal'] ? 'qodef--appear-reveal' : '';
			$holder_classes[] = 'yes' === $atts['disable_links'] ? 'qodef--disable-links' : '';

			$list_classes            = $this->get_list_classes( $atts );
			$hover_animation_classes = $this->get_hover_animation_classes( $atts );
			$holder_classes          = array_merge( $holder_classes, $list_classes, $hover_animation_classes );

			return implode( ' ', $holder_classes );
		}

		private function get_column_number( $atts ) {

			if ( ! empty( $atts['decimal_value'] ) ) {
				$atts['columns']      += $atts['decimal_value'];
				$atts['columns_1440'] += $atts['decimal_value'];
				$atts['columns_1366'] += $atts['decimal_value'];
				$atts['columns_1024'] += $atts['decimal_value'];
				$atts['columns_768']  += $atts['decimal_value'];
				$atts['columns_680']  += $atts['decimal_value'];
				$atts['columns_480']  += $atts['decimal_value'];
			}

			return $atts;
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$list_item_classes = $this->get_list_item_classes( $atts );

			if ( isset( $atts['custom_margin'] ) && 'yes' === $atts['custom_margin'] ) {
				$list_item_classes[] = 'qodef-custom-margin';
			}

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		public function get_title_styles( $atts ) {
			$styles = array();

			$title_color = get_post_meta( get_the_ID(), 'qodef_portfolio_title_color', true );

			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}

			if ( ! empty( $title_color ) ) {
				$styles[] = 'color: ' . $title_color;
			}

			return $styles;
		}

		public function get_list_item_style( $atts ) {
			$styles = array();

			if ( isset( $atts['custom_margin'] ) && 'yes' === $atts['custom_margin'] ) {
				$margin = get_post_meta( get_the_ID(), 'qodef_portfolio_item_padding', true );

				if ( isset( $margin ) && '' !== $margin ) {
					$styles[] = 'margin: ' . get_post_meta( get_the_ID(), 'qodef_portfolio_item_padding', true );
				}
			}

			return $styles;
		}
	}
}
