(function ( $ ) {
	'use strict';

	var shortcode = 'coppola_core_portfolio_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

	$( document ).ready(
		function () {
			qodefPreviewVideo.init();
		}
	);

	$( window ).on(
		'load',
		function () {
			qodefPortfolioAppear.init();
		}
	);

	var qodefPreviewVideo = {
		init: function () {
			this.item = $( '.qodef-portfolio-list .portfolio-item' );

			if ( this.item.length ) {
				this.item.each(
					function () {
						qodefPreviewVideo.itemHover( $( this ) );
					}
				);
			}
		},

		itemHover: function ( $item ) {
			if ( qodefCore.windowWidth > 1024 ) {
				var video = $item.find( '.qodef-video--on-hover video' );

				$item.on(
					'mouseenter touchstart',
					function () {
						if ( video.length ) {
							var isPlaying = video.get( 0 ).currentTime > 0 && ! video.get( 0 ).paused && ! video.get( 0 ).ended && video.get( 0 ).readyState > 2;

							if ( ! isPlaying ) {
								video.get( 0 ).play();
							}
						}
					}
				);
				$item.on(
					'mouseleave touchend',
					function () {
						if ( video.length ) {
							setTimeout(
								function () {
									video.get( 0 ).pause();
									video.get( 0 ).currentTime = 0;
								},
								200
							);
						}
					}
				);
			}
		},
	};

	var qodefPortfolioAppear = {
		init: function () {
			var $holder = $( '.qodef-portfolio-list.qodef--appear-reveal' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						qodefPortfolioAppear.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $holder ) {

			qodefCore.qodefIsInViewport.check(
				$holder.find( 'article:first-child' ),
				function () {
					$holder.addClass( 'qodef--appeared' );
				},
			);
		},
	};

	qodefCore.shortcodes.coppola_core_portfolio_list.qodefPortfolioAppear = qodefPortfolioAppear;

})( jQuery );
