<?php

if ( ! function_exists( 'coppola_core_add_divided_scroll_showcase_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function coppola_core_add_divided_scroll_showcase_shortcode( $shortcodes ) {
		$shortcodes[] = 'CoppolaCore_Divided_Scroll_Showcase_Shortcode';

		return $shortcodes;
	}

	add_filter( 'coppola_core_filter_register_shortcodes', 'coppola_core_add_divided_scroll_showcase_shortcode' );
}

if ( class_exists( 'CoppolaCore_Shortcode' ) ) {
	class CoppolaCore_Divided_Scroll_Showcase_Shortcode extends CoppolaCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( COPPOLA_CORE_CPT_URL_PATH . '/portfolio/shortcodes/divided-scroll-showcase' );
			$this->set_base( 'coppola_core_divided_scroll_showcase' );
			$this->set_name( esc_html__( 'Split Portfolio Categories Scroll', 'coppola-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds split portfolio categories scroll', 'coppola-core' ) );
			$this->set_category( esc_html__( 'Coppola Core', 'coppola-core' ) );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'coppola-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'portfolio_cat_left',
					'title'      => esc_html__( 'Choose Portfolio Category', 'coppola-core' ),
					'group'      => esc_html__( 'Left Portfolio', 'coppola-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'portfolio_cat_right',
					'title'      => esc_html__( 'Choose Portfolio Category', 'coppola-core' ),
					'group'      => esc_html__( 'Right Portfolio', 'coppola-core' ),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts                   = $this->get_atts();
			$atts['holder_classes'] = $this->get_holder_classes( $atts );

			return coppola_core_get_template_part( 'post-types/portfolio/shortcodes/divided-scroll-showcase', 'templates/divided-scroll-showcase', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-divided-scroll-showcase';

			return implode( ' ', $holder_classes );
		}
	}
}