<?php

if ( ! function_exists( 'coppola_core_add_portfolio_category_options' ) ) {
	/**
	 * Function that add general taxonomy options for this module
	 */
	function coppola_core_add_portfolio_category_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'portfolio-category' ),
				'type'  => 'taxonomy',
				'slug'  => 'portfolio-category',
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_portfolio_category_image',
					'title'      => esc_html__( 'Portfolio Category Image', 'coppola-core' ),
				)
			);
		}
	}

	add_action( 'coppola_core_action_register_cpt_tax_fields', 'coppola_core_add_portfolio_category_options' );
}

if ( ! function_exists( 'coppola_core_add_portfolio_artist_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function coppola_core_add_portfolio_artist_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'portfolio-artist' ),
				'type'  => 'taxonomy',
				'slug'  => 'portfolio-artist',
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_portfolio_artist_name',
					'title'      => esc_html__( 'Artist Name', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_artist_surname',
					'title'       => esc_html__( 'Artist Surname', 'coppola-core' ),
					'description' => esc_html__( 'Name and surname are needed in order to be shown', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_portfolio_surname_color',
					'title'      => esc_html__( 'Surname Color', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_portfolio_artist_subtitle',
					'title'      => esc_html__( 'Artist Subtitle Text', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_artist_image',
					'title'      => esc_html__( 'Artist Image', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'textarea',
					'name'       => 'qodef_portfolio_artist_biography',
					'title'      => esc_html__( 'Artist Biography', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_portfolio_artist_twitter_link',
					'title'      => esc_html__( 'Artist Twitter Link', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_portfolio_artist_linkedin_link',
					'title'      => esc_html__( 'Artist LinkedIn Link', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_portfolio_artist_instagram_link',
					'title'      => esc_html__( 'Artist Instagram Link', 'coppola-core' ),
				)
			);
		}
	}

	add_action( 'coppola_core_action_register_cpt_tax_fields', 'coppola_core_add_portfolio_artist_options' );
}
