<?php

if ( ! function_exists( 'coppola_core_add_portfolio_item_list_meta_boxes' ) ) {
	/**
	 * Function that add general meta box options for this module
	 *
	 * @param object $page
	 */
	function coppola_core_add_portfolio_item_list_meta_boxes( $page ) {

		if ( $page ) {

			$list_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-list',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'List Settings', 'coppola-core' ),
					'description' => esc_html__( 'Portfolio list settings', 'coppola-core' ),
				)
			);

			$list_tab->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_portfolio_list_image',
					'title'       => esc_html__( 'Portfolio List Image', 'coppola-core' ),
					'description' => esc_html__( 'Upload image to be displayed on portfolio list instead of featured image', 'coppola-core' ),
				)
			);

			$list_tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_masonry_image_dimension_portfolio_item',
					'title'       => esc_html__( 'Image Dimension', 'coppola-core' ),
					'description' => esc_html__( 'Choose an image layout for "masonry behavior" portfolio list. If you are using fixed image proportions on the list, choose an option other than default', 'coppola-core' ),
					'options'     => coppola_core_get_select_type_options_pool( 'masonry_image_dimension' ),
				)
			);

			$list_tab->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_item_padding',
					'title'       => esc_html__( 'Portfolio Item Custom Padding', 'coppola-core' ),
					'description' => esc_html__( 'Choose item padding when it appears in portfolio list (ex. 5% 5% 5% 5%)', 'coppola-core' ),
				)
			);

			$list_tab->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_item_awards',
					'title'       => esc_html__( 'Portfolio Item Awards', 'coppola-core' ),
					'description' => esc_html__( 'Enter item awards that will be displayed in portfolio list', 'coppola-core' ),
				)
			);

			$list_tab->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_single_external_link',
					'title'       => esc_html__( 'Portfolio External Link', 'coppola-core' ),
					'description' => esc_html__( 'Enter URL to link from Portfolio List element', 'coppola-core' ),
				)
			);

			$list_tab->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_portfolio_single_external_link_target',
					'title'      => esc_html__( 'Portfolio External Link Target', 'coppola-core' ),
					'options'    => coppola_core_get_select_type_options_pool( 'link_target' ),
				)
			);

			$list_tab->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_portfolio_featured_video',
					'title'      => esc_html__( 'Featured Video', 'coppola-core' ),
				)
			);

			$list_tab->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_portfolio_video_type',
					'title'      => esc_html__( 'Featured Video Type', 'coppola-core' ),
					'options'    => array(
						'click'    => esc_html__( 'On Click', 'coppola-core' ),
						'autoplay' => esc_html__( 'Autoplay', 'coppola-core' ),
						'hover'    => esc_html__( 'On Hover', 'coppola-core' ),
					),
				)
			);

			$list_tab->add_field_element(
				array(
					'field_type' => 'color',
					'name'       => 'qodef_portfolio_title_color',
					'title'      => esc_html__( 'Change Title Color', 'coppola-core' ),
				)
			);

			$list_tab->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_scrolling_portfolio_image_position_top',
					'title'       => esc_html__( 'Scrolling Portfolio Image Position Top', 'coppola-core' ),
					'description' => esc_html__( 'Enter image top position for Scrolling Portfolio shortcode', 'coppola-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'coppola-core' ),
					),
				)
			);

			$list_tab->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_scrolling_portfolio_image_position_left',
					'title'       => esc_html__( 'Scrolling Portfolio Image Position Left', 'coppola-core' ),
					'description' => esc_html__( 'Enter image left position for Scrolling Portfolio shortcode', 'coppola-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'coppola-core' ),
					),
				)
			);

			// Hook to include additional options after module options
			do_action( 'coppola_core_action_after_portfolio_list_meta_box_map', $list_tab );
		}
	}

	add_action( 'coppola_core_action_after_portfolio_meta_box_map', 'coppola_core_add_portfolio_item_list_meta_boxes' );
}
