<?php

if ( ! function_exists( 'coppola_core_add_portfolio_archive_sidebar_options' ) ) {
	/**
	 * Function that add sidebar options for portfolio archive module
	 */
	function coppola_core_add_portfolio_archive_sidebar_options( $tab ) {

		if ( $tab ) {
			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_archive_sidebar_layout',
					'title'         => esc_html__( 'Sidebar Layout', 'coppola-core' ),
					'description'   => esc_html__( 'Choose default sidebar layout for portfolio archives', 'coppola-core' ),
					'default_value' => 'no-sidebar',
					'options'       => coppola_core_get_select_type_options_pool( 'sidebar_layouts', false ),
				)
			);

			$custom_sidebars = coppola_core_get_custom_sidebars();
			if ( ! empty( $custom_sidebars ) && count( $custom_sidebars ) > 1 ) {
				$tab->add_field_element(
					array(
						'field_type'  => 'select',
						'name'        => 'qodef_portfolio_archive_custom_sidebar',
						'title'       => esc_html__( 'Custom Sidebar', 'coppola-core' ),
						'description' => esc_html__( 'Choose a custom sidebar to display on portfolio archives', 'coppola-core' ),
						'options'     => $custom_sidebars,
					)
				);
			}

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_archive_sidebar_grid_gutter',
					'title'       => esc_html__( 'Set Grid Gutter', 'coppola-core' ),
					'description' => esc_html__( 'Choose grid gutter size to set space between content and sidebar', 'coppola-core' ),
					'options'     => coppola_core_get_select_type_options_pool( 'items_space' ),
				)
			);
		}
	}

	add_action( 'coppola_core_action_after_portfolio_options_archive', 'coppola_core_add_portfolio_archive_sidebar_options' );
}

if ( ! function_exists( 'coppola_core_add_portfolio_single_sidebar_options' ) ) {
	/**
	 * Function that add sidebar options for portfolio single module
	 */
	function coppola_core_add_portfolio_single_sidebar_options( $tab ) {

		if ( $tab ) {
			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_single_sidebar_layout',
					'title'         => esc_html__( 'Sidebar Layout', 'coppola-core' ),
					'description'   => esc_html__( 'Choose default sidebar layout for portfolio singles', 'coppola-core' ),
					'default_value' => 'no-sidebar',
					'options'       => coppola_core_get_select_type_options_pool( 'sidebar_layouts', false ),
				)
			);

			$custom_sidebars = coppola_core_get_custom_sidebars();
			if ( ! empty( $custom_sidebars ) && count( $custom_sidebars ) > 1 ) {
				$tab->add_field_element(
					array(
						'field_type'  => 'select',
						'name'        => 'qodef_portfolio_single_custom_sidebar',
						'title'       => esc_html__( 'Custom Sidebar', 'coppola-core' ),
						'description' => esc_html__( 'Choose a custom sidebar to display on portfolio singles', 'coppola-core' ),
						'options'     => $custom_sidebars,
					)
				);
			}

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_single_sidebar_grid_gutter',
					'title'       => esc_html__( 'Set Grid Gutter', 'coppola-core' ),
					'description' => esc_html__( 'Choose grid gutter size to set space between content and sidebar', 'coppola-core' ),
					'options'     => coppola_core_get_select_type_options_pool( 'items_space' ),
				)
			);
		}
	}

	add_action( 'coppola_core_action_after_portfolio_options_single', 'coppola_core_add_portfolio_single_sidebar_options' );
}
