<?php

if ( ! function_exists( 'coppola_core_add_map_options' ) ) {
	/**
	 * Function that add map options
	 */
	function coppola_core_add_map_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => COPPOLA_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'map',
				'icon'        => 'fa fa-book',
				'title'       => esc_html__( 'Maps', 'coppola-core' ),
				'description' => esc_html__( 'Global Maps Options', 'coppola-core' ),
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_maps_api_key',
					'title'       => esc_html__( 'Maps API Key', 'coppola-core' ),
					'description' => esc_html__( 'Enter Google Maps API key', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_map_style',
					'title'       => esc_html__( 'Map Style', 'coppola-core' ),
					'description' => esc_html__( 'Enter Snazzy Map style JSON code', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_map_zoom',
					'title'       => esc_html__( 'Map Zoom', 'coppola-core' ),
					'description' => esc_html__( 'Input the default zoom value for the map. Note that this value applies in the event that the map contains a single address only. In the event of multiple addresses being shown, Google Map reverts to its own zoom values in order to fit all the addresses on the screen. ', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_map_scroll',
					'title'         => esc_html__( 'Enable Map Scroll', 'coppola-core' ),
					'description'   => esc_html__( 'Use this option to enable map scrolling', 'coppola-core' ),
					'default_value' => 'no',
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_map_drag',
					'title'         => esc_html__( 'Enable Map Dragging', 'coppola-core' ),
					'description'   => esc_html__( 'Use this option to enable map dragging', 'coppola-core' ),
					'default_value' => 'yes',
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_map_street_view_control',
					'title'         => esc_html__( 'Enable Map Street View Control', 'coppola-core' ),
					'description'   => esc_html__( 'Use this option to enable street view control on map', 'coppola-core' ),
					'default_value' => 'yes',
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_map_zoom_control',
					'title'         => esc_html__( 'Enable Map Zoom Control', 'coppola-core' ),
					'description'   => esc_html__( 'Use this option to enable zoom control on map', 'coppola-core' ),
					'default_value' => 'yes',
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_map_type_control',
					'title'         => esc_html__( 'Enable Map Type Control', 'coppola-core' ),
					'description'   => esc_html__( 'Use this option to enable type control on map', 'coppola-core' ),
					'default_value' => 'yes',
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_map_full_screen_control',
					'title'         => esc_html__( 'Enable Map Full Screen Control', 'coppola-core' ),
					'description'   => esc_html__( 'Use this option to enable full screen control on map', 'coppola-core' ),
					'default_value' => 'yes',
				)
			);

			// Hook to include additional options after module options
			do_action( 'coppola_core_action_after_map_options_map', $page );
		}
	}

	add_action( 'coppola_core_action_default_options_init', 'coppola_core_add_map_options', coppola_core_get_admin_options_map_position( 'maps' ) );
}
