<?php

if ( ! function_exists( 'coppola_core_add_fontkiko_to_collection' ) ) {
	function coppola_core_add_fontkiko_to_collection( $icons ) {
		$icons[] = 'CoppolaCoreFontkikoIconPack';

		return $icons;
	}

	add_filter( 'qode_framework_filter_add_icon', 'coppola_core_add_fontkiko_to_collection' );
}

if ( class_exists( 'QodeFrameworkIconPack' ) ) {
	class CoppolaCoreFontkikoIconPack extends QodeFrameworkIconPack {

		public function __construct() {
			parent::__construct();
		}

		public function add_icon_pack() {
			$this->set_base( 'fontkiko' );
			$this->set_name( 'Font Kiko' );
			$this->set_icons( $this->iconsArray() );
			$this->set_specific_icons( $this->specific_icons() );
		}

		public function get_style_url() {
			return COPPOLA_CORE_INC_URL_PATH . '/icons/' . $this->get_base() . '/assets/css/kiko-all.min.css';
		}

		public function iconsArray() {
			$icons = array(
				'kiko-train'                     => 'kiko-train',
				'kiko-car'                       => 'kiko-car',
				'kiko-truck'                     => 'kiko-truck',
				'kiko-bike'                      => 'kiko-bike',
				'kiko-sailboat'                  => 'kiko-sailboat',
				'kiko-airplane'                  => 'kiko-airplane',
				'kiko-helicopter'                => 'kiko-helicopter',
				'kiko-motor-scooter'             => 'kiko-motor-scooter',
				'kiko-motorcycle'                => 'kiko-motorcycle',
				'kiko-air-balloon'               => 'kiko-air-balloon',
				'kiko-plane-takes-off'           => 'kiko-plane-takes-off',
				'kiko-plane-lands'               => 'kiko-plane-lands',
				'kiko-bus'                       => 'kiko-bus',
				'kiko-cargo-vessel'              => 'kiko-cargo-vessel',
				'kiko-electromobile'             => 'kiko-electromobile',
				'kiko-rocket'                    => 'kiko-rocket',
				'kiko-rocket-shuttle'            => 'kiko-rocket-shuttle',
				'kiko-ambulance'                 => 'kiko-ambulance',
				'kiko-police'                    => 'kiko-police',
				'kiko-tank'                      => 'kiko-tank',
				'kiko-tractor'                   => 'kiko-tractor',
				'kiko-tow-truck'                 => 'kiko-tow-truck',
				'kiko-airship'                   => 'kiko-airship',
				'kiko-scooter'                   => 'kiko-scooter',
				'kiko-self-balancing-scooter'    => 'kiko-self-balancing-scooter',
				'kiko-segway'                    => 'kiko-segway',
				'kiko-metro'                     => 'kiko-metro',
				'kiko-syringe'                   => 'kiko-syringe',
				'kiko-pills'                     => 'kiko-pills',
				'kiko-microscope'                => 'kiko-microscope',
				'kiko-jar-of-medicine'           => 'kiko-jar-of-medicine',
				'kiko-tubes'                     => 'kiko-tubes',
				'kiko-medicine'                  => 'kiko-medicine',
				'kiko-toilet'                    => 'kiko-toilet',
				'kiko-patch'                     => 'kiko-patch',
				'kiko-pregnancy'                 => 'kiko-pregnancy',
				'kiko-medical-app'               => 'kiko-medical-app',
				'kiko-herbs'                     => 'kiko-herbs',
				'kiko-recipe'                    => 'kiko-recipe',
				'kiko-crushing-of-medicines'     => 'kiko-crushing-of-medicines',
				'kiko-blood'                     => 'kiko-blood',
				'kiko-donor'                     => 'kiko-donor',
				'kiko-brain'                     => 'kiko-brain',
				'kiko-kidneys'                   => 'kiko-kidneys',
				'kiko-liver'                     => 'kiko-liver',
				'kiko-lungs'                     => 'kiko-lungs',
				'kiko-heart'                     => 'kiko-heart',
				'kiko-intestine'                 => 'kiko-intestine',
				'kiko-stomach'                   => 'kiko-stomach',
				'kiko-healthy-tooth'             => 'kiko-healthy-tooth',
				'kiko-aching-tooth'              => 'kiko-aching-tooth',
				'kiko-nose'                      => 'kiko-nose',
				'kiko-ear'                       => 'kiko-ear',
				'kiko-eye'                       => 'kiko-eye',
				'kiko-chest'                     => 'kiko-chest',
				'kiko-doctor'                    => 'kiko-doctor',
				'kiko-doctor-woman'              => 'kiko-doctor-woman',
				'kiko-scheduled-med'             => 'kiko-scheduled-med',
				'kiko-hand'                      => 'kiko-hand',
				'kiko-foot'                      => 'kiko-foot',
				'kiko-hospital'                  => 'kiko-hospital',
				'kiko-stethoscope'               => 'kiko-stethoscope',
				'kiko-bacteria'                  => 'kiko-bacteria',
				'kiko-DNA'                       => 'kiko-DNA',
				'kiko-spine'                     => 'kiko-spine',
				'kiko-bed-rest'                  => 'kiko-bed-rest',
				'kiko-bone'                      => 'kiko-bone',
				'kiko-medical-cross'             => 'kiko-medical-cross',
				'kiko-medical-cross-usa'         => 'kiko-medical-cross-usa',
				'kiko-dropper'                   => 'kiko-dropper',
				'kiko-heart-rate'                => 'kiko-heart-rate',
				'kiko-marijuana'                 => 'kiko-marijuana',
				'kiko-fracture'                  => 'kiko-fracture',
				'kiko-urine'                     => 'kiko-urine',
				'kiko-fecal'                     => 'kiko-fecal',
				'kiko-diagnostics'               => 'kiko-diagnostics',
				'kiko-allergy'                   => 'kiko-allergy',
				'kiko-call-med'                  => 'kiko-call-med',
				'kiko-crutches'                  => 'kiko-crutches',
				'kiko-wheelchair'                => 'kiko-wheelchair',
				'kiko-skull'                     => 'kiko-skull',
				'kiko-childbirth'                => 'kiko-childbirth',
				'kiko-vitamins'                  => 'kiko-vitamins',
				'kiko-exclamation-circle'        => 'kiko-exclamation-circle',
				'kiko-exclamation-triangle'      => 'kiko-exclamation-triangle',
				'kiko-arrow-down-circle'         => 'kiko-arrow-down-circle',
				'kiko-arrow-up-circle'           => 'kiko-arrow-up-circle',
				'kiko-arrow-left-circle'         => 'kiko-arrow-left-circle',
				'kiko-arrow-right-circle'        => 'kiko-arrow-right-circle',
				'kiko-arrow-up'                  => 'kiko-arrow-up',
				'kiko-arrow-down'                => 'kiko-arrow-down',
				'kiko-arrow-right'               => 'kiko-arrow-right',
				'kiko-arrow-left'                => 'kiko-arrow-left',
				'kiko-double-arrow-up'           => 'kiko-arrow-up',
				'kiko-double-arrow-down'         => 'kiko-arrow-down',
				'kiko-double-arrow-left'         => 'kiko-arrow-left',
				'kiko-double-arrow-right'        => 'kiko-arrow-right',
				'kiko-clip'                      => 'kiko-clip',
				'kiko-triangular-arrow-up'       => 'kiko-triangular-arrow-up',
				'kiko-triangular-arrow-down'     => 'kiko-triangular-arrow-down',
				'kiko-triangular-arrow-left'     => 'kiko-triangular-arrow-left',
				'kiko-triangular-arrow-right'    => 'kiko-triangular-arrow-right',
				'kiko-email-at'                  => 'kiko-email-at',
				'kiko-signal'                    => 'kiko-signal',
				'kiko-bad-signal'                => 'kiko-bad-signal',
				'kiko-no-signal'                 => 'kiko-no-signal',
				'kiko-video'                     => 'kiko-video',
				'kiko-sound-on'                  => 'kiko-sound-on',
				'kiko-sound-off'                 => 'kiko-sound-off',
				'kiko-call-on'                   => 'kiko-call-on',
				'kiko-call-off'                  => 'kiko-call-off',
				'kiko-bluetooth'                 => 'kiko-bluetooth',
				'kiko-wifi'                      => 'kiko-wifi',
				'kiko-book-open'                 => 'kiko-book-open',
				'kiko-book-close'                => 'kiko-book-close',
				'kiko-bookmark'                  => 'kiko-bookmark',
				'kiko-light-turn-on'             => 'kiko-light-turn-on',
				'kiko-light-turn-off'            => 'kiko-light-turn-off',
				'kiko-brush'                     => 'kiko-brush',
				'kiko-full-battery'              => 'kiko-full-battery',
				'kiko-half-empty-battery'        => 'kiko-half-empty-battery',
				'kiko-empty-battery'             => 'kiko-empty-battery',
				'kiko-check-circle'              => 'kiko-check-circle',
				'kiko-check-square'              => 'kiko-check-square',
				'kiko-check'                     => 'kiko-check',
				'kiko-cross-circle'              => 'kiko-cross-circle',
				'kiko-cross-square'              => 'kiko-cross-square',
				'kiko-cross'                     => 'kiko-cross',
				'kiko-clock'                     => 'kiko-clock',
				'kiko-cloud-download'            => 'kiko-cloud-download',
				'kiko-cloud-load'                => 'kiko-cloud-load',
				'kiko-cloud'                     => 'kiko-cloud',
				'kiko-loading'                   => 'kiko-loading',
				'kiko-credit-card'               => 'kiko-credit-card',
				'kiko-crop'                      => 'kiko-crop',
				'kiko-pencil'                    => 'kiko-pencil',
				'kiko-pencil-write'              => 'kiko-pencil-write',
				'kiko-drop'                      => 'kiko-drop',
				'kiko-no-drop'                   => 'kiko-no-drop',
				'kiko-email'                     => 'kiko-email',
				'kiko-email-open'                => 'kiko-email-open',
				'kiko-email-forward'             => 'kiko-email-forward',
				'kiko-email-deleted'             => 'kiko-email-deleted',
				'kiko-email-attachment'          => 'kiko-email-attachment',
				'kiko-emails'                    => 'kiko-emails',
				'kiko-expand'                    => 'kiko-expand',
				'kiko-open-eye'                  => 'kiko-open-eye',
				'kiko-no-eye'                    => 'kiko-no-eye',
				'kiko-trash'                     => 'kiko-trash',
				'kiko-sheet'                     => 'kiko-sheet',
				'kiko-sheet-plus'                => 'kiko-sheet-plus',
				'kiko-sheet-minus'               => 'kiko-sheet-minus',
				'kiko-sheet-text'                => 'kiko-sheet-text',
				'kiko-video-file'                => 'kiko-video-file',
				'kiko-flag'                      => 'kiko-flag',
				'kiko-gift'                      => 'kiko-gift',
				'kiko-globe-europe'              => 'kiko-globe-europe',
				'kiko-globe-north-america'       => 'kiko-globe-north-america',
				'kiko-globe-asia'                => 'kiko-globe-asia',
				'kiko-globe-australia'           => 'kiko-globe-australia',
				'kiko-globe'                     => 'kiko-globe',
				'kiko-home'                      => 'kiko-home',
				'kiko-hashtag'                   => 'kiko-hashtag',
				'kiko-headphones'                => 'kiko-headphones',
				'kiko-microphone'                => 'kiko-microphone',
				'kiko-microphone-off'            => 'kiko-microphone-off',
				'kiko-link'                      => 'kiko-link',
				'kiko-zoom'                      => 'kiko-zoom',
				'kiko-zoom-minus'                => 'kiko-zoom-minus',
				'kiko-zoom-plus'                 => 'kiko-zoom-plus',
				'kiko-heart-symbol'              => 'kiko-heart-symbol',
				'kiko-picture'                   => 'kiko-picture',
				'kiko-information'               => 'kiko-information',
				'kiko-layers'                    => 'kiko-layers',
				'kiko-hamburger-menu'            => 'kiko-hamburger-menu',
				'kiko-plus'                      => 'kiko-plus',
				'kiko-circle-plus'               => 'kiko-circle-plus',
				'kiko-square-plus'               => 'kiko-square-plus',
				'kiko-pause'                     => 'kiko-pause',
				'kiko-record'                    => 'kiko-record',
				'kiko-forward'                   => 'kiko-forward',
				'kiko-previous'                  => 'kiko-previous',
				'kiko-note'                      => 'kiko-note',
				'kiko-treble-clef'               => 'kiko-treble-clef',
				'kiko-navigation'                => 'kiko-navigation',
				'kiko-moon'                      => 'kiko-moon',
				'kiko-sun'                       => 'kiko-sun',
				'kiko-comment'                   => 'kiko-comment',
				'kiko-dialogue'                  => 'kiko-dialogue',
				'kiko-user'                      => 'kiko-user',
				'kiko-user-add'                  => 'kiko-user-add',
				'kiko-user-minus'                => 'kiko-user-minus',
				'kiko-user-check'                => 'kiko-user-check',
				'kiko-user-x'                    => 'kiko-user-x',
				'kiko-users'                     => 'kiko-users',
				'kiko-phone'                     => 'kiko-phone',
				'kiko-turn-off-phone'            => 'kiko-turn-off-phone',
				'kiko-question'                  => 'kiko-question',
				'kiko-label'                     => 'kiko-label',
				'kiko-off'                       => 'kiko-off',
				'kiko-shield'                    => 'kiko-shield',
				'kiko-shield-crossed'            => 'kiko-shield-crossed',
				'kiko-gear'                      => 'kiko-gear',
				'kiko-several-gears'             => 'kiko-several-gears',
				'kiko-wrench'                    => 'kiko-wrench',
				'kiko-shopping-cart'             => 'kiko-shopping-cart',
				'kiko-shopping-cart-add'         => 'kiko-shopping-cart-add',
				'kiko-shopping-cart-delete'      => 'kiko-shopping-cart-delete',
				'kiko-shopping-cart-pay'         => 'kiko-shopping-cart-pay',
				'kiko-shopping-basket'           => 'kiko-shopping-basket',
				'kiko-shopping-basket-add'       => 'kiko-shopping-basket-add',
				'kiko-shopping-basket-delete'    => 'kiko-shopping-basket-delete',
				'kiko-termometer-minus'          => 'kiko-termometer-minus',
				'kiko-termometer-plus'           => 'kiko-termometer-plus',
				'kiko-star'                      => 'kiko-star',
				'kiko-half-star'                 => 'kiko-half-star',
				'kiko-text'                      => 'kiko-text',
				'kiko-lock'                      => 'kiko-lock',
				'kiko-unlock'                    => 'kiko-unlock',
				'kiko-umbrella'                  => 'kiko-umbrella',
				'kiko-save'                      => 'kiko-save',
				'kiko-save-error'                => 'kiko-save-error',
				'kiko-paper-bag'                 => 'kiko-paper-bag',
				'kiko-circle-checkbox'           => 'kiko-circle-checkbox',
				'kiko-circle-checkbox-full'      => 'kiko-circle-checkbox-full',
				'kiko-square-checkbox'           => 'kiko-square-checkbox',
				'kiko-square-checkbox-full'      => 'kiko-square-checkbox-full',
				'kiko-marker-map'                => 'kiko-marker-map',
				'kiko-pin'                       => 'kiko-pin',
				'kiko-map'                       => 'kiko-map',
				'kiko-lightning'                 => 'kiko-lightning',
				'kiko-lightning-off'             => 'kiko-lightning-off',
				'kiko-pipette'                   => 'kiko-pipette',
				'kiko-compass'                   => 'kiko-compass',
				'kiko-copy'                      => 'kiko-copy',
				'kiko-cut'                       => 'kiko-cut',
				'kiko-past'                      => 'kiko-past',
				'kiko-information-symbol'        => 'kiko-information-symbol',
				'kiko-download-file'             => 'kiko-download-file',
				'kiko-broken-link'               => 'kiko-broken-link',
				'kiko-email-read'                => 'kiko-email-read',
				'kiko-spam'                      => 'kiko-spam',
				'kiko-globe-latin-america'       => 'kiko-globe-latin-america',
				'kiko-globe-japan'               => 'kiko-globe-japan',
				'kiko-globe-africa'              => 'kiko-globe-africa',
				'kiko-globe-east'                => 'kiko-globe-east',
				'kiko-globe-antarctic'           => 'kiko-globe-antarctic',
				'kiko-fire'                      => 'kiko-fire',
				'kiko-support'                   => 'kiko-support',
				'kiko-recycle-symbol'            => 'kiko-recycle-symbol',
				'kiko-reload-arrow'              => 'kiko-reload-arrow',
				'kiko-cross-line'                => 'kiko-cross-line',
				'kiko-check-line'                => 'kiko-check-line',
				'kiko-plus-line'                 => 'kiko-plus-line',
				'kiko-timer'                     => 'kiko-timer',
				'kiko-alarm'                     => 'kiko-alarm',
				'kiko-alarm-off'                 => 'kiko-alarm-off',
				'kiko-fingerprint'               => 'kiko-fingerprint',
				'kiko-scan-fingerprint'          => 'kiko-scan-fingerprint',
				'kiko-computer-virus'            => 'kiko-computer-virus',
				'kiko-the-compass'               => 'kiko-the-compass',
				'kiko-wifi-off'                  => 'kiko-wifi-off',
				'kiko-quote-left'                => 'kiko-quote-left',
				'kiko-quote-right'               => 'kiko-quote-right',
				'kiko-ellipsis-menu-v'           => 'kiko-ellipsis-menu-v',
				'kiko-ellipsis-menu-h'           => 'kiko-ellipsis-menu-h',
				'kiko-iphone'                    => 'kiko-iphone',
				'kiko-android-phone'             => 'kiko-android-phone',
				'kiko-google-pixel-phone'        => 'kiko-google-pixel-phone',
				'kiko-old-phone'                 => 'kiko-old-phone',
				'kiko-nokia-3310'                => 'kiko-nokia-3310',
				'kiko-bendable-smartphone'       => 'kiko-bendable-smartphone',
				'kiko-tablet'                    => 'kiko-tablet',
				'kiko-imac-computer'             => 'kiko-imac-computer',
				'kiko-notebook'                  => 'kiko-notebook',
				'kiko-top-notebook'              => 'kiko-top-notebook',
				'kiko-screen'                    => 'kiko-screen',
				'kiko-mouse'                     => 'kiko-mouse',
				'kiko-graphic-pen'               => 'kiko-graphic-pen',
				'kiko-vr'                        => 'kiko-vr',
				'kiko-google-glass'              => 'kiko-google-glass',
				'kiko-graphics-tablet'           => 'kiko-graphics-tablet',
				'kiko-printer'                   => 'kiko-printer',
				'kiko-scanner'                   => 'kiko-scanner',
				'kiko-warehouse-scanner'         => 'kiko-warehouse-scanner',
				'kiko-iwatch'                    => 'kiko-iwatch',
				'kiko-smart-watch'               => 'kiko-smart-watch',
				'kiko-navigator'                 => 'kiko-navigator',
				'kiko-dashcam'                   => 'kiko-dashcam',
				'kiko-music-speaker'             => 'kiko-music-speaker',
				'kiko-yandex-alice'              => 'kiko-yandex-alice',
				'kiko-cortana-station'           => 'kiko-cortana-station',
				'kiko-hello-google'              => 'kiko-hello-google',
				'kiko-amazon-station'            => 'kiko-amazon-station',
				'kiko-web-camera'                => 'kiko-web-camera',
				'kiko-desktop-microphone'        => 'kiko-desktop-microphone',
				'kiko-earphones'                 => 'kiko-earphones',
				'kiko-music-headphones'          => 'kiko-music-headphones',
				'kiko-headphones-microphone'     => 'kiko-headphones-microphone',
				'kiko-cable'                     => 'kiko-cable',
				'kiko-socket-eu'                 => 'kiko-socket-eu',
				'kiko-socket-us'                 => 'kiko-socket-us',
				'kiko-fitness-bracelet'          => 'kiko-fitness-bracelet',
				'kiko-gps-tracker'               => 'kiko-gps-tracker',
				'kiko-satellite-communication'   => 'kiko-satellite-communication',
				'kiko-television'                => 'kiko-television',
				'kiko-digital-tv'                => 'kiko-digital-tv',
				'kiko-router'                    => 'kiko-router',
				'kiko-external-drive'            => 'kiko-external-drive',
				'kiko-go-pro-camera'             => 'kiko-go-pro-camera',
				'kiko-quadcopter'                => 'kiko-quadcopter',
				'kiko-radio'                     => 'kiko-radio',
				'kiko-transmitter'               => 'kiko-transmitter',
				'kiko-baby-radio-monitor'        => 'kiko-baby-radio-monitor',
				'kiko-baby-monitor'              => 'kiko-baby-monitor',
				'kiko-joystick'                  => 'kiko-joystick',
				'kiko-portable-console'          => 'kiko-portable-console',
				'kiko-ipod'                      => 'kiko-ipod',
				'kiko-handsfree'                 => 'kiko-handsfree',
				'kiko-camera'                    => 'kiko-camera',
				'kiko-professional-camera'       => 'kiko-professional-camera',
				'kiko-professional-video-camera' => 'kiko-professional-video-camera',
				'kiko-journalist-microphone'     => 'kiko-journalist-microphone',
				'kiko-studio-lighting'           => 'kiko-studio-lighting',
				'kiko-robot-pet'                 => 'kiko-robot-pet',
				'kiko-robot-vacuum-cleaner'      => 'kiko-robot-vacuum-cleaner',
				'kiko-robot-big-dog'             => 'kiko-robot-big-dog',
				'kiko-humanoid-robot'            => 'kiko-humanoid-robot',
				'kiko-robot'                     => 'kiko-robot',
				'kiko-robot-head'                => 'kiko-robot-head',
				'kiko-desktop-computer'          => 'kiko-desktop-computer',
				'kiko-anchor'                    => 'kiko-anchor',
				'kiko-calendar'                  => 'kiko-calendar',
				'kiko-schedule'                  => 'kiko-schedule',
				'kiko-address-book'              => 'kiko-address-book',
				'kiko-facebook'                  => 'kiko-facebook',
				'kiko-twitter'                   => 'kiko-twitter',
				'kiko-dribbble'                  => 'kiko-dribbble',
				'kiko-behance'                   => 'kiko-behance',
				'kiko-pinterest'                 => 'kiko-pinterest',
				'kiko-vkontakte'                 => 'kiko-vkontakte',
				'kiko-odnoklassniki'             => 'kiko-odnoklassniki',
				'kiko-flipboard'                 => 'kiko-flipboard',
				'kiko-whatsapp'                  => 'kiko-whatsapp',
				'kiko-blogger'                   => 'kiko-blogger',
				'kiko-evernote'                  => 'kiko-evernote',
				'kiko-gmail'                     => 'kiko-gmail',
				'kiko-line'                      => 'kiko-line',
				'kiko-myspace'                   => 'kiko-myspace',
				'kiko-pocket'                    => 'kiko-pocket',
				'kiko-skype'                     => 'kiko-skype',
				'kiko-viadeo'                    => 'kiko-viadeo',
				'kiko-xing'                      => 'kiko-xing',
				'kiko-linkedin'                  => 'kiko-linkedin',
				'kiko-naver'                     => 'kiko-naver',
				'kiko-stumbleupon'               => 'kiko-stumbleupon',
				'kiko-viber'                     => 'kiko-viber',
				'kiko-snapchat'                  => 'kiko-snapchat',
				'kiko-yammer'                    => 'kiko-yammer',
				'kiko-digg'                      => 'kiko-digg',
				'kiko-messenger'                 => 'kiko-messenger',
				'kiko-live-journal'              => 'kiko-live-journal',
				'kiko-newsvine'                  => 'kiko-newsvine',
				'kiko-qzone'                     => 'kiko-qzone',
				'kiko-telegram'                  => 'kiko-telegram',
				'kiko-yummly'                    => 'kiko-yummly',
				'kiko-douban'                    => 'kiko-douban',
				'kiko-flattr'                    => 'kiko-flattr',
				'kiko-hatena'                    => 'kiko-hatena',
				'kiko-reddit'                    => 'kiko-reddit',
				'kiko-tumblr'                    => 'kiko-tumblr',
				'kiko-weibo'                     => 'kiko-weibo',
				'kiko-google'                    => 'kiko-google',
				'kiko-yandex'                    => 'kiko-yandex',
				'kiko-share'                     => 'kiko-share',
				'kiko-yandex-aura'               => 'kiko-yandex-aura',
				'kiko-wechat'                    => 'kiko-wechat',
				'kiko-baidu'                     => 'kiko-baidu',
				'kiko-bing'                      => 'kiko-bing',
				'kiko-like'                      => 'kiko-like',
				'kiko-unlike'                    => 'kiko-unlike'
			);

			// add classes to items
			$icon_variations = array(
				'Regular' => 'kikor',
				'Light'   => 'kikol',
				'Solid'   => 'kikos'
			);

			foreach ( $icons as $icon_key ) {

				if ( ! empty( $icon_key ) ) {

					// add default empty item
					$new_icons[''] = '';

					foreach ( $icon_variations as $icon_variation_key => $icon_variation_value ) {
						$new_icons[ $icon_variation_value . ' ' . $icon_key ] = $icon_variation_value . ' ' . $icon_key;
					}
				}
			}

			return $new_icons;
		}

		function specific_icons() {
			return array(
				'search'        => 'kikor kiko-zoom',
				'dropdown-cart' => 'kikor kiko-paper-bag',
				'menu'          => 'kikor kiko-hamburger-menu',
				'close'         => 'kikor kiko-cross-line',
				'back-to-top'   => 'kikor kiko-triangular-arrow-up',
				'mobile-menu'   => 'kikor kiko-hamburger-menu',
				'quote'         => 'kikor kiko-quote-left',
				'facebook'      => 'kikor kiko-facebook',
				'twitter'       => 'kikor kiko-twitter',
				'linkedin'      => 'kikor kiko-linkedin',
				'pinterest'     => 'kikor kiko-pinterest',
				'tumblr'        => 'kikor kiko-tumblr',
				'vk'            => 'kikor kiko-vkontakte',
			);
		}
	}
}
