<?php

if ( ! function_exists( 'coppola_core_add_standard_header_meta' ) ) {
	/**
	 * Function that add additional header layout meta box options
	 *
	 * @param object $page
	 */
	function coppola_core_add_standard_header_meta( $page ) {
		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_standard_header_section',
				'title'      => esc_html__( 'Standard Header', 'coppola-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => array( '', 'standard' ),
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_standard_header_in_grid',
				'title'         => esc_html__( 'Content in Grid', 'coppola-core' ),
				'description'   => esc_html__( 'Set content to be in grid', 'coppola-core' ),
				'default_value' => '',
				'options'       => coppola_core_get_select_type_options_pool( 'no_yes' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_height',
				'title'       => esc_html__( 'Header Height', 'coppola-core' ),
				'description' => esc_html__( 'Enter header height', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'coppola-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_height_percentage',
				'title'       => esc_html__( 'Header Height Percentage', 'coppola-core' ),
				'description' => esc_html__( 'Enter header height percentage (useful for adjusting position of menu dropdown)', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( '%', 'coppola-core' ),
				),
				'dependency'  => array(
					'show' => array(
						'qodef_standard_header_menu_position' => array(
							'values'        => 'center',
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type' => 'text',
				'name'       => 'qodef_standard_header_top_margin',
				'title'      => esc_html__( 'Header Top Margin', 'coppola-core' ),
				'args'       => array(
					'suffix' => esc_html__( 'px', 'coppola-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'coppola-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'coppola-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'coppola-core' ),
				'description' => esc_html__( 'Enter header background color', 'coppola-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_standard_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'coppola-core' ),
				'description' => esc_html__( 'Enter header border color', 'coppola-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_standard_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'coppola-core' ),
				'description' => esc_html__( 'Enter header border width size', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'coppola-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_standard_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'coppola-core' ),
				'description' => esc_html__( 'Choose header border style', 'coppola-core' ),
				'options'     => coppola_core_get_select_type_options_pool( 'border_style' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_standard_header_menu_position',
				'title'         => esc_html__( 'Menu position', 'coppola-core' ),
				'default_value' => '',
				'options'       => array(
					''       => esc_html__( 'Default', 'coppola-core' ),
					'left'   => esc_html__( 'Left', 'coppola-core' ),
					'center' => esc_html__( 'Center', 'coppola-core' ),
					'right'  => esc_html__( 'Right', 'coppola-core' ),
				),
			)
		);
	}

	add_action( 'coppola_core_action_after_page_header_meta_map', 'coppola_core_add_standard_header_meta' );
}
