<?php

if ( ! function_exists( 'coppola_core_add_minimal_header_global_option' ) ) {
	/**
	 * This function set header type value for global header option map
	 */
	function coppola_core_add_minimal_header_global_option( $header_layout_options ) {
		$header_layout_options['minimal'] = array(
			'image' => COPPOLA_CORE_HEADER_LAYOUTS_URL_PATH . '/minimal/assets/img/minimal-header.png',
			'label' => esc_html__( 'Minimal', 'coppola-core' ),
		);

		return $header_layout_options;
	}

	add_filter( 'coppola_core_filter_header_layout_option', 'coppola_core_add_minimal_header_global_option' );
}

if ( ! function_exists( 'coppola_core_register_minimal_header_layout' ) ) {
	/**
	 * Function which add header layout into global list
	 *
	 * @param array $header_layouts
	 *
	 * @return array
	 */
	function coppola_core_register_minimal_header_layout( $header_layouts ) {
		$header_layouts['minimal'] = 'CoppolaCore_Minimal_Header';

		return $header_layouts;
	}

	add_filter( 'coppola_core_filter_register_header_layouts', 'coppola_core_register_minimal_header_layout' );
}

if ( ! function_exists( 'coppola_core_enqueue_header_minimal_assets' ) ) {
	/**
	 * Function that enqueue 3rd party plugins script
	 */
	function coppola_core_enqueue_header_minimal_assets() {
		wp_enqueue_style( 'magnific-popup' );
		wp_enqueue_script( 'jquery-magnific-popup' );
	}

	add_action( 'coppola_core_action_before_main_css', 'coppola_core_enqueue_header_minimal_assets' );
}
