<?php

if ( ! function_exists( 'coppola_core_add_minimal_header_options' ) ) {
	/**
	 * Function that add additional header layout options
	 *
	 * @param object $page
	 * @param array  $general_header_tab
	 */
	function coppola_core_add_minimal_header_options( $page, $general_header_tab ) {

		$section = $general_header_tab->add_section_element(
			array(
				'name'       => 'qodef_minimal_header_section',
				'title'      => esc_html__( 'Minimal Header', 'coppola-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => 'minimal',
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'yesno',
				'name'          => 'qodef_minimal_header_logo_centered',
				'title'         => esc_html__( 'Center Logo', 'coppola-core' ),
				'description'   => esc_html__( 'Select whether to center the Logo in the Minimal Header', 'coppola-core' ),
				'default_value' => 'no',
			)
		);

		$section->add_field_element(
			array(
				'field_type'    => 'yesno',
				'name'          => 'qodef_minimal_header_in_grid',
				'title'         => esc_html__( 'Content in Grid', 'coppola-core' ),
				'description'   => esc_html__( 'Set content to be in grid', 'coppola-core' ),
				'default_value' => 'no',
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_minimal_header_height',
				'title'       => esc_html__( 'Header Height', 'coppola-core' ),
				'description' => esc_html__( 'Enter header height', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'coppola-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_minimal_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'coppola-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'coppola-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_minimal_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'coppola-core' ),
				'description' => esc_html__( 'Enter header background color', 'coppola-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_minimal_header_border_color',
				'title'       => esc_html__( 'Header Border Color', 'coppola-core' ),
				'description' => esc_html__( 'Enter header border color', 'coppola-core' ),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_minimal_header_border_width',
				'title'       => esc_html__( 'Header Border Width', 'coppola-core' ),
				'description' => esc_html__( 'Enter header border width size', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'coppola-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_minimal_header_border_style',
				'title'       => esc_html__( 'Header Border Style', 'coppola-core' ),
				'description' => esc_html__( 'Choose header border style', 'coppola-core' ),
				'options'     => coppola_core_get_select_type_options_pool( 'border_style' ),
			)
		);
	}

	add_action( 'coppola_core_action_after_header_options_map', 'coppola_core_add_minimal_header_options', 10, 2 );
}
