<?php

class CoppolaCore_Minimal_Header extends CoppolaCore_Header {
	private static $instance;

	public function __construct() {
		$this->set_layout( 'minimal' );
		$this->set_search_layout( 'fullscreen' );
		$this->default_header_height = 100;

		add_action( 'coppola_action_before_wrapper_close_tag', array( $this, 'fullscreen_menu_template' ) );
		add_filter( 'coppola_filter_header_class', array( $this, 'set_header_minimal_inner_classes' ), 10, 2 );

		parent::__construct();
	}

	/**
	 * @return CoppolaCore_Minimal_Header
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	function set_header_minimal_inner_classes( $class ) {
		// Check logocentered
		$logo_centered = coppola_core_get_post_value_through_levels( 'qodef_minimal_header_logo_centered' );
		if ( ! empty( $logo_centered ) && 'no' !== $logo_centered ) {
			$class[] = 'qodef-logo-centered--' . $logo_centered;
		}

		return $class;
	}

	function fullscreen_menu_template() {
		$parameters = array(
			'fullscreen_menu_in_grid' => 'yes' === coppola_core_get_post_value_through_levels( 'qodef_fullscreen_menu_in_grid' ),
		);

		coppola_core_template_part( 'fullscreen-menu', 'templates/full-screen-menu', '', $parameters );
	}
}
