<?php
if ( ! function_exists( 'coppola_core_add_bottom_header_global_option' ) ) {
	/**
	 * This function set header type value for global header option map
	 */

	function coppola_core_add_bottom_header_global_option( $header_layout_options ) {
		$header_layout_options['bottom'] = array(
			'image' => COPPOLA_CORE_HEADER_LAYOUTS_URL_PATH . '/bottom/assets/img/bottom-header.png',
			'label' => esc_html__( 'Bottom', 'coppola-core' ),
		);

		return $header_layout_options;
	}

	add_filter( 'coppola_core_filter_header_layout_option', 'coppola_core_add_bottom_header_global_option' );
}


if ( ! function_exists( 'coppola_core_register_bottom_header_layout' ) ) {
	/**
	 * Function which add header layout into global list
	 *
	 * @param array $header_layouts
	 *
	 * @return array
	 */
	function coppola_core_register_bottom_header_layout( $header_layouts ) {
		$header_layout = array(
			'bottom' => 'BottomHeader',
		);

		$header_layouts = array_merge( $header_layouts, $header_layout );

		return $header_layouts;
	}

	add_filter( 'coppola_core_filter_register_header_layouts', 'coppola_core_register_bottom_header_layout' );
}

if ( ! function_exists( 'coppola_core_add_template' ) ) {
	function coppola_core_add_template() {
		$header_layout = coppola_core_get_post_value_through_levels( 'qodef_header_layout' );
		$section       = coppola_core_get_post_value_through_levels( 'predefined_section' );

		if ( ( ! empty( $header_layout ) && 'bottom' === $header_layout ) && ! empty( $section ) ) {
			coppola_core_template_part( 'header', 'layouts/bottom/templates/elementor-template' );
		}
	}

	add_action( 'coppola_action_page_header_template', 'coppola_core_add_template' );
}
