<?php

if ( ! function_exists( 'coppola_core_add_bottom_header_meta' ) ) {
	/**
	 * Function that add additional header layout meta box options
	 *
	 * @param object $page
	 */
	function coppola_core_add_bottom_header_meta( $page ) {

		$section = $page->add_section_element(
			array(
				'name'       => 'qodef_bottom_header_section',
				'title'      => esc_html__( 'Bottom Header', 'coppola-core' ),
				'dependency' => array(
					'show' => array(
						'qodef_header_layout' => array(
							'values'        => 'bottom',
							'default_value' => '',
						),
					),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_bottom_header_height',
				'title'       => esc_html__( 'Header Height', 'coppola-core' ),
				'description' => esc_html__( 'Enter header height', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'coppola-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_bottom_header_side_padding',
				'title'       => esc_html__( 'Header Side Padding', 'coppola-core' ),
				'description' => esc_html__( 'Enter side padding for header area', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'coppola-core' ),
				),
			)
		);

		$section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_bottom_header_background_color',
				'title'       => esc_html__( 'Header Background Color', 'coppola-core' ),
				'description' => esc_html__( 'Enter header background color', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px', 'coppola-core' ),
				),
			)
		);

		$header_bottom_template_section = $section->add_section_element(
			array(
				'name'        => 'qodef_bottom_header_template_section',
				'title'       => esc_html__( 'Bottom Header Template', 'coppola-core' ),
				'description' => esc_html__( 'Select Elementor template to be displayed above the Header', 'coppola-core' ),
			)
		);

		if ( qode_framework_is_installed( 'elementor' ) ) {
			$elementor_sections = coppola_core_generate_elementor_templates_control( $section );

			if ( ! empty( $elementor_sections ) ) {
				$header_bottom_template_section->add_field_element( $elementor_sections );
			}
		}

	}

	add_action( 'coppola_core_action_after_page_header_meta_map', 'coppola_core_add_bottom_header_meta' );
}
