<?php

if ( ! function_exists( 'coppola_core_add_header_options' ) ) {
	/**
	 * Function that add header options for this module
	 */
	function coppola_core_add_header_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => COPPOLA_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'layout'      => 'tabbed',
				'slug'        => 'header',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Header', 'coppola-core' ),
				'description' => esc_html__( 'Global Header Options', 'coppola-core' ),
			)
		);

		if ( $page ) {
			$general_tab = $page->add_tab_element(
				array(
					'name'  => 'tab-header-general',
					'icon'  => 'fa fa-cog',
					'title' => esc_html__( 'General Settings', 'coppola-core' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'    => 'radio',
					'name'          => 'qodef_header_layout',
					'title'         => esc_html__( 'Header Layout', 'coppola-core' ),
					'description'   => esc_html__( 'Choose a header layout to set for your website', 'coppola-core' ),
					'args'          => array( 'images' => true ),
					'options'       => apply_filters( 'coppola_core_filter_header_layout_option', array() ),
					'default_value' => apply_filters( 'coppola_core_filter_header_layout_default_option_value', '' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_header_skin',
					'title'       => esc_html__( 'Header Skin', 'coppola-core' ),
					'description' => esc_html__( 'Choose a predefined header style for header elements', 'coppola-core' ),
					'options'     => array(
						'none'  => esc_html__( 'None', 'coppola-core' ),
						'light' => esc_html__( 'Light', 'coppola-core' ),
						'dark'  => esc_html__( 'Dark', 'coppola-core' ),
					),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_header_light_hover',
					'title'      => esc_html__( 'Dark Background On Hover', 'coppola-core' ),
					'options'    => coppola_core_get_select_type_options_pool( 'no_yes', false ),
					'dependency' => array(
						'show' => array(
							'qodef_header_skin' => array(
								'values'        => 'light',
								'default_value' => '',
							),
						),
					),
				)
			);

			// Hook to include additional options after module options
			do_action( 'coppola_core_action_after_header_options_map', $page, $general_tab );
		}
	}

	add_action( 'coppola_core_action_default_options_init', 'coppola_core_add_header_options', coppola_core_get_admin_options_map_position( 'header' ) );
}
