<?php

if ( ! function_exists( 'coppola_core_add_general_page_meta_box' ) ) {
	/**
	 * Function that add general meta box options for this module
	 *
	 * @param object $page
	 */
	function coppola_core_add_general_page_meta_box( $page ) {

		$general_tab = $page->add_tab_element(
			array(
				'name'        => 'tab-page',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Page Settings', 'coppola-core' ),
				'description' => esc_html__( 'General page layout settings', 'coppola-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_page_background_color',
				'title'       => esc_html__( 'Page Background Color', 'coppola-core' ),
				'description' => esc_html__( 'Set background color', 'coppola-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'image',
				'name'        => 'qodef_page_background_image',
				'title'       => esc_html__( 'Page Background Image', 'coppola-core' ),
				'description' => esc_html__( 'Set background image', 'coppola-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_repeat',
				'title'       => esc_html__( 'Page Background Image Repeat', 'coppola-core' ),
				'description' => esc_html__( 'Set background image repeat', 'coppola-core' ),
				'options'     => array(
					''          => esc_html__( 'Default', 'coppola-core' ),
					'no-repeat' => esc_html__( 'No Repeat', 'coppola-core' ),
					'repeat'    => esc_html__( 'Repeat', 'coppola-core' ),
					'repeat-x'  => esc_html__( 'Repeat-x', 'coppola-core' ),
					'repeat-y'  => esc_html__( 'Repeat-y', 'coppola-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_size',
				'title'       => esc_html__( 'Page Background Image Size', 'coppola-core' ),
				'description' => esc_html__( 'Set background image size', 'coppola-core' ),
				'options'     => array(
					''        => esc_html__( 'Default', 'coppola-core' ),
					'contain' => esc_html__( 'Contain', 'coppola-core' ),
					'cover'   => esc_html__( 'Cover', 'coppola-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_page_background_attachment',
				'title'       => esc_html__( 'Page Background Image Attachment', 'coppola-core' ),
				'description' => esc_html__( 'Set background image attachment', 'coppola-core' ),
				'options'     => array(
					''       => esc_html__( 'Default', 'coppola-core' ),
					'fixed'  => esc_html__( 'Fixed', 'coppola-core' ),
					'scroll' => esc_html__( 'Scroll', 'coppola-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_page_content_padding',
				'title'       => esc_html__( 'Page Content Padding', 'coppola-core' ),
				'description' => esc_html__( 'Set padding that will be applied for page content in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'coppola-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_page_content_padding_mobile',
				'title'       => esc_html__( 'Page Content Padding Mobile', 'coppola-core' ),
				'description' => esc_html__( 'Set padding that will be applied for page content on mobile screens (1024px and below) in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'coppola-core' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_boxed',
				'title'         => esc_html__( 'Boxed Layout', 'coppola-core' ),
				'description'   => esc_html__( 'Set boxed layout', 'coppola-core' ),
				'default_value' => '',
				'options'       => coppola_core_get_select_type_options_pool( 'yes_no' ),
			)
		);

		$boxed_section = $general_tab->add_section_element(
			array(
				'name'       => 'qodef_boxed_section',
				'title'      => esc_html__( 'Boxed Layout Section', 'coppola-core' ),
				'dependency' => array(
					'hide' => array(
						'qodef_boxed' => array(
							'values'        => 'no',
							'default_value' => '',
						),
					),
				),
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_boxed_background_color',
				'title'       => esc_html__( 'Boxed Background Color', 'coppola-core' ),
				'description' => esc_html__( 'Set boxed background color', 'coppola-core' ),
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'  => 'image',
				'name'        => 'qodef_boxed_background_pattern',
				'title'       => esc_html__( 'Boxed Background Pattern', 'coppola-core' ),
				'description' => esc_html__( 'Set boxed background pattern', 'coppola-core' ),
			)
		);

		$boxed_section->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_boxed_background_pattern_behavior',
				'title'       => esc_html__( 'Boxed Background Pattern Behavior', 'coppola-core' ),
				'description' => esc_html__( 'Set boxed background pattern behavior', 'coppola-core' ),
				'options'     => array(
					''       => esc_html__( 'Default', 'coppola-core' ),
					'fixed'  => esc_html__( 'Fixed', 'coppola-core' ),
					'scroll' => esc_html__( 'Scroll', 'coppola-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'    => 'select',
				'name'          => 'qodef_passepartout',
				'title'         => esc_html__( 'Passepartout', 'coppola-core' ),
				'description'   => esc_html__( 'Enabling this option will display a passepartout around website content', 'coppola-core' ),
				'default_value' => '',
				'options'       => coppola_core_get_select_type_options_pool( 'yes_no' ),
			)
		);

		$passepartout_section = $general_tab->add_section_element(
			array(
				'name'       => 'qodef_passepartout_section',
				'dependency' => array(
					'hide' => array(
						'qodef_passepartout' => array(
							'values'        => 'no',
							'default_value' => '',
						),
					),
				),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'color',
				'name'        => 'qodef_passepartout_color',
				'title'       => esc_html__( 'Passepartout Color', 'coppola-core' ),
				'description' => esc_html__( 'Choose background color for passepartout', 'coppola-core' ),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'image',
				'name'        => 'qodef_passepartout_image',
				'title'       => esc_html__( 'Passepartout Background Image', 'coppola-core' ),
				'description' => esc_html__( 'Set background image for passepartout', 'coppola-core' ),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_passepartout_size',
				'title'       => esc_html__( 'Passepartout Size', 'coppola-core' ),
				'description' => esc_html__( 'Enter size amount for passepartout', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'coppola-core' ),
				),
			)
		);

		$passepartout_section->add_field_element(
			array(
				'field_type'  => 'text',
				'name'        => 'qodef_passepartout_size_responsive',
				'title'       => esc_html__( 'Passepartout Responsive Size', 'coppola-core' ),
				'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (1024px and below)', 'coppola-core' ),
				'args'        => array(
					'suffix' => esc_html__( 'px or %', 'coppola-core' ),
				),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'  => 'select',
				'name'        => 'qodef_content_width',
				'title'       => esc_html__( 'Initial Width of Content', 'coppola-core' ),
				'description' => esc_html__( 'Choose the initial width of content which is in grid (applies to pages set to "Default Template" and rows set to "In Grid")', 'coppola-core' ),
				'options'     => coppola_core_get_select_type_options_pool( 'content_width' ),
			)
		);

		$general_tab->add_field_element(
			array(
				'field_type'    => 'yesno',
				'default_value' => 'no',
				'name'          => 'qodef_content_behind_header',
				'title'         => esc_html__( 'Always put content behind header', 'coppola-core' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'coppola-core' ),
			)
		);

		// Hook to include additional options after module options
		do_action( 'coppola_core_action_after_general_page_meta_box_map', $general_tab );
	}

	add_action( 'coppola_core_action_after_general_meta_box_map', 'coppola_core_add_general_page_meta_box', 9 );
}

if ( ! function_exists( 'coppola_core_add_general_page_meta_box_callback' ) ) {
	/**
	 * Function that set current meta box callback as general callback functions
	 *
	 * @param array $callbacks
	 *
	 * @return array
	 */
	function coppola_core_add_general_page_meta_box_callback( $callbacks ) {
		$callbacks['page'] = 'coppola_core_add_general_page_meta_box';

		return $callbacks;
	}

	add_filter( 'coppola_core_filter_general_meta_box_callbacks', 'coppola_core_add_general_page_meta_box_callback' );
}
