<?php

if ( ! function_exists( 'coppola_core_add_general_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function coppola_core_add_general_options( $page ) {

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_main_color',
					'title'       => esc_html__( 'Main Color', 'coppola-core' ),
					'description' => esc_html__( 'Choose the most dominant theme color', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_page_background_color',
					'title'       => esc_html__( 'Page Background Color', 'coppola-core' ),
					'description' => esc_html__( 'Set background color', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_page_background_image',
					'title'       => esc_html__( 'Page Background Image', 'coppola-core' ),
					'description' => esc_html__( 'Set background image', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_repeat',
					'title'       => esc_html__( 'Page Background Image Repeat', 'coppola-core' ),
					'description' => esc_html__( 'Set background image repeat', 'coppola-core' ),
					'options'     => array(
						''          => esc_html__( 'Default', 'coppola-core' ),
						'no-repeat' => esc_html__( 'No Repeat', 'coppola-core' ),
						'repeat'    => esc_html__( 'Repeat', 'coppola-core' ),
						'repeat-x'  => esc_html__( 'Repeat-x', 'coppola-core' ),
						'repeat-y'  => esc_html__( 'Repeat-y', 'coppola-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_size',
					'title'       => esc_html__( 'Page Background Image Size', 'coppola-core' ),
					'description' => esc_html__( 'Set background image size', 'coppola-core' ),
					'options'     => array(
						''        => esc_html__( 'Default', 'coppola-core' ),
						'contain' => esc_html__( 'Contain', 'coppola-core' ),
						'cover'   => esc_html__( 'Cover', 'coppola-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_page_background_attachment',
					'title'       => esc_html__( 'Page Background Image Attachment', 'coppola-core' ),
					'description' => esc_html__( 'Set background image attachment', 'coppola-core' ),
					'options'     => array(
						''       => esc_html__( 'Default', 'coppola-core' ),
						'fixed'  => esc_html__( 'Fixed', 'coppola-core' ),
						'scroll' => esc_html__( 'Scroll', 'coppola-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding',
					'title'       => esc_html__( 'Page Content Padding', 'coppola-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_page_content_padding_mobile',
					'title'       => esc_html__( 'Page Content Padding Mobile', 'coppola-core' ),
					'description' => esc_html__( 'Set padding that will be applied for page content on mobile screens (1024px and below) in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_svg_word_overlay_source',
					'title'         => esc_html__( 'SVG Word Overlay Source', 'coppola-core' ),
					'default_value' => 'predefined',
					'options'       => coppola_core_get_select_type_options_pool( 'svg_overlay', false ),
				)
			);

			$section_custom_svg = $page->add_section_element(
				array(
					'title'      => esc_html__( 'Custom SVG Path', 'coppola-core' ),
					'name'       => 'qodef_svg_word_overlay_section',
					'dependency' => array(
						'show' => array(
							'qodef_svg_word_overlay_source' => array(
								'values'        => 'custom_svg',
								'default_value' => 'predefined',
							),
						),
					),
				)
			);

			$section_custom_svg->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_svg_word_overlay',
					'title'       => esc_html__( 'SVG Word Overlay', 'coppola-core' ),
					'description' => esc_html__( 'Insert the SVG graphic that will be used for the SVG Word Overlay', 'coppola-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_boxed',
					'title'         => esc_html__( 'Boxed Layout', 'coppola-core' ),
					'description'   => esc_html__( 'Set boxed layout', 'coppola-core' ),
					'default_value' => 'no',
				)
			);

			$boxed_section = $page->add_section_element(
				array(
					'name'       => 'qodef_boxed_section',
					'title'      => esc_html__( 'Boxed Layout Section', 'coppola-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_boxed' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_boxed_background_color',
					'title'       => esc_html__( 'Boxed Background Color', 'coppola-core' ),
					'description' => esc_html__( 'Set boxed background color', 'coppola-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_boxed_background_pattern',
					'title'       => esc_html__( 'Boxed Background Pattern', 'coppola-core' ),
					'description' => esc_html__( 'Set boxed background pattern', 'coppola-core' ),
				)
			);

			$boxed_section->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_boxed_background_pattern_behavior',
					'title'       => esc_html__( 'Boxed Background Pattern Behavior', 'coppola-core' ),
					'description' => esc_html__( 'Set boxed background pattern behavior', 'coppola-core' ),
					'options'     => array(
						'fixed'  => esc_html__( 'Fixed', 'coppola-core' ),
						'scroll' => esc_html__( 'Scroll', 'coppola-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_passepartout',
					'title'         => esc_html__( 'Passepartout', 'coppola-core' ),
					'description'   => esc_html__( 'Enabling this option will display a passepartout around website content', 'coppola-core' ),
					'default_value' => 'no',
				)
			);

			$passepartout_section = $page->add_section_element(
				array(
					'name'       => 'qodef_passepartout_section',
					'title'      => esc_html__( 'Passepartout Section', 'coppola-core' ),
					'dependency' => array(
						'hide' => array(
							'qodef_passepartout' => array(
								'values'        => 'no',
								'default_value' => '',
							),
						),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'color',
					'name'        => 'qodef_passepartout_color',
					'title'       => esc_html__( 'Passepartout Color', 'coppola-core' ),
					'description' => esc_html__( 'Choose background color for passepartout', 'coppola-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'image',
					'name'        => 'qodef_passepartout_image',
					'title'       => esc_html__( 'Passepartout Background Image', 'coppola-core' ),
					'description' => esc_html__( 'Set background image for passepartout', 'coppola-core' ),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size',
					'title'       => esc_html__( 'Passepartout Size', 'coppola-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout', 'coppola-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'coppola-core' ),
					),
				)
			);

			$passepartout_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_passepartout_size_responsive',
					'title'       => esc_html__( 'Passepartout Responsive Size', 'coppola-core' ),
					'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (1024px and below)', 'coppola-core' ),
					'args'        => array(
						'suffix' => esc_html__( 'px or %', 'coppola-core' ),
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_content_width',
					'title'         => esc_html__( 'Initial Width of Content', 'coppola-core' ),
					'description'   => esc_html__( 'Choose the initial width of content which is in grid (applies to pages set to "Default Template" and rows set to "In Grid")', 'coppola-core' ),
					'options'       => coppola_core_get_select_type_options_pool( 'content_width', false ),
					'default_value' => '1400',
				)
			);

			// Hook to include additional options after module options
			do_action( 'coppola_core_action_after_general_options_map', $page );

			$page->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_custom_js',
					'title'       => esc_html__( 'Custom JS', 'coppola-core' ),
					'description' => esc_html__( 'Enter your custom JavaScript here', 'coppola-core' ),
				)
			);
		}
	}

	add_action( 'coppola_core_action_default_options_init', 'coppola_core_add_general_options', coppola_core_get_admin_options_map_position( 'general' ) );
}
