<?php
$fullscreen_menu_video = coppola_core_get_post_value_through_levels( 'qodef_fullscreen_menu_video', true );
?>

<div id="qodef-fullscreen-area">
	<div class="qodef-content-container">
		<?php if ( $fullscreen_menu_in_grid ) { ?>
		<div class="qodef-content-grid">
			<?php } ?>
			<div id="qodef-fullscreen-area-inner">
				<?php if ( has_nav_menu( 'fullscreen-menu-navigation' ) ) { ?>
					<nav class="qodef-fullscreen-menu" role="navigation" aria-label="<?php esc_attr_e( 'Full Screen Menu', 'coppola-core' ); ?>">
						<?php
						wp_nav_menu(
							array(
								'theme_location' => 'fullscreen-menu-navigation',
								'container'      => '',
								'link_before'    => '<span class="qodef-menu-item-text">',
								'link_after'     => '</span>',
								'walker'         => new CoppolaCoreRootMainMenuWalker(),
							)
						);
						?>
					</nav>
				<?php } ?>
			</div>

			<?php if ( $fullscreen_menu_in_grid ) { ?>
		</div>
	<?php } ?>
	</div>
</div>
