<?php

if ( ! function_exists( 'coppola_core_add_fonts_options' ) ) {
	/**
	 * Function that add options for this module
	 */
	function coppola_core_add_fonts_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => COPPOLA_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'fonts',
				'title'       => esc_html__( 'Fonts', 'coppola-core' ),
				'description' => esc_html__( 'Global Fonts Options', 'coppola-core' ),
				'icon'        => 'fa fa-cog',
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_enable_google_fonts',
					'title'         => esc_html__( 'Enable Google Fonts', 'coppola-core' ),
					'default_value' => 'yes',
					'args'          => array(
						'custom_class' => 'qodef-enable-google-fonts',
					),
				)
			);

			$google_fonts_section = $page->add_section_element(
				array(
					'name'       => 'qodef_google_fonts_section',
					'title'      => esc_html__( 'Google Fonts Options', 'coppola-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_enable_google_fonts' => array(
								'values'        => 'yes',
								'default_value' => '',
							),
						),
					),
				)
			);

			$page_repeater = $google_fonts_section->add_repeater_element(
				array(
					'name'        => 'qodef_choose_google_fonts',
					'title'       => esc_html__( 'Google Fonts to Include', 'coppola-core' ),
					'description' => esc_html__( 'Choose Google Fonts which you want to use on your website', 'coppola-core' ),
					'button_text' => esc_html__( 'Add New Google Font', 'coppola-core' ),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type'  => 'googlefont',
					'name'        => 'qodef_choose_google_font',
					'title'       => esc_html__( 'Google Font', 'coppola-core' ),
					'description' => esc_html__( 'Choose Google Font', 'coppola-core' ),
					'args'        => array(
						'include' => 'google-fonts',
					),
				)
			);

			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_weight',
					'title'       => esc_html__( 'Google Fonts Weight', 'coppola-core' ),
					'description' => esc_html__( 'Choose a default Google Fonts weights for your website. Impact on page load time', 'coppola-core' ),
					'options'     => array(
						'100'  => esc_html__( '100 Thin', 'coppola-core' ),
						'100i' => esc_html__( '100 Thin Italic', 'coppola-core' ),
						'200'  => esc_html__( '200 Extra-Light', 'coppola-core' ),
						'200i' => esc_html__( '200 Extra-Light Italic', 'coppola-core' ),
						'300'  => esc_html__( '300 Light', 'coppola-core' ),
						'300i' => esc_html__( '300 Light Italic', 'coppola-core' ),
						'400'  => esc_html__( '400 Regular', 'coppola-core' ),
						'400i' => esc_html__( '400 Regular Italic', 'coppola-core' ),
						'500'  => esc_html__( '500 Medium', 'coppola-core' ),
						'500i' => esc_html__( '500 Medium Italic', 'coppola-core' ),
						'600'  => esc_html__( '600 Semi-Bold', 'coppola-core' ),
						'600i' => esc_html__( '600 Semi-Bold Italic', 'coppola-core' ),
						'700'  => esc_html__( '700 Bold', 'coppola-core' ),
						'700i' => esc_html__( '700 Bold Italic', 'coppola-core' ),
						'800'  => esc_html__( '800 Extra-Bold', 'coppola-core' ),
						'800i' => esc_html__( '800 Extra-Bold Italic', 'coppola-core' ),
						'900'  => esc_html__( '900 Ultra-Bold', 'coppola-core' ),
						'900i' => esc_html__( '900 Ultra-Bold Italic', 'coppola-core' ),
					),
				)
			);

			$google_fonts_section->add_field_element(
				array(
					'field_type'  => 'checkbox',
					'name'        => 'qodef_google_fonts_subset',
					'title'       => esc_html__( 'Google Fonts Style', 'coppola-core' ),
					'description' => esc_html__( 'Choose a default Google Fonts style for your website. Impact on page load time', 'coppola-core' ),
					'options'     => array(
						'latin'        => esc_html__( 'Latin', 'coppola-core' ),
						'latin-ext'    => esc_html__( 'Latin Extended', 'coppola-core' ),
						'cyrillic'     => esc_html__( 'Cyrillic', 'coppola-core' ),
						'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'coppola-core' ),
						'greek'        => esc_html__( 'Greek', 'coppola-core' ),
						'greek-ext'    => esc_html__( 'Greek Extended', 'coppola-core' ),
						'vietnamese'   => esc_html__( 'Vietnamese', 'coppola-core' ),
					),
				)
			);

			$page_repeater = $page->add_repeater_element(
				array(
					'name'        => 'qodef_custom_fonts',
					'title'       => esc_html__( 'Custom Fonts', 'coppola-core' ),
					'description' => esc_html__( 'Add custom fonts', 'coppola-core' ),
					'button_text' => esc_html__( 'Add New Custom Font', 'coppola-core' ),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_ttf',
					'title'      => esc_html__( 'Custom Font TTF', 'coppola-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_otf',
					'title'      => esc_html__( 'Custom Font OTF', 'coppola-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_woff',
					'title'      => esc_html__( 'Custom Font WOFF', 'coppola-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_custom_font_woff2',
					'title'      => esc_html__( 'Custom Font WOFF2', 'coppola-core' ),
					'args'       => array(
						'allowed_type' => 'application/octet-stream',
					),
				)
			);

			$page_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_custom_font_name',
					'title'      => esc_html__( 'Custom Font Name', 'coppola-core' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'coppola_core_action_after_page_fonts_options_map', $page );
		}
	}

	add_action( 'coppola_core_action_default_options_init', 'coppola_core_add_fonts_options', coppola_core_get_admin_options_map_position( 'fonts' ) );
}
