<?php

if ( ! function_exists( 'coppola_core_is_custom_cursor_enabled' ) ) {
	/**
	 * Function that check is option enabled
	 *
	 * @return bool
	 */
	function coppola_core_is_custom_cursor_enabled() {
		return 'yes' === coppola_core_get_post_value_through_levels( 'qodef_enable_page_custom_cursor' );
	}
}

if ( ! function_exists( 'coppola_core_set_custom_cursor_body_classes' ) ) {
	/**
	 * Function that add additional class name into global class list for body tag
	 *
	 * @param array $classes
	 *
	 * @return array
	 */
	function coppola_core_set_custom_cursor_body_classes( $classes ) {

		if ( coppola_core_is_custom_cursor_enabled() ) {
			$classes[] = 'qodef-custom-cursor-enabled';
		}

		return $classes;
	}

	add_filter( 'body_class', 'coppola_core_set_custom_cursor_body_classes' );
}

if ( ! function_exists( 'coppola_core_load_custom_cursor' ) ) {
	/**
	 * Loads Spinners HTML
	 */
	function coppola_core_load_custom_cursor() {

		if ( coppola_core_is_custom_cursor_enabled() ) {
			$parameters = array();

			coppola_core_template_part( 'custom-cursor', 'templates/custom-cursor', '', $parameters );
		}
	}

	add_action( 'coppola_action_before_body_tag_close', 'coppola_core_load_custom_cursor' );
}
