(function ( $ ) {
	'use strict';
	
	$( document ).ready(
		function() {
			qodefCustomCursor.init();
		}
	);
	
	$( window ).on(
		'elementor/frontend/init',
		function () {
			var isEditMode = Boolean( elementorFrontend.isEditMode() );
			
			if ( isEditMode ) {
				qodefCustomCursor.init();
			}
		}
	);
	
	var qodefCustomCursor = {
		init: function () {
			let cursorEnabled = qodefCore.body.hasClass( 'qodef-custom-cursor-enabled' ),
				cursor = $( '#qodef-custom-cursor' );
			
			if ( qodefCore.windowWidth >= 1024 && cursorEnabled ) {
				$( document ).one( 'mousemove', function () {
					qodefCustomCursor.showCursor( cursor );
				} );
				qodefCustomCursor.moveCursor( cursor );
				qodefCustomCursor.hoverClass( cursor );
				qodefCustomCursor.changeCursor( cursor );
			}
		},
		moveCursor: function ( cursor ) {
			let transformCursor = function ( x, y ) {
				cursor.css( {
					'transform': 'translate3d(' + x + 'px, ' + y + 'px, 0)'
				} );
			};
			
			let handleMove = function ( e ) {
				let x = e.clientX - cursor.width() / 2,
					y = e.clientY - cursor.height() / 2;
				
				requestAnimationFrame( function () {
					transformCursor( x, y );
				} );
			};
			
			$( window ).on( 'mousemove', handleMove );
		},
		hoverClass: function ( cursor ) {
			let items = 'a, button, .tp-bullet, .tp-withaction, button, .qodef-m-filter-item, .ui-slider-handle';
			let addCSSClass = function () {
				!cursor.hasClass( 'qodef--hover' ) && cursor.addClass( 'qodef--hover' );
			};
			
			let removeCSSClass = function () {
				cursor.hasClass( 'qodef--hover' ) && cursor.removeClass( 'qodef--hover' );
			};
			
			$( document ).on( 'mouseenter', items, addCSSClass );
			$( document ).on( 'mouseleave', items, removeCSSClass );
		},
		showCursor: function ( cursor ) {
			!cursor.hasClass( 'qodef--visible' ) && cursor.addClass( 'qodef--visible' );
		},
		hideCursor: function ( cursor ) {
			cursor.hasClass( 'qodef--visible' ) && cursor.removeClass( 'qodef--visible qodef--hover' );
		},
		overrideCursor: function ( cursor ) {
			cursor.toggleClass( 'qodef-override' );
		},
		changeCursor: function ( cursor ) {
			let instances = [
				{
					type: 'watch',
					triggers: '.qodef-portfolio-list .qodef-e-media-image'
				}
				],
				triggers = '',
				hides = '.qodef-e-content-follow, .mfp-content',
				overrides = 'form, #menu-full-screen-menu';
			
			let setCursor = function ( type ) {
				cursor.addClass('qodef--' + type);
			};
			
			let resetCursor = function () {
				instances.forEach( function ( instance ) {
					cursor.removeClass('qodef--' + instance.type);
				} );
			};
			
			instances.forEach( function ( instance, i ) {
				triggers += instance.triggers;
				if ( i + 1 < instances.length ) triggers += ', ';
				
				$( document ).on( 'mouseenter', instance.triggers, function () {
					setCursor( instance.type );
				} );
			} );
			
			$( document ).on( 'mouseleave', triggers, resetCursor );
			$( document ).on( 'mouseenter mouseleave', overrides, function () {
				qodefCustomCursor.overrideCursor( cursor );
			} );
			$( document ).on( 'mousemove', hides, function () {
				qodefCustomCursor.hideCursor( cursor );
			} );
			$( document ).on( 'mouseleave', hides, function () {
				qodefCustomCursor.showCursor( cursor );
			} );
			$( document ).on( 'mouseleave', qodefCustomCursor.hideCursor.bind( this, cursor ) ) ;
			$( document ).on( 'mouseenter', qodefCustomCursor.showCursor.bind( this, cursor ) );
		}
	};
	
})(jQuery);
