<?php

if ( ! function_exists( 'coppola_core_add_blog_list_variation_info_over' ) ) {
	/**
	 * Function that add variation layout for this module
	 *
	 * @param array $variations
	 *
	 * @return array
	 */
	function coppola_core_add_blog_list_variation_info_over( $variations ) {
		$variations['info-over'] = esc_html__( 'Info Over Image', 'coppola-core' );

		return $variations;
	}

	add_filter( 'coppola_core_filter_blog_list_layouts', 'coppola_core_add_blog_list_variation_info_over' );
}

if ( ! function_exists( 'coppola_core_load_blog_list_variation_info_over_assets' ) ) {
	/**
	 * Function that return is global blog asses allowed for variation layout
	 *
	 * @param bool $is_enabled
	 * @param array $params
	 *
	 * @return bool
	 */
	function coppola_core_load_blog_list_variation_info_over_assets( $is_enabled, $params ) {

		if ( 'info-over' === $params['layout'] ) {
			$is_enabled = true;
		}

		return $is_enabled;
	}

	add_filter( 'coppola_core_filter_load_blog_list_assets', 'coppola_core_load_blog_list_variation_info_over_assets', 10, 2 );
}

if ( ! function_exists( 'coppola_core_register_blog_list_info_over_scripts' ) ) {
	/**
	 * Function that register modules 3rd party scripts
	 *
	 * @param array $scripts
	 *
	 * @return array
	 */
	function coppola_core_register_blog_list_info_over_scripts( $scripts ) {

		$scripts['wp-mediaelement']    = array(
			'registered' => true,
		);
		$scripts['mediaelement-vimeo'] = array(
			'registered' => true,
		);

		return $scripts;
	}

	add_filter( 'coppola_core_filter_blog_list_register_scripts', 'coppola_core_register_blog_list_info_over_scripts' );
}

if ( ! function_exists( 'coppola_core_register_blog_list_info_over_styles' ) ) {
	/**
	 * Function that register modules 3rd party scripts
	 *
	 * @param array $styles
	 *
	 * @return array
	 */
	function coppola_core_register_blog_list_info_over_styles( $styles ) {

		$styles['wp-mediaelement'] = array(
			'registered' => true,
		);

		return $styles;
	}

	add_filter( 'coppola_core_filter_blog_list_register_styles', 'coppola_core_register_blog_list_info_over_styles' );
}
