(function ( $ ) {
	'use strict';
	
	var shortcode = 'coppola_core_blog_list';

	$( document ).on(
		'coppola_trigger_get_new_posts',
		function ( e, $holder, response, nextPage ) {
			if ( $holder.hasClass( 'qodef-item-layout--featured-right.qodef-swiper-container' ) ) {
				qodefWooPostHeight.init();
			}
		}
	);

	$( window ).on(
		'load',
		function () {
			qodefWooPostHeight.init();
		}
	);

	var qodefWooPostHeight = {
		init() {
			const $holder  = $( '.qodef-blog.qodef-item-layout--featured-right.qodef-swiper-container' );

			if ( $holder.length ) {
				$holder.each(
					( index,element ) => {
						const $thisHolder       = $( element );
						let   maxHeight         = 0;
						$thisHolder.find( '.qodef-blog-item' ).each(
							( i, e ) => {
								const $thisItem = $( e );
								if ( $thisItem.outerHeight() > maxHeight ) {
									maxHeight = $thisItem.outerHeight();
								}
							}
						);
					$thisHolder.find( '.qodef-blog-item' ).height( maxHeight );
					}
				);
			}
		}
	}

	qodefCore.shortcodes[shortcode]                    = {};
	qodefCore.shortcodes[shortcode].qodefWooPostHeight = qodefWooPostHeight;

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

})( jQuery );
