(function ( $ ) {
	'use strict';

	// This case is important when theme is not active
	if ( typeof qodef !== 'object' ) {
		window.qodef = {};
	}

	window.qodefCore                = {};
	qodefCore.shortcodes            = {};
	qodefCore.listShortcodesScripts = {
		qodefSwiper: qodef.qodefSwiper,
		qodefPagination: qodef.qodefPagination,
		qodefFilter: qodef.qodefFilter,
		qodefMasonryLayout: qodef.qodefMasonryLayout,
		qodefJustifiedGallery: qodef.qodefJustifiedGallery,
	};

	qodefCore.body         = $( 'body' );
	qodefCore.html         = $( 'html' );
	qodefCore.windowWidth  = $( window ).width();
	qodefCore.windowHeight = $( window ).height();
	qodefCore.scroll       = 0;

	$( document ).ready(
		function () {
			qodefCore.scroll = $( window ).scrollTop();
			qodefInlinePageStyle.init();
			qodefUncoverSection.init();
		}
	);

	$( window ).resize(
		function () {
			qodefCore.windowWidth  = $( window ).width();
			qodefCore.windowHeight = $( window ).height();
		}
	);

	$( window ).scroll(
		function () {
			qodefCore.scroll = $( window ).scrollTop();
		}
	);

	$( window ).load(
		function () {
			qodefParallaxItem.init();
		}
	);

	/**
	 * Check element to be in the viewport
	 */
	var qodefIsInViewport = {
		check: function ( $element, callback, onlyOnce ) {
			if ( $element.length ) {
				var offset = typeof $element.data( 'viewport-offset' ) !== 'undefined' ? $element.data( 'viewport-offset' ) : 0.15; // When item is 15% in the viewport

				var observer = new IntersectionObserver(
					function ( entries ) {
						// isIntersecting is true when element and viewport are overlapping
						// isIntersecting is false when element and viewport don't overlap
						if ( entries[0].isIntersecting === true ) {
							callback.call( $element );

							// Stop watching the element when it's initialize
							if ( onlyOnce !== false ) {
								observer.disconnect();
							}
						}
					},
					{ threshold: [offset] }
				);

				observer.observe( $element[0] );
			}
		},
	};

	qodefCore.qodefIsInViewport = qodefIsInViewport;

	var qodefScroll = {
		disable: function () {
			if ( window.addEventListener ) {
				window.addEventListener(
					'wheel',
					qodefScroll.preventDefaultValue,
					{ passive: false }
				);
			}

			// window.onmousewheel = document.onmousewheel = qodefScroll.preventDefaultValue;
			document.onkeydown = qodefScroll.keyDown;
		},
		enable: function () {
			if ( window.removeEventListener ) {
				window.removeEventListener(
					'wheel',
					qodefScroll.preventDefaultValue,
					{ passive: false }
				);
			}
			window.onmousewheel = document.onmousewheel = document.onkeydown = null;
		},
		preventDefaultValue: function ( e ) {
			e = e || window.event;
			if ( e.preventDefault ) {
				e.preventDefault();
			}
			e.returnValue = false;
		},
		keyDown: function ( e ) {
			var keys = [37, 38, 39, 40];
			for ( var i = keys.length; i--; ) {
				if ( e.keyCode === keys[i] ) {
					qodefScroll.preventDefaultValue( e );
					return;
				}
			}
		}
	};

	qodefCore.qodefScroll = qodefScroll;

	var qodefPerfectScrollbar = {
		init: function ( $holder ) {
			if ( $holder.length ) {
				qodefPerfectScrollbar.qodefInitScroll( $holder );
			}
		},
		qodefInitScroll: function ( $holder ) {
			var $defaultParams = {
				wheelSpeed: 0.6,
				suppressScrollX: true
			};

			var $ps = new PerfectScrollbar(
				$holder[0],
				$defaultParams
			);

			$( window ).resize(
				function () {
					$ps.update();
				}
			);
		}
	};

	qodefCore.qodefPerfectScrollbar = qodefPerfectScrollbar;

	var qodefInlinePageStyle = {
		init: function () {
			this.holder = $( '#coppola-core-page-inline-style' );

			if ( this.holder.length ) {
				var style = this.holder.data( 'style' );

				if ( style.length ) {
					$( 'head' ).append( '<style type="text/css">' + style + '</style>' );
				}
			}
		}
	};

	/**
	 * Init parallax item
	 */
	var qodefParallaxItem = {
		init: function () {
			var $items = $( '.qodef-parallax-item' );

			if ( $items.length ) {
				$items.each(
					function () {
						var $currentItem = $( this ),
							$y           = Math.floor( Math.random() * (-100 - (-25)) + (-25) );

						if ( $currentItem.hasClass( 'qodef-grid-item' ) ) {
							$currentItem.children( '.qodef-e-inner' ).attr(
								'data-parallax',
								'{"y": ' + $y + ', "smoothness": ' + '30' + '}'
							);
						} else {
							$currentItem.attr(
								'data-parallax',
								'{"y": ' + $y + ', "smoothness": ' + '30' + '}'
							);
						}
					}
				);
			}

			qodefParallaxItem.initParallax();
		},
		initParallax: function () {
			var parallaxInstances = $( '[data-parallax]' );

			if ( parallaxInstances.length && ! qodefCore.html.hasClass( 'touchevents' ) && typeof ParallaxScroll === 'object' ) {
				ParallaxScroll.init(); //initialization removed from plugin js file to have it run only on non-touch devices
			}
		},
	};

	qodefCore.qodefParallaxItem = qodefParallaxItem;

	/*
	 *  Add uncovering setion
	 */
	var qodefUncoverSection = {
		init: function () {
			this.holder = $( '#qodef-custom-section--uncover' );

			if ( this.holder.length && ! qodefCore.html.hasClass( 'touchevents' ) && qodef.windowWidth > 1024 ) {
				qodefUncoverSection.addClass( this.holder );
				qodefUncoverSection.setHeight( this.holder );
				qodefUncoverSection.setAppear( this.holder );

				$( window ).resize( function () {
					qodefUncoverSection.setHeight( qodefUncoverSection.holder );
				} );
			}
		},
		setHeight: function ( $holder ) {
			$holder.css(
				'height',
				'auto'
			);

			var sectionHeight = $holder.outerHeight();

			if ( sectionHeight > 0 ) {
				$( '#qodef-page-content' ).css( { 'margin-bottom': sectionHeight } );
				$holder.css(
					'height',
					sectionHeight
				);
			}
		},
		addClass: function () {
			qodefCore.body.addClass( 'qodef-page-has-custom-section--uncover' );
		},
		setAppear: function ( $holder ) {
			$( window ).on(
				'scroll',
				function () {
					if ( qodef.scroll + $( window ).height() > $( document ).height() - $holder.height() / 2 ) {
						$holder.addClass( 'qodef-uncovering--active' );
						$holder.find( '.qodef-section-title' ).addClass( 'qodef--appeared' );
					} else {
						$holder.removeClass( 'qodef-uncovering--active' );
						$holder.find( '.qodef-section-title' ).removeClass( 'qodef--appeared' );
					}
				}
			);
		}
	};

	qodef.qodefUncoverSection = qodefUncoverSection;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefBackToTop.init();
		}
	);

	var qodefBackToTop = {
		init: function () {
			this.holder = $( '#qodef-back-to-top' );

			if ( this.holder.length ) {
				// Scroll To Top
				this.holder.on(
					'click',
					function ( e ) {
						e.preventDefault();
						qodefBackToTop.animateScrollToTop();
					}
				);

				qodefBackToTop.showHideBackToTop();
			}
		},
		animateScrollToTop: function () {
			var startPos = qodef.scroll,
				newPos   = qodef.scroll,
				step     = .9,
				animationFrameId;

			var startAnimation = function () {
				if ( newPos === 0 ) {
					return;
				}

				newPos < 0.0001 ? newPos = 0 : null;
				var ease = qodefBackToTop.easingFunction( (startPos - newPos) / startPos );
				$( 'html, body' ).scrollTop( startPos - (startPos - newPos) * ease );
				newPos = newPos * step;

				animationFrameId = requestAnimationFrame( startAnimation );
			};

			startAnimation();

			$( window ).one(
				'wheel touchstart',
				function () {
					cancelAnimationFrame( animationFrameId );
				}
			);
		},
		easingFunction: function ( n ) {
			return 0 == n ? 0 : Math.pow( 1024, n - 1 );
		},
		showHideBackToTop: function () {
			$( window ).scroll(
				function () {
					var $thisItem = $( this ),
						b         = $thisItem.scrollTop(),
						c         = $thisItem.height(),
						d;

					if ( b > 0 ) {
						d = b + c / 2;
					} else {
						d = 1;
					}

					if ( d < 1e3 ) {
						qodefBackToTop.addClass( 'off' );
					} else {
						qodefBackToTop.addClass( 'on' );
					}
				}
			);
		},
		addClass: function ( a ) {
			this.holder.removeClass( 'qodef--off qodef--on' );

			if ( a === 'on' ) {
				this.holder.addClass( 'qodef--on' );
			} else {
				this.holder.addClass( 'qodef--off' );
			}
		}
	};

})( jQuery );

(function ($) {
	"use strict";

	$( window ).on(
		'load',
		function () {
			qodefBackgroundText.init();
		}
	);

	$( window ).resize(
		function () {
			qodefBackgroundText.init();
		}
	);

	var qodefBackgroundText = {
		init                    : function () {
			var $holder = $( '.qodef-background-text' );

			if ($holder.length) {
				$holder.each(
					function () {
						qodefBackgroundText.responsiveOutputHandler( $( this ) );
					}
				);
			}
		},
		responsiveOutputHandler : function ($holder) {
			var breakpoints = {
				3840: 1441,
				1440: 1367,
				1366: 1025,
				1024: 1
			};

			$.each(
				breakpoints,
				function (max, min) {
					if (qodef.windowWidth <= max && qodef.windowWidth >= min) {
						qodefBackgroundText.generateResponsiveOutput( $holder, max );
					}
				}
			);
		},
		generateResponsiveOutput: function ($holder, width) {
			var $textHolder = $holder.find( '.qodef-m-background-text' );

			if ($textHolder.length) {
				$textHolder.css(
					{
						'font-size': $textHolder.data( 'size-' + width ) + 'px',
						'top'      : $textHolder.data( 'vertical-offset-' + width ) + 'px',
					}
				);
			}
		},
	};

	window.qodefBackgroundText = qodefBackgroundText;
})( jQuery );

(function ( $ ) {
	'use strict';
	
	$( document ).ready(
		function() {
			qodefCustomCursor.init();
		}
	);
	
	$( window ).on(
		'elementor/frontend/init',
		function () {
			var isEditMode = Boolean( elementorFrontend.isEditMode() );
			
			if ( isEditMode ) {
				qodefCustomCursor.init();
			}
		}
	);
	
	var qodefCustomCursor = {
		init: function () {
			let cursorEnabled = qodefCore.body.hasClass( 'qodef-custom-cursor-enabled' ),
				cursor = $( '#qodef-custom-cursor' );
			
			if ( qodefCore.windowWidth >= 1024 && cursorEnabled ) {
				$( document ).one( 'mousemove', function () {
					qodefCustomCursor.showCursor( cursor );
				} );
				qodefCustomCursor.moveCursor( cursor );
				qodefCustomCursor.hoverClass( cursor );
				qodefCustomCursor.changeCursor( cursor );
			}
		},
		moveCursor: function ( cursor ) {
			let transformCursor = function ( x, y ) {
				cursor.css( {
					'transform': 'translate3d(' + x + 'px, ' + y + 'px, 0)'
				} );
			};
			
			let handleMove = function ( e ) {
				let x = e.clientX - cursor.width() / 2,
					y = e.clientY - cursor.height() / 2;
				
				requestAnimationFrame( function () {
					transformCursor( x, y );
				} );
			};
			
			$( window ).on( 'mousemove', handleMove );
		},
		hoverClass: function ( cursor ) {
			let items = 'a, button, .tp-bullet, .tp-withaction, button, .qodef-m-filter-item, .ui-slider-handle';
			let addCSSClass = function () {
				!cursor.hasClass( 'qodef--hover' ) && cursor.addClass( 'qodef--hover' );
			};
			
			let removeCSSClass = function () {
				cursor.hasClass( 'qodef--hover' ) && cursor.removeClass( 'qodef--hover' );
			};
			
			$( document ).on( 'mouseenter', items, addCSSClass );
			$( document ).on( 'mouseleave', items, removeCSSClass );
		},
		showCursor: function ( cursor ) {
			!cursor.hasClass( 'qodef--visible' ) && cursor.addClass( 'qodef--visible' );
		},
		hideCursor: function ( cursor ) {
			cursor.hasClass( 'qodef--visible' ) && cursor.removeClass( 'qodef--visible qodef--hover' );
		},
		overrideCursor: function ( cursor ) {
			cursor.toggleClass( 'qodef-override' );
		},
		changeCursor: function ( cursor ) {
			let instances = [
				{
					type: 'watch',
					triggers: '.qodef-portfolio-list .qodef-e-media-image'
				}
				],
				triggers = '',
				hides = '.qodef-e-content-follow, .mfp-content',
				overrides = 'form, #menu-full-screen-menu';
			
			let setCursor = function ( type ) {
				cursor.addClass('qodef--' + type);
			};
			
			let resetCursor = function () {
				instances.forEach( function ( instance ) {
					cursor.removeClass('qodef--' + instance.type);
				} );
			};
			
			instances.forEach( function ( instance, i ) {
				triggers += instance.triggers;
				if ( i + 1 < instances.length ) triggers += ', ';
				
				$( document ).on( 'mouseenter', instance.triggers, function () {
					setCursor( instance.type );
				} );
			} );
			
			$( document ).on( 'mouseleave', triggers, resetCursor );
			$( document ).on( 'mouseenter mouseleave', overrides, function () {
				qodefCustomCursor.overrideCursor( cursor );
			} );
			$( document ).on( 'mousemove', hides, function () {
				qodefCustomCursor.hideCursor( cursor );
			} );
			$( document ).on( 'mouseleave', hides, function () {
				qodefCustomCursor.showCursor( cursor );
			} );
			$( document ).on( 'mouseleave', qodefCustomCursor.hideCursor.bind( this, cursor ) ) ;
			$( document ).on( 'mouseenter', qodefCustomCursor.showCursor.bind( this, cursor ) );
		}
	};
	
})(jQuery);

(function ( $ ) {
	'use strict';

	$( window ).on(
		'load',
		function () {
			qodefUncoverFooter.init();
		}
	);

	var qodefUncoverFooter = {
		holder: '',
		init: function () {
			this.holder = $( '#qodef-page-footer.qodef--uncover' );

			if ( this.holder.length && ! qodefCore.html.hasClass( 'touchevents' ) ) {
				qodefUncoverFooter.addClass();
				qodefUncoverFooter.setHeight( this.holder );

				$( window ).resize(
					function () {
						qodefUncoverFooter.setHeight( qodefUncoverFooter.holder );
					}
				);
			}
		},
		setHeight: function ( $holder ) {
			$holder.css( 'height', 'auto' );

			var footerHeight = $holder.outerHeight();

			if ( footerHeight > 0 ) {
				$( '#qodef-page-outer' ).css(
					{
						'margin-bottom': footerHeight,
						'background-color': qodefCore.body.css( 'backgroundColor' )
					}
				);

				$holder.css( 'height', footerHeight );
			}
		},
		addClass: function () {
			qodefCore.body.addClass( 'qodef-page-footer--uncover' );
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefFullscreenMenu.init();
		}
	);

	$( window ).on(
		'resize',
		function () {
			qodefFullscreenMenu.handleHeaderWidth( 'resize' );
		}
	);

	var qodefFullscreenMenu = {
		init: function () {
			var $fullscreenMenuOpener = $( 'a.qodef-fullscreen-menu-opener' ),
				$menuItems            = $( '#qodef-fullscreen-area nav ul li a' ),
				$menuVideos           = $menuItems.find('.qodef-video--autoplay'),
				$menuContainer        = $('#qodef-fullscreen-area .qodef-content-container'),
				$menuList             = $( '#qodef-fullscreen-area nav ul li' );

			if ( $fullscreenMenuOpener.length ) {
				// prevent header changing width when fullscreen menu is open
				qodefFullscreenMenu.handleHeaderWidth( 'init' );

				// open popup menu
				$fullscreenMenuOpener.on(
					'click',
					function ( e ) {
						e.preventDefault();
						var $thisOpener = $( this );

						if ( ! qodefCore.body.hasClass( 'qodef-fullscreen-menu--opened' ) ) {
							qodefFullscreenMenu.openFullscreen( $thisOpener );

							$( document ).keyup(
								function ( e ) {
									if ( e.keyCode === 27 ) {
										qodefFullscreenMenu.closeFullscreen( $thisOpener );
									}
								}
							);
						} else {
							qodefFullscreenMenu.closeFullscreen( $thisOpener );
						}
					}
				);
				
				$menuVideos.each( function () {
					var $item = $(this);
					$menuContainer.append($item.get());
				});

				$menuList.on('mouseenter', function () {
					var $thisItem = this,
						$id  = $thisItem.className.split(' ').filter($item => $item / 1);
					
					$menuVideos.each( function () {
						var $item = $(this);
							if (  parseInt( $item.attr('id') ) === parseInt( $id[0] ) ) {
							$item.addClass('qodef--active');
						} else {
							$item.removeClass('qodef--active');
						}
					});
				});

				// open dropdowns
				$menuItems.on(
					'tap click',
					function ( e ) {
						var $thisItem = $( this );

						if ( $thisItem.parent().hasClass( 'menu-item-has-children' ) ) {
							e.preventDefault();
							qodefFullscreenMenu.clickItemWithChild( $thisItem );
						} else if ( $thisItem.attr( 'href' ) !== 'http://#' && $thisItem.attr( 'href' ) !== '#' ) {
							qodefFullscreenMenu.closeFullscreen( $fullscreenMenuOpener );
						}
					}
				);
			}
			qodefFullscreenMenu.fullscreenMenuVideo();
		},
		openFullscreen: function ( $opener ) {
			$opener.addClass( 'qodef--opened' );
			qodefCore.body.removeClass( 'qodef-fullscreen-menu-animate--out' ).addClass( 'qodef-fullscreen-menu--opened qodef-fullscreen-menu-animate--in' );
			qodefCore.qodefScroll.disable();
		},
		closeFullscreen: function ( $opener ) {
			$opener.removeClass( 'qodef--opened' );
			qodefCore.body.removeClass( 'qodef-fullscreen-menu--opened qodef-fullscreen-menu-animate--in' ).addClass( 'qodef-fullscreen-menu-animate--out' );
			qodefCore.qodefScroll.enable();
			$( 'nav.qodef-fullscreen-menu ul.sub_menu' ).slideUp( 200 );
		},
		clickItemWithChild: function ( thisItem ) {
			var $thisItemParent  = thisItem.parent(),
				$thisItemSubMenu = $thisItemParent.find( '.sub-menu' ).first();

			if ( $thisItemSubMenu.is( ':visible' ) ) {
				$thisItemSubMenu.slideUp( 300 );
				$thisItemParent.removeClass( 'qodef--opened' );
			} else {
				$thisItemSubMenu.slideDown( 300 );
				$thisItemParent.addClass( 'qodef--opened' ).siblings().find( '.sub-menu' ).slideUp( 400 );
			}
		},
		handleHeaderWidth: function ( state ) {
			var $header               = $( '#qodef-page-header' );
			var $fullscreenMenuOpener = $( 'a.qodef-fullscreen-menu-opener' );

			if ( $header.length && $fullscreenMenuOpener.length ) {
				// if desktop device
				if ( qodefCore.windowWidth > 1024 ) {
					// if page height is greater then window height, scroll bar is visible
					if ( qodefCore.body.height() > qodefCore.windowHeight ) {
						// on resize reset previously set inline width
						if ( 'resize' === state ) {
							$header.css( { 'width': '' } );
						}
						$header.width( $header.width() );
					}
				} else {
					// reset previously set inline width
					$header.css( { 'width': '' } );
				}
			}
		},
		fullscreenMenuVideo: function () {
			var fullscreenVideo = $( '.qodef-fullscreen-menu-video' );

			if ( qodefCore.windowWidth > 1024 ) {
				var video = fullscreenVideo.find( '.qodef-video--on-hover video' );

				fullscreenVideo.on(
					'mouseenter touchstart',
					function ( e ) {
						e.preventDefault();

						if ( video.length ) {
							var isPlaying = video.get( 0 ).currentTime > 0 && ! video.get( 0 ).paused && ! video.get( 0 ).ended && video.get( 0 ).readyState > 2;

							if ( ! isPlaying ) {
								video.get( 0 ).play();
							}
						}
					}
				);
				fullscreenVideo.on(
					'mouseleave touchend',
					function ( e ) {
						e.preventDefault();

						if ( video.length ) {
							setTimeout(
								function () {
									video.get( 0 ).pause();
									video.get( 0 ).currentTime = 0;
								},
								200
							);
						}
					}
				);
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefHeaderScrollAppearance.init();
			qodefBottomHeaderTemplate.init();
		}
	);

	var qodefHeaderScrollAppearance = {
		appearanceType: function () {
			return qodefCore.body.attr( 'class' ).indexOf( 'qodef-header-appearance--' ) !== -1 ? qodefCore.body.attr( 'class' ).match( /qodef-header-appearance--([\w]+)/ )[1] : '';
		},
		init: function () {
			var appearanceType = this.appearanceType();

			if ( appearanceType !== '' && appearanceType !== 'none' ) {
				qodefCore[appearanceType + 'HeaderAppearance']();
			}
		}
	};

	var qodefBottomHeaderTemplate = {
		init: function () {
			var $bottomHeaderTemplate = $( '.qodef-header--bottom .qodef-template-holder' );
			var $bottomHeader         = $( '.qodef-header--bottom #qodef-page-header' );

			$bottomHeader.css(
				'margin-top',
				$bottomHeaderTemplate.outerHeight()
			);
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
	    function () {
            qodefMobileHeaderAppearance.init();
        }
	);

	/*
	 **	Init mobile header functionality
	 */
	var qodefMobileHeaderAppearance = {
		init: function () {
			if ( qodefCore.body.hasClass( 'qodef-mobile-header-appearance--sticky' ) ) {

				var docYScroll1   = qodefCore.scroll,
					displayAmount = qodefGlobal.vars.mobileHeaderHeight + qodefGlobal.vars.adminBarHeight,
					$pageOuter    = $( '#qodef-page-outer' );

				qodefMobileHeaderAppearance.showHideMobileHeader( docYScroll1, displayAmount, $pageOuter );

				$( window ).scroll(
				    function () {
                        qodefMobileHeaderAppearance.showHideMobileHeader( docYScroll1, displayAmount, $pageOuter );
                        docYScroll1 = qodefCore.scroll;
                    }
				);

				$( window ).resize(
				    function () {
                        $pageOuter.css( 'padding-top', 0 );
                        qodefMobileHeaderAppearance.showHideMobileHeader( docYScroll1, displayAmount, $pageOuter );
                    }
				);
			}
		},
		showHideMobileHeader: function ( docYScroll1, displayAmount, $pageOuter ) {
			if ( qodefCore.windowWidth <= 1024 ) {
				if ( qodefCore.scroll > displayAmount * 2 ) {
					//set header to be fixed
					qodefCore.body.addClass( 'qodef-mobile-header--sticky' );

					//add transition to it
					setTimeout(
						function () {
							qodefCore.body.addClass( 'qodef-mobile-header--sticky-animation' );
						},
						300
					); //300 is duration of sticky header animation

					//add padding to content so there is no 'jumping'
					$pageOuter.css( 'padding-top', qodefGlobal.vars.mobileHeaderHeight );
				} else {
					//unset fixed header
					qodefCore.body.removeClass( 'qodef-mobile-header--sticky' );

					//remove transition
					setTimeout(
						function () {
							qodefCore.body.removeClass( 'qodef-mobile-header--sticky-animation' );
						},
						300
					); //300 is duration of sticky header animation

					//remove padding from content since header is not fixed anymore
					$pageOuter.css( 'padding-top', 0 );
				}

				if ( (qodefCore.scroll > docYScroll1 && qodefCore.scroll > displayAmount) || (qodefCore.scroll < displayAmount * 3) ) {
					//show sticky header
					qodefCore.body.removeClass( 'qodef-mobile-header--sticky-display' );
				} else {
					//hide sticky header
					qodefCore.body.addClass( 'qodef-mobile-header--sticky-display' );
				}
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefNavMenu.init();
		}
	);

	var qodefNavMenu = {
		init: function () {
			qodefNavMenu.dropdownBehavior();
			qodefNavMenu.wideDropdownPosition();
			qodefNavMenu.dropdownPosition();
		},
		dropdownBehavior: function () {
			var $menuItems = $( '.qodef-header-navigation > ul > li' );

			$menuItems.each(
				function () {
					var $thisItem = $( this );

					if ( $thisItem.find( '.qodef-drop-down-second' ).length ) {
						qodef.qodefWaitForImages.check(
							$thisItem,
							function () {
								var $dropdownHolder      = $thisItem.find( '.qodef-drop-down-second' ),
									$dropdownMenuItem    = $dropdownHolder.find( '.qodef-drop-down-second-inner ul' ),
									dropDownHolderHeight = $dropdownMenuItem.outerHeight();

								if ( navigator.userAgent.match( /(iPod|iPhone|iPad)/ ) ) {
									$thisItem.on(
										'touchstart mouseenter',
										function () {
											$dropdownHolder.css(
												{
													'height': dropDownHolderHeight,
													'overflow': 'visible',
													'visibility': 'visible',
													'opacity': '1',
												}
											);
										}
									).on(
										'mouseleave',
										function () {
											$dropdownHolder.css(
												{
													'height': '0px',
													'overflow': 'hidden',
													'visibility': 'hidden',
													'opacity': '0',
												}
											);
										}
									);
								} else {
									if ( qodefCore.body.hasClass( 'qodef-drop-down-second--animate-height' ) ) {
										var animateConfig = {
											interval: 0,
											over: function () {
												setTimeout(
													function () {
														$dropdownHolder.addClass( 'qodef-drop-down--start' ).css(
															{
																'visibility': 'visible',
																'height': '0',
																'opacity': '1',
															}
														);
														$dropdownHolder.stop().animate(
															{
																'height': dropDownHolderHeight,
															},
															400,
															'linear',
															function () {
																$dropdownHolder.css( 'overflow', 'visible' );
															}
														);
													},
													100
												);
											},
											timeout: 100,
											out: function () {
												$dropdownHolder.stop().animate(
													{
														'height': '0',
														'opacity': 0,
													},
													100,
													function () {
														$dropdownHolder.css(
															{
																'overflow': 'hidden',
																'visibility': 'hidden',
															}
														);
													}
												);

												$dropdownHolder.removeClass( 'qodef-drop-down--start' );
											}
										};

										$thisItem.hoverIntent( animateConfig );
									} else {
										var config = {
											interval: 0,
											over: function () {
												setTimeout(
													function () {
														$dropdownHolder.addClass( 'qodef-drop-down--start' ).stop().css( { 'height': dropDownHolderHeight } );
													},
													150
												);
											},
											timeout: 150,
											out: function () {
												$dropdownHolder.stop().css( { 'height': '0' } ).removeClass( 'qodef-drop-down--start' );
											}
										};

										$thisItem.hoverIntent( config );
									}
								}
							}
						);
					}
				}
			);
		},
		wideDropdownPosition: function () {
			var $menuItems = $( '.qodef-header-navigation > ul > li.qodef-menu-item--wide' );

			if ( $menuItems.length ) {
				$menuItems.each(
					function () {
						var $menuItem        = $( this );
						var $menuItemSubMenu = $menuItem.find( '.qodef-drop-down-second' );

						if ( $menuItemSubMenu.length ) {
							$menuItemSubMenu.css( 'left', 0 );

							var leftPosition = $menuItemSubMenu.offset().left;

							if ( qodefCore.body.hasClass( 'qodef--boxed' ) ) {
								//boxed layout case
								var boxedWidth = $( '.qodef--boxed #qodef-page-wrapper' ).outerWidth();
								leftPosition   = leftPosition - (qodefCore.windowWidth - boxedWidth) / 2;
								$menuItemSubMenu.css( { 'left': -leftPosition, 'width': boxedWidth } );

							} else if ( qodefCore.body.hasClass( 'qodef-drop-down-second--full-width' ) ) {
								//wide dropdown full width case
								$menuItemSubMenu.css( { 'left': -leftPosition, 'width': qodefCore.windowWidth } );
							} else {
								//wide dropdown in grid case
								$menuItemSubMenu.css( { 'left': -leftPosition + (qodefCore.windowWidth - $menuItemSubMenu.width()) / 2 } );
							}
						}
					}
				);
			}
		},
		dropdownPosition: function () {
			var $menuItems = $( '.qodef-header-navigation > ul > li.qodef-menu-item--narrow.menu-item-has-children' );

			if ( $menuItems.length ) {
				$menuItems.each(
					function () {
						var $thisItem         = $( this ),
							menuItemPosition  = $thisItem.offset().left,
							$dropdownHolder   = $thisItem.find( '.qodef-drop-down-second' ),
							$dropdownMenuItem = $dropdownHolder.find( '.qodef-drop-down-second-inner ul' ),
							dropdownMenuWidth = $dropdownMenuItem.outerWidth(),
							menuItemFromLeft  = $( window ).width() - menuItemPosition;

						if ( qodef.body.hasClass( 'qodef--boxed' ) ) {
							//boxed layout case
							var boxedWidth   = $( '.qodef--boxed #qodef-page-wrapper' ).outerWidth();
							menuItemFromLeft = boxedWidth - menuItemPosition;
						}

						var dropDownMenuFromLeft;

						if ( $thisItem.find( 'li.menu-item-has-children' ).length > 0 ) {
							dropDownMenuFromLeft = menuItemFromLeft - dropdownMenuWidth;
						}

						$dropdownHolder.removeClass( 'qodef-drop-down--right' );
						$dropdownMenuItem.removeClass( 'qodef-drop-down--right' );
						if ( menuItemFromLeft < dropdownMenuWidth || dropDownMenuFromLeft < dropdownMenuWidth ) {
							$dropdownHolder.addClass( 'qodef-drop-down--right' );
							$dropdownMenuItem.addClass( 'qodef-drop-down--right' );
						}
					}
				);
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( window ).on(
		'load',
		function () {
			qodefParallaxBackground.init();
		}
	);

	/**
	 * Init global parallax background functionality
	 */
	var qodefParallaxBackground = {
		init: function ( settings ) {
			this.$sections = $( '.qodef-parallax' );

			// Allow overriding the default config
			$.extend( this.$sections, settings );

			var isSupported = ! qodefCore.html.hasClass( 'touchevents' ) && ! qodefCore.body.hasClass( 'qodef-browser--edge' ) && ! qodefCore.body.hasClass( 'qodef-browser--ms-explorer' );

			if ( this.$sections.length && isSupported ) {
				this.$sections.each(
					function () {
						qodefParallaxBackground.ready( $( this ) );
					}
				);
			}
		},
		ready: function ( $section ) {
			$section.$imgHolder  = $section.find( '.qodef-parallax-img-holder' );
			$section.$imgWrapper = $section.find( '.qodef-parallax-img-wrapper' );
			$section.$img        = $section.find( 'img.qodef-parallax-img' );

			var h           = $section.height(),
				imgWrapperH = $section.$imgWrapper.height();

			$section.movement = 100 * (imgWrapperH - h) / h / 2; //percentage (divided by 2 due to absolute img centering in CSS)

			$section.buffer       = window.pageYOffset;
			$section.scrollBuffer = null;


			//calc and init loop
			requestAnimationFrame(
				function () {
					$section.$imgHolder.animate( { opacity: 1 }, 100 );
					qodefParallaxBackground.calc( $section );
					qodefParallaxBackground.loop( $section );
				}
			);

			//recalc
			$( window ).on(
				'resize',
				function () {
					qodefParallaxBackground.calc( $section );
				}
			);
		},
		calc: function ( $section ) {
			var wH = $section.$imgWrapper.height(),
				wW = $section.$imgWrapper.width();

			if ( $section.$img.width() < wW ) {
				$section.$img.css(
					{
						'width': '100%',
						'height': 'auto',
					}
				);
			}

			if ( $section.$img.height() < wH ) {
				$section.$img.css(
					{
						'height': '100%',
						'width': 'auto',
						'max-width': 'unset',
					}
				);
			}
		},
		loop: function ( $section ) {
			if ( $section.scrollBuffer === Math.round( window.pageYOffset ) ) {
				requestAnimationFrame(
					function () {
						qodefParallaxBackground.loop( $section );
					}
				); //repeat loop

				return false; //same scroll value, do nothing
			} else {
				$section.scrollBuffer = Math.round( window.pageYOffset );
			}

			var wH   = window.outerHeight,
				sTop = $section.offset().top,
				sH   = $section.height();

			if ( $section.scrollBuffer + wH * 1.2 > sTop && $section.scrollBuffer < sTop + sH ) {
				var delta = (Math.abs( $section.scrollBuffer + wH - sTop ) / (wH + sH)).toFixed( 4 ), //coeff between 0 and 1 based on scroll amount
					yVal  = (delta * $section.movement).toFixed( 4 );

				if ( $section.buffer !== delta ) {
					$section.$imgWrapper.css( 'transform', 'translate3d(0,' + yVal + '%, 0)' );
				}

				$section.buffer = delta;
			}

			requestAnimationFrame(
				function () {
					qodefParallaxBackground.loop( $section );
				}
			); //repeat loop
		}
	};

	qodefCore.qodefParallaxBackground = qodefParallaxBackground;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefReview.init();
		}
	);

	var qodefReview = {
		init: function () {
			var ratingHolder = $( '#qodef-page-comments-form .qodef-rating-inner' );

			var addActive = function ( stars, ratingValue ) {
				for ( var i = 0; i < stars.length; i++ ) {
					var star = stars[i];

					if ( i < ratingValue ) {
						$( star ).addClass( 'active' );
					} else {
						$( star ).removeClass( 'active' );
					}
				}
			};

			ratingHolder.each(
				function () {
					var thisHolder  = $( this ),
						ratingInput = thisHolder.find( '.qodef-rating' ),
						ratingValue = ratingInput.val(),
						stars       = thisHolder.find( '.qodef-star-rating' );

					addActive( stars, ratingValue );

					stars.on(
						'click',
						function () {
							ratingInput.val( $( this ).data( 'value' ) ).trigger( 'change' );
						}
					);

					ratingInput.change(
						function () {
							ratingValue = ratingInput.val();

							addActive( stars, ratingValue );
						}
					);
				}
			);
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSideArea.init();
		}
	);

	var qodefSideArea = {
		init: function () {
			var $sideAreaOpener = $( 'a.qodef-side-area-opener' ),
				$sideAreaClose  = $( '#qodef-side-area-close' ),
				$sideArea       = $( '#qodef-side-area' );

			qodefSideArea.openerHoverColor( $sideAreaOpener );

			// Open Side Area
			$sideAreaOpener.on(
				'click',
				function ( e ) {
					e.preventDefault();

					if ( ! qodefCore.body.hasClass( 'qodef-side-area--opened' ) ) {
						qodefSideArea.openSideArea();

						$( document ).keyup(
							function ( e ) {
								if ( e.keyCode === 27 ) {
									qodefSideArea.closeSideArea();
								}
							}
						);
					} else {
						qodefSideArea.closeSideArea();
					}
				}
			);

			$sideAreaClose.on(
				'click',
				function ( e ) {
					e.preventDefault();
					qodefSideArea.closeSideArea();
				}
			);

			if ( $sideArea.length && typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
				qodefCore.qodefPerfectScrollbar.init( $sideArea );
			}
		},
		openSideArea: function () {
			var $wrapper      = $( '#qodef-page-wrapper' );
			var currentScroll = $( window ).scrollTop();

			$( '.qodef-side-area-cover' ).remove();
			$wrapper.prepend( '<div class="qodef-side-area-cover"/>' );
			qodefCore.body.removeClass( 'qodef-side-area-animate--out' ).addClass( 'qodef-side-area--opened qodef-side-area-animate--in' );

			$( '.qodef-side-area-cover' ).on(
				'click',
				function ( e ) {
					e.preventDefault();
					qodefSideArea.closeSideArea();
				}
			);

			$( window ).scroll(
				function () {
					if ( Math.abs( qodefCore.scroll - currentScroll ) > 400 ) {
						qodefSideArea.closeSideArea();
					}
				}
			);
		},
		closeSideArea: function () {
			qodefCore.body.removeClass( 'qodef-side-area--opened qodef-side-area-animate--in' ).addClass( 'qodef-side-area-animate--out' );
		},
		openerHoverColor: function ( $opener ) {
			if ( typeof $opener.data( 'hover-color' ) !== 'undefined' ) {
				var hoverColor    = $opener.data( 'hover-color' );
				var originalColor = $opener.css( 'color' );

				$opener.on(
					'mouseenter',
					function () {
						$opener.css( 'color', hoverColor );
					}
				).on(
					'mouseleave',
					function () {
						$opener.css( 'color', originalColor );
					}
				);
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSpinner.init();
		}
	);

	$( window ).on(
		'load',
		function () {
			qodefSpinner.windowLoaded = true;
		}
	);

	$( window ).on(
		'elementor/frontend/init',
		function () {
			var isEditMode = Boolean( elementorFrontend.isEditMode() );

			if ( isEditMode ) {
				qodefSpinner.init( isEditMode );
			}
		}
	);

	var qodefSpinner = {
		holder: '',
		windowLoaded: false,
		preloaderFinished: false,
		init: function ( isEditMode ) {
			this.holder = $( '#qodef-page-spinner' );

			if ( this.holder.length ) {

				if ( this.holder.hasClass( 'qodef-layout--coppola' ) ) {

					setTimeout(
						function () {
							qodefSpinner.preloaderFinished = true;

							qodefSpinner.animateSpinner( isEditMode );
							qodefSpinner.fadeOutAnimation();
						},
						4500
					);

				} else {
					qodefSpinner.preloaderFinished = true;
					qodefSpinner.animateSpinner( isEditMode );
					qodefSpinner.fadeOutAnimation();
				}

			}
		},
		animateSpinner: function ( isEditMode ) {

			var qodefLoadInterval = setInterval(
				function () {
					if ( qodefSpinner.windowLoaded && qodefSpinner.preloaderFinished ) {
						clearInterval( qodefLoadInterval );
						$( 'body' ).addClass( 'qodef-spinner-finished' );
						qodefSpinner.fadeOutLoader();
					}
				},
				100
			);

			if ( isEditMode ) {
				qodefSpinner.fadeOutLoader();
			}
		},
		fadeOutLoader: function ( speed, delay, easing ) {
			var $holder = qodefSpinner.holder.length ? qodefSpinner.holder : $( '#qodef-page-spinner' );

			speed  = speed ? speed : 600;
			delay  = delay ? delay : 0;
			easing = easing ? easing : 'swing';

			$holder.delay( delay ).fadeOut(
				speed,
				easing
			);

			$( window ).on(
				'bind',
				'pageshow',
				function ( event ) {
					if ( event.originalEvent.persisted ) {
						$holder.fadeOut(
							speed,
							easing
						);
					}
				}
			);
		},
		fadeOutAnimation: function () {

			// Check for fade out animation
			if ( qodefCore.body.hasClass( 'qodef-spinner--fade-out' ) ) {
				var $pageHolder = $( '#qodef-page-wrapper' ),
					$linkItems  = $( 'a' );

				// If back button is pressed, than show content to avoid state where content is on display:none
				window.addEventListener(
					'pageshow',
					function ( event ) {
						var historyPath = event.persisted || (typeof window.performance !== 'undefined' && window.performance.navigation.type === 2);
						if ( historyPath && ! $pageHolder.is( ':visible' ) ) {
							$pageHolder.show();
						}
					}
				);

				$linkItems.on(
					'click',
					function ( e ) {
						var $clickedLink = $( this );

						if (
							e.which === 1 && // check if the left mouse button has been pressed
							$clickedLink.attr( 'href' ).indexOf( window.location.host ) >= 0 && // check if the link is to the same domain
							! $clickedLink.hasClass( 'remove' ) && // check is WooCommerce remove link
							$clickedLink.parent( '.product-remove' ).length <= 0 && // check is WooCommerce remove link
							$clickedLink.parents( '.woocommerce-product-gallery__image' ).length <= 0 && // check is product gallery link
							typeof $clickedLink.data( 'rel' ) === 'undefined' && // check pretty photo link
							typeof $clickedLink.attr( 'rel' ) === 'undefined' && // check VC pretty photo link
							! $clickedLink.hasClass( 'lightbox-active' ) && // check is lightbox plugin active
							(typeof $clickedLink.attr( 'target' ) === 'undefined' || $clickedLink.attr( 'target' ) === '_self') && // check if the link opens in the same window
							$clickedLink.attr( 'href' ).split( '#' )[0] !== window.location.href.split( '#' )[0] // check if it is an anchor aiming for a different page
						) {
							e.preventDefault();

							$pageHolder.fadeOut(
								600,
								'easeOutSine',
								function () {
									window.location = $clickedLink.attr( 'href' );
								}
							);
						}
					}
				);
			}
		}
	};

})( jQuery );

(function ($) {
	"use strict";

	$(window).on('load', function () {
		qodefStickyColumn.init('init');
	});

	$(window).resize(function () {
		qodefStickyColumn.init('resize');
	});

	var qodefStickyColumn = {
		pageOffset: '',
		scrollAmount: '',

		init: function (state) {
			var $holder = $('.qodef-sticky-column'),
				editor = $holder.hasClass('wpb_column') ? 'wp_bakery' : 'elementor';

			if ($holder.length) {
				$holder.each(function () {
					qodefStickyColumn.calculateVars($(this), state, editor);
				});
			}
		},
		calculateVars: function ($column, state, editor) {
			var columnVars = {};

			if ('wp_bakery' === editor) {
				columnVars.$columnInner = $column.find('.vc_column-inner');
			} else {
				columnVars.$columnInner = $column.find('.elementor-column-wrap');
				if ( ! columnVars.$columnInner.length ) {
					columnVars.$columnInner = $column.find('.elementor-widget-wrap');
				}
			}

			columnVars.columnTopEdgePosition = $column.offset().top;
			columnVars.columnLeftEdgePosition = $column.offset().left;
			columnVars.columnWidth = $column.innerWidth();
			columnVars.columnHeight = columnVars.$columnInner.outerHeight(true);

			if ('wp_bakery' === editor) {
				columnVars.$row = $column.closest('.vc_row');
			} else {
				columnVars.$row = $column.closest('.elementor-section');
			}

			columnVars.rowTopEdgePosition = columnVars.$row.offset().top;
			columnVars.rowHeight = columnVars.$row.outerHeight(true);
			columnVars.rowBottomEdgePosition = columnVars.rowTopEdgePosition + columnVars.rowHeight;
			qodefStickyColumn.scrollAmount = qodef.scroll;
			qodefStickyColumn.scrollAmount = $('#qodef-page-header').outerHeight();

			qodefStickyColumn.checkPosition( $column, columnVars);

			$(window).scroll(function () {
				if ('init' === state) {
					var scrollDirection = qodefStickyColumn.checkScrollDirection();
				}

				qodefStickyColumn.checkPosition( $column, columnVars, scrollDirection);
			});
		},
		checkPosition: function (column, columnVars, direction) {

			if (qodef.windowWidth > 1024) {
				qodefStickyColumn.calculateOffset();

				if ( column.hasClass('qodef-sticky-fixed') ) {
					qodefStickyColumn.setPosition(columnVars, 'fixed');
				} else {

					if ((qodef.scroll + qodefStickyColumn.pageOffset) <= columnVars.columnTopEdgePosition) {
						qodefStickyColumn.setPosition(columnVars, 'relative');
					}

					if (((qodef.scroll + qodefStickyColumn.pageOffset) >= columnVars.columnTopEdgePosition) && ((qodef.scroll + qodefStickyColumn.pageOffset + columnVars.columnHeight) < columnVars.rowBottomEdgePosition)) {
						qodefStickyColumn.setPosition(columnVars, 'fixed', direction);
					} else if ((qodef.scroll + qodefStickyColumn.pageOffset + columnVars.columnHeight) >= columnVars.rowBottomEdgePosition) {
						if ( column.parents('.qodef-custom-scroll-fix').length ) {
							qodefStickyColumn.setPosition(columnVars, 'fixed', direction);
						} else {
							qodefStickyColumn.setPosition(columnVars, 'absolute');
						}
					}
				}

			} else {
				qodefStickyColumn.setPosition(columnVars, 'relative');
			}
		},
		calculateOffset: function () {
			qodefStickyColumn.pageOffset = 0;

			if ($('body').hasClass('admin-bar')) {
				qodefStickyColumn.pageOffset += 32;
			}

			if ($('body').hasClass('qodef-header--sticky-display') && $('.qodef-header-sticky').length) {
				qodefStickyColumn.pageOffset += parseInt($('.qodef-header-sticky').outerHeight(true));
			}

			if ($('body').hasClass('qodef-header--fixed-display')) {
				qodefStickyColumn.pageOffset += parseInt($('#qodef-page-header').outerHeight(true));
				qodefStickyColumn.pageOffset += parseInt($('#qodef-page-header').css('margin-top'));
			}
		},
		checkScrollDirection: function () {
			var scrollDirection = (qodef.scroll > qodefStickyColumn.scrollAmount) ? 'down' : 'up';

			qodefStickyColumn.scrollAmount = qodef.scroll;

			return scrollDirection;
		},
		setPosition: function (columnVars, position, direction) {
			if ('relative' === position) {
				columnVars.$columnInner.css({
					'bottom': 'auto',
					'left': 'auto',
					'position': 'relative',
					'top': 'auto',
					'width': columnVars.columnWidth,
					'transform': 'translateY(0)',
					'transition': 'none'
				});
			}
			if ('fixed' === position) {
				var transitionValue = 'none';


				if ($('body').hasClass('qodef-header--sticky-display')) {
					transitionValue = ('up' === direction) ? 'none' : 'transform .5s ease';
				}

				if ( $('body').hasClass('qodef-header-fixed-from-start') ) {
					columnVars.$columnInner.css({
						'bottom': 'auto',
						'left': columnVars.columnLeftEdgePosition,
						'position': 'fixed',
						'top': 0,
						'width': columnVars.columnWidth,
						'transform': 'translateY(' +  $('#qodef-page-header').outerHeight()  + 'px)',
						'transition': transitionValue
					});
				} else {
					columnVars.$columnInner.css({
						'bottom': 'auto',
						'left': columnVars.columnLeftEdgePosition,
						'position': 'fixed',
						'top': 0,
						'width': columnVars.columnWidth,
						'transform': 'translateY(' + qodefStickyColumn.pageOffset + 'px)',
						'transition': transitionValue
					});
				}
			}
			if ('absolute' === position) {
				columnVars.$columnInner.css({
					'bottom': -columnVars.rowHeight,
					'left': '0',
					'position': 'absolute',
					'top': 'auto',
					'width': columnVars.columnWidth,
					'transform': 'translateY(0)',
					'transition': 'none'
				});
			}
		}
	};

	window.qodefStickyColumn = qodefStickyColumn;
})(jQuery);

(function ( $ ) {
	'use strict';

	$( window ).on(
		'load',
		function () {
			qodefSubscribeModal.init();
		}
	);

	var qodefSubscribeModal = {
		init: function () {
			this.holder = $( '#qodef-subscribe-popup-modal' );

			if ( this.holder.length ) {
				var $preventHolder = this.holder.find( '.qodef-sp-prevent' ),
					$modalClose    = $( '.qodef-sp-close' ),
					disabledPopup  = 'no';

				if ( $preventHolder.length ) {
					var isLocalStorage = this.holder.hasClass( 'qodef-sp-prevent-cookies' ),
						$preventInput  = $preventHolder.find( '.qodef-sp-prevent-input' ),
						preventValue   = $preventInput.data( 'value' );

					if ( isLocalStorage ) {
						disabledPopup = localStorage.getItem( 'disabledPopup' );
						sessionStorage.removeItem( 'disabledPopup' );
					} else {
						disabledPopup = sessionStorage.getItem( 'disabledPopup' );
						localStorage.removeItem( 'disabledPopup' );
					}

					$preventHolder.children().on(
						'click',
						function ( e ) {
							if ( preventValue !== 'yes' ) {
								preventValue = 'yes';
								$preventInput.addClass( 'qodef-sp-prevent-clicked' ).data( 'value', 'yes' );
							} else {
								preventValue = 'no';
								$preventInput.removeClass( 'qodef-sp-prevent-clicked' ).data( 'value', 'no' );
							}

							if ( preventValue === 'yes' ) {
								if ( isLocalStorage ) {
									localStorage.setItem( 'disabledPopup', 'yes' );
								} else {
									sessionStorage.setItem( 'disabledPopup', 'yes' );
								}
							} else {
								if ( isLocalStorage ) {
									localStorage.setItem( 'disabledPopup', 'no' );
								} else {
									sessionStorage.setItem( 'disabledPopup', 'no' );
								}
							}
						}
					);
				}

				if ( disabledPopup !== 'yes' ) {
					if ( qodefCore.body.hasClass( 'qodef-sp-opened' ) ) {
						qodefSubscribeModal.handleClassAndScroll( 'remove' );
					} else {
						qodefSubscribeModal.handleClassAndScroll( 'add' );
					}

					$modalClose.on(
						'click',
						function ( e ) {
							e.preventDefault();

							qodefSubscribeModal.handleClassAndScroll( 'remove' );
						}
					);

					// Close on escape
					$( document ).keyup(
						function ( e ) {
							if ( e.keyCode === 27 ) { // KeyCode for ESC button is 27
								qodefSubscribeModal.handleClassAndScroll( 'remove' );
							}
						}
					);
				}
			}
		},

		handleClassAndScroll: function ( option ) {
			if ( option === 'remove' ) {
				qodefCore.body.removeClass( 'qodef-sp-opened' );
				qodefCore.qodefScroll.enable();
			}

			if ( option === 'add' ) {
				qodefCore.body.addClass( 'qodef-sp-opened' );
				qodefCore.qodefScroll.disable();
			}
		},
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefWishlist.init();
		}
	);

	/**
	 * Function object that represents wishlist area popup.
	 * @returns {{init: Function}}
	 */
	var qodefWishlist = {
		init: function () {
			var $wishlistLink = $( '.qodef-wishlist .qodef-m-link' );

			if ( $wishlistLink.length ) {
				$wishlistLink.each(
					function () {
						var $thisWishlistLink = $( this ),
							wishlistIconHTML  = $thisWishlistLink.html(),
							$responseMessage  = $thisWishlistLink.siblings( '.qodef-m-response' );

						$thisWishlistLink.off().on(
							'click',
							function ( e ) {
								e.preventDefault();

								if ( qodefCore.body.hasClass( 'logged-in' ) ) {
									var itemID = $thisWishlistLink.data( 'id' );

									if ( itemID !== 'undefined' && ! $thisWishlistLink.hasClass( 'qodef--added' ) ) {
										$thisWishlistLink.html( '<span class="fa fa-spinner fa-spin" aria-hidden="true"></span>' );

										var wishlistData = {
											type: 'add',
											itemID: itemID,
										};

										$.ajax(
											{
												type: 'POST',
												url: qodefGlobal.vars.restUrl + qodefGlobal.vars.wishlistRestRoute,
												data: {
													options: wishlistData,
												},
												beforeSend: function ( request ) {
													request.setRequestHeader( 'X-WP-Nonce', qodefGlobal.vars.restNonce );
												},
												success: function ( response ) {

													if ( response.status === 'success' ) {
														$thisWishlistLink.addClass( 'qodef--added' );
														$responseMessage.html( response.message ).addClass( 'qodef--show' ).fadeIn( 200 );

														$( document ).trigger(
															'coppola_core_wishlist_item_is_added',
															[itemID, response.data.user_id]
														);
													} else {
														$responseMessage.html( response.message ).addClass( 'qodef--show' ).fadeIn( 200 );
													}

													setTimeout(
														function () {
															$thisWishlistLink.html( wishlistIconHTML );

															var $wishlistTitle = $thisWishlistLink.find( '.qodef-m-link-label' );

															if ( $wishlistTitle.length ) {
																$wishlistTitle.text( $wishlistTitle.data( 'added-title' ) );
															}

															$responseMessage.fadeOut( 300 ).removeClass( 'qodef--show' ).empty();
														},
														800
													);
												}
											}
										);
									}
								} else {
									// Trigger event.
									$( document.body ).trigger( 'coppola_membership_trigger_login_modal' );
								}
							}
						);
					}
				);
			}
		}
	};

	$( document ).on(
		'coppola_core_wishlist_item_is_removed',
		function ( e, removedItemID ) {
			var $wishlistLink = $( '.qodef-wishlist .qodef-m-link' );

			if ( $wishlistLink.length ) {
				$wishlistLink.each(
					function () {
						var $thisWishlistLink = $( this ),
							$wishlistTitle    = $thisWishlistLink.find( '.qodef-m-link-label' );

						if ( $thisWishlistLink.data( 'id' ) === removedItemID && $thisWishlistLink.hasClass( 'qodef--added' ) ) {
							$thisWishlistLink.removeClass( 'qodef--added' );

							if ( $wishlistTitle.length ) {
								$wishlistTitle.text( $wishlistTitle.data( 'title' ) );
							}
						}
					}
				);
			}
		}
	);

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_accordion = {};

	$( document ).ready(
		function () {
			qodefAccordion.init();
		}
	);

	var qodefAccordion = {
		init: function () {
			var $holder = $( '.qodef-accordion' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						qodefAccordion.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			if ( $currentItem.hasClass( 'qodef-behavior--accordion' ) ) {
				qodefAccordion.initAccordion( $currentItem );
			}

			if ( $currentItem.hasClass( 'qodef-behavior--toggle' ) ) {
				qodefAccordion.initToggle( $currentItem );
			}

			$currentItem.addClass( 'qodef--init' );
		},
		initAccordion: function ( $accordion ) {
			$accordion.accordion(
				{
					animate: 'swing',
					collapsible: true,
					active: 0,
					icons: '',
					heightStyle: 'content',
				}
			);
		},
		initToggle: function ( $toggle ) {
			var $toggleAccordionTitle = $toggle.find( '.qodef-accordion-title' );

			$toggleAccordionTitle.off().on(
				'mouseenter',
				function () {
					$( this ).addClass( 'ui-state-hover' );
				}
			).on(
				'mouseleave',
				function () {
					$( this ).removeClass( 'ui-state-hover' );
				}
			).on(
				'click',
				function ( e ) {
					e.preventDefault();
					e.stopImmediatePropagation();

					var $thisTitle = $( this );

					if ( $thisTitle.hasClass( 'ui-state-active' ) ) {
						$thisTitle.removeClass( 'ui-state-active' );
						$thisTitle.next().removeClass( 'ui-accordion-content-active' ).slideUp( 300 );
					} else {
						$thisTitle.addClass( 'ui-state-active' );
						$thisTitle.next().addClass( 'ui-accordion-content-active' ).slideDown( 400 );
					}
				}
			);
		}
	};

	qodefCore.shortcodes.coppola_core_accordion.qodefAccordion = qodefAccordion;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefAuthorListPagination.init();
		}
	);

	$( window ).scroll(
		function () {
			qodefAuthorListPagination.scroll();
		}
	);

	$( document ).on(
		'coppola_core_trigger_author_load_more',
		function ( e, $holder, nextPage ) {
			qodefAuthorListPagination.triggerLoadMore( $holder, nextPage );
		}
	);

	/*
	 **	Init pagination functionality
	 */
	var qodefAuthorListPagination = {
		init: function ( settings ) {
			this.holder = $( '.qodef-author-pagination--on' );

			// Allow overriding the default config
			$.extend( this.holder, settings );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						var $holder = $( this );

						qodefAuthorListPagination.initPaginationType( $holder );
					}
				);
			}
		},
		scroll: function ( settings ) {
			this.holder = $( '.qodef-author-pagination--on' );

			// Allow overriding the default config
			$.extend( this.holder, settings );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						var $holder = $( this );

						if ( $holder.hasClass( 'qodef-pagination-type--infinite-scroll' ) ) {
							qodefAuthorListPagination.initInfiniteScroll( $holder );
						}
					}
				);
			}
		},
		initPaginationType: function ( $holder ) {
			if ( $holder.hasClass( 'qodef-pagination-type--standard' ) ) {
				qodefAuthorListPagination.initStandard( $holder );
			} else if ( $holder.hasClass( 'qodef-pagination-type--load-more' ) ) {
				qodefAuthorListPagination.initLoadMore( $holder );
			} else if ( $holder.hasClass( 'qodef-pagination-type--infinite-scroll' ) ) {
				qodefAuthorListPagination.initInfiniteScroll( $holder );
			}
		},
		initStandard: function ( $holder ) {
			var $paginationItems = $holder.find( '.qodef-m-pagination-items' );

			if ( $paginationItems.length ) {
				var options = $holder.data( 'options' );

				$paginationItems.children().each( function () {
					var $thisItem = $( this ),
						$itemLink = $thisItem.children( 'a' );

					qodefAuthorListPagination.changeStandardState( $holder, options.max_num_pages, 1 );

					$itemLink.on(
						'click',
						function ( e ) {
							e.preventDefault();

							if ( ! $thisItem.hasClass( 'qodef--active' ) ) {
								qodefAuthorListPagination.getNewPosts( $holder, $itemLink.data( 'paged' ) );
							}
						}
					);
				} );
			}
		},
		changeStandardState: function ( $holder, max_num_pages, nextPage ) {
			if ( $holder.hasClass( 'qodef-pagination-type--standard' ) ) {
				var $paginationNav = $holder.find( '.qodef-m-pagination-items' ),
					$numericItem   = $paginationNav.children( '.qodef--number' ),
					$prevItem      = $paginationNav.children( '.qodef--prev' ),
					$nextItem      = $paginationNav.children( '.qodef--next' );

				$numericItem.removeClass( 'qodef--active' ).eq( nextPage - 1 ).addClass( 'qodef--active' );

				$prevItem.children().data( 'paged', nextPage - 1 );

				if ( nextPage > 1 ) {
					$prevItem.show();
				} else {
					$prevItem.hide();
				}

				$nextItem.children().data( 'paged', nextPage + 1 );

				if ( nextPage === max_num_pages ) {
					$nextItem.hide();
				} else {
					$nextItem.show();
				}
			}
		},
		initLoadMore: function ( $holder ) {
			var $loadMoreButton = $holder.find( '.qodef-load-more-button' );

			$loadMoreButton.on(
				'click',
				function ( e ) {
					e.preventDefault();

					qodefAuthorListPagination.getNewPosts( $holder );
				}
			);
		},
		triggerLoadMore: function ( $holder, nextPage ) {
			qodefAuthorListPagination.getNewPosts( $holder, nextPage );
		},
		hideLoadMoreButton: function ( $holder, options ) {
			if ( $holder.hasClass( 'qodef-pagination-type--load-more' ) && options.next_page > options.max_num_pages ) {
				$holder.find( '.qodef-load-more-button' ).hide();
			}
		},
		initInfiniteScroll: function ( $holder ) {
			var holderEndPosition = $holder.outerHeight() + $holder.offset().top,
				scrollPosition    = qodefCore.scroll + qodefCore.windowHeight,
				options           = $holder.data( 'options' );

			if ( ! $holder.hasClass( 'qodef--loading' ) && scrollPosition > holderEndPosition && options.max_num_pages >= options.next_page ) {
				qodefAuthorListPagination.getNewPosts( $holder );
			}
		},
		getNewPosts: function ( $holder, nextPage ) {
			$holder.addClass( 'qodef--loading' );

			var $itemsHolder = $holder.children( '.qodef-grid-inner' );
			var options      = $holder.data( 'options' );

			qodefAuthorListPagination.setNextPageValue( options, nextPage, false );

			$.ajax(
				{
					type: 'GET',
					url: qodefGlobal.vars.restUrl + qodefGlobal.vars.authorPaginationRestRoute,
					data: {
						options: options,
					},
					beforeSend: function ( request ) {
						request.setRequestHeader( 'X-WP-Nonce', qodefGlobal.vars.restNonce );
					},
					success: function ( response ) {

						if ( response.status === 'success' ) {
							qodefAuthorListPagination.setNextPageValue( options, nextPage, true );
							qodefAuthorListPagination.changeStandardState( $holder, options.max_num_pages, nextPage );

							qodef.qodefWaitForImages.check(
								$itemsHolder,
								function () {
									qodefAuthorListPagination.addPosts( $itemsHolder, response.data, nextPage );

									qodefCore.body.trigger(
										'coppola_core_trigger_get_new_authors',
										[$holder]
									);
								}
							);

							qodefAuthorListPagination.hideLoadMoreButton( $holder, options );
						} else {
							console.log( response.message );
						}
					},
					complete: function () {
						$holder.removeClass( 'qodef--loading' );
					}
				}
			);
		},
		setNextPageValue: function ( options, nextPage, ajaxTrigger ) {
			if ( typeof nextPage !== 'undefined' && nextPage !== '' && ! ajaxTrigger ) {
				options.next_page = nextPage;
			} else if ( ajaxTrigger ) {
				options.next_page = parseInt( options.next_page, 10 ) + 1;
			}
		},
		addPosts: function ( $itemsHolder, newItems, nextPage ) {
			if ( typeof nextPage !== 'undefined' && nextPage !== '' ) {
				$itemsHolder.html( newItems );
			} else {
				$itemsHolder.append( newItems );
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_button = {};
	
	$( document ).ready(
		function () {
			qodefButton.init();
		}
	);
	
	var qodefButton = {
		init: function () {
			this.buttons = $( '.qodef-button' );
			if ( this.buttons.length ) {
				this.buttons.each(
					function () {
						qodefButton.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			qodefButton.buttonHoverColor( $currentItem );
			qodefButton.buttonHoverBgColor( $currentItem );
			qodefButton.buttonHoverBorderColor( $currentItem );
		},
		buttonHoverColor: function ( $button ) {
			if ( typeof $button.data( 'hover-color' ) !== 'undefined' ) {
				var hoverColor    = $button.data( 'hover-color' );
				var originalColor = $button.css( 'color' );

				$button.on(
					'mouseenter touchstart',
					function () {
						qodefButton.changeColor( $button, 'color', hoverColor );
					}
				);
				$button.on(
					'mouseleave touchend',
					function () {
						qodefButton.changeColor( $button, 'color', originalColor );
					}
				);
			}
		},
		buttonHoverBgColor: function ( $button ) {
			if ( typeof $button.data( 'hover-background-color' ) !== 'undefined' ) {
				var hoverBackgroundColor    = $button.data( 'hover-background-color' );
				var originalBackgroundColor = $button.css( 'background-color' );

				$button.on(
					'mouseenter touchstart',
					function () {
						qodefButton.changeColor( $button, 'background-color', hoverBackgroundColor );
					}
				);
				$button.on(
					'mouseleave touchend',
					function () {
						qodefButton.changeColor( $button, 'background-color', originalBackgroundColor );
					}
				);
			}
		},
		buttonHoverBorderColor: function ( $button ) {
			if ( typeof $button.data( 'hover-border-color' ) !== 'undefined' ) {
				var hoverBorderColor    = $button.data( 'hover-border-color' );
				var originalBorderColor = $button.css( 'borderTopColor' );

				$button.on(
					'mouseenter touchstart',
					function () {
						qodefButton.changeColor( $button, 'border-color', hoverBorderColor );
					}
				);
				$button.on(
					'mouseleave touchend',
					function () {
						qodefButton.changeColor( $button, 'border-color', originalBorderColor );
					}
				);
			}
		},
		changeColor: function ( $button, cssProperty, color ) {
			$button.css( cssProperty, color );
		}
	};

	qodefCore.shortcodes.coppola_core_button.qodefButton = qodefButton;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_countdown = {};

	$( document ).ready(
		function () {
			qodefCountdown.init();
		}
	);

	var qodefCountdown = {
		init: function () {
			this.countdowns = $( '.qodef-countdown' );

			if ( this.countdowns.length ) {
				this.countdowns.each(
					function () {
						qodefCountdown.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			var $countdownElement = $currentItem.find( '.qodef-m-date' ),
				dateFormats       = ['week', 'day', 'hour', 'minute', 'second'],
				options           = qodefCountdown.generateOptions( $currentItem, dateFormats );

			qodefCountdown.initCountdown( $countdownElement, options, dateFormats );
		},
		generateOptions: function ( $countdown, dateFormats ) {
			var options = {};

			options.date = typeof $countdown.data( 'date' ) !== 'undefined' ? $countdown.data( 'date' ) : null;

			for ( var i = 0; i < dateFormats.length; i++ ) {
				var label       = dateFormats[i] + 'Label',
					labelPlural = dateFormats[i] + 'LabelPlural';

				options[label]       = typeof $countdown.data( dateFormats[i] + '-label' ) !== 'undefined' ? $countdown.data( dateFormats[i] + '-label' ) : '';
				options[labelPlural] = typeof $countdown.data( dateFormats[i] + '-label-plural' ) !== 'undefined' ? $countdown.data( dateFormats[i] + '-label-plural' ) : '';
			}

			return options;
		},
		initCountdown: function ( $countdownElement, options, dateFormats ) {
			var countDownDate = new Date( options.date ).getTime();

			// Update the count down every 1 second
			var x = setInterval(
				function () {

					// Get today's date and time
					var now = new Date().getTime();

					// Find the distance between now and the count down date
					var distance = countDownDate - now;

					// Time calculations for days, hours, minutes and seconds
					this.weeks   = Math.floor( distance / (1000 * 60 * 60 * 24 * 7) );
					this.days    = Math.floor( (distance % (1000 * 60 * 60 * 24 * 7)) / (1000 * 60 * 60 * 24) );
					this.hours   = Math.floor( (distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60) );
					this.minutes = Math.floor( (distance % (1000 * 60 * 60)) / (1000 * 60) );
					this.seconds = Math.floor( (distance % (1000 * 60)) / 1000 );

					for ( var i = 0; i < dateFormats.length; i++ ) {
						var dateName = dateFormats[i] + 's';
						qodefCountdown.initiateDate( $countdownElement, this[dateName], dateFormats[i], options );
					}

					// If the count down is finished, write some text
					if ( distance < 0 ) {
						clearInterval( x );
						qodefCountdown.afterClearInterval( $countdownElement, dateFormats, options );
					}
				},
				1000
			);
		},
		initiateDate: function ( $countdownElement, date, dateFormat, options ) {
			var $holder = $countdownElement.find( '.qodef-' + dateFormat + 's' );

			$holder.find( '.qodef-label' ).html( ( 1 === date ) ? options[dateFormat + 'Label'] : options[dateFormat + 'LabelPlural'] );

			date = (date < 10) ? '0' + date : date;

			$holder.find( '.qodef-digit' ).html( date );
		},
		afterClearInterval: function( $countdownElement, dateFormats, options ) {
			for ( var i = 0; i < dateFormats.length; i++ ) {
				var $holder = $countdownElement.find( '.qodef-' + dateFormats[i] + 's' );

				$holder.find( '.qodef-label' ).html( options[dateFormats[i] + 'LabelPlural'] );
				$holder.find( '.qodef-digit' ).html( '00' );
			}
		}
	};

	qodefCore.shortcodes.coppola_core_countdown.qodefCountdown = qodefCountdown;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_counter = {};

	$( document ).ready(
		function () {
			qodefCounter.init();
		}
	);

	var qodefCounter = {
		init: function () {
			this.counters = $( '.qodef-counter' );

			if ( this.counters.length ) {
				this.counters.each(
					function () {
						qodefCounter.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			var $counterElement = $currentItem.find( '.qodef-m-digit' ),
				options         = qodefCounter.generateOptions( $currentItem );

			qodefCore.qodefIsInViewport.check(
				$currentItem,
				function () {
					qodefCounter.counterScript( $counterElement, options );
				},
				false
			);
		},
		generateOptions: function ( $counter ) {
			var options   = {};
			options.start = typeof $counter.data( 'start-digit' ) !== 'undefined' && $counter.data( 'start-digit' ) !== '' ? $counter.data( 'start-digit' ) : 0;
			options.end   = typeof $counter.data( 'end-digit' ) !== 'undefined' && $counter.data( 'end-digit' ) !== '' ? $counter.data( 'end-digit' ) : null;
			options.step  = typeof $counter.data( 'step-digit' ) !== 'undefined' && $counter.data( 'step-digit' ) !== '' ? $counter.data( 'step-digit' ) : 1;
			options.delay = typeof $counter.data( 'step-delay' ) !== 'undefined' && $counter.data( 'step-delay' ) !== '' ? parseInt( $counter.data( 'step-delay' ), 10 ) : 100;
			options.txt   = typeof $counter.data( 'digit-label' ) !== 'undefined' && $counter.data( 'digit-label' ) !== '' ? $counter.data( 'digit-label' ) : '';

			return options;
		},
		counterScript: function ( $counterElement, options ) {
			var defaults = {
				start: 0,
				end: null,
				step: 1,
				delay: 50,
				txt: '',
			};

			var settings = $.extend( defaults, options || {} );
			var nb_start = settings.start;
			var nb_end   = settings.end;

			$counterElement.text( nb_start + settings.txt );

			// Timer
			// Launches every "settings.delay"
			var counterInterval = setInterval(
				function () {
					// Definition of conditions of arrest
					if ( nb_end !== null && nb_start >= nb_end ) {
						return;
					}

					// incrementation
					nb_start = nb_start + settings.step;

					// Check is ended
					if ( nb_start >= nb_end ) {
						nb_start = nb_end;

						clearInterval( counterInterval );
					}

					// display
					$counterElement.text( nb_start + settings.txt );
				},
				settings.delay
			);
		}
	};

	qodefCore.shortcodes.coppola_core_counter.qodefCounter = qodefCounter;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_frame_slider = {};

	$( document ).ready(
		function () {
			qodefFrameSlider.init();
		}
	);

	var qodefFrameSlider = {
		init: function () {
			this.holder = $( '.qodef-frame-slider-holder' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefFrameSlider.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $holder ) {
			var $pad             = $holder.find('.qodef-frame-slider-pad'),
				$swiperHolderPad = $pad.find( '.qodef-m-swiper' ),
				$sliderHolderPad = $pad.find( '.qodef-m-items' ),
				$mob             = $holder.find('.qodef-frame-slider-mob'),
				$swiperHolderMob = $mob.find( '.qodef-m-swiper' ),
				$sliderHolderMob = $mob.find( '.qodef-m-items' );

			var $swiperPad = new Swiper(
				$swiperHolderPad,
				{
					effect: 'fade',
					slidesPerView: 1,
					centeredSlides: true,
					spaceBetween: 0,
					autoplay: true,
					loop: true,
					speed: 800,
					on: {
						init: function () {
							setTimeout(
								function () {
									$sliderHolderPad.addClass( 'qodef-swiper--initialized' );
								},
								1500
							);
						}
					},
				}
			);
			
			var $swiperMob = new Swiper(
				$swiperHolderMob,
				{
					effect: 'fade',
					slidesPerView: 1,
					centeredSlides: true,
					spaceBetween: 0,
					autoplay: {
						delay: 3300,
					},
					loop: true,
					speed: 600,
					on: {
						init: function () {
							setTimeout(
								function () {
									$sliderHolderMob.addClass( 'qodef-swiper--initialized' );
								},
								1500
							);
						}
					},
				}
			);
		}
	};

	qodefCore.shortcodes.coppola_core_frame_slider.qodefFrameSlider = qodefFrameSlider;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_google_map = {};

	$( document ).ready(
		function () {
			qodefGoogleMap.init();
		}
	);

	var qodefGoogleMap = {
		init: function () {
			this.holder = $( '.qodef-google-map' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefGoogleMap.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			if ( typeof window.qodefGoogleMap !== 'undefined' ) {
				window.qodefGoogleMap.init( $currentItem.find( '.qodef-m-map' ) );
			}
		},
	};

	qodefCore.shortcodes.coppola_core_google_map.qodefGoogleMap = qodefGoogleMap;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_horizontal_showcase = {};

	$( window ).on(
		'load',
		function () {
			qodefHorizontalShowcase.init();
		}
	);

	$( document ).ready(
		function () {
			qodefHorizontalShowcaseAppear.init();
		}
	);

	$( window ).on(
		'resize',
		function () {
			qodefHorizontalShowcase.init();
		}
	);

	$( window ).on(
		'orientationchange',
		function () {
			qodefHorizontalShowcase.init();
		}
	);

	var qodefHorizontalShowcase = {
		init: function () {
			var $holder = $( '.qodef-horizontal-showcase' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						qodefHorizontalShowcase.initItem( $( this ) );

						if ( $( this ).hasClass( 'qodef--parallax' ) ) {
							qodefHorizontalShowcase.initParallax( $( this ) );
						}
					}
				);
			}
		},
		initItem: function ( $thisHolder ) {
			if ( qodef.windowWidth > 1024 ) {
				qodefHorizontalShowcase.animateSlider( $thisHolder );
			}
		},
		animateSlider: function ( $thisHolder ) {
			/* logic for scrolling slider - start */

			var $Scrollbar = window.Scrollbar;

			//custom horizontalscroll plugin
			class HorizontalScrollPlugin extends Scrollbar.ScrollbarPlugin {
				transformDelta( delta, fromEvent ) {
					if ( ! /wheel/.test( fromEvent.type ) ) {
						return delta;
					}

					const { x, y } = delta;

					return {
						y: 0,
						x: Math.abs( x ) > Math.abs( y ) ? x : y
					};
				}
			}

			function _defineProperty( obj, key, value ) {
				if ( key in obj ) {
					Object.defineProperty(
						obj,
						key,
						{ value: value, enumerable: true, configurable: true, writable: true }
					);
				} else {
					obj[key] = value;
				}
				return obj;
			}

			_defineProperty(
				HorizontalScrollPlugin,
				'pluginName',
				'horizontalScroll'
			);

			//initialize scrolling
			$Scrollbar.use( HorizontalScrollPlugin );
			$Scrollbar.use( window.OverscrollPlugin );

			var thresholdScroll      = 0, //used for trashold
				triggerScroll        = false;
			var $horizontalScrollbar = $Scrollbar.init(
				document.querySelector( '.qodef-horizontal-showcase .qodef-m-items' ),
				{
					damping: 0.05,
					continuousScrolling: true,
					plugins: {
						overscroll: {
							onScroll: function ( thisScroll ) {
								if ( $thisHolder.hasClass( 'qodef--focus-in-viewport' ) ) { //if 'Enable Focus When in Viewport' option is enabled
									//when thresholdScroll reaches desired amount, than we trigger scrolling of page so slider would not be in viewport
									// depending on direction we scroll up or down
									thresholdScroll += Math.abs( thisScroll.x ); //aboslute value is taken sice x could be negative, depending on scroll direction
									if ( thresholdScroll > 2000 && ! triggerScroll ) {
										triggerScroll = true;
										qodefCore.qodefScroll.disable();
										var direction = thisScroll.x > 0 ? 'down' : 'up';
										scrollSliderOut( direction );
									}
								} else { //than just enable countinius scrolling
									$horizontalScrollbar.options.continuousScrolling = true;
								}
							},
							damping: 0.1,
							maxOverscroll: 150
						}
					}
				}
			);

			var scrollSliderOut = function ( direction ) {
				//calculate where to scroll page, depending on scroll direction
				var scrollTopAmount = direction == 'down' ? $thisHolder.offset().top + $thisHolder.outerHeight( true ) : $thisHolder.offset().top - qodef.windowHeight;

				$( 'html, body' ).stop().animate(
					{
						scrollTop: scrollTopAmount
					},
					1200,
					function () {
						$horizontalScrollbar.options.continuousScrolling = true;
						thresholdScroll                                  = 0;
						triggerScroll                                    = false;
						qodefCore.qodefScroll.enable();
					}
				);
			};

			//if 'Enable Focus When in Viewport' option is enabled, than watch scroll to focus slider when in viewport
			if ( $thisHolder.hasClass( 'qodef--focus-in-viewport' ) ) {

				var thisHolderTopOffset    = $thisHolder.offset().top,
					thisHolderBottomOffset = $thisHolder.offset().top + $thisHolder.outerHeight( true );

				//we have to listen wheel, since slider could be positioned on middle of page in some situations, and than our qodefIsInViewport will not work
				window.addEventListener(
					'wheel',
					function ( e ) {

						var previousPosition = $( window ).scrollTop(),
							currentPosition  = previousPosition + e.deltaY;

						//check direction of scroll and scroll page to slider slider top offset position
						if ( (e.deltaY > 0 && currentPosition < thisHolderTopOffset) || (e.deltaY < 0 && thisHolderBottomOffset < currentPosition + qodefAddonsCore.windowHeight) ) {
							qodefCore.qodefIsInViewport.check(
								$thisHolder,
								function () {
									qodefCore.qodefScroll.disable();
									$( 'html, body' ).stop().animate(
										{
											scrollTop: thisHolderTopOffset
										},
										1200,
										function () {
											triggerScroll = false;
											qodefCore.qodefScroll.enable();
										},
									);
								},
								true
							);
						}
					},
					{ passive: false }
				);
			}

			/* logic for scrolling slider - end */

			/* logic for show items on load/scroll - start */

			var $items        = $thisHolder.find( '.qodef-e' ),
				$first        = $thisHolder.find( '.qodef-intro-slide' ),
				$firstContent = $first.find( '.qodef-m-first-slide' );

			if ( $first.length && $firstContent.length ) {
				$first.css(
					'width',
					qodef.windowWidth * .88 + 'px'
				);
			}

			$items.each(
				function ( i ) {
					var $element = $( this );
					if ( i % 5 === 0 ) {
						$element.css(
							'width',
							qodef.windowWidth * .88 + 'px'
						);
						$element.find( '.qodef-e-media-image img' ).css(
							'max-width',
							qodef.windowWidth * .88 + 150 + 'px'
						);
					} else if ( i % 5 === 4 ) {
						$element.css(
							'width',
							qodef.windowWidth * .37 + 'px'
						);
						$element.find( '.qodef-e-media-image img' ).css(
							'max-width',
							qodef.windowWidth * .37 + 150 + 'px'
						);
					} else {
						$element.css(
							'width',
							qodef.windowWidth * .37 + 'px'
						);
					}
				}
			);

			//set data offset to items, so we could know when to show them
			$items.each(
				function ( i ) {
					var $thisOffsetLeft = $( this ).offset().left;
					$( this ).attr(
						'data-offset-left',
						$thisOffsetLeft
					);
					$( this ).data(
						'offset-left',
						$thisOffsetLeft
					);
				}
			);

			//if some items are in viewport on load, than show them
			$items.each(
				function ( i ) {
					var thisItem = $( this );
					if ( $thisHolder.width() > $( this ).data( 'offset-left' ) ) {
						setTimeout(
							function () {
								thisItem.addClass( 'qodef--appear' );
							},
							(i + 1) * 200
						);
					}
				}
			);

			//check items on scroll and show them when they are in viewport
			$horizontalScrollbar.addListener(
				function () {
					var scrollbarOffset = this.offset.x;
					$items.each(
						function () {
							if ( ! $( this ).hasClass( 'qodef--appear' ) ) {
								if ( $thisHolder.width() + scrollbarOffset > $( this ).data( 'offset-left' ) ) {
									$( this ).addClass( 'qodef--appear qodef--appear-delay' );
								}
							}
						}
					);
				}
			);

			/* logic for show items on load/scroll - end */
		},
		initParallax: function ( $thisHolder ) {
			var $parallaxImage = $thisHolder.find( '.qodef-m-item:nth-of-type(5n + 2) img, .qodef-m-item:nth-of-type(5n+6) img' );

			$parallaxImage.each( function () {
				var $thisItem     = $( this ),
					thisItemWidth = $thisItem.outerWidth(),
					progressVal   = 0,
					modifier      = 'translateX',
					modifierUnit  = 'px',
					startValue    = 150,
					endValue      = 0;

				// Set init value
				$thisItem.waitForImages( function () {
					$thisItem.css(
						'transform',
						modifier + '(' + startValue + modifierUnit + ')'
					);
				} );

				if ( qodefCore.windowWidth > 1024 ) {
					$( $thisHolder ).on(
						'wheel',
						function () {
							var thisItemLeft  = $thisItem.offset().left,
								thisItemRight = thisItemLeft + thisItemWidth;

							if ( qodef.scroll + window.innerWidth > thisItemLeft ) {
								progressVal = Math.abs( qodef.scroll + window.innerWidth - thisItemRight ) / window.innerWidth;
								if ( progressVal < 1 ) {
									$thisItem.css(
										'transform',
										modifier + '(' + (endValue + (1 - progressVal) * Math.abs( 1 - startValue )) + modifierUnit + ')'
									);
								}
							}
						}
					);
				}
			} );
		}
	};

	var qodefHorizontalShowcaseAppear = {
		init: function () {
			var $holder = $( '.qodef-horizontal-showcase' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						qodefHorizontalShowcaseAppear.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $holder ) {

			qodefCore.qodefIsInViewport.check(
				$holder.find( '.qodef-intro-slide' ),
				function () {
					$holder.addClass( 'qodef--appeared' );
				},
			);
		},
	};

	qodefCore.shortcodes.coppola_core_horizontal_showcase.qodefHorizontalShowcaseAppear = qodefHorizontalShowcaseAppear;
	qodefCore.shortcodes.coppola_core_horizontal_showcase.qodefHorizontalShowcase       = qodefHorizontalShowcase;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_icon = {};

	$( document ).ready(
		function () {
			qodefIcon.init();
		}
	);

	var qodefIcon = {
		init: function () {
			this.icons = $( '.qodef-icon-holder' );

			if ( this.icons.length ) {
				this.icons.each(
					function () {
						qodefIcon.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			qodefIcon.iconHoverColor( $currentItem );
			qodefIcon.iconHoverBgColor( $currentItem );
			qodefIcon.iconHoverBorderColor( $currentItem );
		},
		iconHoverColor: function ( $iconHolder ) {
			if ( typeof $iconHolder.data( 'hover-color' ) !== 'undefined' ) {
				var spanHolder    = $iconHolder.find( 'span' ).length ? $iconHolder.find( 'span' ) : $iconHolder;
				var originalColor = spanHolder.css( 'color' );
				var hoverColor    = $iconHolder.data( 'hover-color' );

				$iconHolder.on(
					'mouseenter',
					function () {
						qodefIcon.changeColor(
							spanHolder,
							'color',
							hoverColor
						);
					}
				);
				$iconHolder.on(
					'mouseleave',
					function () {
						qodefIcon.changeColor(
							spanHolder,
							'color',
							originalColor
						);
					}
				);
			}
		},
		iconHoverBgColor: function ( $iconHolder ) {
			if ( typeof $iconHolder.data( 'hover-background-color' ) !== 'undefined' ) {
				var hoverBackgroundColor    = $iconHolder.data( 'hover-background-color' );
				var originalBackgroundColor = $iconHolder.css( 'background-color' );

				$iconHolder.on(
					'mouseenter',
					function () {
						qodefIcon.changeColor(
							$iconHolder,
							'background-color',
							hoverBackgroundColor
						);
					}
				);
				$iconHolder.on(
					'mouseleave',
					function () {
						qodefIcon.changeColor(
							$iconHolder,
							'background-color',
							originalBackgroundColor
						);
					}
				);
			}
		},
		iconHoverBorderColor: function ( $iconHolder ) {
			if ( typeof $iconHolder.data( 'hover-border-color' ) !== 'undefined' ) {
				var hoverBorderColor    = $iconHolder.data( 'hover-border-color' );
				var originalBorderColor = $iconHolder.css( 'borderTopColor' );

				$iconHolder.on(
					'mouseenter',
					function () {
						qodefIcon.changeColor(
							$iconHolder,
							'border-color',
							hoverBorderColor
						);
					}
				);
				$iconHolder.on(
					'mouseleave',
					function () {
						qodefIcon.changeColor(
							$iconHolder,
							'border-color',
							originalBorderColor
						);
					}
				);
			}
		},
		changeColor: function ( iconElement, cssProperty, color ) {
			iconElement.css(
				cssProperty,
				color
			);
		}
	};

	qodefCore.shortcodes.coppola_core_icon.qodefIcon = qodefIcon;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_icon_list_item = {};
	
	$( document ).ready(
		function () {
			qodefIconListItem.init();
		}
	);
	
	var qodefIconListItem = {
		init: function () {
			this.iconListItem = $( '.qodef-icon-list-item a' );
			if ( this.iconListItem.length ) {
				this.iconListItem.each(
					function () {
						qodefIconListItem.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			qodefIconListItem.iconHoverColor( $currentItem );
		},
		iconHoverColor: function ( $icon ) {
			if ( typeof $icon.data( 'hover-color' ) !== 'undefined' ) {
				var hoverColor    = $icon.data( 'hover-color' );
				var originalColor = $icon.css( 'color' );

				$icon.on(
					'mouseenter touchstart',
					function () {
						qodefIconListItem.changeColor( $icon, 'color', hoverColor );
					}
				);
				$icon.on(
					'mouseleave touchend',
					function () {
						qodefIconListItem.changeColor( $icon, 'color', originalColor );
					}
				);
			}
		},
		changeColor: function ( $icon, cssProperty, color ) {
			$icon.css( cssProperty, color );
		}
	};

	qodefCore.shortcodes.coppola_core_icon_list_item.qodefIconListItem = qodefIconListItem;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_image_gallery                    = {};
	qodefCore.shortcodes.coppola_core_image_gallery.qodefSwiper        = qodef.qodefSwiper;
	qodefCore.shortcodes.coppola_core_image_gallery.qodefMasonryLayout = qodef.qodefMasonryLayout;
	qodefCore.shortcodes.coppola_core_image_gallery.qodefMagnificPopup = qodef.qodefMagnificPopup;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_image_with_text = {};

	$( document ).ready(
		function () {
			qodefImageWithText.init();
		}
	);

	var qodefImageWithText = {
		init: function () {
			this.counters = $( '.qodef-image-with-text' );

			if ( this.counters.length ) {
				this.counters.each(
					function () {
						qodefImageWithText.initHover( $( this ) );
					}
				);
			}
		},
		initHover: function ( $item ) {
			var $triggers = $item.find( '.qodef-m-image, .qodef-portfolio-single-video-holder, .qodef-m-title a' ),
				$title    = $item.find( '.qodef-m-title' );

			$triggers.on(
				'mouseenter',
				() => $title.addClass( 'qodef--active' )
			)
			.on(
				'mouseleave',
				() => $title.removeClass( 'qodef--active' )
			);
		}
	};

	qodefCore.shortcodes.coppola_core_image_with_text.qodefImageWithText = qodefImageWithText;
	qodefCore.shortcodes.coppola_core_image_with_text.qodefMagnificPopup = qodef.qodefMagnificPopup;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_interactive_corners = {};

	$( document ).ready(
		function () {
			qodefInteractiveCornersList.init();
		}
	);

	var qodefInteractiveCornersList = {
		init: function () {
			this.holder = $( '.qodef-interactive-corners' );
			var $header = $( '#qodef-page-mobile-header' );

			var $headerHeight = $header.outerHeight() + 'px';

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						if ( qodef.windowWidth < 1025 ) {
							$( this ).css(
								'height',
								'calc(100vh - ' + $headerHeight + ')'
							);
						}
						qodefInteractiveCornersList.initActiveItem( $( this ) );
					}
				);
			}
		},
		initActiveItem: function ( $currentItem ) {
			var $title   = $currentItem.find( '.qodef-ic-title' ),
				$parents = $title.parents();

			$title.first().closest( 'div' ).addClass( 'qodef-ic-active-item' );

			$title.on(
				'mouseenter touchstart',
				function () {
					$parents.removeClass( 'qodef-ic-active-item' );
					$( this ).closest( 'div' ).addClass( 'qodef-ic-active-item' );

					var $current = $( this ).closest( 'div' );

					TweenMax.to(
						$current.find( '#gooBlur' ),
						0.5,
						{
							attr: {
								stdDeviation: '20'
							},
							onComplete: function () {
								TweenMax.to(
									$current.find( '#gooBlur' ),
									0.5,
									{
										attr: {
											stdDeviation: '0'
										}
									}
								);
							}
						}
					);

					TweenMax.to(
						$current.find( '.text1' ),
						1,
						{
							autoAlpha: 0,
							ease: 'Power2.easeInOut',
						}
					);

					TweenMax.to(
						$current.find( '.text2' ),
						1,
						{
							autoAlpha: 1,
							ease: 'Power2.easeInOut',
						}
					);
				}
			);

			if ( qodef.windowWidth < 1025 ) {
				$title.on(
					'click',
					function ( e ) {
						if ( ! $( this ).is( '.clicked' ) ) {
							e.preventDefault();
							$title.removeClass( 'clicked' );
							$( this ).addClass( 'clicked' );

							$parents.removeClass( 'qodef-ic-active-item' );
							$( this ).closest( 'div' ).addClass( 'qodef-ic-active-item' );
						}
					}
				);
			}
		}
	};
})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_progress_bar = {};

	$( document ).ready(
		function () {
			qodefProgressBar.init();
		}
	);

	/**
	 * Init progress bar shortcode functionality
	 */
	var qodefProgressBar = {
		init: function () {
			this.holder = $( '.qodef-progress-bar' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefProgressBar.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			var layout = $currentItem.data( 'layout' );

			qodefCore.qodefIsInViewport.check(
				$currentItem,
				function () {
					$currentItem.addClass( 'qodef--init' );

					var $container = $currentItem.find( '.qodef-m-canvas' ),
						data       = qodefProgressBar.generateBarData( $currentItem, layout ),
						number     = $currentItem.data( 'number' ) / 100;

					switch (layout) {
						case 'circle':
							qodefProgressBar.initCircleBar( $container, data, number );
							break;
						case 'semi-circle':
							qodefProgressBar.initSemiCircleBar( $container, data, number );
							break;
						case 'line':
							data = qodefProgressBar.generateLineData( $currentItem, number );
							qodefProgressBar.initLineBar( $container, data );
							break;
						case 'custom':
							qodefProgressBar.initCustomBar( $container, data, number );
							break;
					}
				},
				false
			);
		},
		generateBarData: function ( thisBar, layout ) {
			var activeWidth   = thisBar.data( 'active-line-width' );
			var activeColor   = thisBar.data( 'active-line-color' );
			var inactiveWidth = thisBar.data( 'inactive-line-width' );
			var inactiveColor = thisBar.data( 'inactive-line-color' );
			var easing        = 'linear';
			var duration      = typeof thisBar.data( 'duration' ) !== 'undefined' && thisBar.data( 'duration' ) !== '' ? parseInt( thisBar.data( 'duration' ), 10 ) : 1600;
			var textColor     = thisBar.data( 'text-color' );

			return {
				strokeWidth: activeWidth,
				color: activeColor,
				trailWidth: inactiveWidth,
				trailColor: inactiveColor,
				easing: easing,
				duration: duration,
				svgStyle: {
					width: '100%',
					height: '100%'
				},
				text: {
					style: {
						color: textColor
					},
					autoStyleContainer: false
				},
				from: {
					color: inactiveColor
				},
				to: {
					color: activeColor
				},
				step: function ( state, bar ) {
					if ( layout !== 'custom' ) {
						bar.setText( Math.round( bar.value() * 100 ) + '%' );
					}
				},
			};
		},
		generateLineData: function ( thisBar, number ) {
			var height         = thisBar.data( 'active-line-width' );
			var activeColor    = thisBar.data( 'active-line-color' );
			var inactiveHeight = thisBar.data( 'inactive-line-width' );
			var inactiveColor  = thisBar.data( 'inactive-line-color' );
			var duration       = typeof thisBar.data( 'duration' ) !== 'undefined' && thisBar.data( 'duration' ) !== '' ? parseInt( thisBar.data( 'duration' ), 10 ) : 1600;
			var textColor      = thisBar.data( 'text-color' );

			return {
				percentage: number * 100,
				duration: duration,
				fillBackgroundColor: activeColor,
				backgroundColor: inactiveColor,
				height: height,
				inactiveHeight: inactiveHeight,
				followText: thisBar.hasClass( 'qodef-percentage--floating' ),
				textColor: textColor,
			};
		},
		initCircleBar: function ( $container, data, number ) {
			if ( qodefProgressBar.checkBar( $container ) ) {
				var $bar = new ProgressBar.Circle( $container[0], data );

				$bar.animate( number );
			}
		},
		initSemiCircleBar: function ( $container, data, number ) {
			if ( qodefProgressBar.checkBar( $container ) ) {
				var $bar = new ProgressBar.SemiCircle( $container[0], data );

				$bar.animate( number );
			}
		},
		initCustomBar: function ( $container, data, number ) {
			if ( qodefProgressBar.checkBar( $container ) ) {
				var $bar = new ProgressBar.Path( $container[0], data );

				$bar.set( 0 );
				$bar.animate( number );
			}
		},
		initLineBar: function ( $container, data ) {
			$container.LineProgressbar( data );
		},
		checkBar: function ( $container ) {
			// check if svg is already in container, elementor fix
			if ( $container.find( 'svg' ).length ) {
				return false;
			}

			return true;
		}
	};

	qodefCore.shortcodes.coppola_core_progress_bar.qodefProgressBar = qodefProgressBar;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_section_title = {};

	$( document ).ready(
		function () {
			qodefSectionTitle.init();
		}
	);

	var qodefSectionTitle = {
		init: function () {
			var $holder = $( '.qodef-section-title' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						qodefSectionTitle.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $holder ) {

			qodefCore.qodefIsInViewport.check(
				$holder,
				function () {
					$holder.addClass( 'qodef--appeared' );
				},
			);
		},
	};

	qodefCore.shortcodes.coppola_core_section_title.qodefSectionTitle = qodefSectionTitle;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_tabs = {};

	$( document ).ready(
		function () {
			qodefTabs.init();
		}
	);

	var qodefTabs = {
		init: function () {
			this.holder = $( '.qodef-tabs' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefTabs.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			$currentItem.children( '.qodef-tabs-content' ).each(
				function ( index ) {
					index = index + 1;

					var $that    = $( this ),
						link     = $that.attr( 'id' ),
						$navItem = $that.parent().find( '.qodef-tabs-navigation li:nth-child(' + index + ') a' ),
						navLink  = $navItem.attr( 'href' );

					link = '#' + link;

					if ( link.indexOf( navLink ) > -1 ) {
						$navItem.attr(
							'href',
							link
						);
					}
				}
			);

			$currentItem.addClass( 'qodef--init' ).tabs();
		}
	};

	qodefCore.shortcodes.coppola_core_tabs.qodefTabs = qodefTabs;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_text_marquee = {};

	$( document ).ready(
		function () {
			qodefTextMarquee.init();
		}
	);

	var qodefTextMarquee = {
		init: function () {
			this.holder = $( '.qodef-text-marquee' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefTextMarquee.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $currentItem ) {
			qodefTextMarquee.initMarquee( $currentItem );
			qodefTextMarquee.initResponsive( $currentItem.find( '.qodef-m-content' ) );
		},
		initResponsive: function ( thisMarquee ) {
			var fontSize,
				lineHeight,
				coef1 = 1,
				coef2 = 1;

			if ( qodefCore.windowWidth < 1480 ) {
				coef1 = 0.8;
			}

			if ( qodefCore.windowWidth < 1200 ) {
				coef1 = 0.6;
			}

			if ( qodefCore.windowWidth < 768 ) {
				coef1 = 0.55;
				coef2 = 0.65;
			}

			if ( qodefCore.windowWidth < 600 ) {
				coef1 = 0.35;
				coef2 = 0.55;
			}

			if ( qodefCore.windowWidth < 480 ) {
				coef1 = 0.35;
				coef2 = 0.5;
			}

			fontSize = parseInt( thisMarquee.css( 'font-size' ) );

			if ( fontSize > 200 ) {
				fontSize = Math.round( fontSize * coef1 );
			} else if ( fontSize > 60 ) {
				fontSize = Math.round( fontSize * coef2 );
			}

			thisMarquee.css( 'font-size', fontSize + 'px' );

			lineHeight = parseInt( thisMarquee.css( 'line-height' ) );

			if ( lineHeight > 70 && qodefCore.windowWidth < 1440 ) {
				lineHeight = '1.2em';
			} else if ( lineHeight > 35 && qodefCore.windowWidth < 768 ) {
				lineHeight = '1.2em';
			} else {
				lineHeight += 'px';
			}

			thisMarquee.css( 'line-height', lineHeight );
		},
		initMarquee: function ( thisMarquee ) {
			var elements = thisMarquee.find( '.qodef-m-text' ),
				delta    = 0.05;

			var contentWidth = 0;
			
			elements.each(
				function ( i ) {
					$( this ).data( 'x', 0 );
					contentWidth += $( this ).width();
				}
			);
			
			thisMarquee.find( '.qodef-m-content' ).width(contentWidth);
			
			requestAnimationFrame(
				function () {
					qodefTextMarquee.loop( thisMarquee, elements, delta );
				}
			);
		},
		inRange: function ( thisMarquee ) {
			if ( qodefCore.scroll + qodefCore.windowHeight >= thisMarquee.offset().top && qodefCore.scroll < thisMarquee.offset().top + thisMarquee.height() ) {
				return true;
			}

			return false;
		},
		loop: function ( thisMarquee, elements, delta ) {
			if ( ! qodefTextMarquee.inRange( thisMarquee ) ) {
				requestAnimationFrame(
					function () {
						qodefTextMarquee.loop( thisMarquee, elements, delta );
					}
				);
				return false;
			} else {
				elements.each(
					function ( i ) {
						var el = $( this );
						el.css( 'transform', 'translate3d(' + el.data( 'x' ) + '%, 0, 0)' );
						el.data( 'x', (el.data( 'x' ) - delta) );
						el.offset().left < -el.width() && el.data( 'x', 100 * Math.abs( i - 1 ) - 9 );
					}
				);
				requestAnimationFrame(
					function () {
						qodefTextMarquee.loop( thisMarquee, elements, delta );
					}
				);
			}
		}
	};

	qodefCore.shortcodes.coppola_core_text_marquee.qodefTextMarquee = qodefTextMarquee;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_video_button                    = {};
	qodefCore.shortcodes.coppola_core_video_button.qodefMagnificPopup = qodef.qodefMagnificPopup;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( window ).on(
		'load',
		function () {
			qodefStickySidebar.init();
		}
	);

	var qodefStickySidebar = {
		init: function () {
			var info = $( '.widget_coppola_core_sticky_sidebar' );

			if ( info.length && qodefCore.windowWidth > 1024 ) {
				info.wrapper = info.parents( '#qodef-page-sidebar' );
				info.offsetM = info.offset().top - info.wrapper.offset().top;
				info.adj     = 15;

				qodefStickySidebar.callStack( info );

				$( window ).on(
					'resize',
					function () {
						if ( qodefCore.windowWidth > 1024 ) {
							qodefStickySidebar.callStack( info );
						}
					}
				);

				$( window ).on(
					'scroll',
					function () {
						if ( qodefCore.windowWidth > 1024 ) {
							qodefStickySidebar.infoPosition( info );
						}
					}
				);
			}
		},
		calc: function ( info ) {
			var content = $( '.qodef-page-content-section' ),
				headerH = qodefCore.body.hasClass( 'qodef-header-appearance--none' ) ? 0 : parseInt( qodefGlobal.vars.headerHeight, 10 );

			// If posts not found set content to have the same height as the sidebar
			if ( qodefCore.windowWidth > 1024 && content.height() < 100 ) {
				content.css( 'height', info.wrapper.height() - content.height() );
			}

			info.start = content.offset().top;
			info.end   = content.outerHeight();
			info.h     = info.wrapper.height();
			info.w     = info.outerWidth();
			info.left  = info.offset().left;
			info.top   = headerH + qodefGlobal.vars.adminBarHeight - info.offsetM;
			info.data( 'state', 'top' );
		},
		infoPosition: function ( info ) {
			if ( qodefCore.scroll < info.start - info.top && qodefCore.scroll + info.h && info.data( 'state' ) !== 'top' ) {
				gsap.to(
					info.wrapper,
					.1,
					{
						y: 5,
					}
				);
				gsap.to(
					info.wrapper,
					.3,
					{
						y: 0,
						delay: .1,
					}
				);
				info.data( 'state', 'top' );
				info.wrapper.css(
					{
						'position': 'static',
					}
				);
			} else if ( qodefCore.scroll >= info.start - info.top && qodefCore.scroll + info.h + info.adj <= info.start + info.end &&
				info.data( 'state' ) !== 'fixed' ) {
				var c = info.data( 'state' ) === 'top' ? 1 : -1;
				info.data( 'state', 'fixed' );
				info.wrapper.css(
					{
						'position': 'fixed',
						'top': info.top,
						'left': info.left,
						'width': info.w,
					}
				);
				gsap.fromTo(
					info.wrapper,
					.2,
					{
						y: 0
					},
					{
						y: c * 10,
						ease: Power4.easeInOut
					}
				);
				gsap.to(
					info.wrapper,
					.2,
					{
						y: 0,
						delay: .2,
					}
				);
			} else if ( qodefCore.scroll + info.h + info.adj > info.start + info.end && info.data( 'state' ) !== 'bottom' ) {
				info.data( 'state', 'bottom' );
				info.wrapper.css(
					{
						'position': 'absolute',
						'top': info.end - info.h - info.adj,
						'left': 'auto',
						'width': info.w,
					}
				);
				gsap.fromTo(
					info.wrapper,
					.1,
					{
						y: 0
					},
					{
						y: -5,
					}
				);
				gsap.to(
					info.wrapper,
					.3,
					{
						y: 0,
						delay: .1,
					}
				);
			}
		},
		callStack: function ( info ) {
			this.calc( info );
			this.infoPosition( info );
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	var shortcode = 'coppola_core_blog_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

	qodefCore.shortcodes[shortcode].qodefResizeIframes = qodef.qodefResizeIframes;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefVerticalNavMenu.init();
		}
	);

	/**
	 * Function object that represents vertical menu area.
	 * @returns {{init: Function}}
	 */
	var qodefVerticalNavMenu = {
		initNavigation: function ( $verticalMenuObject ) {
			var $verticalNavObject = $verticalMenuObject.find( '.qodef-header-vertical-navigation' );

			if ( $verticalNavObject.hasClass( 'qodef-vertical-drop-down--below' ) ) {
				qodefVerticalNavMenu.dropdownClickToggle( $verticalNavObject );
			} else if ( $verticalNavObject.hasClass( 'qodef-vertical-drop-down--side' ) ) {
				qodefVerticalNavMenu.dropdownFloat( $verticalNavObject );
			}
		},
		dropdownClickToggle: function ( $verticalNavObject ) {
			var $menuItems = $verticalNavObject.find( 'ul li.menu-item-has-children' );

			$menuItems.each(
				function () {
					var $elementToExpand = $( this ).find( ' > .qodef-drop-down-second, > ul' );
					var menuItem         = this;
					var $dropdownOpener  = $( this ).find( '> a' );
					var slideUpSpeed     = 'fast';
					var slideDownSpeed   = 'slow';

					$dropdownOpener.on(
						'click tap',
						function ( e ) {
							e.preventDefault();
							e.stopPropagation();

							if ( $elementToExpand.is( ':visible' ) ) {
								$( menuItem ).removeClass( 'qodef-menu-item--open' );
								$elementToExpand.slideUp( slideUpSpeed );
							} else if ( $dropdownOpener.parent().parent().children().hasClass( 'qodef-menu-item--open' ) && $dropdownOpener.parent().parent().parent().hasClass( 'qodef-vertical-menu' ) ) {
								$( this ).parent().parent().children().removeClass( 'qodef-menu-item--open' );
								$( this ).parent().parent().children().find( ' > .qodef-drop-down-second' ).slideUp( slideUpSpeed );

								$( menuItem ).addClass( 'qodef-menu-item--open' );
								$elementToExpand.slideDown( slideDownSpeed );
							} else {

								if ( ! $( this ).parents( 'li' ).hasClass( 'qodef-menu-item--open' ) ) {
									$menuItems.removeClass( 'qodef-menu-item--open' );
									$menuItems.find( ' > .qodef-drop-down-second, > ul' ).slideUp( slideUpSpeed );
								}

								if ( $( this ).parent().parent().children().hasClass( 'qodef-menu-item--open' ) ) {
									$( this ).parent().parent().children().removeClass( 'qodef-menu-item--open' );
									$( this ).parent().parent().children().find( ' > .qodef-drop-down-second, > ul' ).slideUp( slideUpSpeed );
								}

								$( menuItem ).addClass( 'qodef-menu-item--open' );
								$elementToExpand.slideDown( slideDownSpeed );
							}
						}
					);
				}
			);
		},
		dropdownFloat: function ( $verticalNavObject ) {
			var $menuItems = $verticalNavObject.find( 'ul li.menu-item-has-children' );
			var $allDropdowns = $menuItems.find( ' > .qodef-drop-down-second > .qodef-drop-down-second-inner > ul, > ul' );

			$menuItems.each(
				function () {
					var $elementToExpand = $( this ).find( ' > .qodef-drop-down-second > .qodef-drop-down-second-inner > ul, > ul' );
					var menuItem         = this;

					if ( Modernizr.touch ) {
						var $dropdownOpener = $( this ).find( '> a' );

						$dropdownOpener.on(
							'click tap',
							function ( e ) {
								e.preventDefault();
								e.stopPropagation();

								if ( $elementToExpand.hasClass( 'qodef-float--open' ) ) {
									$elementToExpand.removeClass( 'qodef-float--open' );
									$( menuItem ).removeClass( 'qodef-menu-item--open' );
								} else {
									if ( ! $( this ).parents( 'li' ).hasClass( 'qodef-menu-item--open' ) ) {
										$menuItems.removeClass( 'qodef-menu-item--open' );
										$allDropdowns.removeClass( 'qodef-float--open' );
									}

									$elementToExpand.addClass( 'qodef-float--open' );
									$( menuItem ).addClass( 'qodef-menu-item--open' );
								}
							}
						);
					} else {
						//must use hoverIntent because basic hover effect doesn't catch dropdown
						//it doesn't start from menu item's edge
						$( this ).hoverIntent(
							{
								over: function () {
									$elementToExpand.addClass( 'qodef-float--open' );
									$( menuItem ).addClass( 'qodef-menu-item--open' );
								},
								out: function () {
									$elementToExpand.removeClass( 'qodef-float--open' );
									$( menuItem ).removeClass( 'qodef-menu-item--open' );
								},
								timeout: 300
							}
						);
					}
				}
			);
		},
		verticalAreaScrollable: function ( $verticalMenuObject ) {
			return $verticalMenuObject.hasClass( 'qodef-with-scroll' );
		},
		initVerticalAreaScroll: function ( $verticalMenuObject ) {
			if ( qodefVerticalNavMenu.verticalAreaScrollable( $verticalMenuObject ) && typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
				qodefCore.qodefPerfectScrollbar.init( $verticalMenuObject );
			}
		},
		init: function () {
			var $verticalMenuObject = $( '.qodef-header--vertical #qodef-page-header' );

			if ( $verticalMenuObject.length ) {
				qodefVerticalNavMenu.initNavigation( $verticalMenuObject );
				qodefVerticalNavMenu.initVerticalAreaScroll( $verticalMenuObject );
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
	    function () {
            qodefVerticalSlidingNavMenu.init();
        }
	);

	/**
	 * Function object that represents vertical menu area.
	 * @returns {{init: Function}}
	 */
	var qodefVerticalSlidingNavMenu = {
		openedScroll: 0,

		initNavigation: function ( $verticalSlidingMenuObject ) {
			var $verticalSlidingNavObject = $verticalSlidingMenuObject.find( '.qodef-header-vertical-sliding-navigation' );

			if ( $verticalSlidingNavObject.hasClass( 'qodef-vertical-sliding-drop-down--below' ) ) {
				qodefVerticalSlidingNavMenu.dropdownClickToggle( $verticalSlidingNavObject );
			} else if ( $verticalSlidingNavObject.hasClass( 'qodef-vertical-sliding-drop-down--side' ) ) {
				qodefVerticalSlidingNavMenu.dropdownFloat( $verticalSlidingNavObject );
			}
		},
		dropdownClickToggle: function ( $verticalSlidingNavObject ) {
			var $menuItems = $verticalSlidingNavObject.find( 'ul li.menu-item-has-children' );

			$menuItems.each(
				function () {
					var $elementToExpand = $( this ).find( ' > .qodef-drop-down-second, > ul' );
					var menuItem         = this;
					var $dropdownOpener  = $( this ).find( '> a' );
					var slideUpSpeed     = 'fast';
					var slideDownSpeed   = 'slow';

					$dropdownOpener.on(
						'click tap',
						function ( e ) {
							e.preventDefault();
							e.stopPropagation();

							if ( $elementToExpand.is( ':visible' ) ) {
								$( menuItem ).removeClass( 'qodef-menu-item--open' );
								$elementToExpand.slideUp( slideUpSpeed );
							} else if ( $dropdownOpener.parent().parent().children().hasClass( 'qodef-menu-item--open' ) && $dropdownOpener.parent().parent().parent().hasClass( 'qodef-vertical-menu' ) ) {
								$( this ).parent().parent().children().removeClass( 'qodef-menu-item--open' );
								$( this ).parent().parent().children().find( ' > .qodef-drop-down-second' ).slideUp( slideUpSpeed );

								$( menuItem ).addClass( 'qodef-menu-item--open' );
								$elementToExpand.slideDown( slideDownSpeed );
							} else {

								if ( ! $( this ).parents( 'li' ).hasClass( 'qodef-menu-item--open' ) ) {
									$menuItems.removeClass( 'qodef-menu-item--open' );
									$menuItems.find( ' > .qodef-drop-down-second, > ul' ).slideUp( slideUpSpeed );
								}

								if ( $( this ).parent().parent().children().hasClass( 'qodef-menu-item--open' ) ) {
									$( this ).parent().parent().children().removeClass( 'qodef-menu-item--open' );
									$( this ).parent().parent().children().find( ' > .qodef-drop-down-second, > ul' ).slideUp( slideUpSpeed );
								}

								$( menuItem ).addClass( 'qodef-menu-item--open' );
								$elementToExpand.slideDown( slideDownSpeed );
							}
						}
					);
				}
			);
		},
		dropdownFloat: function ( $verticalSlidingNavObject ) {
			var $menuItems = $verticalSlidingNavObject.find( 'ul li.menu-item-has-children' );
			var $allDropdowns = $menuItems.find( ' > .qodef-drop-down-second > .qodef-drop-down-second-inner > ul, > ul' );

			$menuItems.each(
				function () {
					var $elementToExpand = $( this ).find( ' > .qodef-drop-down-second > .qodef-drop-down-second-inner > ul, > ul' );
					var menuItem         = this;

					if ( Modernizr.touch ) {
						var $dropdownOpener = $( this ).find( '> a' );

						$dropdownOpener.on(
							'click tap',
							function ( e ) {
								e.preventDefault();
								e.stopPropagation();

								if ( $elementToExpand.hasClass( 'qodef-float--open' ) ) {
									$elementToExpand.removeClass( 'qodef-float--open' );
									$( menuItem ).removeClass( 'qodef-menu-item--open' );
								} else {
									if ( ! $( this ).parents( 'li' ).hasClass( 'qodef-menu-item--open' ) ) {
										$menuItems.removeClass( 'qodef-menu-item--open' );
										$allDropdowns.removeClass( 'qodef-float--open' );
									}

									$elementToExpand.addClass( 'qodef-float--open' );
									$( menuItem ).addClass( 'qodef-menu-item--open' );
								}
							}
						);
					} else {
						//must use hoverIntent because basic hover effect doesn't catch dropdown
						//it doesn't start from menu item's edge
						$( this ).hoverIntent(
							{
								over: function () {
									$elementToExpand.addClass( 'qodef-float--open' );
									$( menuItem ).addClass( 'qodef-menu-item--open' );
								},
								out: function () {
									$elementToExpand.removeClass( 'qodef-float--open' );
									$( menuItem ).removeClass( 'qodef-menu-item--open' );
								},
								timeout: 300
							}
						);
					}
				}
			);
		},
		verticalSlidingAreaScrollable: function ( $verticalSlidingMenuObject ) {
			return $verticalSlidingMenuObject.hasClass( 'qodef-with-scroll' );
		},
		initVerticalSlidingAreaScroll: function ( $verticalSlidingMenuObject ) {
			if ( qodefVerticalSlidingNavMenu.verticalSlidingAreaScrollable( $verticalSlidingMenuObject ) && typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
				qodefCore.qodefPerfectScrollbar.init( $verticalSlidingMenuObject );
			}
		},
		verticalSlidingAreaShowHide: function ( $verticalSlidingMenuObject ) {
			var $verticalSlidingMenuOpener = $verticalSlidingMenuObject.find( '.qodef-vertical-sliding-menu-opener' );

			$verticalSlidingMenuOpener.on(
				'click',
				function ( e ) {
					e.preventDefault();

					var $thisOpener = $( this );

					if ( ! $verticalSlidingMenuObject.hasClass( 'qodef-vertical-sliding-menu--opened' ) ) {
						$thisOpener.addClass( 'qodef--opened' );
						$verticalSlidingMenuObject.addClass( 'qodef-vertical-sliding-menu--opened' );
						qodefVerticalSlidingNavMenu.openedScroll = qodef.window.scrollTop();
					} else {
						$thisOpener.removeClass( 'qodef--opened' );
						$verticalSlidingMenuObject.removeClass( 'qodef-vertical-sliding-menu--opened' );
					}
				}
			);
		},
		verticalSlidingAreaCloseOnScroll: function ( $verticalSlidingMenuObject ) {
			qodef.window.on(
				'scroll',
				function () {
					if ( $verticalSlidingMenuObject.hasClass( 'qodef-vertical-sliding-menu--opened' ) && Math.abs( qodef.scroll - qodefVerticalSlidingNavMenu.openedScroll ) > 400 ) {
						$verticalSlidingMenuObject.find( '.qodef-vertical-sliding-menu-opener' ).removeClass( 'qodef--opened' );
						$verticalSlidingMenuObject.removeClass( 'qodef-vertical-sliding-menu--opened' );
					}
				}
			);
		},
		init: function () {
			var $verticalSlidingMenuObject = $( '.qodef-header--vertical-sliding #qodef-page-header' );

			if ( $verticalSlidingMenuObject.length ) {
				qodefVerticalSlidingNavMenu.verticalSlidingAreaShowHide( $verticalSlidingMenuObject );
				qodefVerticalSlidingNavMenu.verticalSlidingAreaCloseOnScroll( $verticalSlidingMenuObject );
				qodefVerticalSlidingNavMenu.initNavigation( $verticalSlidingMenuObject );
				qodefVerticalSlidingNavMenu.initVerticalSlidingAreaScroll( $verticalSlidingMenuObject );
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	var fixedHeaderAppearance = {
		showHideHeader: function ( $pageOuter, $header ) {
			if ( qodefCore.windowWidth > 1024 ) {
				if ( qodefCore.scroll <= 0 ) {
					qodefCore.body.removeClass( 'qodef-header--fixed-display' );
					$pageOuter.css( 'padding-top', '0' );
					$header.css( 'margin-top', '0' );
				} else {
					qodefCore.body.addClass( 'qodef-header--fixed-display' );
					$pageOuter.css( 'padding-top', parseInt( qodefGlobal.vars.headerHeight + qodefGlobal.vars.topAreaHeight ) + 'px' );
					$header.css( 'margin-top', parseInt( qodefGlobal.vars.topAreaHeight ) + 'px' );
				}
			}
		},
		init: function () {

			if ( ! qodefCore.body.hasClass( 'qodef-header--vertical' ) ) {
				var $pageOuter = $( '#qodef-page-outer' ),
					$header    = $( '#qodef-page-header' );

				fixedHeaderAppearance.showHideHeader( $pageOuter, $header );

				$( window ).scroll(
					function () {
						fixedHeaderAppearance.showHideHeader( $pageOuter, $header );
					}
				);

				$( window ).resize(
					function () {
						$pageOuter.css( 'padding-top', '0' );
						fixedHeaderAppearance.showHideHeader( $pageOuter, $header );
					}
				);
			}
		}
	};

	qodefCore.fixedHeaderAppearance = fixedHeaderAppearance.init;

})( jQuery );

(function ( $ ) {
	'use strict';

	var stickyHeaderAppearance = {
		header: '',
		docYScroll: 0,
		init: function () {
			var displayAmount = stickyHeaderAppearance.displayAmount();

			// Set variables
			stickyHeaderAppearance.header 	  = $( '.qodef-header-sticky' );
			stickyHeaderAppearance.docYScroll = $( document ).scrollTop();

			// Set sticky visibility
			stickyHeaderAppearance.setVisibility( displayAmount );

			$( window ).scroll(
				function () {
					stickyHeaderAppearance.setVisibility( displayAmount );
				}
			);
		},
		displayAmount: function () {
			if ( qodefGlobal.vars.qodefStickyHeaderScrollAmount !== 0 ) {
				return parseInt( qodefGlobal.vars.qodefStickyHeaderScrollAmount, 10 );
			} else {
				return parseInt( qodefGlobal.vars.headerHeight + qodefGlobal.vars.adminBarHeight, 10 );
			}
		},
		setVisibility: function ( displayAmount ) {
			var isStickyHidden = qodefCore.scroll < displayAmount;

			if ( stickyHeaderAppearance.header.hasClass( 'qodef-appearance--up' ) ) {
				var currentDocYScroll = $( document ).scrollTop();

				isStickyHidden = (currentDocYScroll > stickyHeaderAppearance.docYScroll && currentDocYScroll > displayAmount) || (currentDocYScroll < displayAmount);

				stickyHeaderAppearance.docYScroll = $( document ).scrollTop();
			}

			stickyHeaderAppearance.showHideHeader( isStickyHidden );
		},
		showHideHeader: function ( isStickyHidden ) {
			if ( isStickyHidden ) {
				qodefCore.body.removeClass( 'qodef-header--sticky-display' );
			} else {
				qodefCore.body.addClass( 'qodef-header--sticky-display' );
			}
		},
	};

	qodefCore.stickyHeaderAppearance = stickyHeaderAppearance.init;

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSideAreaMobileHeader.init();
		}
	);

	var qodefSideAreaMobileHeader = {
		init: function () {
			var $holder = $( '#qodef-side-area-mobile-header' );

			if ( $holder.length && qodefCore.body.hasClass( 'qodef-mobile-header--side-area' ) ) {
				var $navigation = $holder.find( '.qodef-m-navigation' );

				qodefSideAreaMobileHeader.initOpenerTrigger( $holder, $navigation );
				qodefSideAreaMobileHeader.initNavigationClickToggle( $navigation );

				if ( typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
					qodefCore.qodefPerfectScrollbar.init( $holder );
				}
			}
		},
		initOpenerTrigger: function ( $holder, $navigation ) {
			var $openerIcon = $( '.qodef-side-area-mobile-header-opener' ),
				$closeIcon  = $holder.children( '.qodef-m-close' );

			if ( $openerIcon.length && $navigation.length ) {
				$openerIcon.on(
					'tap click',
					function ( e ) {
						e.stopPropagation();
						e.preventDefault();

						if ( $holder.hasClass( 'qodef--opened' ) ) {
							$holder.removeClass( 'qodef--opened' );
						} else {
							$holder.addClass( 'qodef--opened' );
						}
					}
				);
			}

			$closeIcon.on(
				'tap click',
				function ( e ) {
					e.stopPropagation();
					e.preventDefault();

					if ( $holder.hasClass( 'qodef--opened' ) ) {
						$holder.removeClass( 'qodef--opened' );
					}
				}
			);
		},
		initNavigationClickToggle: function ( $navigation ) {
			var $menuItems = $navigation.find( 'ul li.menu-item-has-children' );

			$menuItems.each(
				function () {
					var $thisItem        = $( this ),
						$elementToExpand = $thisItem.find( ' > .qodef-drop-down-second, > ul' ),
						$dropdownOpener  = $thisItem.find( '> .qodef-menu-item-arrow' ),
						slideUpSpeed     = 'fast',
						slideDownSpeed   = 'slow';

					$dropdownOpener.on(
						'click tap',
						function ( e ) {
							e.preventDefault();
							e.stopPropagation();

							if ( $elementToExpand.is( ':visible' ) ) {
								$thisItem.removeClass( 'qodef-menu-item--open' );
								$elementToExpand.slideUp( slideUpSpeed );
							} else if ( $dropdownOpener.parent().parent().children().hasClass( 'qodef-menu-item--open' ) && $dropdownOpener.parent().parent().parent().hasClass( 'qodef-vertical-menu' ) ) {
								$thisItem.parent().parent().children().removeClass( 'qodef-menu-item--open' );
								$thisItem.parent().parent().children().find( ' > .qodef-drop-down-second' ).slideUp( slideUpSpeed );

								$thisItem.addClass( 'qodef-menu-item--open' );
								$elementToExpand.slideDown( slideDownSpeed );
							} else {

								if ( ! $thisItem.parents( 'li' ).hasClass( 'qodef-menu-item--open' ) ) {
									$menuItems.removeClass( 'qodef-menu-item--open' );
									$menuItems.find( ' > .qodef-drop-down-second, > ul' ).slideUp( slideUpSpeed );
								}

								if ( $thisItem.parent().parent().children().hasClass( 'qodef-menu-item--open' ) ) {
									$thisItem.parent().parent().children().removeClass( 'qodef-menu-item--open' );
									$thisItem.parent().parent().children().find( ' > .qodef-drop-down-second, > ul' ).slideUp( slideUpSpeed );
								}

								$thisItem.addClass( 'qodef-menu-item--open' );
								$elementToExpand.slideDown( slideDownSpeed );
							}
						}
					);
				}
			);
		},
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSearchCoversHeader.init();
		}
	);

	var qodefSearchCoversHeader = {
		init: function () {
			var $searchOpener = $( 'a.qodef-search-opener' ),
				$searchForm   = $( '.qodef-search-cover-form' ),
				$searchClose  = $searchForm.find( '.qodef-m-close' );

			if ( $searchOpener.length && $searchForm.length ) {
				$searchOpener.on(
					'click',
					function ( e ) {
						e.preventDefault();
						qodefSearchCoversHeader.openCoversHeader( $searchForm );
					}
				);
				$searchClose.on(
					'click',
					function ( e ) {
						e.preventDefault();
						qodefSearchCoversHeader.closeCoversHeader( $searchForm );
					}
				);
			}
		},
		openCoversHeader: function ( $searchForm ) {
			qodefCore.body.addClass( 'qodef-covers-search--opened qodef-covers-search--fadein' );
			qodefCore.body.removeClass( 'qodef-covers-search--fadeout' );

			setTimeout(
				function () {
					$searchForm.find( '.qodef-m-form-field' ).focus();
				},
				600
			);
		},
		closeCoversHeader: function ( $searchForm ) {
			qodefCore.body.removeClass( 'qodef-covers-search--opened qodef-covers-search--fadein' );
			qodefCore.body.addClass( 'qodef-covers-search--fadeout' );

			setTimeout(
				function () {
					$searchForm.find( '.qodef-m-form-field' ).val( '' );
					$searchForm.find( '.qodef-m-form-field' ).blur();
					qodefCore.body.removeClass( 'qodef-covers-search--fadeout' );
				},
				300
			);
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSearchFullscreen.init();
		}
	);

	var qodefSearchFullscreen = {
		init: function () {
			var $searchOpener = $( 'a.qodef-search-opener' ),
				$searchHolder = $( '.qodef-fullscreen-search-holder' ),
				$searchClose  = $searchHolder.find( '.qodef-m-close' );

			if ( $searchOpener.length && $searchHolder.length ) {
				$searchOpener.on(
					'click',
					function ( e ) {
						e.preventDefault();
						if ( qodefCore.body.hasClass( 'qodef-fullscreen-search--opened' ) ) {
							qodefSearchFullscreen.closeFullscreen( $searchHolder );
						} else {
							qodefSearchFullscreen.openFullscreen( $searchHolder );
						}
					}
				);
				$searchClose.on(
					'click',
					function ( e ) {
						e.preventDefault();
						qodefSearchFullscreen.closeFullscreen( $searchHolder );
					}
				);

				//Close on escape
				$( document ).keyup(
					function ( e ) {
						if ( e.keyCode === 27 && qodefCore.body.hasClass( 'qodef-fullscreen-search--opened' ) ) { //KeyCode for ESC button is 27
							qodefSearchFullscreen.closeFullscreen( $searchHolder );
						}
					}
				);
			}
		},
		openFullscreen: function ( $searchHolder ) {
			qodefCore.body.removeClass( 'qodef-fullscreen-search--fadeout' );
			qodefCore.body.addClass( 'qodef-fullscreen-search--opened qodef-fullscreen-search--fadein' );

			setTimeout(
				function () {
					$searchHolder.find( '.qodef-m-form-field' ).focus();
				},
				900
			);

			qodefCore.qodefScroll.disable();
		},
		closeFullscreen: function ( $searchHolder ) {
			qodefCore.body.removeClass( 'qodef-fullscreen-search--opened qodef-fullscreen-search--fadein' );
			qodefCore.body.addClass( 'qodef-fullscreen-search--fadeout' );

			setTimeout(
				function () {
					$searchHolder.find( '.qodef-m-form-field' ).val( '' );
					$searchHolder.find( '.qodef-m-form-field' ).blur();
					qodefCore.body.removeClass( 'qodef-fullscreen-search--fadeout' );
				},
				300
			);

			qodefCore.qodefScroll.enable();
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSearch.init();
		}
	);

	var qodefSearch = {
		init: function () {
			this.search = $( 'a.qodef-search-opener' );

			if ( this.search.length ) {
				this.search.each(
					function () {
						var $thisSearch = $( this );

						qodefSearch.searchHoverColor( $thisSearch );
					}
				);
			}
		},
		searchHoverColor: function ( $searchHolder ) {
			if ( typeof $searchHolder.data( 'hover-color' ) !== 'undefined' ) {
				var hoverColor    = $searchHolder.data( 'hover-color' ),
					originalColor = $searchHolder.css( 'color' );

				$searchHolder.on(
					'mouseenter',
					function () {
						$searchHolder.css( 'color', hoverColor );
					}
				).on(
					'mouseleave',
					function () {
						$searchHolder.css( 'color', originalColor );
					}
				);
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function() {
			qodefProgressBarSpinner.init();
		}
	);

	$( window ).on(
		'load',
		function () {
			qodefProgressBarSpinner.windowLoaded = true;
			qodefProgressBarSpinner.completeAnimation();
		}
	);

	$( window ).on(
		'elementor/frontend/init',
		function () {
			var isEditMode = Boolean( elementorFrontend.isEditMode() );

			if ( isEditMode ) {
				qodefProgressBarSpinner.init( isEditMode );
			}
		}
	);

	var qodefProgressBarSpinner = {
		holder: '',
		windowLoaded: false,
		percentNumber: 0,
		init: function ( isEditMode ) {
			this.holder = $( '#qodef-page-spinner.qodef-layout--progress-bar' );

			if ( this.holder.length ) {
				qodefProgressBarSpinner.animateSpinner( this.holder, isEditMode );
			}
		},
		animateSpinner: function ( $holder, isEditMode ) {
			var $numberHolder = $holder.find( '.qodef-m-spinner-number-label' ),
				$spinnerLine  = $holder.find( '.qodef-m-spinner-line-front' );

			$spinnerLine.animate(
				{ 'width': '100%' },
				10000,
				'linear'
			);

			var numberInterval = setInterval(
				function () {
					qodefProgressBarSpinner.animatePercent( $numberHolder, qodefProgressBarSpinner.percentNumber );

					if ( qodefProgressBarSpinner.windowLoaded ) {
						clearInterval( numberInterval );
					}
				},
				100
			);

			if ( isEditMode ) {
				qodefProgressBarSpinner.fadeOutLoader( $holder );
			}
		},
		completeAnimation: function () {
			var $holder = qodefProgressBarSpinner.holder.length ? qodefProgressBarSpinner.holder : $( '#qodef-page-spinner.qodef-layout--progress-bar' );

			var numberIntervalFastest = setInterval(
				function () {

					if ( qodefProgressBarSpinner.percentNumber >= 100 ) {
						clearInterval( numberIntervalFastest );

						$holder.find( '.qodef-m-spinner-line-front' ).stop().animate(
							{ 'width': '100%' },
							500
						);

						$holder.addClass( 'qodef--finished' );

						setTimeout(
							function () {
								qodefProgressBarSpinner.fadeOutLoader( $holder );
							},
							600
						);
					} else {
						qodefProgressBarSpinner.animatePercent(
							$holder.find( '.qodef-m-spinner-number-label' ),
							qodefProgressBarSpinner.percentNumber
						);
					}
				},
				6
			);
		},
		animatePercent: function ( $numberHolder, percentNumber ) {
			if ( percentNumber < 100 ) {
				percentNumber += 5;
				$numberHolder.text( percentNumber );

				qodefProgressBarSpinner.percentNumber = percentNumber;
			}
		},
		fadeOutLoader: function ( $holder, speed, delay, easing ) {
			speed  = speed ? speed : 600;
			delay  = delay ? delay : 0;
			easing = easing ? easing : 'swing';

			$holder.delay( delay ).fadeOut( speed, easing );

			$( window ).on(
				'bind',
				'pageshow',
				function ( event ) {
					if ( event.originalEvent.persisted ) {
						$holder.fadeOut( speed, easing );
					}
				}
			);
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function() {
			qodefTextualSpinner.init();
		}
	);

	$( window ).on(
		'load',
		function(){
			qodefTextualSpinner.windowLoaded = true;
		}
	);

	$( window ).on(
		'elementor/frontend/init',
		function(){
			const isEditMode = Boolean( elementorFrontend.isEditMode() );

			if ( isEditMode ) {
				qodefTextualSpinner.init( isEditMode );
			}
		}
	);

	const qodefTextualSpinner = {
		init( isEditMode ) {
			const $holder = $( '#qodef-page-spinner.qodef-layout--textual' );

			if ( $holder.length ) {
				if ( isEditMode ) {
					qodefTextualSpinner.fadeOutLoader( $holder );
				} else {
					qodefTextualSpinner.splitText( $holder );
				}
			}
		},
		splitText( $holder ) {
			const $textHolder = $holder.find( '.qodef-m-text' );

			if ( $textHolder.length ) {
				let text     = $textHolder.text().trim(),
					chars    = text.split( '' ),
					cssClass = '';

				$textHolder.empty();

				chars.forEach(
					function( c ) {
						cssClass = (c === ' ' ? 'qodef-m-empty-char' : ' ');
						$textHolder.append( '<span class="qodef-m-char ' + cssClass + '">' + c + '</span>' );
					}
				);

				setTimeout(
					function() {
						qodefTextualSpinner.animateSpinner( $holder );
					},
					100
				);
			}
		},
		animateSpinner( $holder ) {
			$holder.addClass( 'qodef--init' );

			function animationLoop( animationProps ) {
				const $chars      = $holder.find( '.qodef-m-char' ),
					  charsLength = $chars.length - 1;

				if ( $chars.length ) {
					$chars.each(
						function ( i ) {
							const $thisChar = $( this );

							setTimeout(
								function() {
									$thisChar.animate(
									    animationProps.type,
										animationProps.duration,
										animationProps.easing,
										function() {
											if ( i === charsLength ) {
												if ( 1 === animationProps.repeat ) {
													animationLoop(
													    {
                                                            type: { opacity: 0 },
                                                            duration: 1200,
                                                            easing: 'swing',
                                                            delay: 0,
                                                            repeat: 0,
                                                        }
													);
												} else {
													if ( ! qodefTextualSpinner.windowLoaded ) {
														animationLoop(
														    {
                                                                type: { opacity: 1 },
                                                                duration: 1800,
                                                                easing: 'swing',
                                                                delay: 160,
                                                                repeat: 1,
                                                            }
														);
													} else {
														qodefTextualSpinner.fadeOutLoader(
															$holder,
															600,
															0,
															'swing'
														);

														setTimeout(
															function() {
																const $revSlider = $( '.qodef-after-spinner-rev rs-module' );

																if ( $revSlider.length ) {
																	$revSlider.revstart();
																}
															},
															800
														);
													}
												}
											}
										}
									);
								},
								i * animationProps.delay
							);
						}
					);
				}
			}

			animationLoop(
			    {
                    type: { opacity: 1 },
                    duration: 1800,
                    easing: 'swing',
                    delay: 160,
                    repeat: 1,
                }
			);
		},
		fadeOutLoader( $holder, speed, delay, easing ) {
			speed  = speed ? speed : 500;
			delay  = delay ? delay : 0;
			easing = easing ? easing : 'swing';

			if ( $holder.length ) {
				$holder.delay( delay ).fadeOut( speed, easing );

				$( window ).on(
					'bind',
					'pageshow',
					function( event ) {

						if ( event.originalEvent.persisted ) {
							$holder.fadeOut( speed, easing );
						}
					}
				);
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefWishlistDropdown.init();
		}
	);

	/**
	 * Function object that represents wishlist dropdown.
	 * @returns {{init: Function}}
	 */
	var qodefWishlistDropdown = {
		init: function () {
			var $holder = $( '.qodef-wishlist-dropdown' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						var $thisHolder = $( this ),
							$link       = $thisHolder.find( '.qodef-m-link' );

						$link.on(
							'click',
							function ( e ) {
								e.preventDefault();
							}
						);

						qodefWishlistDropdown.removeItem( $thisHolder );
					}
				);
			}
		},
		removeItem: function ( $holder ) {
			var $removeLink = $holder.find( '.qodef-e-remove' );

			$removeLink.off().on(
				'click',
				function ( e ) {
					e.preventDefault();

					var $thisRemoveLink = $( this ),
						removeLinkHTML  = $thisRemoveLink.html(),
						removeItemID    = $thisRemoveLink.data( 'id' );

					$thisRemoveLink.html( '<span class="fa fa-spinner fa-spin" aria-hidden="true"></span>' );

					var wishlistData = {
						type: 'remove',
						itemID: removeItemID,
					};

					$.ajax(
						{
							type: 'POST',
							url: qodefGlobal.vars.restUrl + qodefGlobal.vars.wishlistRestRoute,
							data: {
								options: wishlistData,
							},
							beforeSend: function ( request ) {
								request.setRequestHeader( 'X-WP-Nonce', qodefGlobal.vars.restNonce );
							},
							success: function ( response ) {
								if ( response.status === 'success' ) {
									var newNumberOfItemsValue = parseInt( response.data['count'], 10 );

									$holder.find( '.qodef-m-link-count' ).html( newNumberOfItemsValue );

									if ( newNumberOfItemsValue === 0 ) {
										$holder.removeClass( 'qodef-items--has' ).addClass( 'qodef-items--no' );
									}

									$thisRemoveLink.closest( '.qodef-m-item' ).fadeOut( 200 ).remove();

									$( document ).trigger(
										'coppola_core_wishlist_item_is_removed',
										[removeItemID]
									);
								} else {
									$thisRemoveLink.html( removeLinkHTML );
								}
							}
						}
					);
				}
			);
		}
	};

	$( document ).on(
		'coppola_core_wishlist_item_is_added',
		function ( e, addedItemID, addedUserID ) {
			var $holder = $( '.qodef-wishlist-dropdown' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						var $thisHolder        = $( this ),
							$link              = $thisHolder.find( '.qodef-m-link' ),
							numberOfItemsValue = $link.find( '.qodef-m-link-count' ),
							$itemsHolder       = $thisHolder.find( '.qodef-m-items' );

						var wishlistData = {
							itemID: addedItemID,
							userID: addedUserID,
						};

						$.ajax(
							{
								type: 'POST',
								url: qodefGlobal.vars.restUrl + qodefGlobal.vars.wishlistDropdownRestRoute,
								data: {
									options: wishlistData,
								},
								beforeSend: function ( request ) {
									request.setRequestHeader( 'X-WP-Nonce', qodefGlobal.vars.restNonce );
								},
								success: function ( response ) {
									if ( response.status === 'success' ) {
										numberOfItemsValue.html( parseInt( response.data['count'], 10 ) );

										if ( $thisHolder.hasClass( 'qodef-items--no' ) ) {
											$thisHolder.removeClass( 'qodef-items--no' ).addClass( 'qodef-items--has' );
										}

										$itemsHolder.append( response.data['new_html'] );
									}
								},
								complete: function () {
									qodefWishlistDropdown.init();
								}
							}
						);
					}
				);
			}
		}
	);

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_instagram_list = {};

	$( document ).ready(
		function () {
			qodefInstagram.init();
		}
	);

	var qodefInstagram = {
		init: function () {
			this.holder = $( '.sbi.qodef-instagram-swiper-container' );

			if ( this.holder.length ) {
				this.holder.each(
					function () {
						qodefInstagram.initSlider( $( this ) );
					}
				);
			}
		},
		initSlider: function ( $currentItem, $initAllItems ) {
			var sliderOptions   = $currentItem.parent().attr( 'data-options' ),
				$instagramImage = $currentItem.find( '.sbi_item.sbi_type_image' ),
				$imageHolder    = $currentItem.find( '#sbi_images' );

			$currentItem.attr( 'data-options', sliderOptions );

			$imageHolder.addClass( 'swiper-wrapper' );

			if ( $instagramImage.length ) {
				$instagramImage.each(
					function () {
						$( this ).addClass( 'qodef-e qodef-image-wrapper swiper-slide' );
					}
				);
			}

			if ( typeof qodef.qodefSwiper === 'object' ) {

				if ( false === $initAllItems ) {
					qodef.qodefSwiper.initSlider( $currentItem );
				} else {
					qodef.qodefSwiper.init( $currentItem );
				}
			}
		},
	};

	qodefCore.shortcodes.coppola_core_instagram_list.qodefInstagram = qodefInstagram;
	qodefCore.shortcodes.coppola_core_instagram_list.qodefSwiper    = qodef.qodefSwiper;

})( jQuery );

(function ( $ ) {
	'use strict';

	/*
	 **	Re-init scripts on gallery loaded
	 */
	$( document ).on(
		'yith_wccl_product_gallery_loaded',
		function () {

			if ( typeof qodefCore.qodefWooMagnificPopup === 'function' ) {
				qodefCore.qodefWooMagnificPopup.init();
			}
		}
	);

})( jQuery );

(function ($) {
	'use strict';

	$(document).on(
		'qv_loader_stop qv_variation_gallery_loaded',
		function () {
			qodefYithSelect2.init();
		}
	);

	var qodefYithSelect2 = {
		init: function (settings) {
			this.holder = [];
			this.holder.push(
				{
					holder: $('#yith-quick-view-modal .variations select'),
					options: {
						minimumResultsForSearch: Infinity
					}
				}
			);

			// Allow overriding the default config
			$.extend(this.holder, settings);

			if (typeof this.holder === 'object') {
				$.each(
					this.holder,
					function (key, value) {
						qodefYithSelect2.createSelect2(value.holder, value.options);
					}
				);
			}
		},
		createSelect2: function ($holder, options) {
			if (typeof $holder.select2 === 'function') {
				$holder.select2(options);
			}
		}
	};

})(jQuery);

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_product_category_list                    = {};
	qodefCore.shortcodes.coppola_core_product_category_list.qodefMasonryLayout = qodef.qodefMasonryLayout;
	qodefCore.shortcodes.coppola_core_product_category_list.qodefSwiper        = qodef.qodefSwiper;

})( jQuery );

(function ( $ ) {
	'use strict';

	var shortcode = 'coppola_core_product_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefDropDownCart.init();
		}
	);

	var qodefDropDownCart = {
		init: function () {
			var $holder = $( '.qodef-widget-dropdown-cart-content' );

			if ( $holder.length ) {
				$holder.off().each(
					function () {
						var $thisHolder = $( this );

						qodefDropDownCart.trigger( $thisHolder );

						qodefCore.body.on(
							'added_to_cart removed_from_cart',
							function () {
								qodefDropDownCart.init();
							}
						);
					}
				);
			}
		},
		trigger: function ( $holder ) {
			var $items = $holder.find( '.qodef-woo-mini-cart' );
			if ( $items.length && typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
				qodefCore.qodefPerfectScrollbar.init( $items );
			}
		},
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefSideAreaCart.init();
		}
	);

	var qodefSideAreaCart = {
		init: function () {
			var $holder = $( '.qodef-widget-side-area-cart-inner' );

			if ( $holder.length ) {
				$holder.off().each(
					function () {
						var $thisHolder = $( this );

						if ( qodefCore.windowWidth > 680 ) {
							qodefSideAreaCart.trigger( $thisHolder );
							qodefSideAreaCart.start( $thisHolder );

							qodefCore.body.on(
								'added_to_cart removed_from_cart',
								function () {
									qodefSideAreaCart.init();
								}
							);
						}
					}
				);
			}
		},
		trigger: function ( $holder ) {
			var $items = $holder.find( '.qodef-woo-side-area-cart' );
			if ( $items.length && typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
				qodefCore.qodefPerfectScrollbar.init( $items );
			}
		},
		start: function ( $holder ) {
			$holder.on(
				'click',
				'.qodef-m-opener',
				function ( e ) {
					e.preventDefault();

					if ( ! $holder.hasClass( 'qodef--opened' ) ) {
						qodefSideAreaCart.openSideArea( $holder );
						qodefSideAreaCart.trigger( $holder );

						$( document ).keyup(
							function ( e ) {
								if ( e.keyCode === 27 ) {
									qodefSideAreaCart.closeSideArea( $holder );
								}
							}
						);
					} else {
						qodefSideAreaCart.closeSideArea( $holder );
					}
				}
			);

			$holder.on(
				'click',
				'.qodef-m-close',
				function ( e ) {
					e.preventDefault();
					qodefSideAreaCart.closeSideArea( $holder );
				}
			);
		},
		openSideArea: function ( $holder ) {
			qodefCore.qodefScroll.disable();

			$holder.addClass( 'qodef--opened' );
			$( '#qodef-page-wrapper' ).prepend( '<div class="qodef-woo-side-area-cart-cover"/>' );

			$( '.qodef-woo-side-area-cart-cover' ).on(
				'click',
				function ( e ) {
					e.preventDefault();

					qodefSideAreaCart.closeSideArea( $holder );
				}
			);
		},
		closeSideArea: function ( $holder ) {
			if ( $holder.hasClass( 'qodef--opened' ) ) {
				qodefCore.qodefScroll.enable();

				$holder.removeClass( 'qodef--opened' );
				$( '.qodef-woo-side-area-cart-cover' ).remove();
			}
		}
	};

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_clients_list             = {};
	qodefCore.shortcodes.coppola_core_clients_list.qodefSwiper = qodef.qodefSwiper;

})( jQuery );

(function ($) {
    "use strict";
    qodefCore.shortcodes.coppola_core_divided_scroll_showcase = {};

})(jQuery);
(function ( $ ) {
	'use strict';

	var shortcode = 'coppola_core_portfolio_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

	$( document ).ready(
		function () {
			qodefPreviewVideo.init();
		}
	);

	$( window ).on(
		'load',
		function () {
			qodefPortfolioAppear.init();
		}
	);

	var qodefPreviewVideo = {
		init: function () {
			this.item = $( '.qodef-portfolio-list .portfolio-item' );

			if ( this.item.length ) {
				this.item.each(
					function () {
						qodefPreviewVideo.itemHover( $( this ) );
					}
				);
			}
		},

		itemHover: function ( $item ) {
			if ( qodefCore.windowWidth > 1024 ) {
				var video = $item.find( '.qodef-video--on-hover video' );

				$item.on(
					'mouseenter touchstart',
					function () {
						if ( video.length ) {
							var isPlaying = video.get( 0 ).currentTime > 0 && ! video.get( 0 ).paused && ! video.get( 0 ).ended && video.get( 0 ).readyState > 2;

							if ( ! isPlaying ) {
								video.get( 0 ).play();
							}
						}
					}
				);
				$item.on(
					'mouseleave touchend',
					function () {
						if ( video.length ) {
							setTimeout(
								function () {
									video.get( 0 ).pause();
									video.get( 0 ).currentTime = 0;
								},
								200
							);
						}
					}
				);
			}
		},
	};

	var qodefPortfolioAppear = {
		init: function () {
			var $holder = $( '.qodef-portfolio-list.qodef--appear-reveal' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						qodefPortfolioAppear.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $holder ) {

			qodefCore.qodefIsInViewport.check(
				$holder.find( 'article:first-child' ),
				function () {
					$holder.addClass( 'qodef--appeared' );
				},
			);
		},
	};

	qodefCore.shortcodes.coppola_core_portfolio_list.qodefPortfolioAppear = qodefPortfolioAppear;

})( jQuery );

(function ( $ ) {
	'use strict';
	
	qodefCore.shortcodes.coppola_core_scrolling_portfolio = {};
	
	$( window ).on(
		'load',
		function () {
			qodefScrollingPortfolio.init();
		}
	);
	
	var qodefScrollingPortfolio = {
		init: function ( settings ) {
			var $slider = $('.qodef-scrolling-portfolio');
			
			// Allow overriding the default config
			$.extend($slider, settings);
			
			if ( $slider.length ) {
				$slider.each(function () {
					qodefScrollingPortfolio.createSlider( $( this ) );
				});
			}
		},
		createSlider: function ($slider) {
			var options = qodefScrollingPortfolio.getOptions($slider),
				events  = qodefScrollingPortfolio.getEvents($slider, options);
			
			var $swiper = new Swiper($slider, Object.assign(options, events));
		},
		getOptions: function ($slider) {
			var sliderOptions     = typeof $slider.data( 'options' ) !== 'undefined' ? $slider.data( 'options' ) : {},
				loopedSlides = sliderOptions.loopedSlides !== undefined && sliderOptions.loopedSlides !== '' ? sliderOptions.loopedSlides : 6;
			
			var options = {
				loop: true,
				slidesPerView: 'auto',
				slidesOffsetBefore: -185,
				loopedSlides: loopedSlides,
				centeredSlides: true,
				speed: 600,
				direction: 'vertical',
				sliderScroll: false,
				grabCursor: true,
				spaceBetween: 0,
				autoplay: false,
				breakpoints: {
					// when window width is < 481px
					0: {
						slidesOffsetBefore: -185
					},
					680: {
						slidesOffsetBefore: -80
					},
					// when window width is >= 1025px
					1025: {
						slidesOffsetBefore: -185
					}
				},
			};
			
			return Object.assign(options, qodefScrollingPortfolio.getSliderData($slider));
		},
		getEvents: function ($holder, options) {
			return {
				on: {
					slideChangeTransitionStart: function() {
						var activeSlide = $holder.find('.swiper-slide-active'),
							activeTitle = activeSlide.find('.qodef-e-title'),
							activeIndex = activeSlide.data('swiper-slide-index'),
							title       = $holder.find('.qodef-e-title'),
							container   = $holder.find('.qodef-e-media-container'),
							line        = activeSlide.find('.qodef-e-line'),
							activeColor = activeTitle.data('title-styles').titleColor;
						
						title.css('color', '#fff');
						
						if ( '' !== activeColor ) {
							activeTitle.css('color', activeColor );
						}
						
						if ( '' !== activeIndex ) {
							activeTitle.css('color', activeColor );
						}
						activeTitle.on('mouseenter', function () {
							line.addClass('qodef--active');
						}).on('mouseleave', function () {
							line.removeClass('qodef--active');
						});
						
						container.each(
							function () {
								if ( $( this ).length ) {
									var item = $( this ).children().first();
									if (  $( this ).data('image-index') === activeIndex ) {
										if ( item.hasClass('qodef-video--on-hover') ) {
											$( this ).find('video').get( 0 ).play();
										}
										$( this ).addClass('qodef--active');
									} else {
										if ( item.hasClass('qodef-video--on-hover') ) {
											$( this ).find('video').get( 0 ).pause();
										}
										$( this ).removeClass('qodef--active');
									}
								}
							}
						);
					},
					init: function () {
						var activeSlide = $holder.find('.swiper-slide-active'),
							activeTitle = activeSlide.find('.qodef-e-title'),
							activeColor = activeTitle.data('title-styles').titleColor;
						
						if ( '' !== activeColor ) {
							activeTitle.css('color', activeColor );
						}
						
						var scrollStart        = false;
						
						$holder.off().on(
							'wheel',
							function ( e ) {
								e.preventDefault();
								
								if ( ! scrollStart ) {
									scrollStart = true;
									
									if ( e.originalEvent.deltaY > 0 ) {
										$holder[0].swiper.slideNext();
									} else {
										$holder[0].swiper.slidePrev();
									}
									
									setTimeout(
										function () {
											scrollStart = false;
										},
										1000
									);
								}
							}
						);
					}
				}
			};
		},
		getSliderData: function ($slider) {
			var dataList = $slider.data(),
				returnValue = {};
			
			for (var property in dataList) {
				if (dataList.hasOwnProperty(property)) {
					// It's required to be different from data options because da options are all options from shortcode element
					if (property !== 'options' && typeof dataList[property] !== 'undefined' && dataList[property] !== '') {
						returnValue[property] = dataList[property];
					}
				}
			}
			
			return returnValue;
		},
	};
	
	qodefCore.shortcodes.coppola_core_scrolling_portfolio.qodefScrollingPortfolio = qodefScrollingPortfolio;
	
})( jQuery );

(function ( $ ) {
	'use strict';

	var shortcode = 'coppola_core_team_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_testimonials_list             = {};
	qodefCore.shortcodes.coppola_core_testimonials_list.qodefSwiper = qodef.qodefSwiper;

})( jQuery );

(function ( $ ) {
	'use strict';

	qodefCore.shortcodes.coppola_core_interactive_corners = {};

	$( document ).ready(
		function () {
			qodefInteractiveCornersList.init();
		}
	);

	var qodefInteractiveCornersList = {
		init: function () {
			var $holder = $( '.qodef-interactive-corners' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						qodefInteractiveCornersList.initItem( $( this ) );
					}
				);
			}
		},
		initItem: function ( $holder ) {

			qodefCore.qodefIsInViewport.check(
				$holder.find( '> a' ),
				function () {
					$holder.addClass( 'qodef--appeared' );
				},
			);
		},
	};

	qodefCore.shortcodes.coppola_core_interactive_corners.qodefInteractiveCornersList = qodefInteractiveCornersList;

})( jQuery );

(function ( $ ) {
	'use strict';
	
	var shortcode = 'coppola_core_blog_list';

	$( document ).on(
		'coppola_trigger_get_new_posts',
		function ( e, $holder, response, nextPage ) {
			if ( $holder.hasClass( 'qodef-item-layout--featured-right.qodef-swiper-container' ) ) {
				qodefWooPostHeight.init();
			}
		}
	);

	$( window ).on(
		'load',
		function () {
			qodefWooPostHeight.init();
		}
	);

	var qodefWooPostHeight = {
		init() {
			const $holder  = $( '.qodef-blog.qodef-item-layout--featured-right.qodef-swiper-container' );

			if ( $holder.length ) {
				$holder.each(
					( index,element ) => {
						const $thisHolder       = $( element );
						let   maxHeight         = 0;
						$thisHolder.find( '.qodef-blog-item' ).each(
							( i, e ) => {
								const $thisItem = $( e );
								if ( $thisItem.outerHeight() > maxHeight ) {
									maxHeight = $thisItem.outerHeight();
								}
							}
						);
					$thisHolder.find( '.qodef-blog-item' ).height( maxHeight );
					}
				);
			}
		}
	}

	qodefCore.shortcodes[shortcode]                    = {};
	qodefCore.shortcodes[shortcode].qodefWooPostHeight = qodefWooPostHeight;

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

})( jQuery );

(function ( $ ) {
	'use strict';

	$( document ).ready(
		function () {
			qodefInfoFollow.init();
		}
	);

	$( document ).on(
		'coppola_trigger_get_new_posts',
		function () {
			qodefInfoFollow.init();
		}
	);

	var qodefInfoFollow = {
		init: function () {
			var $gallery = $( '.qodef-hover-animation--follow' );

			if ( $gallery.length ) {
				qodefCore.body.append( '<div class="qodef-e-content-follow"><div class="qodef-e-top-holder"></div><div class="qodef-e-text"></div></div>' );

				var $contentFollow = $( '.qodef-e-content-follow' ),
					$topHolder     = $contentFollow.find( '.qodef-e-top-holder' ),
					$textHolder    = $contentFollow.find( '.qodef-e-text' );

				$gallery.each(
					function () {
						$gallery.find( '.qodef-e-inner' ).each(
							function () {
								var $thisItem = $( this );

								//info element position
								$thisItem.on(
									'mousemove',
									function ( e ) {
										if ( e.clientX + 20 + $contentFollow.width() > qodefCore.windowWidth ) {
											$contentFollow.addClass( 'qodef-right' );
										} else {
											$contentFollow.removeClass( 'qodef-right' );
										}

										$contentFollow.css(
											{
												top: e.clientY + 20,
												left: e.clientX + 20,
											}
										);
									}
								);

								//show/hide info element
								$thisItem.on(
									'mouseenter',
									function () {
										var $thisItemTopHolder  = $( this ).find( '.qodef-e-top-holder' ),
											$thisItemTextHolder = $( this ).find( '.qodef-e-text' );

										if ( $thisItemTopHolder.length ) {
											$topHolder.html( $thisItemTopHolder.html() );
										}

										if ( $thisItemTextHolder.length ) {
											$textHolder.html( $thisItemTextHolder.html() );
										}

										if ( ! $contentFollow.hasClass( 'qodef-is-active' ) ) {
											$contentFollow.addClass( 'qodef-is-active' );
										}
									}
								).on(
									'mouseleave',
									function () {
										if ( $contentFollow.hasClass( 'qodef-is-active' ) ) {
											$contentFollow.removeClass( 'qodef-is-active' );
										}
									}
								);
							}
						);
					}
				);
			}
		},
	};

	qodefCore.shortcodes.coppola_core_portfolio_list.qodefInfoFollow = qodefInfoFollow;

})( jQuery );
