<?php
$is_enabled = coppola_get_post_value_through_levels( 'qodef_blog_single_enable_related_posts' );

// Hook to include additional content before page content holder
do_action( 'coppola_action_before_page_content_holder' );
?>
<main id="qodef-page-content" class="qodef-grid qodef-layout--template <?php echo esc_attr( coppola_get_grid_gutter_classes() ); ?>" role="main">
	<div class="qodef-grid-inner clear">
		<?php
		// Hook to include additional content before blog and sidebar
		do_action( 'coppola_action_before_blog_sidebar' );

		// Include blog template
		echo apply_filters( 'coppola_filter_blog_template', coppola_get_template_part( 'blog', 'templates/blog' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

		// Include page content sidebar
		coppola_template_part( 'sidebar', 'templates/sidebar' );

		if ( is_single() && 'post' === get_post_type() && defined( 'COPPOLA_CORE_VERSION' ) ) {
			if ( $is_enabled ) {
				?>
				<div class="qodef-grid-item qodef-page-related-section">
					<?php do_action( 'coppola_related_after_blog_content' ); ?>
				</div>
				<?php
			}
		}
		?>
	</div>
</main>
<?php
// Hook to include additional content after main page content holder
do_action( 'coppola_action_after_page_content_holder' );
?>
