<?php
/**
 * name             - Wireframe title
 * cat_name         - Comma separated list for multiple categories (cat display name)
 * custom_class     - Space separated list for multiple categories (cat ID)
 * dependency       - Array of dependencies
 * is_content_block - (optional) Best in a content block
 *
 * @version  1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$wireframe_categories = UNCDWF_Dynamic::get_wireframe_categories();
$data                 = array();

// Wireframe properties

$data[ 'name' ]             = esc_html__( 'Pattern Grid Five', 'uncode-wireframes' );
$data[ 'cat_name' ]         = $wireframe_categories[ 'patterns' ];
$data[ 'custom_class' ]     = 'patterns';
$data[ 'image_path' ]       = UNCDWF_THUMBS_URL . 'patterns/Pattern-Grid-Five.jpg';
$data[ 'dependency' ]       = array();
$data[ 'is_content_block' ] = true;

// Wireframe content

$data[ 'content' ]      = '
[vc_row row_height_percent="0" overlay_alpha="50" gutter_size="3" column_width_percent="100" shift_y="0" z_index="0" uncode_shortcode_id="365637"][vc_column column_width_percent="100" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="0" mobile_width="0" width="1/1" uncode_shortcode_id="356601"][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" uncode_shortcode_id="578654" limit_content=""][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="2" mobile_width="4" css_animation="alpha-anim" animation_speed="1000" animation_delay="600" parallax_intensity="6" width="2/12" uncode_shortcode_id="203175"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="80" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="4" mobile_width="4" css_animation="alpha-anim" animation_speed="1000" parallax_intensity="1" width="3/12" uncode_shortcode_id="205578"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="1" medium_width="2" mobile_width="4" css_animation="alpha-anim" animation_speed="1000" animation_delay="400" parallax_intensity="5" width="2/12" uncode_shortcode_id="751729"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="-3" shift_y="0" shift_y_down="0" z_index="1" medium_width="3" mobile_width="3" css_animation="alpha-anim" animation_speed="1000" parallax_intensity="2" width="2/12" uncode_shortcode_id="205625"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="5" mobile_width="4" css_animation="alpha-anim" animation_speed="1000" animation_delay="100" parallax_intensity="2" width="3/12" uncode_shortcode_id="160108"][uncode_module_placeholder][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" uncode_shortcode_id="106232" limit_content=""][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="3" shift_y="0" shift_y_down="0" z_index="0" medium_width="2" mobile_width="4" css_animation="alpha-anim" animation_speed="1000" animation_delay="100" parallax_intensity="2" width="2/12" uncode_shortcode_id="163789"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="-2" shift_y="0" shift_y_down="0" z_index="0" medium_width="2" mobile_width="4" css_animation="alpha-anim" animation_speed="1000" parallax_intensity="4" width="2/12" uncode_shortcode_id="931570"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="80" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="4" mobile_width="5" css_animation="alpha-anim" animation_speed="1000" parallax_intensity="1" width="4/12" uncode_shortcode_id="131418"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="90" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="2" shift_y="0" shift_y_down="0" z_index="0" medium_width="4" mobile_width="4" css_animation="alpha-anim" animation_speed="1000" animation_delay="600" parallax_intensity="3" width="2/12" uncode_shortcode_id="206875"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="-2" shift_y="0" shift_y_down="0" z_index="1" medium_width="4" mobile_width="4" css_animation="alpha-anim" animation_speed="1000" animation_delay="200" parallax_intensity="5" width="2/12" uncode_shortcode_id="115505"][uncode_module_placeholder][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" uncode_shortcode_id="129000" limit_content=""][vc_column_inner column_width_percent="80" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="4" mobile_width="4" css_animation="alpha-anim" animation_speed="1000" parallax_intensity="3" width="3/12" uncode_shortcode_id="130321"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="4" mobile_width="4" css_animation="alpha-anim" animation_speed="1000" animation_delay="100" parallax_intensity="1" width="3/12" uncode_shortcode_id="146952"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="3" shift_y="0" shift_y_down="0" z_index="0" medium_width="3" mobile_width="3" css_animation="alpha-anim" animation_speed="1000" animation_delay="200" parallax_intensity="2" width="2/12" uncode_shortcode_id="853999"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="80" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="-2" shift_y="0" shift_y_down="0" z_index="1" medium_width="3" mobile_width="3" css_animation="alpha-anim" animation_speed="1000" parallax_intensity="4" width="2/12" uncode_shortcode_id="880074"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="80" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="1" medium_width="3" mobile_width="3" css_animation="alpha-anim" animation_speed="1000" animation_delay="500" parallax_intensity="2" width="2/12" uncode_shortcode_id="373075"][uncode_module_placeholder][/vc_column_inner][/vc_row_inner][vc_row_inner row_inner_height_percent="0" overlay_alpha="50" gutter_size="3" shift_y="0" z_index="0" uncode_shortcode_id="173821" limit_content=""][vc_column_inner column_width_percent="80" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="-2" shift_y="0" shift_y_down="0" z_index="1" medium_width="2" mobile_width="2" css_animation="alpha-anim" animation_speed="1000" animation_delay="200" parallax_intensity="2" width="2/12" uncode_shortcode_id="108780"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="2" mobile_width="2" css_animation="alpha-anim" animation_speed="1000" animation_delay="500" parallax_intensity="4" width="2/12" uncode_shortcode_id="180703"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="3" shift_y="0" shift_y_down="0" z_index="1" medium_width="4" mobile_width="4" css_animation="alpha-anim" animation_speed="1000" parallax_intensity="5" width="3/12" uncode_shortcode_id="185630"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="100" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="-2" shift_y="0" shift_y_down="0" z_index="0" medium_width="5" mobile_width="5" css_animation="alpha-anim" animation_speed="1000" animation_delay="600" parallax_intensity="1" width="3/12" uncode_shortcode_id="113795"][uncode_module_placeholder][/vc_column_inner][vc_column_inner column_width_percent="80" position_vertical="middle" align_horizontal="align_center" gutter_size="3" overlay_alpha="50" shift_x="0" shift_y="0" shift_y_down="0" z_index="0" medium_width="3" mobile_width="3" css_animation="alpha-anim" animation_speed="1000" animation_delay="100" parallax_intensity="2" width="2/12" uncode_shortcode_id="161974"][uncode_module_placeholder][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]
';

// Check if this wireframe is for a content block
if ( $data[ 'is_content_block' ] && ! $is_content_block ) {
	$data[ 'custom_class' ] .= ' for-content-blocks';
}

// Check if this wireframe requires a plugin
foreach ( $data[ 'dependency' ]  as $dependency ) {
	if ( ! UNCDWF_Dynamic::has_dependency( $dependency ) ) {
		$data[ 'custom_class' ] .= ' has-dependency needs-' . $dependency;
	}
}

vc_add_default_templates( $data );
